/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.fm.rpt.liquid.param.LiquidBaseParamRelation;

public class LiquidFlowAnalysisParamRelation
extends LiquidBaseParamRelation {
    private static final int MAX_PERIOD_COUNT = 31;

    public void dataChange(String paramName) throws Exception {
        super.dataChange(paramName);
        if (paramName.equals("queryCycle") || paramName.equals("beginDate") || paramName.equals("endDate")) {
            this.setBeginAndEndDate(paramName, false);
        } else if (paramName.equals("currency")) {
            this.paramRelationHelper.checkCurrencyHasExchangeRate(this.currentCompany, this.baseCurrency, (KDBizPromptBox)this.getComponent(paramName));
        }
    }

    private void setBeginAndEndDate(String paramName, boolean isInit) throws Exception {
        String queryCycleString = this.getComponentValue("queryCycle");
        if ("-1".equals(queryCycleString)) {
            return;
        }
        int queryCycle = Integer.parseInt(queryCycleString);
        KDDatePicker dpkBeginDate = (KDDatePicker)this.getComponent("beginDate");
        KDDatePicker dpkEndDate = (KDDatePicker)this.getComponent("endDate");
        if (paramName.equals("queryCycle") && !isInit) {
            dpkBeginDate.setValue((Object)DateUtil.getDayBegin(), false);
            dpkEndDate.setValue((Object)DateUtil.getDayBegin(), false);
        }
        try {
            this.paramRelationHelper.setBeginAndEndDate(paramName, dpkBeginDate, dpkEndDate, queryCycle);
        }
        catch (LiquidException e) {
            if (!isInit) {
                RptHelper.handleException(e);
            }
            this.setComponentValue("queryCycle", "-1", true);
            dpkBeginDate.setValue((Object)DateUtil.getDayBegin(), false);
            dpkEndDate.setValue((Object)dpkBeginDate.getSqlDate(), false);
        }
    }

    private boolean checkDateRange() throws BOSException, EASBizException {
        String queryCycleString = this.getComponentValue("queryCycle");
        if (EmptyUtil.isEmpty((String)queryCycleString)) {
            return true;
        }
        KDDatePicker dpkBeginDate = (KDDatePicker)this.getComponent("beginDate");
        KDDatePicker dpkEndDate = (KDDatePicker)this.getComponent("endDate");
        if ("-1".equals(queryCycleString)) {
            return this.paramRelationHelper.checkDateRange(dpkBeginDate, dpkEndDate);
        }
        return this.paramRelationHelper.checkMaxPeriodRange(Integer.parseInt(queryCycleString), dpkBeginDate.getSqlDate(), dpkEndDate.getSqlDate());
    }

    public boolean confirmFilterBefore() throws Exception {
        if (!this.checkBeginAndEndDate() || !this.checkDateRange()) {
            return false;
        }
        this.setIsDiffYearParam();
        return super.confirmFilterBefore();
    }

    protected void initComponentParams() throws Exception {
        super.initComponentParams();
        this.paramRelationHelper.addSelfCustomItem((KDComboBox)this.getComponent("queryCycle"));
        this.setBeginAndEndDate("beginDate", true);
        this.deleteEmptyItem("staticUnit");
    }
}

