/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.AccrualCalculator;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.td.AccrualCalculatorPropertyUtil;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.client.AbstractIntReceivedBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IntReceivedBillEditUI
extends AbstractIntReceivedBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceivedBillEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private String intReceivedBillType;
    private TimeDepositBillInfo timeDepositBillInfo;
    private CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    private UnTimeDepositBillInfo unTimeDepositBillInfo;
    private boolean isSuccess = false;
    private IObjectPK pk = null;

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "im_td_int_01preInt";
        }
        return "im_td_int_02view";
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.prmtcorpCurAcct.setDisplayFormat("$name$");
        this.initCurrency();
        this.initCustomedVariable();
        super.onLoad();
        this.setControlStatus();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtDepYearRate.setPrecision(5);
        this.txtCreYearRate.setPrecision(5);
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.cboCurrency.getSelectedItem();
    }

    private void setControlStatus() throws EASBizException, BOSException {
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAccountant);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtCreator);
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            if (this.editData.isIsAddedByReceive()) {
                this.pkBizDate.setEnabled(true);
                this.txtShijiAmt.setEnabled(false);
                this.txtDigest.setEnabled(true);
            } else {
                this.pkBizDate.setEnabled(true);
                this.txtShijiAmt.setEnabled(true);
                this.txtDigest.setEnabled(true);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi = CasRecPayHandler.getAccountBankEvi((String)this.currentCompany.getId().toString(), null);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(1)));
            this.prmtcorpCurAcct.setEntityViewInfo(evi);
        }
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.actionCopyFrom.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.txtCreInterest.setEnabled(true);
        this.txtDeInterest.setEnabled(true);
        this.txtShijiAmt.setEnabled(false);
    }

    private void initControls() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.isPreDrawInt()) {
                this.initControlsPreDrawInt();
            } else if (this.isRedopsitInt()) {
                this.initControlsRedopsitInt();
            } else if (this.isUnTimeDepositInt()) {
                this.initUnTimeDepositInt();
            }
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
        this.pkBizDate.setSupportedEmpty(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.initControls();
    }

    private void initCustomedVariable() throws Exception {
        this.intReceivedBillType = (String)this.getUIContext().get("intType");
        if (this.isRedopsitInt()) {
            String sourceID = (String)this.getUIContext().get("sourceTimeBillID");
            this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getSelectorsForQueryTimeDeposit());
        } else if (this.isUnTimeDepositInt()) {
            String pk = (String)this.getUIContext().get("sourceTimeBillID");
            if (pk == null) {
                this.unTimeDepositBillInfo = (UnTimeDepositBillInfo)this.getUIContext().get("UnDipositID");
                if (this.unTimeDepositBillInfo.getTimeDepositBill() != null) {
                    this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.unTimeDepositBillInfo.getTimeDepositBill().getId()), this.getSelectorsForQueryTimeDeposit());
                    this.unTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
                } else {
                    this.timeDepositBillInfo = this.unTimeDepositBillInfo.getTimeDepositBill();
                }
            } else {
                this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(pk), this.getSelectorsForQueryTimeDeposit());
                this.unTimeDepositBillInfo = (UnTimeDepositBillInfo)this.getUIContext().get("UnDipositID");
            }
        }
    }

    public SelectorItemCollection getSelectorsForQueryTimeDeposit() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("depositBank.id"));
        sic.add(new SelectorItemInfo("depositBank.name"));
        sic.add(new SelectorItemInfo("timeDepositType"));
        sic.add(new SelectorItemInfo("intTerm.*"));
        sic.add(new SelectorItemInfo("bankCurAcct.id"));
        sic.add(new SelectorItemInfo("bankCurAcct.name"));
        sic.add(new SelectorItemInfo("bankCurAcct.number"));
        sic.add(new SelectorItemInfo("bankCurAcct.bankAccountNumber"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBillID.number"));
        sic.add(new SelectorItemInfo("currency.*"));
        return sic;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntReceivedBillFactory.getRemoteInstance();
    }

    private void initUnTimeDepositInt() {
        this.txtYingjiAmt.setMaximumValue((Comparable)this.txtShijiAmt.getBigDecimalValue());
    }

    private void initControlsRedopsitInt() {
        this.initOtherContrlos_RedepositInt();
    }

    private void initOtherContrlos_RedepositInt() {
        this.txtNumber.setEnabled(false);
    }

    private void initControlsPreDrawInt() {
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
    }

    private void setPre(int currencyPre) {
        this.txtDepYearRate.setDataType(1);
        this.txtCreYearRate.setDataType(1);
        this.txtDepositAmt.setPrecision(currencyPre);
        this.txtDeInterest.setPrecision(currencyPre);
        this.txtCreInterest.setPrecision(currencyPre);
        this.txtYingjiAmt.setPrecision(currencyPre);
        this.txtShijiAmt.setPrecision(currencyPre);
        this.txtCreYearRate.setPrecision(currencyPre);
        this.txtDepYearRate.setPrecision(currencyPre);
    }

    private boolean isUnTimeDepositInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("1");
    }

    private boolean isRedopsitInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("2");
    }

    private boolean isPreDrawInt() {
        return this.intReceivedBillType != null && this.intReceivedBillType.equals("0");
    }

    @Override
    protected IObjectValue createNewData() {
        IntReceivedBillInfo objectValue = new IntReceivedBillInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setIsAddedByReceive(false);
        objectValue.setComInterstBillID(null);
        objectValue.setIsChongzhang(false);
        if (this.isPreDrawInt()) {
            this.setOtherValue_DrawInt(objectValue);
        } else if (this.isRedopsitInt()) {
            this.setOtherValue_ReDopsitInt(objectValue);
        } else if (this.isUnTimeDepositInt()) {
            this.setOtherValue_UnTimeDepositInt(objectValue);
        }
        objectValue.setDigest(this.timeDepositBillInfo.getNumber() + " " + objectValue.getIntReceiveType().getAlias());
        return objectValue;
    }

    private void setOtherValue_DrawInt(IntReceivedBillInfo objectValue) {
        objectValue.setSrcBillID(this.timeDepositBillInfo.getId().toString());
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.PRE_DRAWING);
    }

    private void setOtherValue_ReDopsitInt(IntReceivedBillInfo objectValue) {
        TimeDepositBillInfo infoSource = (TimeDepositBillInfo)this.getUIContext().get("ObjectInfo_ID");
        objectValue.setSrcBillID(infoSource.getId().toString());
        objectValue.setCorpCurAcct(this.timeDepositBillInfo.getBankCurAcct());
        objectValue.setLastIntDate(this.timeDepositBillInfo.getLastRecvIntDay());
        objectValue.setIntRateTypeExpression(this.timeDepositBillInfo.getIntRateTypeExpression());
        objectValue.setYearDays(this.timeDepositBillInfo.getYearDays());
        String sourceBillID = (String)this.getUIContext().get("sourceTimeBillID");
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("intTerm.*");
            TimeDepositBillInfo sourceInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID), sic);
            objectValue.setTimeDepositBillID(sourceInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        objectValue.setEffectiveDate(this.timeDepositBillInfo.getEffectiveDate());
        objectValue.setEndDate(this.getIntBillEnDate(this.timeDepositBillInfo.getMaturityDay()));
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.INTBILL_REDEPOSIT);
        objectValue.setBank(this.timeDepositBillInfo.getDepositBank());
        objectValue.setCompany(this.timeDepositBillInfo.getDepositCompany());
        objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
        BigDecimal floorAmt = this.timeDepositBillInfo.getFloorAmt() == null ? Constants.ZERO : this.timeDepositBillInfo.getFloorAmt();
        objectValue.setDepositAmt(this.timeDepositBillInfo.getBalance().subtract(floorAmt));
        objectValue.setDepYearRate(this.getYearRate_Redeposit(this.timeDepositBillInfo, objectValue.getEndDate()));
        boolean param_FT001 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        int days = 0;
        days = param_FT001 ? TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1 : TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1;
        objectValue.setIntervalDays(days);
        objectValue.setCreYearRate(this.timeDepositBillInfo.getCurYearRate());
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        AccrualCalculatorPropertyUtil.copyPropertiesValue(null, aceni, (CoreBaseInfo)this.timeDepositBillInfo, objectValue.getIntReceiveType());
        aceni.setFloorAmtTmp(this.timeDepositBillInfo.getFloorAmt());
        aceni.setTimeDepositType(this.timeDepositBillInfo.getTimeDepositType());
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(null, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    private void setOtherValue_UnTimeDepositInt(IntReceivedBillInfo objectValue) {
        objectValue.setIntRateTypeExpression(this.timeDepositBillInfo.getIntRateTypeExpression());
        objectValue.setYearDays(this.timeDepositBillInfo.getYearDays());
        UnTimeDepositBillInfo infoUndeSource = (UnTimeDepositBillInfo)this.getUIContext().get("UnDipositID");
        objectValue.setSrcBillID(infoUndeSource.getId().toString());
        objectValue.setCorpCurAcct(infoUndeSource.getPayeeBankAccount());
        String sourceBillID = (String)this.getUIContext().get("sourceTimeBillID");
        if (sourceBillID == null) {
            sourceBillID = this.timeDepositBillInfo.getId().toString();
        }
        try {
            TimeDepositBillInfo sourceInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
            objectValue.setTimeDepositBillID(sourceInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        objectValue.setLastIntDate(this.timeDepositBillInfo.getLastUnDepositDate());
        Date lastUndepositTime = this.timeDepositBillInfo.getLastUnDepositDate();
        Date timeDepositEffectiveDate = this.timeDepositBillInfo.getEffectiveDate();
        if (lastUndepositTime == null) {
            objectValue.setEffectiveDate(timeDepositEffectiveDate);
        } else if (lastUndepositTime.compareTo(timeDepositEffectiveDate) > 0) {
            objectValue.setEffectiveDate(lastUndepositTime);
        } else {
            objectValue.setEffectiveDate(timeDepositEffectiveDate);
        }
        objectValue.setEndDate(this.calcEndDate(this.unTimeDepositBillInfo.getBizDate()));
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT);
        objectValue.setBank(this.getBank(this.timeDepositBillInfo.getDepositBank().getId().toString()));
        objectValue.setCompany(this.getCompany(this.timeDepositBillInfo.getDepositCompany().getId().toString()));
        objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
        if (this.unTimeDepositBillInfo.getUnDepositAmt().compareTo(this.timeDepositBillInfo.getBalance()) == 0) {
            BigDecimal floorAmtTmp = this.timeDepositBillInfo.getFloorAmt() == null ? Constants.ZERO : this.timeDepositBillInfo.getFloorAmt();
            objectValue.setDepositAmt(this.unTimeDepositBillInfo.getUnDepositAmt().subtract(floorAmtTmp));
        } else {
            objectValue.setDepositAmt(this.unTimeDepositBillInfo.getUnDepositAmt());
        }
        objectValue.setDepYearRate(this.getYearRate_Redeposit(this.timeDepositBillInfo, this.unTimeDepositBillInfo.getBizDate()));
        objectValue.setCreYearRate(this.unTimeDepositBillInfo.getYearRate());
        boolean param_FT001 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        int days = 0;
        days = param_FT001 ? (this.timeDepositBillInfo.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositBillInfo.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER ? TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1 : TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1) : TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1;
        objectValue.setIntervalDays(days);
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        this.unTimeDepositBillInfo.setInfo(objectValue);
        AccrualCalculatorPropertyUtil.copyPropertiesValue(null, aceni, (CoreBaseInfo)this.unTimeDepositBillInfo, objectValue.getIntReceiveType());
        aceni.setYearRate(objectValue.getDepYearRate());
        aceni.setTimeDepositType(this.timeDepositBillInfo.getTimeDepositType());
        if (this.unTimeDepositBillInfo.getUnDepositAmt().compareTo(this.timeDepositBillInfo.getBalance()) == 0) {
            aceni.setLastUnde(true);
            aceni.setFloorAmtTmp(this.timeDepositBillInfo.getFloorAmt());
        }
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(null, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    private CompanyOrgUnitInfo getCompany(String uid) {
        CompanyOrgUnitInfo info = null;
        try {
            info = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(uid));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return info;
    }

    private BankInfo getBank(String bankid) {
        BankInfo info = null;
        try {
            info = (BankInfo)BankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(bankid));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return info;
    }

    private void calcInterst(IntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(Constants.ZERO);
        objectValue.setCreInterest(Constants.ZERO);
        if (this.unTimeDepositBillInfo.getUnDepositType().getValue().equals("consultUnDeposit")) {
            int days = this.getDeDays("consultUnDeposit", objectValue);
            this.calcDeInterst(objectValue, days);
        } else if (this.unTimeDepositBillInfo.getUnDepositType().getValue().equals("matureUnDeposit")) {
            int days = this.getDeDays("matureUnDeposit", objectValue);
            this.calcDeInterst(objectValue, days);
            this.calcCuInterst(objectValue);
        } else {
            this.calcCuInterst(objectValue);
        }
    }

    private void calcDeInterst(IntReceivedBillInfo objectValue, int days) {
        BigDecimal unDeposiAmt = this.unTimeDepositBillInfo.getUnDepositAmt();
        BigDecimal yearRate = objectValue.getDepYearRate();
        BigDecimal yearDays = new BigDecimal(String.valueOf(this.timeDepositBillInfo.getYearDays()));
        BigDecimal tmp = yearRate.divide(yearDays.multiply(Constants.ONE_HUNDRED), 8, 4);
        objectValue.setDeInterest(unDeposiAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(days))).setScale(8, 4));
    }

    @Override
    protected void comboRateExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        String strValue = "";
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contCreYearRate.setBoundLabelText(strValue);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCreYearRate.setBoundLabelText(strValue);
        } else {
            strValue = this.contDepYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contDepYearRate.setBoundLabelText(strValue);
            strValue = this.contCreYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCreYearRate.setBoundLabelText(strValue);
        }
    }

    private void calcCuInterst(IntReceivedBillInfo objectValue) {
        BigDecimal unDeposiAmt = this.unTimeDepositBillInfo.getUnDepositAmt();
        BigDecimal yearRate = objectValue.getCreYearRate();
        BigDecimal yearDays = new BigDecimal(String.valueOf(this.timeDepositBillInfo.getYearDays()));
        int days = 0;
        if (this.unTimeDepositBillInfo.getUnDepositType().getValue().equals("matureUnDeposit")) {
            days = this.getCuDays(objectValue, 0);
        } else if (this.unTimeDepositBillInfo.getUnDepositType().getValue().equals("aheadUnDeposit") || this.unTimeDepositBillInfo.getUnDepositType().getValue().equals("unConsultUnDeposit")) {
            days = this.getCuDays(objectValue, 1);
        }
        BigDecimal tmp = yearRate.divide(yearDays.multiply(Constants.ONE_HUNDRED), 8, 4);
        objectValue.setCreInterest(unDeposiAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(days))).setScale(8, 4));
    }

    private int getDeDays(String undeposit_value, IntReceivedBillInfo info) {
        int returnDays = 0;
        if (undeposit_value.equals("consultUnDeposit")) {
            returnDays = info.getIntervalDays();
        } else if (undeposit_value.equals("matureUnDeposit")) {
            returnDays = this.calcDaysBetweenTwoDate(this.timeDepositBillInfo.getEffectiveDate(), this.timeDepositBillInfo.getMaturityDay());
        }
        return returnDays + 1;
    }

    private int getCuDays(IntReceivedBillInfo objectValue, int type) {
        int days = 0;
        if (0 == type) {
            int daysTmp = this.calcDaysBetweenTwoDate(this.timeDepositBillInfo.getMaturityDay(), objectValue.getEndDate()) + 1;
            if (daysTmp > 0) {
                days = daysTmp;
            }
        } else if (1 == type) {
            days = this.calcDaysBetweenTwoDate(objectValue.getEffectiveDate(), objectValue.getEndDate()) + 1;
        }
        return days;
    }

    private int calcDaysBetweenTwoDate(Date startDate, Date endDate) {
        long endTime = endDate.getTime();
        long beginTime = startDate.getTime();
        long betweenDays = (long)((double)((endTime - beginTime) / 86400000L) + 0.5);
        return new Long(betweenDays).intValue() + 1;
    }

    private Date calcEndDate(Date billDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(billDate);
        c.add(5, -1);
        return c.getTime();
    }

    @Override
    public void loadFields() {
        if (this.isSetPrecisionAuto()) {
            try {
                this.setPrecision();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
            }
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboIntReceiveType, (Object)this.editData.getIntReceiveType());
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.isRedopsitInt()) {
            this.editData.setDepYearRate(this.txtDepYearRate.getBigDecimalValue());
            this.editData.setCreInterest(this.txtCreInterest.getBigDecimalValue());
        } else if (this.isUnTimeDepositInt()) {
            if (this.unTimeDepositBillInfo.getUnDepositAmt().compareTo(this.timeDepositBillInfo.getBalance()) == 0) {
                BigDecimal floorAmt = this.timeDepositBillInfo.getFloorAmt() == null ? Constants.ZERO : this.timeDepositBillInfo.getFloorAmt();
                this.editData.setDepositAmt(this.unTimeDepositBillInfo.getUnDepositAmt().subtract(floorAmt));
            }
        } else {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
            this.editData.setDescription(this.txtDigest.getText());
            this.editData.setYingjiAmt(this.txtYingjiAmt.getBigDecimalValue());
        }
        this.editData.setFivouchered(false);
    }

    private int getIntervalDays(TimeDepositBillInfo info) {
        long beginTime = info.getEffectiveDate().getTime();
        long endTime = info.getMaturityDay().getTime();
        long betweenDays = (long)((double)((endTime - beginTime) / 86400000L) + 0.5);
        return new Long(betweenDays).intValue();
    }

    private BigDecimal getDeInterest(TimeDepositBillInfo info, BigDecimal yearRate, int intervalDays) {
        BigDecimal yearDays = new BigDecimal(String.valueOf(info.getYearDays()));
        BigDecimal remAmt = info.getBalance();
        BigDecimal tmp = yearRate.divide(yearDays.multiply(Constants.ONE_HUNDRED), 8, 4);
        return remAmt.multiply(tmp).multiply(new BigDecimal(String.valueOf(intervalDays))).setScale(8, 4);
    }

    private BigDecimal getYearRate_Redeposit(TimeDepositBillInfo info, Date endDate) {
        BigDecimal returnValue = Constants.ZERO;
        if (info.getTimeDepositType().getValue().equals("timedeposit") || info.getTimeDepositType().getValue().equals("timedeposit_outer")) {
            returnValue = info.getYearRate();
        } else if (info.getTimeDepositType().getValue().equals("calldeposit") || info.getTimeDepositType().getValue().equals("calldeposit_outer")) {
            try {
                returnValue = TimeDepositHelper.getInstance().calcYearRate(null, info.getIntRateTable(), info.getCurrency(), endDate);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return returnValue;
    }

    private Date getIntBillEnDate(Date maturityDay) {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(maturityDay);
        endDate.add(5, -1);
        return endDate.getTime();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.isRedopsitInt()) {
            try {
                this.editData.setTimeDepositBillInfo((TimeDepositBillInfo)this.getUIContext().get("ObjectInfo_ID"));
                this.editData.setAddNewType("2");
                super.actionSubmit_actionPerformed(e);
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                this.isSuccess = true;
                this.disposeUIWindow();
            }
            catch (Exception ex) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
                SysUtil.abort();
            }
        } else if (this.isUnTimeDepositInt()) {
            this.editData.setUnTimeDepositBillInfo((UnTimeDepositBillInfo)this.getUIContext().get("UnDipositID"));
            this.editData.setAddNewType("1");
            this.editData.setHasEffected(false);
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            this.isSuccess = true;
            this.disposeUIWindow();
        } else {
            this.editData.setAddNewType("intReceiveBill_save");
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public boolean submitSuccess() {
        return this.isSuccess;
    }

    public Map getSubmitStatus() {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        hm.put("successFlag", new Boolean(this.isSuccess));
        hm.put("intBillID", (Boolean)this.pk);
        return hm;
    }

    private void setAutoNumber() {
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            try {
                if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    sysNumber = FrameWorkUtils.getCodeRuleClient((CoreBillBaseInfo)this.editData, (String)SysContext.getSysContext().getCurrentOrgUnit().getString("id"));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (sysNumber != null && sysNumber.trim().length() > 0) {
                this.editData.setNumber(sysNumber);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    public static Map showIntReceiveEditUI(CoreUIObject ui, CoreBaseInfo info, String intbill_redeposit_value, String sourceBillID) {
        Map successStatus = null;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            if (info instanceof TimeDepositBillInfo) {
                uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
                uiContext.put((Object)"ObjectInfo_ID", (Object)info);
                uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
            } else if (info instanceof UnTimeDepositBillInfo) {
                uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
                uiContext.put((Object)"UnDipositID", (Object)info);
                uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceivedBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            successStatus = ((IntReceivedBillEditUI)uiWindow.getUIObject()).getSubmitStatus();
            Boolean flag = (Boolean)successStatus.get("successFlag");
            if (flag.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        return successStatus;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected void txtCreInterest_dataChanged(DataChangeEvent arg0) throws Exception {
        this.setShijiAmt();
    }

    @Override
    protected void txtDeInterest_dataChanged(DataChangeEvent arg0) throws Exception {
        this.setShijiAmt();
    }

    private void setShijiAmt() {
        BigDecimal creInterest = this.txtCreInterest.getBigDecimalValue();
        BigDecimal deInterest = this.txtDeInterest.getBigDecimalValue();
        this.txtShijiAmt.setValue((Object)FMHelper.add((BigDecimal)creInterest, (BigDecimal)deInterest));
    }
}

