/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.client.AbstractIntReceivedBillFilterUI;
import com.kingdee.eas.fm.td.client.IntReceiveBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class IntReceivedBillFilterUI
extends AbstractIntReceivedBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceivedBillFilterUI.class);

    protected void init() throws Exception {
        this.dtpDateFrom.setSupportedEmpty(false);
        this.dtpDateTo.setSupportedEmpty(false);
        super.init();
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.initBillType();
        this.initCurrency();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initBillType() {
        this.cboBillType.removeAllItems();
        this.cboBillType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboBillType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    public void initDate() {
        Date now = new Date();
        this.dtpDateFrom.setSupportedEmpty(false);
        this.dtpDateTo.setSupportedEmpty(false);
        this.dtpDateFrom.setValue((Object)this.getStartDate(now));
        this.dtpDateTo.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(6, calendar.get(6) - calendar.get(6) + 1);
        return calendar.getTime();
    }

    public Object getParam() {
        Object obj;
        IntReceiveBillFilterParam param = new IntReceiveBillFilterParam();
        if (null != this.dtpDateFrom.getValue()) {
            param.setDateFrom(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateFrom.getValue())));
        }
        if (null != this.dtpDateTo.getValue()) {
            param.setDateTo(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateTo.getValue())));
        }
        if (null != this.cboBillType.getSelectedItem() && (obj = this.cboBillType.getSelectedItem()) instanceof TimeDepositTypeEnum) {
            param.setBillType((TimeDepositTypeEnum)((Object)this.cboBillType.getSelectedItem()));
        }
        if (null != this.cboCurrency.getSelectedItem() && (obj = this.cboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            param.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        }
        if (null != this.f7DepBank.getValue()) {
            param.setBank((BankInfo)this.f7DepBank.getValue());
        }
        if (null != this.getCompanyIdSet()) {
            param.setCompanys(this.getCompanyIdSet());
        }
        return param;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof IntReceiveBillFilterParam)) {
            return;
        }
        IntReceiveBillFilterParam filterParam = (IntReceiveBillFilterParam)param;
        this.dtpDateFrom.setValue((Object)filterParam.getDateFrom());
        this.dtpDateTo.setValue((Object)filterParam.getDateTo());
        if (filterParam.getBillType() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboBillType, (Object)((Object)filterParam.getBillType()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboBillType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        if (filterParam.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.f7DepBank.setValue((Object)filterParam.getBank());
        this.setCompanyIdSet(filterParam.getCompanys());
    }

    public boolean verify() {
        if (this.dtpDateFrom.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"15_IntReceivedBillFilterUI"));
            SysUtil.abort();
        }
        if (this.dtpDateTo.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"16_IntReceivedBillFilterUI"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)((Date)this.dtpDateFrom.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateTo.getValue())))) {
            MsgBox.showInfo((String)EASResource.getString((String)TimeDepositHelper.getInstance().getResourcePath(), (String)TimeDepositHelper.getInstance().getDateMsg()));
            this.dtpDateFrom.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.customInit();
        this.f7DepBank.setValue(null);
    }

    protected Class getParamClass() {
        return IntReceiveBillFilterParam.class;
    }
}

