/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.td.IIntReceivedBill;
import com.kingdee.eas.fm.td.IntReceivedBillCollection;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.IntReceivedStatusEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.client.AbstractIntReceivedBillListUI;
import com.kingdee.eas.fm.td.client.IntReceiveBillFilterParam;
import com.kingdee.eas.fm.td.client.IntReceiveDataProvider;
import com.kingdee.eas.fm.td.client.IntReceiveDateChooseUI;
import com.kingdee.eas.fm.td.client.IntReceiveQueryProcessor;
import com.kingdee.eas.fm.td.client.IntReceivedBillEditUI;
import com.kingdee.eas.fm.td.client.IntReceivedBillFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IntReceivedBillListUI
extends AbstractIntReceivedBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceivedBillListUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private String uiParam;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    FillListener fillListener = new FillListener();
    IntReceivedBillFilterUI filterUI = null;
    private String INTRECEIVE_FILENAME = "/FM/IM/INTRECEIVE";

    public IntReceivedBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (this.uiParam.equals("DBCKICKFROMMENU_TD")) {
                this.checkHasNumber();
                Set setIDs = IntReceiveDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
                if (setIDs == null) {
                    SysUtil.abort();
                }
                this.getUIContext().put("newID", setIDs);
            }
        }
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.menuItemPreD.setEnabled(true);
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new IntReceiveQueryProcessor();
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IntReceivedBillInfo info;
        super.tblMain_tableSelectChanged(e);
        IRow row = this.getSelectedRow(this.tblMain);
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        if (!row.getCell("status").getValue().toString().equals(IntReceivedStatusEnum.SUBMIT.toString())) {
            this.btnAudit.setEnabled(false);
        }
        if (!row.getCell("status").getValue().toString().equals(IntReceivedStatusEnum.EXAMINE.toString()) || ((Boolean)row.getCell("isGenReceiving").getValue()).booleanValue()) {
            this.btnUnAudit.setEnabled(false);
        }
        this.actionVoucher.setEnabled(!(info = this.getSelectObject()).isFivouchered() && IntReceivedStatusEnum.EXAMINE.equals((Object)info.getEffectedStatus()));
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new IntReceivedBillInfo(), this.currentCompany.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionPreDrawing.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReceiveInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.preDraw.setEnabled(true);
        this.actionSubmit.setEnabled(true);
        this.actionEdit.setEnabled(true);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    protected String getEditUIName() {
        return IntReceivedBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntReceivedBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IntReceivedBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBillID.timeDepositType"));
        sic.add(new SelectorItemInfo("timeDepositBillID.number"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        return sic;
    }

    private void setQueryFilter(Set ids) {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
        this.mainQuery.setFilter(filter);
    }

    protected void execQuery() {
        Map botpCtx;
        if (this.getUIContext().get("newID") != null) {
            this.setQueryFilter((Set)this.getUIContext().get("newID"));
        }
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null) {
            String targetBillType = (String)botpCtx.get("TargetBillType");
            FilterInfo filter = new FilterInfo();
            if (targetBillType != null) {
                if (targetBillType.equals("ReceivingBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)3, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)"0", CompareType.NOTEQUALS));
                }
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
        }
        super.execQuery();
        this.getUIContext().remove("newID");
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    @Override
    public void actionPreDrawing_actionPerformed(ActionEvent e) throws Exception {
        Set setIDs = IntReceiveDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
        if (setIDs != null && setIDs.size() != 0) {
            String includeValue = this.parseValue(setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        this.refresh(e);
    }

    private IntReceivedBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        IntReceivedBillInfo info = ((IIntReceivedBill)this.getBizInterface()).getIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        return info;
    }

    private String parseValue(Set setIDs) {
        return TimeDepositHelper.getInstance().parseValue(setIDs);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeModify();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanBeModify() throws Exception {
        IntReceivedBillInfo info = this.getSelectObject();
        if (info.getEffectedStatus() == IntReceivedStatusEnum.EXAMINE) {
            throw new TDException(TDException.INTRECEIVEBILL_MODIFY_EXC1);
        }
    }

    @Override
    public void actionSumbmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IntReceivedBillCollection collection = IntReceivedBillFactory.getRemoteInstance().submitBatch(new HashSet(this.getSelectedIdValues()), "submit");
        if (!FMHelper.isEmpty((AbstractObjectCollection)collection)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < collection.size(); ++i) {
                IntReceivedBillInfo info = collection.get(i);
                stringBuffer.append(info.getNumber()).append(" ");
            }
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"56_IntReceivedBillListUI"), collection.size(), stringBuffer);
            MsgBox.showInfo((String)msgStr);
        }
        this.refresh(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IntReceiveDataProvider data = new IntReceiveDataProvider(idList, this.tblMain);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.INTRECEIVE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IntReceiveDataProvider data = new IntReceiveDataProvider(idList, this.tblMain);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.INTRECEIVE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            IntReceiveBillFilterParam param = (IntReceiveBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.TimeDepInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkVoucher(e);
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkDelVoucher();
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IntReceivedBillCollection collection = IntReceivedBillFactory.getRemoteInstance().submitBatch(new HashSet(this.getSelectedIdValues()), "Approve");
        if (!FMHelper.isEmpty((AbstractObjectCollection)collection)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < collection.size(); ++i) {
                IntReceivedBillInfo info = collection.get(i);
                stringBuffer.append(info.getNumber()).append(" ");
            }
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"56_IntReceivedBillListUI"), collection.size(), stringBuffer);
            MsgBox.showInfo((String)msgStr);
        }
        this.refresh(e);
    }

    @Override
    public void actionRevApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IntReceivedBillCollection collection = IntReceivedBillFactory.getRemoteInstance().submitBatch(new HashSet(this.getSelectedIdValues()), "RevApprove");
        if (!FMHelper.isEmpty((AbstractObjectCollection)collection)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < collection.size(); ++i) {
                IntReceivedBillInfo info = collection.get(i);
                stringBuffer.append(info.getNumber()).append(" ");
            }
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"56_IntReceivedBillListUI"), collection.size(), stringBuffer);
            MsgBox.showInfo((String)msgStr);
        }
        this.refresh(e);
    }

    private void checkDelVoucher() throws EASBizException, BOSException {
        IntReceivedBillInfo info;
        this.checkSelected();
        if (IvtModualUtils.getSysParam(null, (String)"TD009") && (info = IntReceivedBillFactory.getRemoteInstance().getIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))).getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"19_IntReceivedBillListUI"));
            SysUtil.abort();
        }
    }

    private void checkVoucher(ActionEvent e) throws Exception {
        IntReceivedBillInfo info;
        this.checkSelected();
        if (IvtModualUtils.getSysParam(null, (String)"TD009") && (info = IntReceivedBillFactory.getRemoteInstance().getIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))).getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"19_IntReceivedBillListUI"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGenReceivingBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
        Map requestMap = iMutexServiceControl.batchRequestObjIDForUpdate((List)idList);
        ArrayList<String> requestIdList = new ArrayList<String>();
        boolean isLocked = false;
        int size = idList.size();
        for (int j = 0; j < size; ++j) {
            String intRecBillId = idList.get(j).toString();
            if (!((Boolean)requestMap.get(intRecBillId)).booleanValue()) {
                isLocked = true;
                continue;
            }
            requestIdList.add(intRecBillId);
        }
        if (isLocked) {
            iMutexServiceControl.batchReleaseObjIDForUpdate(requestIdList);
            throw new TDException(TDException.DATAMUTEX);
        }
        try {
            ArrayList<String> errorNumberLsit = new ArrayList<String>();
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            CtrlUnitInfo cu = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.cu.*"));
            view.setSelector(sic);
            IntReceivedBillCollection coll = IntReceivedBillFactory.getRemoteInstance().getIntReceivedBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                IntReceivedBillInfo intReceivedBill = coll.get(i);
                if (!intReceivedBill.isIsGenReceiving() && intReceivedBill.getEffectedStatus() == IntReceivedStatusEnum.EXAMINE && !intReceivedBill.isIsBooked()) {
                    billCollection.add((CoreBillBaseInfo)intReceivedBill);
                } else {
                    errorNumberLsit.add(intReceivedBill.getNumber());
                }
                if (cu != null) continue;
                cu = intReceivedBill.getCompany().getCU();
            }
            if (billCollection.size() > 0) {
                FMClientHelper.generateDestBill((CtrlUnitInfo)cu, (CoreBillListUI)this, (String)new IntReceivedBillInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (CoreBillBaseCollection)billCollection, (boolean)false);
            }
            int successCount = billCollection.size();
            int failCount = errorNumberLsit.size();
            String failDetail = EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"GenRec_Detail", (Object[])new Object[]{errorNumberLsit.toString()});
            if (failCount > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"GenRec_Result", (Object[])new Object[]{idList.size(), successCount, failCount}), (String)failDetail, (int)2);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"GenRec_Success", (Object[])new Object[]{successCount}), (String)"", (int)2);
            }
        }
        finally {
            iMutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(IntReceivedBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"amt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"deInterest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"creInterest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"shijiAmt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"yingjiAmt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"strikeAmt", (String)currencyId);
                    this.setAmtCellNumberFormat(row);
                }
                Object status = row.getCell("status").getValue();
                if (row.getCell("strikeStatus") == null) continue;
                String str = EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"hasChongzhang");
                if (row.getCell("strikeStatus").getValue().equals(str)) continue;
                if (row.getCell("strikeStatus").getValue().equals("1")) {
                    row.getCell("strikeStatus").setValue((Object)str);
                    continue;
                }
                row.getCell("strikeStatus").setValue((Object)"");
            }
        }

        private void setNumberFormat(IRow row, String columnKey, int precision) {
            String formatString = "%r-[ ]0." + precision + "n";
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat(formatString);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row) {
            Object strObj = row.getCell("depRate").getValue();
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
            if (exp != null) {
                Object enu = exp.getValue();
                if (strObj != null) {
                    if ("year".equalsIgnoreCase(enu.toString())) {
                        row.getCell("depRate").getStyleAttributes().setNumberFormat("#,##0.0000\\%");
                    } else {
                        row.getCell("depRate").getStyleAttributes().setNumberFormat("#,##0.0000\\\u2030");
                    }
                    row.getCell("depRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                if ((strObj = row.getCell("creYearRate").getValue()) != null) {
                    if ("year".equalsIgnoreCase(enu.toString())) {
                        row.getCell("creYearRate").getStyleAttributes().setNumberFormat("#,##0.0000\\%");
                    } else {
                        row.getCell("creYearRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
                    }
                    row.getCell("creYearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
            }
        }
    }
}

