/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositHandlerAdapter;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class RptTimeDepositBalanceByComoanyHandler
extends RptTimeDepositHandlerAdapter {
    public RptTimeDepositBalanceByComoanyHandler(KDTable tblMain, FilterInfo filter, RptTimeDepositBalanceFilterParam filterParam) {
        super(tblMain, filter);
        this.setChloanDetailFilterParam(filterParam);
        this.prepare();
    }

    @Override
    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    @Override
    protected void initCustomHeader() {
        IColumn cCompany = this.kdt.addColumn();
        cCompany.setKey("company");
        cCompany.setGroup(true);
        IColumn cBank = this.kdt.addColumn();
        cBank.setKey("bank");
        IColumn cDepositType = this.kdt.addColumn();
        cDepositType.setKey("depositType");
        IColumn cCurrecny = this.kdt.addColumn();
        cCurrecny.setKey("currency");
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell("company").setValue(rs.getObject("companyName"));
            row.getCell("bank").setValue(rs.getObject("bankName"));
            row.getCell("depositType").setValue(rs.getObject("ftimedeposittype"));
            row.getCell("currency").setValue(rs.getObject("fcurrencyName"));
            super.setContentToCommonColumn(row, rs);
        }
    }

    @Override
    protected void formatCustomerHeadRow(IRow headRow) {
        headRow.getCell("company").setValue((Object)this.getResString("rpt_balance_company"));
        headRow.getCell("bank").setValue((Object)this.getResString("rpt_balance_bank"));
        headRow.getCell("depositType").setValue((Object)this.getResString("rpt_balance_depositType"));
        headRow.getCell("currency").setValue((Object)this.getResString("rpt_balance_currency"));
    }
}

