/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ApplyTimeDepositTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.sql.Date;
import java.util.HashSet;

public class TimeDepositApplyFilterParam
extends FMFilterParamBase {
    private static final long serialVersionUID = 1L;
    private Date dpStartDate;
    private String sApplyTimeDepositTypeEnum;
    private Date dpEndDate;
    private CoreBaseInfo[] bankInfos;
    private String sApplyBillStatusEnum;
    private String currencyId;

    public ApplyTimeDepositTypeEnum getApplyTimeDepositTypeEnum() {
        return ApplyTimeDepositTypeEnum.getEnum(this.sApplyTimeDepositTypeEnum);
    }

    public void setApplyTimeDepositTypeEnum(ApplyTimeDepositTypeEnum applyTimeDepositTypeEnum) {
        this.sApplyTimeDepositTypeEnum = applyTimeDepositTypeEnum == null ? null : applyTimeDepositTypeEnum.getValue();
    }

    public CoreBaseInfo[] getBankInfos() {
        return this.bankInfos;
    }

    public void setBankInfos(CoreBaseInfo[] bankInfos) {
        this.bankInfos = bankInfos;
    }

    public ApplyBillStatusEnum getApplyBillStatusEnum() {
        return ApplyBillStatusEnum.getEnum(this.sApplyBillStatusEnum);
    }

    public void setApplyBillStatusEnum(ApplyBillStatusEnum applyBillStatusEnum) {
        this.sApplyBillStatusEnum = applyBillStatusEnum == null ? null : applyBillStatusEnum.getValue();
    }

    public Date getDpEndDate() {
        return this.dpEndDate;
    }

    public void setDpEndDate(Date dpEndDate) {
        this.dpEndDate = dpEndDate;
    }

    public Date getDpStartDate() {
        return this.dpStartDate;
    }

    public void setDpStartDate(Date dpStartDate) {
        this.dpStartDate = dpStartDate;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (this.getDpStartDate() != null) {
            filterItems.add(new FilterItemInfo("bizDate", (Object)this.getDpStartDate(), CompareType.GREATER_EQUALS));
        }
        if (this.getDpEndDate() != null) {
            filterItems.add(new FilterItemInfo("bizDate", (Object)this.getDpEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.getBankInfos() != null) {
            HashSet<String> bankID = new HashSet<String>();
            for (int i = 0; i < this.getBankInfos().length; ++i) {
                bankID.add(this.getBankInfos()[i].getId().toString());
            }
            filterItems.add(new FilterItemInfo("saveingOrg.id", bankID, CompareType.INCLUDE));
        }
        if (this.getApplyTimeDepositTypeEnum() != null) {
            filterItems.add(new FilterItemInfo("applytype", (Object)this.getApplyTimeDepositTypeEnum().getValue(), CompareType.EQUALS));
        }
        if (this.getApplyBillStatusEnum() != null) {
            filterItems.add(new FilterItemInfo("billState", (Object)this.getApplyBillStatusEnum().getValue(), CompareType.EQUALS));
        }
        if (this.getCurrencyInfo() != null) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)this.getCurrencyInfo().getId().toString(), CompareType.EQUALS));
        }
        filterItems.add(new FilterItemInfo("company.id", (Object)FMBillUtil.getCurrentCompany().getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public CurrencyInfo getCurrencyInfo() {
        if (this.currencyId != null) {
            CurrencyInfo info = new CurrencyInfo();
            try {
                info = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currencyId));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return info;
        }
        return null;
    }

    public void setCurrencyInfo(CurrencyInfo currency) {
        this.currencyId = currency == null ? null : currency.getId().toString();
    }
}

