/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.FixedMutualRenewFlagEnum;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.RegularFixTransInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ApplyTimeDepositTypeEnum;
import com.kingdee.eas.fm.td.ITimeDepositApply;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.client.AbstractTimeDepositApplyListUI;
import com.kingdee.eas.fm.td.client.FixedMutualUpdateTermUI;
import com.kingdee.eas.fm.td.client.TimeDepositApplyDataProvider;
import com.kingdee.eas.fm.td.client.TimeDepositApplyEditUI;
import com.kingdee.eas.fm.td.client.TimeDepositApplyFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TimeDepositApplyListUI
extends AbstractTimeDepositApplyListUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeDepositApplyListUI.class);
    private TimeDepositApplyFilterUI filterUI;
    private String path = "com.kingdee.eas.fm.td.TimeDeposittResource";
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final String TIMEDEPOSITAPPLYBILL_FILENAME = "/FM/INVEST/TD/TIMEDEPOSITAPPLY";

    public TimeDepositApplyListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.setEnabled(true);
        this.actionSubmitBank.setEnabled(true);
        this.actionSubmitBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        TimeDepositApplyDataProvider data = new TimeDepositApplyDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(TIMEDEPOSITAPPLYBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        TimeDepositApplyDataProvider data = new TimeDepositApplyDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(TIMEDEPOSITAPPLYBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void onLoad() throws Exception {
        if (!"FINDVIEW".equals(this.getOprtState())) {
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
        super.onLoad();
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.td.app.TimeDepositApplyTDQuery");
    }

    protected void execQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "PaymentBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)ApplyBillStatusEnum.AUDITED.getValue(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("applyType", (Object)ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER.getValue(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("applyType", (Object)ApplyTimeDepositTypeEnum.CALLDEPOSIT_OUTER.getValue(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isCreatePayment", (Object)new Integer(1), CompareType.NOTEQUALS));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY");
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and (#1 or #2) and #3 and #4");
            try {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        super.execQuery();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TimeDepositApplyFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        return new TimeDepositApplyInfo();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TimeDepositApplyFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected String getEditUIName() {
        return TimeDepositApplyEditUI.class.getName();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEditOrDel();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEditOrDel() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        Object value = ((BizEnumValueDTO)this.tblMain.getRow(rowNumber).getCell("state").getValue()).getValue();
        if (!ApplyBillStatusEnum.SAVE.getValue().equals(value) && !ApplyBillStatusEnum.SUBMIT.getValue().equals(value)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"timeDepositApplyUpdate"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet<Object> idSet = new HashSet<Object>();
        Set rowNumbers = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (rowNumbers != null && rowNumbers.size() > 0) {
            Iterator rowNumber = rowNumbers.iterator();
            while (rowNumber.hasNext()) {
                int number = (Integer)rowNumber.next();
                Object value = ((BizEnumValueDTO)this.tblMain.getRow(number).getCell("state").getValue()).getValue();
                if (value.equals(ApplyBillStatusEnum.SAVE.getValue())) {
                    idSet.add(this.tblMain.getRow(number).getCell("id").getValue());
                }
                Iterator iterator = idSet.iterator();
                while (iterator.hasNext()) {
                    TimeDepositApplyInfo applyInfo = new TimeDepositApplyInfo();
                    BOSUuid id = BOSUuid.read((String)((String)iterator.next()));
                    applyInfo.setId(id);
                    TimeDepositApplyFactory.getRemoteInstance().submit((CoreBaseInfo)applyInfo);
                }
            }
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        TimeDepositApplyFactory.getRemoteInstance().auditBatch(new HashSet(this.getSelectedIdValues()));
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int status = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("status").getValue()).getInt();
        if (status == 2) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_antiaudit"));
            SysUtil.abort();
        }
        TimeDepositApplyFactory.getRemoteInstance().antiAuditBatch(new HashSet(this.getSelectedIdValues()));
        this.refreshList();
    }

    public FilterInfo getFilterInfo() {
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)ApplyBillStatusEnum.AUDITED.getValue(), CompareType.EQUALS));
        Map btpMap = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (btpMap.get("FROME") != null && btpMap.get("FROME").equals("TIMEDEPOSIT")) {
            filter.getFilterItems().add(new FilterItemInfo("isTimeDepBank", (Object)new Integer(1), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", btpMap.get("COMPANYID"), CompareType.EQUALS));
        } else if (btpMap.get("FROME") != null && btpMap.get("FROME").equals("COMPDEPOSIT")) {
            filter.getFilterItems().add(new FilterItemInfo("isBalanceBill", (Object)new Integer(1), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("saveingOrg.relatedCompany.id", btpMap.get("COMPANYID"), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void actionSubmitBank_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int status = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("status").getValue()).getInt();
        String state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("state").getValue()).toString();
        String stype = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("type").getValue()).toString();
        if (status != 1 && status != 5) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_req"));
            SysUtil.abort();
        }
        if (!stype.equals(ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER.getAlias())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_req"));
            SysUtil.abort();
        }
        if (!state.equals(ApplyBillStatusEnum.AUDITED.getAlias())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_audit"));
            SysUtil.abort();
        }
        ArrayList idList = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        ITimeDepositApply timeDepositApp = TimeDepositApplyFactory.getRemoteInstance();
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        RegularFixTransInfo regularBizInfo = new RegularFixTransInfo();
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 0) {
            String id = (String)ids.get(0);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add("*");
            sic.add("currency.id");
            sic.add("currency.name");
            sic.add("currency.number");
            sic.add("payerAccount.*");
            sic.add("payeeAccount.*");
            sic.add("intTermID.*");
            sic.add("company.*");
            sic.add("saveingOrg.*");
            TimeDepositApplyInfo info = timeDepositApp.getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(id), sic);
            CurrencyInfo currencyInfo = info.getCurrency();
            String[] accountBanks = new String[]{""};
            accountBanks[0] = info.getPayerAccount().getId().toString();
            if (!info.getPayerAccount().isIsSetBankInterface()) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_bankinterface"));
                SysUtil.abort();
            }
            if (!info.getPayerAccount().getBank().equals((Object)info.getSaveingOrg())) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_dept"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            String uiName = FixedMutualUpdateTermUI.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            FixedMutualRenewFlagEnum updateState = ((FixedMutualUpdateTermUI)uiWindow.getUIObject()).getResult();
            IntTermInfo intTermInfo = ((FixedMutualUpdateTermUI)uiWindow.getUIObject()).getInfoResult();
            if (updateState == null) {
                return;
            }
            String saveTerm = info.getIntTermID().getNumber();
            if ((saveTerm = this.transTerm(saveTerm)) == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_selterm"));
                SysUtil.abort();
            }
            int depositTermValue = this.transValueTerm(saveTerm);
            String depositTermUnit = this.transUnitTerm(saveTerm);
            String nextDepositTermUnit = null;
            String saveIntTerm = null;
            int nextDepositTermValue = 0;
            if (intTermInfo != null) {
                saveIntTerm = this.transTerm(intTermInfo.getNumber());
                nextDepositTermValue = this.transValueTerm(saveIntTerm);
                nextDepositTermUnit = this.transUnitTerm(saveIntTerm);
                if (saveIntTerm == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_selterm"));
                    SysUtil.abort();
                }
            }
            regularBizInfo.setCurrentAccNo(info.getPayerAccount().getBankAccountNumber());
            if (info.getPayeeAccount() != null) {
                regularBizInfo.setFixedAccNo(info.getPayeeAccount().getBankAccountNumber());
            } else {
                regularBizInfo.setFixedAccNo(info.getPayerAccount().getBankAccountNumber());
            }
            regularBizInfo.setDepositTermValue(depositTermValue);
            regularBizInfo.setDepositTermUnit(depositTermUnit);
            regularBizInfo.setNextDepositType(String.valueOf(updateState.getValue()));
            regularBizInfo.setNextDepositTermValue(nextDepositTermValue);
            regularBizInfo.setNextDepositTermUnit(nextDepositTermUnit);
            regularBizInfo.setAmount(String.valueOf(info.getApplyAmount()));
            timeDepositApp.submitBank(pks[0]);
            Map rst = bankFacade.TransRegular(regularBizInfo, currencyInfo, accountBanks, info);
            if (rst != null && rst.size() > 0) {
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"79_TransDetailListUI"));
            }
        }
        this.refreshList();
    }

    public String transTerm(String term) {
        if (term != null) {
            if (term.indexOf("60M") == 0) {
                return "Y05";
            }
            if (term.indexOf("36M") == 0) {
                return "Y03";
            }
            if (term.indexOf("24M") == 0) {
                return "Y02";
            }
            if (term.indexOf("12M") == 0 || term.indexOf("360D") == 0) {
                return "Y01";
            }
            if (term.indexOf("6M") == 0 || term.indexOf("180D") == 0) {
                return "M06";
            }
            if (term.indexOf("3M") == 0 || term.indexOf("90D") == 0) {
                return "M03";
            }
            return null;
        }
        return "";
    }

    public int transValueTerm(String term) {
        if (term != null) {
            return Integer.parseInt(term.substring(2, 3));
        }
        return 0;
    }

    public String transUnitTerm(String term) {
        if (term != null) {
            if (term.indexOf("M") == 0) {
                return "MONTH";
            }
            if (term.indexOf("Y") == 0) {
                return "YEAR";
            }
            if (term.indexOf("W") == 0) {
                return "WEEK";
            }
            if (term.indexOf("D") == 0) {
                return "DAY";
            }
            return null;
        }
        return "";
    }

    protected final class FillListener
    implements KDTDataFillListener {
        protected FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            IRow currentRow = null;
            String currencyID = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                currentRow = TimeDepositApplyListUI.this.tblMain.getRow(i);
                currencyID = (String)currentRow.getCell("currencyID").getValue();
                if (currencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"applyAmount", (String)currencyID);
                }
                currentRow.getCell("baseRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                currentRow.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ICell baseRate = currentRow.getCell("baseRate");
                ICell rate = currentRow.getCell("rate");
                if (currentRow.getCell("intRateTypeExpression").getValue() != null) {
                    String rateExpression = currentRow.getCell("intRateTypeExpression").getValue().toString();
                    if (rateExpression == null) continue;
                    if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                        baseRate.getStyleAttributes().setNumberFormat("###,##0.00000\\%");
                        rate.getStyleAttributes().setNumberFormat("###,##0.00000\\%");
                        continue;
                    }
                    baseRate.getStyleAttributes().setNumberFormat("###,##0.00000\\\u2030");
                    rate.getStyleAttributes().setNumberFormat("###,##0.00000\\\u2030");
                    continue;
                }
                baseRate.getStyleAttributes().setNumberFormat("###,##0.00000\\%");
                rate.getStyleAttributes().setNumberFormat("###,##0.00000\\%");
            }
        }
    }
}

