/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.BaseDataF7ContextUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.DepTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.td.BillTypeEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositConstants;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.client.AbstractTimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.IntReceivedBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;

public class TimeDepositBillEditUI
extends AbstractTimeDepositBillEditUI {
    private static final String CUR_ACCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"cur_account");
    private static final String OUT_ACCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"out_account");
    private CompanyOrgUnitInfo currentCompany;
    private boolean TD002 = false;
    private CompanyOrgUnitInfo companyInfo = null;
    private TimeDepositHelper helper;
    private BigDecimal matureIntAmtIntending = Constants.ZERO;
    private Map successHm;
    private boolean isCopy = false;
    private boolean isSubmit = false;

    public TimeDepositBillEditUI() throws Exception {
        this.helper = TimeDepositHelper.getInstance();
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.companyInfo == null) {
            this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "fm_td_04add";
        }
        return "fm_td_01view";
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        if (this.editData.getExchangeRate() != null) {
            this.txtexchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        if (this.editData.getDepositLocalAmt() != null) {
            this.txtLocalAmt.setValue((Object)this.editData.getDepositLocalAmt());
        }
        if (this.editData.getExchangeRate() == null) {
            try {
                this.calcRate(this.editData.getCurrency(), null, null, (Date)this.dpBizDate.getValue());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            this.txtexchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.txtBalance.setValue((Object)this.editData.getBalance());
        this.txtmatureIntAmt.setValue((Object)this.editData.getMatureIntAmtIntending());
        this.txtyearRate.setValue((Object)this.editData.getYearRate());
        this.comboCurrency.setEnabled(false);
        Boolean b = (Boolean)this.getUIContext().get("effectedDateCanBeEdited");
        if (b == null) {
            b = Boolean.TRUE;
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            boolean isEnabled = b == false;
            this.pkeffectiveDate.setEnabled(isEnabled);
            this.pkdlastRecvIntDay.setEnabled(isEnabled);
            this.prmtintTerm.setEnabled(isEnabled);
            this.comboRateExpression.setEnabled(isEnabled);
            this.txtyearDays.setEnabled(isEnabled);
            this.txtDescription.setEnabled(isEnabled);
            this.ptmtHandler.setEnabled(isEnabled);
            this.txtyearRate.setEnabled(isEnabled);
            this.txtcurYearRate.setEnabled(isEnabled);
        }
        this.txtmatureIntAmt.setValue((Object)this.editData.getMatureIntAmtIntending());
        if (this.editData.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.editData.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            this.contintTerm.setVisible(true);
            this.contmaturityDay.setVisible(true);
            this.kDLabelContainer3.setVisible(false);
        } else {
            this.contintTerm.setVisible(false);
            this.kDLabelContainer3.setVisible(true);
            this.contintRateTable.setVisible(true);
            if (this.getOprtState() == OprtState.EDIT) {
                this.comboRateExpression.setEnabled(false);
                this.txtyearDays.setEnabled(false);
            }
        }
        this.pkmaturityDay.setValue((Object)this.editData.getMaturityDay());
        this.txtyearDays.setPrecision(0);
        AccountBankInfo depAcct = (AccountBankInfo)this.prmtbankDepAcct.getValue();
        if (depAcct == null) {
            this.prmtdepositBank.setValue((Object)this.editData.getDepositBank());
        }
        if (FMHelper.isInstanceof((String)this.editData.getSourceBillId(), TimeDepositApplyInfo.class)) {
            this.prmtbankDepAcct.setEnabled(false);
        } else {
            this.prmtbankDepAcct.setEnabled(true);
        }
        if (this.editData.getDepositCompany() != null) {
            CompanyOrgUnitInfo depositCompany = null;
            try {
                depositCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getDepositCompany().getId()));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtCompany.setValue(depositCompany);
            this.editData.setDepositCompany(depositCompany);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setYearDays();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBalance(this.txtBalance.getBigDecimalValue());
        if (this.editData.isIsHistoryBill()) {
            this.editData.setInitBalanceOfHistoryBill(this.editData.getBalance());
        } else {
            this.editData.setInitBalanceOfHistoryBill(this.editData.getDepositAmt());
        }
        if (!this.editData.isIsHistoryBill()) {
            this.editData.setLastRecvIntDay(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        }
        this.editData.setHandler(FMClientHelper.getUserByF7Person((CoreUI)this, (KDBizPromptBox)this.ptmtHandler));
        this.editData.setLastUnDepositDate(this.editData.getEffectiveDate());
        this.editData.setFivouchered(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (BillTypeEnum.getEnum((String)this.getUIContext().get("UIClassParam")) == BillTypeEnum.BANK) {
            this.btnCreateFrom.setVisible(true);
        }
    }

    public void onLoad() throws Exception {
        this.dpBizDate.setSupportedEmpty(false);
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.txtdepositAmt.setSupportedEmpty(false);
        this.txtdepositAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtdepositAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtBalance.setSupportedEmpty(false);
        this.txtfloorAmt.setSupportedEmpty(false);
        this.txtfloorAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtyearRate.setSupportedEmpty(false);
        this.txtBaseRate.setSupportedEmpty(false);
        this.txtcurYearRate.setSupportedEmpty(false);
        this.txtmatureIntAmt.setEnabled(false);
        this.txtcertificateNo.setMaxLength(80);
        Boolean isRTD = (Boolean)this.getUIContext().get("ISRTD");
        Boolean isHis = (Boolean)this.getUIContext().get("ISHIS");
        if (isHis != null && isHis.booleanValue()) {
            this.initControlToHis(isHis);
        } else if (isRTD != null) {
            this.initControlToRedeposit(isRTD == false);
        }
        super.onLoad();
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(true);
        this.actionCopy.setVisible(true);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.txtyearDays.setMinimumValue((Comparable)new Integer(1));
        this.calcMatureIntAmt();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.isIsHistoryBill()) {
            this.pkdlastRecvIntDay.setVisible(true);
            this.contLastRecvIntDay.setVisible(true);
        }
        this.setDataStatus();
        this.menuTable1.setVisible(false);
        this.menuBiz.setVisible(false);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.ptmtHandler);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAccountant);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtCreator);
        BaseDataF7ContextUtil.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtdepositBank);
        this.txtDescription.setMaxLength(80);
        this.TD002 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TD002", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.isAccrualPrincipal.isEnabled()) {
            this.isAccrualPrincipal.setSelected(true);
        }
        if (this.getOprtState().equals("CERTIFICATEEDIT")) {
            Component[] compArr = this.getComponents();
            for (int i = 0; i < compArr.length; ++i) {
                if (this.concertificateNo.getName().equals(compArr[i].getName())) {
                    compArr[i].setEnabled(true);
                    continue;
                }
                compArr[i].setEnabled(false);
            }
        }
        if (this.companyInfo == null || !this.companyInfo.isIsBizUnit()) {
            this.menuSubmitOption.setEnabled(false);
            this.MenuItemAttachment.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.btnAttachment.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        UIUtil.setFirstFocus((Component[])new Component[]{this.txtNumber, this.dpBizDate});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtyearRate.setPrecision(5);
        this.txtcurYearRate.setPrecision(5);
        this.txtBaseRate.setPrecision(5);
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForLocalAmt() {
        this.txtLocalAmt.setPrecision(this.getBaseCurrencyPrecision());
    }

    private void setDataStatus() {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (this.editData.getEffectedStatus() == EffectedStatusEnum.EFFECTED) {
                this.comboRateExpression.setEnabled(false);
                this.txtyearDays.setEnabled(false);
                this.pkeffectiveDate.setEnabled(true);
                this.prmtdepositBank.setEnabled(false);
            } else {
                this.comboDepositType.setEnabled(true);
                this.comboRateExpression.setEnabled(true);
                this.txtyearDays.setEnabled(true);
                this.dpBizDate.setEnabled(true);
                this.txtexchangeRate.setEnabled(true);
                this.pkeffectiveDate.setEnabled(true);
                this.prmtdepositBank.setEnabled(true);
            }
            if (this.editData.isIsAddedByReceive()) {
                this.pkeffectiveDate.setEnabled(false);
                this.prmtintTerm.setEnabled(false);
            }
            if (this.editData.isIsHistoryBill()) {
                this.pkdlastRecvIntDay.setEnabled(true);
            } else {
                this.pkdlastRecvIntDay.setEnabled(false);
            }
            Boolean b = (Boolean)this.getUIContext().get("effectedDateCanBeEdited");
            if (b == null) {
                b = Boolean.TRUE;
            }
            this.pkeffectiveDate.setEnabled(b == false);
            this.pkdlastRecvIntDay.setEnabled(b == false);
            this.prmtintTerm.setEnabled(b == false);
            this.pkeffectiveDate.setEnabled(!this.editData.isIsAddedByReDeposit());
        }
        this.txtmatureIntAmt.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        TimeDepositBillInfo info = (TimeDepositBillInfo)this.getDataObject();
        Boolean isHis = (Boolean)this.getUIContext().get("ISHIS");
        if (isHis != null && isHis.booleanValue()) {
            info.setIsHistoryBill(true);
        }
        if (info.isIsAddedByReDeposit()) {
            this.isAccrualPrincipal.setVisible(true);
            this.isAccrualPrincipal.setSelected(true);
            if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
                this.isAccrualPrincipal.setEnabled(false);
            } else {
                this.isAccrualPrincipal.setEnabled(true);
            }
            this.prmtdepositBank.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.txtdepositAmt.setEnabled(false);
            this.prmtbankCurAcct.setEnabled(false);
            this.pkeffectiveDate.setEnabled(false);
        } else {
            this.isAccrualPrincipal.setVisible(false);
            this.isAccrualPrincipal.setSelected(false);
            if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
                this.isAccrualPrincipal.setEnabled(false);
            } else {
                this.isAccrualPrincipal.setEnabled(true);
            }
            this.prmtdepositBank.setEnabled(true);
            this.comboCurrency.setEnabled(true);
            this.txtdepositAmt.setEnabled(true);
            this.prmtbankCurAcct.setEnabled(true);
            this.pkeffectiveDate.setEnabled(true);
        }
        if (info.isIsHistoryBill()) {
            this.pkdlastRecvIntDay.setVisible(true);
            this.contLastRecvIntDay.setVisible(true);
            this.txtBalance.setEnabled(true);
            this.pkdlastRecvIntDay.setSupportedEmpty(false);
            this.pkdlastRecvIntDay.setRequired(true);
        } else {
            this.pkdlastRecvIntDay.setVisible(false);
            this.contLastRecvIntDay.setVisible(false);
            this.txtBalance.setEnabled(false);
            this.pkdlastRecvIntDay.setSupportedEmpty(true);
            this.pkdlastRecvIntDay.setRequired(false);
        }
        this.pkeffectiveDate.setSupportedEmpty(false);
        this.pkmaturityDay.setSupportedEmpty(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        if (info.isIsAddedByReDeposit()) {
            this.contbankCurAcct.setBoundLabelText(OUT_ACCOUNT);
        } else {
            this.contbankCurAcct.setBoundLabelText(CUR_ACCOUNT);
        }
        boolean isAddNew = info.getEffectedStatus() == null || info.getEffectedStatus() == EffectedStatusEnum.TEMPSTORE;
        this.setBillControlStatusByParam(isAddNew, info.isIsAddedByReDeposit());
        if (info.isIsAddedByReDeposit()) {
            this.pkeffectiveDate.setEnabled(false);
        } else {
            this.pkeffectiveDate.setEnabled(true);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.comboDepositType.setEnabled(false);
            this.txtexchangeRate.setEnabled(false);
            this.dpBizDate.setEnabled(false);
        } else {
            this.comboDepositType.setEnabled(true);
            this.dpBizDate.setEnabled(true);
            this.ptmtHandler.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.txtmatureIntAmt.setEnabled(false);
        }
        boolean isActionEnabled = this.getOprtState().equals(OprtState.VIEW) || "FINDVIEW".equals(this.getOprtState());
        this.actionCreateFrom.setEnabled(!isActionEnabled);
        this.actionCreateFrom.setVisible(!isActionEnabled);
        if (info.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || info.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            this.txtyearRate.setEditable(true);
        } else {
            this.txtyearRate.setEditable(false);
        }
        UIUtil.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        if (isHis != null && (isHis.booleanValue() || info.isIsHistoryBill())) {
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"57_TimeDepositBillEditUI"), this.getUITitle());
            this.setUITitle(msgStr);
        }
    }

    private void initControlToHis(boolean isHisBill) {
        this.txtBalance.setEnabled(isHisBill);
        this.contLastRecvIntDay.setVisible(isHisBill);
        if (isHisBill) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"historyBillUITile"));
        }
    }

    private void initControlToRedeposit(boolean isRedeposit) {
        this.comboDepositType.setEnabled(isRedeposit);
        this.prmtdepositBank.setEnabled(isRedeposit);
        this.comboCurrency.setEnabled(isRedeposit);
        this.txtdepositAmt.setEnabled(isRedeposit);
        this.btnSave.setVisible(isRedeposit);
        this.isAccrualPrincipal.setVisible(!isRedeposit);
        if (!isRedeposit) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"redepositUITitle"));
        }
    }

    private void setBillControlStatusByParam(boolean isEnabled, boolean isaddedByredeposit) {
        this.prmtdepositBank.setEnabled(isEnabled);
        this.comboCurrency.setEnabled(isEnabled);
        this.txtdepositAmt.setEnabled(isEnabled);
        this.txtexchangeRate.setEnabled(isEnabled);
        this.txtyearDays.setEnabled(isEnabled);
        this.txtmatureIntAmt.setEnabled(isEnabled);
        this.txtfloorAmt.setEnabled(isEnabled);
        this.txtcertificateNo.setEnabled(isEnabled);
        this.txtcurYearRate.setEnabled(isEnabled);
        this.pkeffectiveDate.setEnabled(false);
        if (isaddedByredeposit) {
            this.prmtdepositBank.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.pkeffectiveDate.setEnabled(false);
            this.txtdepositAmt.setEnabled(false);
            this.prmtbankCurAcct.setEnabled(false);
        }
    }

    @Override
    protected String getEditUIName() {
        return TimeDepositBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TimeDepositBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        TimeDepositBillInfo objectValue = (TimeDepositBillInfo)super.createNewData();
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            try {
                TimeDepositBillInfo oldInfo = (TimeDepositBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                objectValue = oldInfo.copy();
                objectValue.setHandler(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                this.isCopy = true;
                map.remove("COPY");
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        } else {
            Boolean isRTD = (Boolean)this.getUIContext().get("ISRTD");
            Boolean isHis = (Boolean)this.getUIContext().get("ISHIS");
            if (isRTD != null) {
                objectValue.setIsAddedByReDeposit(isRTD);
            } else {
                objectValue.setIsAddedByReDeposit(false);
            }
            if (isHis != null) {
                objectValue.setIsHistoryBill(isHis);
                objectValue.setLastRecvIntDay(DateUtil.getDayBegin());
            } else {
                objectValue.setIsHistoryBill(false);
                objectValue.setLastRecvIntDay(null);
            }
            objectValue.setCompany(this.currentCompany);
            objectValue.setDepositCompany(this.currentCompany);
            objectValue.setEffectiveDate(DateUtil.getDayBegin());
            objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            objectValue.setDepositAmt(Constants.ZERO);
            objectValue.setBalance(Constants.ZERO);
            objectValue.setHandler(objectValue.getCreator());
            objectValue.setFloating(Constants.ZERO);
            objectValue.setYearRate(Constants.ZERO);
            objectValue.setMatureIntAmtIntending(Constants.ZERO);
            objectValue.setCurYearRate(Constants.ZERO);
            objectValue.setBizDate(DateUtil.getDayBegin());
            objectValue.setCurrency(this.companyInfo.getBaseCurrency());
            objectValue.setTimeDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
            objectValue.setFloorAmt(Constants.ZERO);
            objectValue.setFivouchered(false);
            objectValue.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            objectValue.setYearDays(360);
            objectValue.setIsReDeposited(false);
            objectValue.setIsAddedByReceive(false);
            objectValue.setComDepositBillID(null);
            if (objectValue.isIsAddedByReDeposit()) {
                this.copyValueToNewData_rtd(objectValue);
            }
        }
        return objectValue;
    }

    private void copyValueToNewData_rtd(TimeDepositBillInfo objectValue) {
        String id = (String)this.getUIContext().get("infoid");
        TimeDepositBillInfo timeDepositBillInfo = null;
        try {
            timeDepositBillInfo = (TimeDepositBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
        objectValue.setIntRateTypeExpression(timeDepositBillInfo.getIntRateTypeExpression());
        objectValue.setSourceBillId(id);
        objectValue.setDepositBank(timeDepositBillInfo.getDepositBank());
        objectValue.setTimeDepositType(timeDepositBillInfo.getTimeDepositType());
        objectValue.setEffectiveDate(DateTimeUtils.truncateDate((Date)timeDepositBillInfo.getMaturityDay()));
        objectValue.setIntTerm(timeDepositBillInfo.getIntTerm());
        if (this.isOther(timeDepositBillInfo.getIntTerm())) {
            objectValue.setMaturityDay(DateUtil.getAfterDay((Date)objectValue.getEffectiveDate()));
        } else {
            objectValue.setMaturityDay(this.helper.calcMaturityDay(objectValue.getEffectiveDate(), objectValue.getIntTerm()));
        }
        objectValue.setYearRate(timeDepositBillInfo.getYearRate());
        objectValue.setYearDays(timeDepositBillInfo.getYearDays());
        objectValue.setBankDepAcct(timeDepositBillInfo.getBankDepAcct());
        objectValue.setBankCurAcct(timeDepositBillInfo.getBankDepAcct());
        objectValue.setCurrency(timeDepositBillInfo.getCurrency());
        objectValue.setDepositAmt(timeDepositBillInfo.getBalance());
        objectValue.setHandler(timeDepositBillInfo.getHandler());
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"58_TimeDepositBillEditUI"), timeDepositBillInfo.getNumber());
        objectValue.setDescription(msgStr);
        objectValue.setIsAddedByReDeposit(true);
        objectValue.setBalance(objectValue.getDepositAmt());
        objectValue.setSourceBillId(id);
        objectValue.setAccrualToDepositAmt(Constants.ZERO);
        objectValue.setIntRateTable(timeDepositBillInfo.getIntRateTable());
        objectValue.setCertificateNo(timeDepositBillInfo.getCertificateNo());
        this.matureIntAmtIntending = timeDepositBillInfo.getMatureIntAmtIntending();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        this.doBizVerify();
    }

    private void doBizVerify() throws TDException, EASBizException, BOSException {
        if (this.txtfloorAmt.getBigDecimalValue().compareTo(this.txtdepositAmt.getBigDecimalValue()) > 0) {
            this.txtfloorAmt.requestFocus();
            throw new TDException(TDException.FLOORAMT_TOO_LAGER);
        }
        if (this.editData.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_INNER && this.editData.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_OUTER && this.editData.getEffectiveDate().compareTo(this.editData.getMaturityDay()) >= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"36_TimeDepositBillEditUI"));
            this.pkmaturityDay.requestFocus();
            SysUtil.abort();
        }
        if (!FMClientHelper.verifyIsPlus((String)this.txtdepositAmt.getBigDecimalValue().toString())) {
            this.txtdepositAmt.requestFocus(true);
            throw new TDException(TDException.AMT_NEGATIVE_EXC);
        }
        if (!FMClientHelper.verifyIsPlus1((String)this.txtfloorAmt.getBigDecimalValue().toString())) {
            this.txtfloorAmt.requestFocus(true);
            throw new TDException(TDException.FLOORAMT_NEGATIVE_EXC);
        }
        if (!FMClientHelper.verifyIsPlus((String)this.txtyearRate.getBigDecimalValue().toString())) {
            this.txtyearRate.requestFocus(true);
            FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtyearRate, (BigDecimal)Constants.ZERO);
        }
        if (!FMClientHelper.verifyIsPlus1((String)this.txtcurYearRate.getBigDecimalValue().toString())) {
            this.txtcurYearRate.requestFocus(true);
            throw new TDException(TDException.CURYEARRATE_NEAGTIVE_EXC);
        }
        this.checkCtrlStrategy();
        if (this.editData.isIsAddedByReDeposit()) {
            this.checkBillDateValid((Date)this.dpBizDate.getValue());
        }
        if (this.editData.isIsHistoryBill()) {
            Date startDate;
            if (this.txtBalance.getBigDecimalValue().intValue() <= 0 || this.txtBalance.getBigDecimalValue().doubleValue() > this.txtdepositAmt.getBigDecimalValue().doubleValue()) {
                this.txtBalance.requestFocus();
                throw new TDException(TDException.HIS_REMAMT_OVERMANY);
            }
            Date lastRecDate = (Date)this.pkdlastRecvIntDay.getValue();
            if (lastRecDate.compareTo(startDate = (Date)this.pkeffectiveDate.getValue()) < 0) {
                throw new TDException(TDException.HIS_LASTRECDATE_EXC);
            }
        }
        this.checkCurrency();
    }

    private void checkCurrency() throws TDException {
        AccountBankInfo cbi = (AccountBankInfo)this.prmtbankDepAcct.getValue();
        if (cbi.getCurrency() != null) {
            CurrencyInfo infoC = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (!cbi.getCurrency().getId().toString().equals(infoC.getId().toString())) {
                throw new TDException(TDException.BAD_CURRENCY);
            }
        }
    }

    private void checkBillDateValid(Date depositDate) throws BOSException, TDException {
        String id = this.editData.getSourceBillId();
        Date maxUnDeDeposutDate = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositDateByTiemDeposit(id);
        if (null != maxUnDeDeposutDate && depositDate.compareTo(maxUnDeDeposutDate) < 0) {
            throw new TDException(TDException.REDEPOSIT_EXE1);
        }
    }

    @Override
    protected void pkeffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkeffectiveDate_dataChanged(e);
        if (this.editData.isIsHistoryBill()) {
            Date lastRecDate = (Date)this.pkdlastRecvIntDay.getValue();
            Date startDate = (Date)this.pkeffectiveDate.getValue();
            if (lastRecDate != null && startDate != null && lastRecDate.compareTo(startDate) < 0) {
                this.pkdlastRecvIntDay.setValue((Object)startDate);
            }
        }
        this.calcMaturityDay();
        this.calcMatureIntAmt();
        this.calYearRate();
    }

    @Override
    protected void pkmaturityDay_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void prmtintTerm_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMaturityDay();
        this.calcMatureIntAmt();
    }

    @Override
    protected void comboDepositType_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositTypeEnum depositType = (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem();
        if (depositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || depositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            this.doSettingRelatedToTimeDeposit();
        } else {
            this.doSettingRelatedToCallDeposit();
        }
        if (!(this.TD002 || depositType != TimeDepositTypeEnum.TIMEDEPOSIT_OUTER && depositType != TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            this.prmtbankCurAcct.setRequired(false);
        } else {
            this.prmtbankCurAcct.setRequired(true);
        }
        this.calYearDays();
        this.calcMatureIntAmt();
        this.calYearRate();
    }

    @Override
    public void txtyearDays_dataChanged(DataChangeEvent e) {
        this.calcMatureIntAmt();
    }

    private void doSettingRelatedToCallDeposit() {
        this.contyearRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"RefYearRate"));
        this.txtmatureIntAmt.setValue((Object)new BigDecimal(String.valueOf(0)));
        this.txtmatureIntAmt.setEnabled(false);
        this.prmtintTerm.setEnabled(false);
        this.prmtintTerm.setValue(null);
        this.comboRateExpression.setEnabled(false);
        this.kDLabelContainer3.setVisible(true);
        this.comboDepType.setSelectedItem((Object)DepTypeEnum.SevenDay);
        this.contintRateTable.setVisible(true);
        this.contintTerm.setVisible(false);
        this.pkmaturityDay.setValue(null);
        this.prmtintTerm.setValue(null);
        this.prmtintTerm.setRequired(false);
        this.pkmaturityDay.setRequired(false);
        this.txtyearRate.setRequired(true);
        this.txtcurYearRate.setRequired(true);
        this.prmtintRateTable.setRequired(true);
        this.txtcurYearRate.setRequired(true);
        this.txtyearRate.setEnabled(false);
    }

    private void doSettingRelatedToTimeDeposit() {
        String strValue = EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"37_TimeDepositBillEditUI");
        this.contyearRate.setBoundLabelText(strValue);
        this.kDLabelContainer3.setVisible(false);
        this.comboRateExpression.setEnabled(true);
        this.prmtintTerm.setEnabled(true);
        this.txtyearDays.setEnabled(true);
        this.contintTerm.setVisible(true);
        this.contmaturityDay.setVisible(true);
        this.prmtintRateTable.setValue(null);
        this.prmtintTerm.setRequired(true);
        this.pkmaturityDay.setRequired(true);
        this.prmtintRateTable.setRequired(false);
        this.txtyearRate.setRequired(true);
        this.txtcurYearRate.setRequired(true);
        this.txtyearRate.setEnabled(true);
        this.comboDepType.setSelectedItem(null);
        this.editData.setNull("depType");
    }

    protected void yearDays_actionPerformed(ActionEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void txtdepositAmt_dataChanged(DataChangeEvent e) throws Exception {
        this.txtBalance.setMaximumValue((Comparable)this.txtdepositAmt.getBigDecimalValue());
        this.txtBalance.setValue((Object)this.txtdepositAmt.getBigDecimalValue());
        this.txtfloorAmt.setMaximumValue((Comparable)this.txtdepositAmt.getBigDecimalValue());
        this.calcMatureIntAmt();
        this.calcNaturalAmt();
        this.calcRemAmt();
    }

    @Override
    public void txtfloorAmt_dataChanged(DataChangeEvent e) {
        this.calcMatureIntAmt();
    }

    @Override
    protected void txtexchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcNaturalAmt();
    }

    private void calcRemAmt() {
        this.txtBalance.setValue((Object)this.txtdepositAmt.getBigDecimalValue());
    }

    @Override
    protected void prmtintRateTable_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
        this.calYearRate();
        this.setYearDays();
    }

    private void setYearDays() {
        IntRateTypeInfo rateType = (IntRateTypeInfo)this.prmtintRateTable.getValue();
        if (rateType != null) {
            if (rateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=")) {
                this.txtyearDays.setValue((Object)new Integer(360));
                this.comboRateExpression.setEnabled(true);
                this.txtyearDays.setEnabled(true);
            } else {
                this.comboRateExpression.setSelectedItem((Object)rateType.getRateExpression());
                this.txtyearDays.setValue((Object)new Integer(rateType.getFactorDay()));
                this.comboRateExpression.setEnabled(false);
                this.txtyearDays.setEnabled(false);
            }
        }
    }

    protected void txtfloating_dataChanged(DataChangeEvent e) throws Exception {
        this.calYearRate();
    }

    @Override
    protected void txtyearRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setPrecision();
        if (currencyInfo == null) {
            return;
        }
        String baseCurrencyId = this.companyInfo.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currencyInfo.getId().toString())) {
            this.txtexchangeRate.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtexchangeRate.setEnabled(true);
        }
        this.calcRate(currencyInfo, null, this.companyInfo, (Date)this.dpBizDate.getValue());
        this.calcNaturalAmt();
        this.calYearRate();
    }

    @Override
    public void comboRateExpression_actionPerformed(ActionEvent e) {
        this.calYearDays();
    }

    @Override
    protected void prmtdepositBank_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.editData.isIsAddedByReDeposit()) {
            this.prmtbankCurAcct.setValue(null);
        }
    }

    @Override
    protected void prmtintRateTable_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ=", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtintRateTable.setEntityViewInfo(evi);
        this.prmtintRateTable.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtdepositBank_willShow(SelectorEvent e) throws Exception {
        this.setPrmtdepositBankFilter();
    }

    private void setPrmtdepositBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtdepositBank.setEntityViewInfo(evi);
        this.prmtdepositBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtdepositBank_willCommit(CommitEvent e) throws Exception {
        this.setPrmtdepositBankFilter();
    }

    @Override
    protected void prmtbankCurAcct_willShow(SelectorEvent e) throws Exception {
        this.setPrmtbankCurAcctFilter();
    }

    @Override
    protected void prmtbankCurAcct_willCommit(CommitEvent e) throws Exception {
        this.setPrmtbankCurAcctFilter();
    }

    private void setPrmtbankCurAcctFilter() {
        int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"38_TimeDepositBillEditUI"));
        if (result == 0) {
            this.prmtbankCurAcct.setEntityViewInfo(this.getBankAccountFilter(AccountBankPropertyEnum.Current, (BankInfo)this.prmtdepositBank.getValue()));
            this.prmtbankCurAcct.getQueryAgent().resetRuntimeEntityView();
        } else {
            this.prmtbankCurAcct.setEntityViewInfo(this.getBankAccountAllFilter());
            this.prmtbankCurAcct.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    public void prmtbankCurAcct_dataChanged(DataChangeEvent e) {
        AccountBankInfo abi = (AccountBankInfo)this.prmtbankCurAcct.getValue();
        if (abi != null && abi.getCurrency() != null) {
            CurrencyInfo oldCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (oldCurrency == null || !oldCurrency.getId().equals((Object)abi.getCurrency().getId())) {
                UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)abi.getCurrency());
            }
            this.comboCurrency.setEnabled(false);
        } else {
            CurrencyInfo oldCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (oldCurrency == null || !oldCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
                UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.currentCompany.getBaseCurrency());
            }
            this.comboCurrency.setEnabled(true);
        }
    }

    @Override
    protected void prmtbankDepAcct_willShow(SelectorEvent e) throws Exception {
        this.setPrmtbankDepAcctFilter();
    }

    private void setPrmtbankDepAcctFilter() {
        this.prmtbankDepAcct.setEntityViewInfo(this.getBankAccountFilter(AccountBankPropertyEnum.Fixed, null));
        this.prmtbankDepAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void prmtbankDepAcct_willCommit(CommitEvent e) {
        this.setPrmtbankDepAcctFilter();
    }

    private EntityViewInfo getBankAccountFilter(AccountBankPropertyEnum property, BankInfo bankInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        if (bankInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankInfo.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(property.getValue())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    private EntityViewInfo getBankAccountAllFilter() {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        evi.setFilter(filter);
        return evi;
    }

    private void calcRate(CurrencyInfo currencyInfo, String destCurrId, CompanyOrgUnitInfo company, Date date) throws Exception {
        this.txtexchangeRate.setPrecision(5);
        this.txtexchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, (CompanyOrgUnitInfo)company, (Date)date));
    }

    private void calcNaturalAmt() {
        BigDecimal depositAmt = this.txtdepositAmt.getBigDecimalValue();
        BigDecimal exchangeRate = this.txtexchangeRate.getBigDecimalValue();
        if (depositAmt == null || exchangeRate == null) {
            return;
        }
        this.txtLocalAmt.setValue((Object)depositAmt.multiply(exchangeRate));
    }

    private void calcMatureIntAmt() {
        TimeDepositTypeEnum depositType = (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem();
        if (depositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || depositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            if (this.txtdepositAmt.getBigDecimalValue() == null || this.txtyearRate.getBigDecimalValue() == null || this.prmtintTerm.getValue() == null) {
                this.txtmatureIntAmt.setValue((Object)Constants.ZERO);
                return;
            }
            BigDecimal depositAmt = (BigDecimal)this.txtdepositAmt.getValue(BigDecimal.class);
            BigDecimal yearrate = (BigDecimal)this.txtyearRate.getValue(BigDecimal.class);
            int yearDays = this.txtyearDays.getIntegerValue();
            if (this.pkmaturityDay.getValue() == null || this.pkeffectiveDate.getValue() == null) {
                return;
            }
            int intervalDays = 0;
            IntTermInfo termInfo = (IntTermInfo)this.prmtintTerm.getValue();
            intervalDays = TimeDepositHelper.getInstance().value_TD001(this.currentCompany) && termInfo.getType() == TermTypeEnum.MONTH ? termInfo.getTerm() * 30 : (TimeDepositHelper.getInstance().value_TD001(this.currentCompany) && termInfo.getType() == TermTypeEnum.YEAR ? termInfo.getTerm() * 360 : TimeDepositHelper.getInstance().calcuIntervalDays((Date)this.pkmaturityDay.getValue(), (Date)this.pkeffectiveDate.getValue()));
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
            BigDecimal base = Constants.ONE_HUNDRED;
            if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
                base = Constants.ONE_THOUSAND;
            }
            if (this.txtfloorAmt.getBigDecimalValue() != null) {
                depositAmt = depositAmt.subtract(this.txtfloorAmt.getBigDecimalValue());
            }
            BigDecimal intAmt = this.helper.calcMatureIntAmt(depositAmt, yearrate, new BigDecimal(String.valueOf(yearDays)), new BigDecimal(String.valueOf(intervalDays)), base);
            this.txtmatureIntAmt.setValue((Object)intAmt);
        } else {
            this.txtmatureIntAmt.setValue((Object)Constants.ZERO);
        }
    }

    private void calYearDays() {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        String strValue = "";
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtyearDays.setValue((Object)TimeDepositConstants.VALUE_360);
            strValue = this.contyearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contyearRate.setBoundLabelText(strValue);
            strValue = this.contcurYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contcurYearRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contBaseRate.setBoundLabelText(strValue);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtyearDays.setValue((Object)TimeDepositConstants.VALUE_30);
            strValue = this.contyearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contyearRate.setBoundLabelText(strValue);
            strValue = this.contcurYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contcurYearRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        } else {
            this.txtyearDays.setValue((Object)TimeDepositConstants.VALUE_1);
            strValue = this.contyearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contyearRate.setBoundLabelText(strValue);
            strValue = this.contcurYearRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contcurYearRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        }
    }

    private void calcMaturityDay() {
        Date startday = (Date)this.pkeffectiveDate.getValue();
        IntTermInfo intterm = (IntTermInfo)this.prmtintTerm.getValue();
        if (intterm == null || startday == null) {
            return;
        }
        if (this.isOther(intterm)) {
            this.pkmaturityDay.setEnabled(true);
            this.pkmaturityDay.setMinimumDate(DateUtil.getAfterDay((Date)((Date)this.pkeffectiveDate.getValue())));
            this.pkmaturityDay.setValue((Object)DateUtil.getAfterDay((Date)((Date)this.pkeffectiveDate.getValue())));
        } else {
            this.pkmaturityDay.setValue((Object)this.helper.calcMaturityDay(startday, intterm));
            this.pkmaturityDay.setEnabled(false);
        }
    }

    private boolean isOther(IntTermInfo intterm) {
        return intterm.getId().toString().equals("jhNyIgEWEADgAAr6wKgSC61eI6Y=");
    }

    private void calYearRate() throws Exception {
        IntRateTypeInfo intType = (IntRateTypeInfo)this.prmtintRateTable.getValue();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (intType == null || null == currency) {
            this.txtyearRate.setValue((Object)new Integer(0));
            this.txtBaseRate.setValue((Object)new Integer(0));
            return;
        }
        BigDecimal yearrate = this.helper.calcYearRate(null, intType, currency, (Date)this.pkeffectiveDate.getValue());
        this.txtyearRate.setValue((Object)yearrate);
        this.txtBaseRate.setValue((Object)yearrate);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.editData.isIsAddedByReDeposit()) {
            Boolean succ;
            this.verify(e);
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            TimeDepositBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            this.editData.setBalance(this.editData.getDepositAmt());
            TimeDepositBillInfo rInfo = this.editData;
            if (rInfo.getId() == null) {
                this.editData.setId(BOSUuid.create((BOSObjectType)rInfo.getBOSType()));
            }
            if (!this.isSubmit) {
                try {
                    this.isSubmit = true;
                    this.successHm = IntReceivedBillEditUI.showIntReceiveEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData, "2", (String)this.getUIContext().get("infoid"));
                }
                finally {
                    this.isSubmit = false;
                }
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.successHm != null && (succ = (Boolean)this.successHm.get("successFlag")) != null && succ.booleanValue()) {
                this.uiWindow.close();
            }
        } else {
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        UIUtil.setFirstFocus((Component[])new Component[]{this.txtNumber, this.dpBizDate});
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("intTerm.*"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        return sic;
    }

    private void checkCtrlStrategy() throws TDException, EASBizException, BOSException {
        BigDecimal lowestBalance;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ctrlStrategy.lowestBalance"));
        sic.add(new SelectorItemInfo("ctrlStrategy.startAmount"));
        AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(this.editData.getBankDepAcct().getId()), sic);
        if (info.getCtrlStrategy() != null && (lowestBalance = info.getCtrlStrategy().getStartAmount().multiply(Constants.TEN_THOUSAND)) != null && this.editData.getDepositAmt().compareTo(lowestBalance) < 0) {
            this.txtdepositAmt.requestFocus();
            throw new TDException(TDException.DEPOSIT_AMT_LACK);
        }
    }

    public static void showReDeopsitWindow(CoreUIObject ui, String selectedValue, int type) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"infoid", (Object)selectedValue);
            uiContext.put((Object)"ISRTD", (Object)Boolean.TRUE);
            uiContext.put((Object)"effectedDateCanBeEdited", (Object)Boolean.FALSE);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(TimeDepositBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            Map successHm = ((TimeDepositBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    @Override
    public void isAccrualPrincipal_stateChanged(ChangeEvent e) {
    }

    public Map getSuccessHm() {
        return this.successHm;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected void prmtbankDepAcct_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo depAcct = (AccountBankInfo)this.prmtbankDepAcct.getValue();
        if (depAcct == null) {
            if (!this.editData.isIsAddedByReDeposit()) {
                this.prmtdepositBank.setValue(null);
            }
            this.prmtdepositBank.setEnabled(true);
            this.prmtbankDepAcct.requestFocus();
        } else {
            if (depAcct.getBank() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("bank.*");
                depAcct = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(depAcct.getId()), sic);
                this.prmtdepositBank.setValue((Object)depAcct.getBank());
            } else {
                BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(depAcct.getBank().getId()));
                this.prmtdepositBank.setValue((Object)bank);
            }
            this.prmtdepositBank.setEnabled(false);
            this.prmtbankCurAcct.requestFocus();
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("FROME", "TIMEDEPOSIT");
        ctx.put("COMPANYID", ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        this.getBillEdit().createFrom(null, ctx);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        TimeDepositBillInfo info = (TimeDepositBillInfo)dataObject;
        if (this.getBOTPViewStatus() != 1) {
            return;
        }
        try {
            String sourceBillId = info.getSourceBillId();
            if (sourceBillId == null) {
                return;
            }
            BOSUuid sbid = BOSUuid.read((String)sourceBillId);
            if (!sbid.getType().equals((Object)new TimeDepositApplyInfo().getBOSType())) {
                info.setBalance(info.getDepositAmt());
                info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
                info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
                info.setBizDate(DateUtil.getDayBegin());
                info.setHandler(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                info.setFivouchered(false);
                info.setYearDays(360);
                info.setIsReDeposited(false);
                info.setIsAddedByReceive(false);
                info.setComDepositBillID(null);
                if (EmptyUtil.isEmpty((Object)info.getFloorAmt())) {
                    info.setFloorAmt(Constants.ZERO);
                }
                return;
            }
            SelectorItemCollection sic = super.getSelectors();
            sic.add(new SelectorItemInfo("*"));
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getRemoteInstance().getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            if (info.getDepositCompany() == null) {
                info.setDepositCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            }
            if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.TIMEDEPOSIT_INNER.toString())) {
                info.setTimeDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
                this.doSettingRelatedToTimeDeposit();
                this.txtyearRate.setEditable(true);
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.TIMEDEPOSIT_OUTER.toString())) {
                info.setTimeDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_OUTER);
                this.doSettingRelatedToTimeDeposit();
                this.txtyearRate.setEditable(true);
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.CALLDEPOSIT_INNER.toString())) {
                info.setTimeDepositType(TimeDepositTypeEnum.CALLDEPOSIT_INNER);
                this.doSettingRelatedToCallDeposit();
                this.txtyearRate.setEditable(true);
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.CALLDEPOSIT_OUTER.toString())) {
                info.setTimeDepositType(TimeDepositTypeEnum.CALLDEPOSIT_OUTER);
                this.doSettingRelatedToCallDeposit();
                this.txtyearRate.setEditable(true);
            }
            if (timeDepositApplyInfo.getPayerAccount() != null) {
                info.setBankCurAcct(AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(timeDepositApplyInfo.getPayerAccount().getId())));
            }
            if (timeDepositApplyInfo.getPayeeAccount() != null) {
                info.setBankDepAcct(AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(timeDepositApplyInfo.getPayeeAccount().getId())));
            }
            if (timeDepositApplyInfo.getIntTermID() != null) {
                IntTermInfo intTermInfo = (IntTermInfo)IntTermFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositApplyInfo.getIntTermID().getId().toString()));
                info.setIntTerm(intTermInfo);
                if (info.getEffectiveDate() != null) {
                    info.setMaturityDay(this.helper.calcMaturityDay(info.getEffectiveDate(), intTermInfo));
                } else {
                    info.setMaturityDay(this.helper.calcMaturityDay((Date)this.pkeffectiveDate.getValue(), intTermInfo));
                }
            }
            info.setYearRate(timeDepositApplyInfo.getRate());
            info.setBalance(info.getDepositAmt());
            info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            if (timeDepositApplyInfo.getIntRateTable() != null) {
                IntRateTypeExpressionEnum intRateTypeExpression = timeDepositApplyInfo.getIntRateTable().getRateExpression();
                info.setIntRateTypeExpression(intRateTypeExpression == null ? IntRateTypeExpressionEnum.YEAR : intRateTypeExpression);
            } else {
                info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            }
            info.setBizDate(DateUtil.getDayBegin());
            info.setHandler(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            info.setFivouchered(false);
            info.setYearDays(360);
            info.setIsReDeposited(false);
            info.setIsAddedByReceive(false);
            info.setComDepositBillID(null);
            info.setBaseRate(timeDepositApplyInfo.getBaseRate());
            info.setIntRateTable(timeDepositApplyInfo.getIntRateTable());
            if (EmptyUtil.isEmpty((Object)info.getFloorAmt())) {
                info.setFloorAmt(Constants.ZERO);
            }
            this.getUIContext().put("effectedDateCanBeEdited", Boolean.FALSE);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isCopy = true;
        this.checkModified();
        if (this.editData != null) {
            TimeDepositBillInfo newEditData = this.editData.copy();
            newEditData.setHandler(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            newEditData.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            newEditData.setId(BOSUuid.create((BOSObjectType)newEditData.getBOSType()));
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        if (srcBosTypeList == null) {
            return srcBosTypeList;
        }
        if (srcBosTypeList.contains(new CompDepositAccountBillInfo().getBOSType().toString())) {
            srcBosTypeList.remove(new CompDepositAccountBillInfo().getBOSType().toString());
        }
        return srcBosTypeList;
    }

    public static void showModifyCertificateNoWindow(CoreUIObject ui, String selectedValue) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"ID", (Object)selectedValue);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TimeDepositBillEditUI.class.getName(), (Map)uiContext, null, "CERTIFICATEEDIT");
            if (uiWindow instanceof UIDialog) {
                FMClientHelper.settleUIDialogDimension((UIDialog)((UIDialog)uiWindow), (IUIObject)uiWindow.getUIObject());
            }
            uiWindow.show();
            Map successHm = ((TimeDepositBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "effectiveDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

