/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.RegularFixTransInfo;
import com.kingdee.eas.fm.be.ws.CurrentTransInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ApplyTimeDepositTypeEnum;
import com.kingdee.eas.fm.td.IUnTimeDepositApplyBill;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.fm.td.client.AbstractUnTimeDepositApplyBillListUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositApplyBillFilterParam;
import com.kingdee.eas.fm.td.client.UnTimeDepositApplyBillFilterUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnTimeDepositApplyBillListUI
extends AbstractUnTimeDepositApplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(UnTimeDepositApplyBillListUI.class);
    private UnTimeDepositApplyBillFilterUI filterUI;
    private String path = "com.kingdee.eas.fm.td.TimeDeposittResource";
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public UnTimeDepositApplyBillListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return UnTimeDepositApplyBillFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("unDepositDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected void execQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "TimeDeposit".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)"audited", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isCreCmpUnTmDep", (Object)new Integer(1), CompareType.NOTEQUALS));
            String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            try {
                filterInfo.getFilterItems().add(new FilterItemInfo("depositBank.id", (Object)BankFactory.getRemoteInstance().getClearingHouse(companyId).getId(), CompareType.EQUALS));
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            filterInfo = this.getSrcBillCollFilter(filterInfo, CompDepositAccountBillInfo.class);
            try {
                UnTimeDepositApplyBillFilterParam unTimeDepositApplyBillFilterParam = (UnTimeDepositApplyBillFilterParam)((Object)this.getFilterUI().getParam());
                FilterInfo queryFilterInfo = this.buildFilterInfo(unTimeDepositApplyBillFilterParam);
                filterInfo.mergeFilter(queryFilterInfo, "AND");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            try {
                UnTimeDepositApplyBillFilterParam unTimeDepositApplyBillFilterParam = (UnTimeDepositApplyBillFilterParam)((Object)this.getFilterUI().getParam());
                filterInfo = this.buildFilterInfo(unTimeDepositApplyBillFilterParam);
                FilterInfo mainFilterInfo = this.mainQuery.getFilter();
                filterInfo.mergeFilter(mainFilterInfo, "AND");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            this.mainQuery.setFilter(filterInfo);
        }
        super.execQuery();
    }

    public FilterInfo getFilterInfo() {
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"audited", CompareType.EQUALS));
        Map btpMap = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (btpMap != null && btpMap.get("TargetBillType") != null) {
            if (btpMap.get("TargetBillType").equals("TimeDeposit")) {
                filter.getFilterItems().add(new FilterItemInfo("isGenUnTDBill", (Object)new Integer(1), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
            }
            if (btpMap.get("TargetBillType").equals("CompDepositAccountBill")) {
                filter.getFilterItems().add(new FilterItemInfo("isCreCmpUnTmDep", (Object)new Integer(1), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("depositBank.relatedCompany.id", btpMap.get("companyID"), CompareType.EQUALS));
            }
        }
        return filter;
    }

    private FilterInfo getSrcBillCollFilter(FilterInfo filter, Class srcInfoCls) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        CoreBaseCollection applyCol = null;
        try {
            applyCol = UnTimeDepositApplyBillFactory.getRemoteInstance().getCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        HashSet<String> applyIDs = new HashSet<String>();
        for (int i = 0; i < applyCol.size(); ++i) {
            UnTimeDepositApplyBillInfo applyInfo = (UnTimeDepositApplyBillInfo)applyCol.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)applyInfo) || FMHelper.isEmpty((String)applyInfo.getSourceBillId()) || !FMHelper.isInstanceof((String)applyInfo.getSourceBillId(), (Class)srcInfoCls)) continue;
            applyIDs.add(applyInfo.getSourceBillId());
        }
        if (applyIDs.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", applyIDs, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    protected IObjectValue createNewData() {
        UnTimeDepositApplyBillInfo objectValue = new UnTimeDepositApplyBillInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new UnTimeDepositApplyBillFilterUI();
        }
        return this.filterUI;
    }

    private FilterInfo buildFilterInfo(UnTimeDepositApplyBillFilterParam applyFilterParam) {
        FilterInfo filter = new FilterInfo();
        if (applyFilterParam == null) {
            return filter;
        }
        if (applyFilterParam.getDpStartDate() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)applyFilterParam.getDpStartDate(), CompareType.GREATER_EQUALS));
        }
        if (applyFilterParam.getDpEndDate() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)applyFilterParam.getDpEndDate(), CompareType.LESS_EQUALS));
        }
        if (applyFilterParam.getUnDepositTypeEnum() != null) {
            filter.getFilterItems().add(new FilterItemInfo("unDepositType", (Object)applyFilterParam.getUnDepositTypeEnum().getValue(), CompareType.EQUALS));
        }
        if (applyFilterParam.getApplyBillStatusEnum() != null) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)applyFilterParam.getApplyBillStatusEnum().getValue(), CompareType.EQUALS));
        }
        if (applyFilterParam.getCurrencyInfo() != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)applyFilterParam.getCurrencyInfo().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        return filter;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEditOrDel();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEditOrDel();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEditOrDel() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        Object value = ((BizEnumValueDTO)this.tblMain.getRow(rowNumber).getCell("billState").getValue()).getValue();
        if (!ApplyBillStatusEnum.SAVE.getValue().equals(value) && !ApplyBillStatusEnum.SUBMIT.getValue().equals(value)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"unTimeDepositApplyBillEditOrDel"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet<Object> idSet = new HashSet<Object>();
        Set rowNumbers = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (rowNumbers != null && rowNumbers.size() > 0) {
            Iterator rowNumber = rowNumbers.iterator();
            while (rowNumber.hasNext()) {
                int number = (Integer)rowNumber.next();
                Object value = ((BizEnumValueDTO)this.tblMain.getRow(number).getCell("billState").getValue()).getValue();
                if (value.equals(ApplyBillStatusEnum.SAVE.getValue())) {
                    idSet.add(this.tblMain.getRow(number).getCell("id").getValue());
                }
                Iterator iterator = idSet.iterator();
                while (iterator.hasNext()) {
                    UnTimeDepositApplyBillInfo applyInfo = new UnTimeDepositApplyBillInfo();
                    BOSUuid id = BOSUuid.read((String)((String)iterator.next()));
                    applyInfo.setId(id);
                    UnTimeDepositApplyBillFactory.getRemoteInstance().submit((CoreBaseInfo)applyInfo);
                }
            }
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        boolean hasWf = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            UnTimeDepositApplyBillFactory.getRemoteInstance().auditBatch(new HashSet(this.getSelectedIdValues()));
        }
        this.refreshList();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmitBank.setEnabled(true);
        this.actionSubmitBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int status = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("status").getValue()).getInt();
        if (status == 2) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_deptaudit"));
            SysUtil.abort();
        }
        UnTimeDepositApplyBillFactory.getRemoteInstance().antiAuditBatch(new HashSet(this.getSelectedIdValues()));
        this.refreshList();
    }

    @Override
    public void actionSubmitBank_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int status = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("status").getValue()).getInt();
        String state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("billState").getValue()).toString();
        String stype = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("unDepositType").getValue()).toString();
        String deptype = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("depositType").getValue()).toString();
        if (status != 1) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_req"));
            SysUtil.abort();
        }
        if (!deptype.equals(ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER.getAlias())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_req"));
            SysUtil.abort();
        }
        if (!stype.equals(UnDepositTypeEnum.MATURE_UNDEPOSIT.getAlias())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_req"));
            SysUtil.abort();
        }
        if (!state.equals(ApplyBillStatusEnum.AUDITED.getAlias())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_audit"));
            SysUtil.abort();
        }
        ArrayList idList = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        IUnTimeDepositApplyBill untimeDepositApp = UnTimeDepositApplyBillFactory.getRemoteInstance();
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        CurrentTransInfo currentTransInfo = new CurrentTransInfo();
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 0) {
            String id = (String)ids.get(0);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add("*");
            sic.add("currency.id");
            sic.add("currency.name");
            sic.add("currency.number");
            sic.add("payeeAccount.*");
            sic.add("payerAccount.*");
            sic.add("company.*");
            sic.add("depositBank.*");
            sic.add("payeeAccount.bank.*");
            UnTimeDepositApplyBillInfo info = untimeDepositApp.getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            CurrencyInfo currencyInfo = info.getCurrency();
            String[] accountBanks = new String[]{""};
            if (info.getPayeeAccount() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_bankinterface"));
                SysUtil.abort();
            }
            if (!info.getPayeeAccount().isIsSetBankInterface()) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_bankinterface"));
                SysUtil.abort();
            }
            if (!info.getPayeeAccount().getBank().equals((Object)info.getDepositBank())) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixeddep_dept"));
                SysUtil.abort();
            }
            if (info.getDepositBank().isInGroup()) {
                MsgBox.showInfo((String)EASResource.getString((String)this.path, (String)"fixed_outdept"));
                SysUtil.abort();
            }
            accountBanks[0] = info.getPayeeAccount().getId().toString();
            currentTransInfo.setCshDraFlag(String.valueOf(1));
            currentTransInfo.setCurrency(info.getCurrency().toString());
            currentTransInfo.setAmount(info.getApplyAmount());
            RegularFixTransInfo regularBizInfo = new RegularFixTransInfo();
            regularBizInfo.setCurrentAccNo(info.getPayeeAccount().getBankAccountNumber());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccount())) {
                regularBizInfo.setFixedAccNo(info.getPayeeAccount().getBankAccountNumber());
            } else {
                regularBizInfo.setFixedAccNo(info.getPayeeAccount().getBankAccountNumber());
            }
            regularBizInfo.setAmount(String.valueOf(info.getApplyAmount()));
            untimeDepositApp.submitBank(pks[0]);
            Map rst = bankFacade.TransCurrent(regularBizInfo, currencyInfo, accountBanks, info);
            if (rst != null && rst.size() > 0) {
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"79_TransDetailListUI"));
            }
        }
        this.refreshList();
    }

    @Override
    protected String getTDFileName() {
        return "/fm/invest/td/undepositapply";
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            IRow currentRow = null;
            String currencyID = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                currentRow = UnTimeDepositApplyBillListUI.this.tblMain.getRow(i);
                currencyID = (String)currentRow.getCell("currency.id").getValue();
                if (currencyID == null) continue;
                FMClientHelper.setNumberFormat((IRow)currentRow, (String)"applyAmount", (String)currencyID);
            }
        }
    }
}

