/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.hr.base.BConfJobGradeTypeCollection;
import com.kingdee.eas.hr.base.BConfJobGradeTypeFactory;
import com.kingdee.eas.hr.base.BConfJobGradeTypeInfo;
import com.kingdee.eas.hr.base.DefaultJobGradeTypeEnum;
import com.kingdee.eas.hr.base.DefaultJobGradeTypeOutcome;
import com.kingdee.eas.hr.base.HRBillConfFactory;
import com.kingdee.eas.hr.base.HRBillConfParam;
import com.kingdee.eas.hr.base.HRBillConfigInfo;
import com.kingdee.eas.hr.base.IBConfJobGradeType;
import com.kingdee.eas.hr.base.client.AbstractBConfJobGradeTypeUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BConfJobGradeTypeUI
extends AbstractBConfJobGradeTypeUI {
    private static final Logger logger = CoreUIObject.getLogger(BConfJobGradeTypeUI.class);
    private BConfJobGradeTypeCollection bconfJobGradeTypeColletion = null;
    private DefaultJobGradeTypeEnum gradeTypeCopy = DefaultJobGradeTypeEnum.NULL;
    private String oldValue = "";
    private String newValue = "";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.loadFields();
        KDComboBox cboGradeType = new KDComboBox();
        cboGradeType.addItems(DefaultJobGradeTypeEnum.getEnumList().toArray());
        this.tblMain.getColumn("jobGradeType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboGradeType));
        this.setCanCopyPaste(false);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    BConfJobGradeTypeUI.this.actionKeyPressed(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.tblMain.getColumn("hro.Name").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("jobGradeType").getStyleAttributes().setWrapText(true);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)i);
        }
    }

    private void actionKeyPressed(KeyEvent e) throws Exception {
        int row;
        if (128 == e.getModifiersEx() && e.getKeyCode() == 67 && (row = KDTableUtil.getSelectedRow((KDTable)this.tblMain)) >= 0) {
            this.gradeTypeCopy = (DefaultJobGradeTypeEnum)((Object)this.tblMain.getRow(row).getCell("jobGradeType").getValue());
        }
        if (128 == e.getModifiersEx() && e.getKeyCode() == 86) {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int len = rows.length;
            for (int i = 0; i < rows.length; ++i) {
                this.tblMain.getRow(rows[i]).getCell("jobGradeType").setValue((Object)this.gradeTypeCopy);
            }
        }
    }

    @Override
    public void loadFields() {
        try {
            this.loadData();
            this.storeFields();
            this.oldValue = this.newValue;
            this.updateCache();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void storeFields() {
        this.bconfJobGradeTypeColletion = new BConfJobGradeTypeCollection();
        this.newValue = "";
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            BConfJobGradeTypeInfo confTypeInfo = new BConfJobGradeTypeInfo();
            String hroId = (String)this.tblMain.getRow(i).getCell("hro.Id").getValue();
            HROrgUnitInfo hro = new HROrgUnitInfo();
            hro.setId(BOSUuid.read((String)hroId));
            confTypeInfo.setHrOrgUnit(hro);
            DefaultJobGradeTypeEnum gradeTypeEnum = (DefaultJobGradeTypeEnum)((Object)this.tblMain.getRow(i).getCell("jobGradeType").getValue());
            confTypeInfo.setJobGradeType(gradeTypeEnum);
            String hrBillConfigId = (String)this.getUIContext().get("hrBillConfigId");
            HRBillConfigInfo hrBillConfigInfo = new HRBillConfigInfo();
            hrBillConfigInfo.setId(BOSUuid.read((String)hrBillConfigId));
            confTypeInfo.setHrBillConfig(hrBillConfigInfo);
            this.newValue = this.newValue + hroId + hrBillConfigId + confTypeInfo.getJobGradeType().getAlias() + "";
            this.bconfJobGradeTypeColletion.add(confTypeInfo);
        }
    }

    private void loadData() throws Exception {
        Map confJobGradeTypeMap = this.getConfJobGradeTypeMap();
        HROrgUnitCollection hroCol = this.getHroColletion();
        this.tblMain.removeRows();
        int size = hroCol.size();
        for (int i = 0; i < size; ++i) {
            HROrgUnitInfo hro = hroCol.get(i);
            String hroId = hro.getId().toString();
            IRow row = this.tblMain.addRow();
            row.getCell("hro.Id").setValue((Object)hroId);
            row.getCell("hro.Name").setValue((Object)hro.getName());
            row.getCell("jobGradeType").setValue(confJobGradeTypeMap.get(hroId));
            if (confJobGradeTypeMap.get(hroId) != null) continue;
            row.getCell("jobGradeType").setValue((Object)DefaultJobGradeTypeEnum.NULL);
        }
    }

    private HROrgUnitCollection getHroColletion() throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer orgRangeSql = new StringBuffer();
        orgRangeSql.append("select forgId from T_PM_OrgRange where ftype = ");
        orgRangeSql.append(10);
        orgRangeSql.append(" and fuserid = '");
        orgRangeSql.append(userID);
        orgRangeSql.append("' ");
        String oql = "where id in (" + orgRangeSql.toString() + ") and isBizUnit=1 and isSealUp=0 order by longNumber";
        IHROrgUnit iHro = HROrgUnitFactory.getRemoteInstance();
        HROrgUnitCollection hroCol = iHro.getHROrgUnitCollection(oql);
        return hroCol;
    }

    private Map getConfJobGradeTypeMap() throws Exception {
        IBConfJobGradeType iBConfType = BConfJobGradeTypeFactory.getRemoteInstance();
        String hrBillConfigId = (String)this.getUIContext().get("hrBillConfigId");
        String oql = "where hrBillConfig.id='" + hrBillConfigId + "'";
        BConfJobGradeTypeCollection col = iBConfType.getBConfJobGradeTypeCollection(oql);
        HashMap<String, DefaultJobGradeTypeEnum> map = new HashMap<String, DefaultJobGradeTypeEnum>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String hroId = col.get(i).getHrOrgUnit().getId().toString();
            DefaultJobGradeTypeEnum jobGradeType = col.get(i).getJobGradeType();
            map.put(hroId, jobGradeType);
        }
        return map;
    }

    private void updateCache() {
        if (this.bconfJobGradeTypeColletion == null) {
            return;
        }
        int size = this.bconfJobGradeTypeColletion.size();
        for (int i = 0; i < size; ++i) {
            BConfJobGradeTypeInfo info = this.bconfJobGradeTypeColletion.get(i);
            String uiName = (String)this.getUIContext().get("hrBillConfigNumber");
            HRBillConfParam param = new HRBillConfParam(info.getHrOrgUnit(), uiName);
            DefaultJobGradeTypeOutcome outcome = new DefaultJobGradeTypeOutcome(info.getJobGradeType());
            try {
                HRBillConfFactory.getHRBillConfSupervisor("gradeType").updateCache(param, outcome);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public boolean destroyWindow() {
        this.storeFields();
        if (!this.oldValue.equals(this.newValue)) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"3_BConfApproveTypeUI"));
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                this.storeFields();
                try {
                    BConfJobGradeTypeFactory.getRemoteInstance().saveBatch(this.bconfJobGradeTypeColletion);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void actionConfSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (this.bconfJobGradeTypeColletion == null || this.bconfJobGradeTypeColletion.size() == 0) {
            return;
        }
        BConfJobGradeTypeFactory.getRemoteInstance().saveBatch(this.bconfJobGradeTypeColletion);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"4_BConfApproveTypeUI"));
        this.loadFields();
    }

    public boolean isNeedSaveUI() {
        this.storeFields();
        if (!this.oldValue.equals(this.newValue)) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"3_BConfApproveTypeUI"));
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                this.storeFields();
                try {
                    BConfJobGradeTypeFactory.getRemoteInstance().saveBatch(this.bconfJobGradeTypeColletion);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                return true;
            }
        }
        return false;
    }
}

