/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CodingRuleManager {
    public static final Color REQUIRE_FIELD_COLOR = UIManager.getColor("TextField.requiredBackground");
    public static final Color DISABLE_FIELD_COLOR = CtrlUtil.Color.parseColor((String)"#D3D3D3");
    private JTextField txtNumber = null;
    private ICell cell = null;
    private IColumn column = null;
    private ICodingRuleManageFacade icrmFacade = null;
    private IObjectValue bizObject = null;
    private String orgID = null;
    private boolean isExistRule = false;
    private boolean isModifable = true;

    public CodingRuleManager(JTextField txtNumber, IObjectValue bizObject, ICodingRuleManageFacade icrmFacade) {
        this.txtNumber = txtNumber;
        this.bizObject = bizObject;
        this.icrmFacade = icrmFacade;
    }

    public CodingRuleManager(JTextField txtNumber, IObjectValue bizObject) {
        this(txtNumber, bizObject, null);
    }

    public CodingRuleManager(ICell cell, IObjectValue bizObject, ICodingRuleManageFacade icrmFacade) {
        this.cell = cell;
        this.bizObject = bizObject;
        this.icrmFacade = icrmFacade;
    }

    public CodingRuleManager(ICell cell, IObjectValue bizObject) {
        this(cell, bizObject, null);
    }

    public CodingRuleManager(IColumn column, IObjectValue bizObject, ICodingRuleManageFacade icrmFacade) {
        this.column = column;
        this.bizObject = bizObject;
        this.icrmFacade = icrmFacade;
    }

    public void setIcrmFacade(ICodingRuleManageFacade icrmFacade) {
        this.icrmFacade = icrmFacade;
    }

    public void setBizObject(IObjectValue bizObject) {
        this.bizObject = bizObject;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public boolean isExistRule() {
        return this.isExistRule;
    }

    public boolean isModifable() {
        if (this.isExistRule) {
            return this.isModifable;
        }
        return true;
    }

    public String apply() throws Exception {
        if (this.bizObject == null) {
            return null;
        }
        if (this.icrmFacade == null) {
            this.icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstance();
        }
        CodingRuleData codingRuleData = this.icrmFacade.getCodingRuleData(this.bizObject, this.orgID);
        this.isExistRule = codingRuleData.isExistRule();
        String number = null;
        if (this.isExistRule) {
            if (codingRuleData.isAddView()) {
                number = codingRuleData.getNumber();
            }
            this.isModifable = codingRuleData.isModifable();
            this.setControlState(this.isModifable);
        } else {
            this.setControlState(true);
        }
        if (this.txtNumber != null) {
            this.txtNumber.setText(number);
        }
        if (this.cell != null) {
            this.cell.setValue((Object)number);
        }
        return number;
    }

    private void setControlState(boolean enable) {
        if (this.txtNumber != null) {
            this.txtNumber.setEnabled(enable);
        }
        if (this.cell != null) {
            if (enable) {
                this.cell.getStyleAttributes().setLocked(false);
                this.cell.getStyleAttributes().setBackground(REQUIRE_FIELD_COLOR);
            } else {
                this.cell.getStyleAttributes().setLocked(true);
                this.cell.getStyleAttributes().setBackground(DISABLE_FIELD_COLOR);
            }
        }
        if (this.column != null) {
            if (enable) {
                this.column.getStyleAttributes().setLocked(false);
                this.column.getStyleAttributes().setBackground(REQUIRE_FIELD_COLOR);
            } else {
                this.column.getStyleAttributes().setLocked(true);
                this.column.getStyleAttributes().setBackground(DISABLE_FIELD_COLOR);
            }
        }
    }
}

