/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizCollection;
import com.kingdee.eas.hr.affair.AffairBizFactory;
import com.kingdee.eas.hr.affair.AffairBizInfo;
import com.kingdee.eas.hr.base.EntityFieldInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.EntityFieldMappingInfo;
import com.kingdee.eas.hr.base.EntityListMapping;
import com.kingdee.eas.hr.base.EntitySettingCollection;
import com.kingdee.eas.hr.base.EntitySettingInfo;
import com.kingdee.eas.hr.base.EntityTreeMapping;
import com.kingdee.eas.hr.base.Expression;
import com.kingdee.eas.hr.base.ExpressionNode;
import com.kingdee.eas.hr.base.ExpressionValue;
import com.kingdee.eas.hr.base.FieldMapping;
import com.kingdee.eas.hr.base.FieldMappingException;
import com.kingdee.eas.hr.base.MappingLogicEnum;
import com.kingdee.eas.hr.base.MappingOperationEnum;
import com.kingdee.eas.hr.base.MappingSolutionFactory;
import com.kingdee.eas.hr.base.MappingSolutionInfo;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.eas.hr.base.client.AbstractEntityFieldMappingUI;
import com.kingdee.eas.hr.base.client.HREntityDataSelector;
import com.kingdee.eas.hr.base.client.NullVerifier;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.base.util.MappingUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EntityFieldMappingUI
extends AbstractEntityFieldMappingUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityFieldMappingUI.class);
    public static final String ENTITY_META = "ENTITY_META";
    public static final String BINDING = "BINDING";
    public static final String HRO = "HRO";
    private String sourceEntity = null;
    private EntityTreeMapping loadTree = null;
    private EntityListMapping bindList = null;
    private KDTDefaultCellEditor emptyEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox());
    private final int entityMergeCol = 0;
    private final int fieldMergeCol = 1;
    private int selectTab = 0;
    private DefaultComboBoxModel tarModel = new DefaultComboBoxModel();
    private HashSet tarModelSet = new HashSet();
    private HashMap propModels = new HashMap();
    private DefaultComboBoxModel srcModel = null;
    private IMetaDataLoader loader = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblEntity.checkParsed();
        this.initEditor();
        super.onLoad();
        this.sourceEntity = this.editData.getEntity();
        this.tHelper.getDisabledTables().add(this.tblEntity);
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.selectTab = this.tpSetting.getSelectedIndex();
        if (this.editData.isEnable()) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        if (this.tblMain.getRowCount() <= 0) {
            this.tblMain.addRow();
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.setSomeActionState();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.setOprtState(this.getOprtState());
    }

    private void setSomeActionState() {
        if ("VIEW".equals(this.oprtState)) {
            this.actionAddLine.setEnabled(false);
            this.actionDeleteLine.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            if (this.editData != null && this.editData.isEnable()) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            }
        } else {
            this.actionAddLine.setEnabled(true);
            this.actionDeleteLine.setEnabled(true);
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setSomeActionState();
    }

    private IMetaDataLoader getMetaDataLoader() {
        if (this.loader == null) {
            this.loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        }
        return this.loader;
    }

    private void initEditor() throws Exception {
        KDBizPromptBox prmtEntity = new KDBizPromptBox();
        prmtEntity.setSelector((KDPromptSelector)new HREntityDataSelector((Component)((Object)this)));
        prmtEntity.setEditable(false);
        this.tblEntity.getStyleAttributes().setLocked(false);
        this.tblEntity.getColumn("entity").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntity));
        this.tblEntity.getColumn("newOnNotExist").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tblEntity.getColumn("field").getStyleAttributes().setLocked(true);
        KDComboBox cbLogic = new KDComboBox();
        DefaultComboBoxModel<MappingLogicEnum> mLogic = new DefaultComboBoxModel<MappingLogicEnum>();
        mLogic.addElement(MappingLogicEnum.NONE);
        mLogic.addElement(MappingLogicEnum.AND);
        mLogic.addElement(MappingLogicEnum.OR);
        cbLogic.setModel(mLogic);
        this.tblEntity.getColumn("logic").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbLogic));
        KDComboBox cb = new KDComboBox();
        cb.addItems(MappingOperationEnum.getEnumList().toArray());
        this.tblEntity.getColumn("operation").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cb));
        this.tblMain.getColumn("targetEntity").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.tarModel)));
        this.initHRF7();
    }

    @Override
    protected void tblEntity_editStopped(KDTEditEvent e) throws Exception {
        MetaInfo info;
        int col = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.tblEntity.getRow(rowIndex);
        IRow tRow = null;
        if (col == this.tblEntity.getColumn("entity").getColumnIndex()) {
            info = (MetaInfo)e.getValue();
            KDTMergeBlock block = this.getMergeBlock(this.tblEntity, rowIndex, col);
            KDTDefaultCellEditor editor = null;
            if (info != null) {
                editor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.getPropertiesModel(info.getName())));
            }
            if (block != null) {
                for (int i = block.getTop(); i <= block.getBottom(); ++i) {
                    tRow = this.tblEntity.getRow(i);
                    if (info != null) {
                        if (info.equals(e.getOldValue())) continue;
                        tRow.getCell("field").setEditor((ICellEditor)editor);
                        tRow.getCell("field").getStyleAttributes().setLocked(false);
                        tRow.getCell("field").setValue(null);
                        continue;
                    }
                    tRow.getCell("field").setEditor((ICellEditor)this.emptyEditor);
                    tRow.getCell("field").getStyleAttributes().setLocked(true);
                    tRow.getCell("field").setValue(null);
                }
            } else if (info != null) {
                if (!info.equals(e.getOldValue())) {
                    row.getCell("field").setEditor((ICellEditor)editor);
                    row.getCell("field").getStyleAttributes().setLocked(false);
                    row.getCell("field").setValue(null);
                }
            } else {
                row.getCell("field").setEditor((ICellEditor)this.emptyEditor);
                row.getCell("field").getStyleAttributes().setLocked(true);
                row.getCell("field").setValue(null);
            }
            this.handleTblMainEditor();
        }
        if (col == this.tblEntity.getColumn("sourceEntity").getColumnIndex()) {
            info = (MetaInfo)e.getValue();
            row.getCell("value").setValue(null);
            if (info != null && info.getUserObject() != null) {
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.getPropertiesModel((EntityObjectInfo)info.getUserObject(), null))));
            } else {
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
            }
        }
    }

    private void handleTblMainEditor() throws Exception {
        int i;
        this.tarModel.removeAllElements();
        this.tarModelSet.clear();
        Object tarEntity = null;
        IRow row = null;
        int size = this.tblEntity.getRowCount();
        for (i = 0; i < size; ++i) {
            tarEntity = this.tblEntity.getRow(i).getCell("entity").getValue();
            if (tarEntity == null || this.tarModelSet.contains(tarEntity)) continue;
            this.tarModel.addElement(tarEntity);
            this.tarModelSet.add(tarEntity);
        }
        int count = this.tblMain.getRowCount();
        for (i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            tarEntity = row.getCell("targetEntity").getValue();
            if (tarEntity == null) continue;
            boolean isValid = false;
            int size2 = this.tarModel.getSize();
            for (int j = 0; j < size2; ++j) {
                if (!tarEntity.equals(this.tarModel.getElementAt(j))) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            row.getCell("targetEntity").setValue(null);
            row.getCell("targetField").setValue(null);
            row.getCell("targetField").setEditor((ICellEditor)this.emptyEditor);
            row.getCell("targetField").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void tblEntity_editStopping(KDTEditEvent e) throws Exception {
        MetaInfo info;
        int col = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = null;
        if (col == this.tblEntity.getColumn("entity").getColumnIndex() && (info = (MetaInfo)e.getValue()) != null) {
            KDTMergeBlock block = this.getMergeBlock(this.tblEntity, rowIndex, col);
            int size = this.tblEntity.getRowCount();
            for (int j = 0; j < size; ++j) {
                if (rowIndex == j || block != null && j >= block.getTop() && j <= block.getBottom() || !info.equals((row = this.tblEntity.getRow(j)).getCell("entity").getValue())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"19_EntityFieldMappingUI") + info.getValue() + EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"20_EntityFieldMappingUI")));
                e.setCancel(true);
                return;
            }
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        MetaInfo info;
        int col = e.getColIndex();
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (col == this.tblMain.getColumn("targetEntity").getColumnIndex()) {
            info = (MetaInfo)e.getValue();
            if (info != null) {
                if (!info.equals(e.getOldValue())) {
                    row.getCell("targetField").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.getPropertiesModel(info.getName()))));
                    row.getCell("targetField").getStyleAttributes().setLocked(false);
                    row.getCell("targetField").setValue(null);
                }
            } else {
                row.getCell("targetField").setEditor((ICellEditor)this.emptyEditor);
                row.getCell("targetField").getStyleAttributes().setLocked(true);
                row.getCell("targetField").setValue(null);
            }
        }
        if (col == this.tblMain.getColumn("entity").getColumnIndex()) {
            info = (MetaInfo)e.getValue();
            if (info != null) {
                this.initSourceFieldColumnEditor(row, info);
            } else {
                row.getCell("sourceField").setEditor((ICellEditor)this.emptyEditor);
                row.getCell("sourceField").getStyleAttributes().setLocked(true);
                row.getCell("sourceField").setValue(null);
            }
        }
    }

    private DefaultComboBoxModel getPropertiesModel(String entity) throws Exception {
        DefaultComboBoxModel model = null;
        if (!StringUtils.isEmpty((String)entity) && (model = (DefaultComboBoxModel)this.propModels.get(entity)) == null) {
            model = new DefaultComboBoxModel();
            EntityObjectInfo entityInfo = null;
            IMetaDataLoader loader = this.getMetaDataLoader();
            entityInfo = loader.getEntity((IMetaDataPK)new MetaDataPK(entity));
            model = this.getPropertiesModel(entityInfo, model);
            this.propModels.put(entity, model);
        }
        return model;
    }

    private DefaultComboBoxModel getPropertiesModel(EntityObjectInfo entity, DefaultComboBoxModel model) throws Exception {
        PropertyCollection pCol;
        if (model == null) {
            model = new DefaultComboBoxModel<MetaInfo>();
        } else {
            model.removeAllElements();
        }
        if (entity != null && (pCol = entity.getInheritedNoDuplicatedProperties()) != null && pCol.size() > 0) {
            PropertyInfo property = null;
            MetaInfo info = null;
            int size = pCol.size();
            for (int i = 0; i < size; ++i) {
                property = pCol.get(i);
                info = new MetaInfo();
                info.setName(property.getName());
                info.setValue(MappingUtil.getMDAlias(property));
                info.setUserObject(property);
                model.addElement(info);
            }
        }
        return model;
    }

    private DefaultComboBoxModel getEntityAndSubModel(String entity) throws Exception {
        List list = MappingUtil.getEntityAndSub(entity, this.getMetaDataLoader());
        DefaultComboBoxModel<MetaInfo> model = new DefaultComboBoxModel<MetaInfo>();
        if (list != null) {
            model.addElement(new MetaInfo());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                model.addElement((MetaInfo)list.get(i));
            }
        }
        return model;
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        super.tblMain_editStopping(e);
    }

    private void fillTblMain(EntityListMapping list) throws Exception {
        if (list == null || list.getFields() == null || this.loadTree == null) {
            return;
        }
        List<MetaInfo> fields = list.getFields();
        String prefix = list.getHeader().getName();
        String fullName = null;
        FieldMapping mapping = null;
        EntityFieldInfo field = null;
        MetaInfo f = null;
        IRow tarRow = null;
        List ms = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            f = fields.get(i);
            fullName = f.getName();
            if (prefix != null) {
                fullName = prefix + "." + fullName;
            }
            if ((mapping = this.loadTree.getFieldMapping(fullName)) == null) continue;
            ms = mapping.getFields();
            int s = ms.size();
            for (int j = 0; j < s; ++j) {
                tarRow = this.tblMain.addRow();
                tarRow.getCell("entity").setValue((Object)list.getHeader());
                tarRow.getCell("sourceField").setValue((Object)f);
                field = (EntityFieldInfo)ms.get(j);
                tarRow.getCell("targetEntity").setValue((Object)field.getEntity());
                tarRow.getCell("targetField").setValue((Object)field.getField());
                if (field.getEntity() == null) continue;
                tarRow.getCell("targetField").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.getPropertiesModel(field.getEntity().getName()))));
                tarRow.getCell("targetField").getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadAffairType();
            this.loadEntitySetting();
            this.loadFieldMapping();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadEntitySetting() throws Exception {
        EntitySettingCollection col;
        this.tblEntity.removeRows();
        this.tarModel.removeAllElements();
        this.tarModelSet.clear();
        if (this.editData != null && (col = this.editData.getEntitySetting()) != null) {
            EntitySettingInfo setting = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                setting = col.get(i);
                this.fillTblEntity(setting);
            }
        }
    }

    private void fillTblEntity(EntitySettingInfo setting) throws Exception {
        if (setting != null) {
            int startIndex;
            Expression head;
            IRow row = this.tblEntity.addRow();
            String enName = setting.getEntity();
            String exp = setting.getCondition();
            EntityObjectInfo entity = this.getMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(enName));
            MetaInfo enInfo = new MetaInfo();
            enInfo.setName(enName);
            enInfo.setValue(MappingUtil.getMDAlias(entity));
            row.getCell("entity").setValue((Object)enInfo);
            row.getCell("newOnNotExist").setValue((Object)setting.isNewOnNotExist());
            if (!this.tarModelSet.contains(enInfo)) {
                this.tarModel.addElement(enInfo);
                this.tarModelSet.add(enInfo);
            }
            KDTDefaultCellEditor fEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.getPropertiesModel(enInfo.getName())));
            if (enInfo != null) {
                row.getCell("field").setEditor((ICellEditor)fEditor);
                row.getCell("field").getStyleAttributes().setLocked(false);
            }
            ExpressionNode root = new ExpressionNode(exp);
            root.buildTree();
            Expression temp = head = root.buildExpression();
            PropertyInfo pInfo = null;
            MetaInfo fInfo = null;
            ExpressionValue value = null;
            int endIndex = startIndex = row.getRowIndex();
            while (temp != null) {
                String field = temp.getField();
                if (field != null && field.endsWith(".id")) {
                    String[] s = StringUtils.split((String)field, (String)".");
                    field = s[0];
                }
                if ((pInfo = entity.getPropertyByName(field)) != null) {
                    fInfo = new MetaInfo();
                    fInfo.setName(field);
                    fInfo.setValue(MappingUtil.getMDAlias(pInfo));
                    fInfo.setUserObject(pInfo);
                    row.getCell("field").setValue((Object)fInfo);
                }
                row.getCell("operation").setValue((Object)temp.getOprt());
                value = temp.getValue();
                this.setSettingValue(value, row);
                if (temp.getNext() != null) {
                    row.getCell("logic").setValue((Object)this.getLogic(temp.getRelationWithNex()));
                }
                if ((temp = temp.getNext()) == null) continue;
                row = this.tblEntity.addRow();
                endIndex = row.getRowIndex();
                row.getCell("entity").setValue((Object)enInfo);
                row.getCell("newOnNotExist").setValue((Object)setting.isNewOnNotExist());
                row.getCell("field").setEditor((ICellEditor)fEditor);
                row.getCell("field").getStyleAttributes().setLocked(false);
            }
            if (endIndex > startIndex) {
                this.tblEntity.getMergeManager().mergeBlock(startIndex, 0, endIndex, 0, 1);
                this.tblEntity.getMergeManager().mergeBlock(startIndex, 1, endIndex, 1, 1);
            }
        }
    }

    private MappingLogicEnum getLogic(String rel) {
        if (StringUtils.isEmpty((String)rel)) {
            return null;
        }
        if (" and ".equals(rel)) {
            return MappingLogicEnum.AND;
        }
        return MappingLogicEnum.OR;
    }

    private void setSettingValue(ExpressionValue value, IRow row) throws Exception {
        if (value == null || row == null) {
            return;
        }
        PropertyInfo pInfo = null;
        MetaInfo fInfo = null;
        MetaInfo tInfo = null;
        MetaInfo selectInfo = null;
        String srcEntity = null;
        String srcField = null;
        EntityObjectInfo selectEn = null;
        if (value.isEntityRef()) {
            if (value.haveLevel()) {
                srcEntity = value.getFirstLevel();
                srcField = MappingUtil.removePrefix(srcEntity, value.getValue());
            } else {
                srcField = value.getValue();
            }
            int size = this.srcModel.getSize();
            for (int i = 0; i < size; ++i) {
                tInfo = (MetaInfo)this.srcModel.getElementAt(i);
                if (tInfo.getUserObject() == null || (srcEntity != null || tInfo.getName() != null) && (srcEntity == null || !srcEntity.equals(tInfo.getName()))) continue;
                selectInfo = tInfo;
                row.getCell("sourceEntity").setValue((Object)selectInfo);
                break;
            }
            if (selectInfo != null && (pInfo = (selectEn = (EntityObjectInfo)selectInfo.getUserObject()).getPropertyByName(srcField)) != null) {
                fInfo = new MetaInfo();
                fInfo.setName(srcField);
                fInfo.setValue(MappingUtil.getMDAlias(pInfo));
                fInfo.setUserObject(pInfo);
                row.getCell("value").setValue((Object)fInfo);
            }
            return;
        }
        row.getCell("value").setValue((Object)value.getValue());
    }

    private void loadFieldMapping() throws Exception {
        this.tblMain.removeRows();
        if (this.sourceEntity == null) {
            return;
        }
        this.bindList = MappingUtil.buildListByEntity(this.sourceEntity, this.loader);
        if (this.editData != null) {
            this.loadTree = this.editData.getEntityTreeMapping();
        }
        if (this.bindList != null) {
            this.fillTblMain(this.bindList);
            List<EntityListMapping> details = this.bindList.getDetails();
            if (details != null) {
                int size = details.size();
                for (int i = 0; i < size; ++i) {
                    this.fillTblMain(details.get(i));
                }
            }
        }
        this.tblMain.checkParsed();
    }

    private void storeData() throws Exception {
        boolean isValid = new NullVerifier(new JComponent[]{this.txtSolutionNumber, this.txtSolutionName}).verify();
        if (!isValid) {
            SysUtil.abort();
        }
        this.storeEntitySetting();
        this.storeMappingFields(this.storeFieldMapping());
    }

    private Map storeFieldMapping() throws Exception {
        HashMap<String, FieldMapping> data = new HashMap<String, FieldMapping>();
        IRow row = null;
        MetaInfo srcEntity = null;
        MetaInfo key = null;
        MetaInfo entity = null;
        MetaInfo field = null;
        FieldMapping mapping = null;
        EntityFieldInfo mapField = null;
        String prefix = null;
        String fullName = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            srcEntity = (MetaInfo)row.getCell("entity").getValue();
            key = (MetaInfo)row.getCell("sourceField").getValue();
            entity = (MetaInfo)row.getCell("targetEntity").getValue();
            field = (MetaInfo)row.getCell("targetField").getValue();
            if (srcEntity == null || key == null || entity == null || field == null) continue;
            prefix = srcEntity.getName();
            fullName = key.getName();
            if (!StringUtils.isEmpty((String)prefix)) {
                fullName = prefix + "." + fullName;
            }
            if ((mapping = (FieldMapping)data.get(fullName)) == null) {
                mapping = new FieldMapping();
                data.put(fullName, mapping);
                mapping.setPrefix(prefix);
                mapping.setProperty((PropertyInfo)key.getUserObject());
            }
            mapField = new EntityFieldInfo();
            mapField.setEntity(entity);
            mapField.setProperty((PropertyInfo)field.getUserObject());
            mapping.addFieldInfo(mapField);
        }
        return data;
    }

    private void storeMappingFields(Map data) throws Exception {
        if (data == null) {
            return;
        }
        Iterator ite = data.keySet().iterator();
        List list = null;
        MetaInfo sourceField = null;
        MetaInfo targetEntity = null;
        MetaInfo targetField = null;
        EntityFieldMappingInfo model = null;
        EntityFieldMappingCollection col = new EntityFieldMappingCollection();
        FieldMapping mapping = null;
        EntityFieldInfo mapField = null;
        String prefix = null;
        String fullName = null;
        while (ite.hasNext()) {
            mapping = (FieldMapping)data.get(ite.next());
            if (mapping == null) continue;
            sourceField = mapping.getField();
            prefix = mapping.getPrefix();
            fullName = sourceField.getName();
            if (!StringUtils.isEmpty((String)prefix)) {
                fullName = prefix + "." + fullName;
            }
            list = mapping.getFields();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                mapField = (EntityFieldInfo)list.get(i);
                if (!mapping.isSameType(mapField)) {
                    throw new FieldMappingException(FieldMappingException.TYPE_NOT_SAME, new Object[]{mapField.getEntity().getValue(), mapField.getField().getValue(), mapping.getField().getValue()});
                }
                targetEntity = mapField.getEntity();
                targetField = mapField.getField();
                model = new EntityFieldMappingInfo();
                model.setSourceFieldPath(fullName);
                model.setTargetEntity(targetEntity.getName());
                model.setTargetFieldPath(targetField.getName());
                col.add(model);
            }
        }
        if (this.editData != null) {
            this.editData.put("mapping", (Object)col);
        }
    }

    private void storeEntitySetting() throws Exception {
        IRow row = null;
        IRow nextRow = null;
        Object entity = null;
        Object nextEntity = null;
        Object isNew = null;
        EntitySettingInfo setting = null;
        EntitySettingCollection col = new EntitySettingCollection();
        Expression exp = null;
        Expression tempExp = null;
        Expression nextExp = null;
        String condition = null;
        MappingLogicEnum logic = null;
        int count = this.tblEntity.getRowCount();
        for (int i = 0; i < count; ++i) {
            int j;
            row = this.tblEntity.getRow(i);
            entity = row.getCell("entity").getValue();
            isNew = row.getCell("newOnNotExist").getValue();
            if (entity == null) continue;
            tempExp = exp = this.buildExpression(row);
            logic = (MappingLogicEnum)((Object)row.getCell("logic").getValue());
            for (j = i + 1; j < count && entity.equals(nextEntity = (nextRow = this.tblEntity.getRow(j)).getCell("entity").getValue()); ++j) {
                if (tempExp == null) {
                    MsgBox.showInfo((String)HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "158_DuplicateColumnVerifier", new String[]{String.valueOf(j)}));
                    SysUtil.abort();
                }
                if (logic == null || MappingLogicEnum.NONE.equals((Object)logic)) {
                    MsgBox.showInfo((String)HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "159_DuplicateColumnVerifier", new String[]{String.valueOf(j)}));
                    SysUtil.abort();
                }
                if ((nextExp = this.buildExpression(nextRow)) != null) {
                    tempExp.setNext(nextExp);
                    if (MappingLogicEnum.AND.equals((Object)logic)) {
                        tempExp.setRelationWithNex(" and ");
                    } else {
                        tempExp.setRelationWithNex(" or ");
                    }
                }
                tempExp = nextExp;
                logic = (MappingLogicEnum)((Object)nextRow.getCell("logic").getValue());
            }
            i = j - 1;
            condition = exp == null ? null : exp.toString();
            setting = new EntitySettingInfo();
            setting.setEntity(((MetaInfo)entity).getName());
            setting.setNewOnNotExist((Boolean)isNew);
            setting.setCondition(condition);
            col.add(setting);
        }
        if (this.editData != null) {
            this.editData.put("entitySetting", (Object)col);
        }
    }

    private Expression buildExpression(IRow row) {
        Object field = null;
        Object operation = null;
        Object value = null;
        Object source = null;
        Expression exp = null;
        String prefix = null;
        String fExp = null;
        MetaInfo f = null;
        field = row.getCell("field").getValue();
        operation = row.getCell("operation").getValue();
        source = row.getCell("sourceEntity").getValue();
        value = row.getCell("value").getValue();
        boolean isExpNull = false;
        if (field == null || operation == null || value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            if (field == null && operation == null && value == null) {
                isExpNull = true;
            }
            if (!isExpNull) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"23_EntityFieldMappingUI"));
                SysUtil.abort();
            }
        }
        if (isExpNull) {
            return null;
        }
        exp = new Expression();
        f = (MetaInfo)field;
        if (f.getUserObject() instanceof LinkPropertyInfo) {
            exp.setField(f.getName() + ".id");
        } else {
            exp.setField(f.getName());
        }
        exp.setOprt((MappingOperationEnum)((Object)operation));
        if (value instanceof String) {
            if (f.getUserObject() instanceof OwnPropertyInfo) {
                DataType type = ((OwnPropertyInfo)f.getUserObject()).getDataType();
                fExp = (String)value;
                if (DataType.STRING.equals((Object)type)) {
                    exp.setValue(new ExpressionValue("'" + fExp + "'"));
                } else if (DataType.DATE.equals((Object)type) || DataType.TIME.equals((Object)type) || DataType.TIMESTAMP.equals((Object)type)) {
                    exp.setValue(new ExpressionValue("#" + fExp + "#"));
                } else {
                    exp.setValue(new ExpressionValue(fExp));
                }
            }
        } else if (value instanceof MetaInfo) {
            prefix = ((MetaInfo)source).getName();
            fExp = ((MetaInfo)value).getName();
            if (!MappingUtil.isPropertySameType((PropertyInfo)f.getUserObject(), (PropertyInfo)((MetaInfo)value).getUserObject())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"24_EntityFieldMappingUI"));
                SysUtil.abort();
            }
            if (prefix != null) {
                fExp = prefix + "." + fExp;
            }
            exp.setValue(new ExpressionValue("$" + fExp + "$"));
        }
        return exp;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.selectTab = this.tpSetting.getSelectedIndex();
        if (this.selectTab == 1) {
            this.tblMain_addLine(e);
        } else {
            this.tblEntity_addLine(e);
        }
    }

    private void tblMain_addLine(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        this.tblMain.repaint();
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0] + 1;
            IRow row = this.tblMain.addRow(rowIndex);
            IRow selectRow = this.tblMain.getRow(selectRows[0]);
            row.getCell("sourceField").setValue(selectRow.getCell("sourceField").getValue());
            row.getCell("entity").setValue(selectRow.getCell("entity").getValue());
            this.mergeBlock(this.tblMain, selectRows[0], this.entityMergeCol);
            this.mergeBlock(this.tblMain, selectRows[0], this.fieldMergeCol);
        } else {
            this.tblMain.addRow();
        }
        this.tblMain.repaint();
    }

    private void tblEntity_addLine(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblEntity);
        IRow row = null;
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0] + 1;
            row = this.tblEntity.addRow(rowIndex);
            IRow selectRow = this.tblEntity.getRow(selectRows[0]);
            MappingLogicEnum logic = (MappingLogicEnum)((Object)selectRow.getCell("logic").getValue());
            Object entity = selectRow.getCell("entity").getValue();
            if (logic != null && !MappingLogicEnum.NONE.equals((Object)logic) && entity != null) {
                row.getCell("entity").setValue(entity);
                row.getCell("newOnNotExist").setValue(selectRow.getCell("newOnNotExist").getValue());
                row.getCell("field").setEditor(selectRow.getCell("field").getEditor());
                row.getCell("field").getStyleAttributes().setLocked(false);
                this.mergeBlock(this.tblEntity, selectRows[0], 0);
                this.mergeBlock(this.tblEntity, selectRows[0], 1);
            } else {
                row.getCell("newOnNotExist").setValue((Object)Boolean.TRUE);
            }
        } else {
            row = this.tblEntity.addRow();
            row.getCell("newOnNotExist").setValue((Object)Boolean.TRUE);
        }
    }

    private void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void mergeBlock(KDTable tbl, int row, int col) {
        KDTMergeBlock mergeBlock = this.getMergeBlock(tbl, row, col);
        if (mergeBlock != null) {
            if (row == mergeBlock.getBottom()) {
                tbl.getMergeManager().mergeBlock(mergeBlock.getTop(), col, mergeBlock.getBottom() + 1, col, 1);
            }
        } else {
            tbl.getMergeManager().mergeBlock(row, col, row + 1, col, 1);
        }
    }

    private KDTMergeBlock getMergeBlock(KDTable tbl, int row, int col) {
        List blocks = tbl.getMergeManager().getMergeBlockList();
        KDTMergeBlock block = null;
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            block = (KDTMergeBlock)blocks.get(i);
            if (!block.contains(row, col)) continue;
            return block;
        }
        return null;
    }

    private void clearCellBlocks(KDTable tbl, int col) {
        KDTMergeBlock block = null;
        List blocks = tbl.getMergeManager().getMergeBlockList();
        int size = tbl.getRowCount();
        for (int i = 0; i < size; ++i) {
            block = tbl.getMergeManager().getMergeBlockOfCell(i, col);
            if (block == null || blocks.contains(block)) continue;
            tbl.getCell(i, col).getKDTCell().setMergeBlock(null);
        }
    }

    private boolean isRowCanDelete(int row) {
        KDTMergeBlock mergeBlock = this.getMergeBlock(this.tblMain, row, this.fieldMergeCol);
        return mergeBlock != null && this.tblMain.getMergeManager().getMergeBlockList().contains(mergeBlock) && mergeBlock.getBottom() > mergeBlock.getTop();
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.selectTab = this.tpSetting.getSelectedIndex();
        if (this.selectTab == 1) {
            this.tblMain_deleteLine(e);
        } else {
            this.tblEntity_deleteLine(e);
        }
    }

    private void tblMain_deleteLine(ActionEvent e) throws Exception {
        this.checkSelected(this.tblMain);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        this.tblMain.repaint();
        for (int i = selectRows.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selectRows[i]);
            if (this.isRowCanDelete(selectRows[i])) {
                this.tblMain.removeRow(selectRows[i]);
                this.clearCellBlocks(this.tblMain, this.fieldMergeCol);
                this.clearCellBlocks(this.tblMain, this.entityMergeCol);
                continue;
            }
            row.getCell("targetEntity").setValue(null);
            row.getCell("targetField").setEditor((ICellEditor)this.emptyEditor);
            row.getCell("targetField").getStyleAttributes().setLocked(true);
        }
        this.tblMain.repaint();
    }

    private void tblEntity_deleteLine(ActionEvent e) throws Exception {
        this.checkSelected(this.tblEntity);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblEntity);
        this.tblEntity.repaint();
        boolean isNeedHandleEditor = false;
        for (int i = selectRows.length - 1; i >= 0; --i) {
            if (!isNeedHandleEditor && this.tblEntity.getRow(i).getCell("entity").getValue() != null) {
                isNeedHandleEditor = true;
            }
            this.tblEntity.removeRow(selectRows[i]);
            this.clearCellBlocks(this.tblEntity, 0);
            this.clearCellBlocks(this.tblEntity, 1);
        }
        if (isNeedHandleEditor) {
            this.handleTblMainEditor();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeData();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) throws Exception {
        this.storeData();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        this.editData.setEnable(false);
        this.cbEnable.setSelected(this.editData.isEnable());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        this.setSomeActionState();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancelCancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        this.editData.setEnable(true);
        this.cbEnable.setSelected(this.editData.isEnable());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        this.setSomeActionState();
    }

    protected IObjectValue createNewData() {
        MappingSolutionInfo solution = new MappingSolutionInfo();
        solution.setEntity(this.sourceEntity);
        solution.setHrOrg((HROrgUnitInfo)this.getUIContext().get(HRO));
        return solution;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MappingSolutionFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entity"));
        sic.add(new SelectorItemInfo("ui"));
        sic.add(new SelectorItemInfo("enable"));
        sic.add(new SelectorItemInfo("entitySetting.*"));
        sic.add(new SelectorItemInfo("hrOrg.id"));
        sic.add(new SelectorItemInfo("hrOrg.name"));
        return sic;
    }

    public int hashCode() {
        return 42;
    }

    @Override
    protected void bizEntityF7_dataChanged(DataChangeEvent e) throws Exception {
        AffairBizInfo bizInfo = (AffairBizInfo)e.getNewValue();
        if (bizInfo != null) {
            if (bizInfo.equals(e.getOldValue())) {
                return;
            }
            String billBosType = bizInfo.getBillBOSType();
            EntityObjectInfo entity = this.getMetaDataLoader().getEntity(BOSObjectType.create((String)billBosType));
            this.sourceEntity = entity.getFullName();
            this.txtEntityName.setText(this.sourceEntity);
            this.bindList = MappingUtil.buildListByEntity(this.sourceEntity, this.loader);
            this.initEntityColumnEditor();
            this.tblMain.removeRows();
            this.tblMain.addRow();
        }
    }

    private void loadAffairType() throws BOSException {
        if (this.editData == null || this.editData.getEntity() == null) {
            return;
        }
        this.sourceEntity = this.editData.getEntity();
        String simpleEntity = this.sourceEntity.substring(this.sourceEntity.lastIndexOf(".") + 1);
        AffairBizCollection c = AffairBizFactory.getRemoteInstance().getAffairBizCollection("where affairBizEntity='" + simpleEntity + "'");
        if (c.size() > 0) {
            this.bizEntityF7.setValue((Object)c.get(0));
        }
    }

    private void initEntityColumnEditor() throws Exception {
        if (this.bindList == null) {
            return;
        }
        DefaultComboBoxModel<MetaInfo> entityModel = new DefaultComboBoxModel<MetaInfo>();
        entityModel.addElement(this.bindList.getHeader());
        if (this.bindList.getDetails() != null && this.bindList.getDetails().size() > 0) {
            entityModel.addElement(this.bindList.getDetails().get(0).getHeader());
        }
        this.tblMain.getColumn("entity").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(entityModel)));
        if (this.sourceEntity != null) {
            this.srcModel = this.getEntityAndSubModel(this.sourceEntity);
            this.tblEntity.getColumn("sourceEntity").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.srcModel)));
            this.tblEntity.getColumn("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        }
    }

    private void initSourceFieldColumnEditor(IRow row, MetaInfo info) {
        if (this.bindList == null || info == null) {
            return;
        }
        DefaultComboBoxModel<MetaInfo> fieldModel = new DefaultComboBoxModel<MetaInfo>();
        if (info.equals(this.bindList.getHeader())) {
            for (MetaInfo header : this.bindList.getFields()) {
                fieldModel.addElement(header);
            }
        } else if (this.bindList.getDetails() != null && this.bindList.getDetails().size() > 0) {
            for (MetaInfo entry : this.bindList.getDetails().get(0).getFields()) {
                fieldModel.addElement(entry);
            }
        }
        KDTDefaultCellEditor cell = new KDTDefaultCellEditor((JComboBox)new KDComboBox(fieldModel));
        row.getCell("sourceField").setEditor((ICellEditor)cell);
        row.getCell("sourceField").getStyleAttributes().setLocked(false);
        row.getCell("sourceField").setValue(null);
    }

    private void initHRF7() {
        NewHROF7 model = new NewHROF7();
        model.setMultiSelect(false);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model);
        this.prmtHRO.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtHRO.setSelector((KDPromptSelector)iProducer.getModel());
        this.prmtHRO.setCommitFormat("$number$");
        this.prmtHRO.setEditFormat("$number$");
        this.prmtHRO.setDisplayFormat("$name$");
        this.prmtHRO.setEnabledMultiSelection(false);
        this.prmtHRO.setQueryInfo("com.kingdee.eas.basedata.org.app.HROrgUnitQuery");
    }
}

