/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.SpecialBorder;
import com.kingdee.eas.hr.base.client.GroupLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KDGroupContainer
extends KDPanel {
    private KDWorkButton btnTitle = new KDWorkButton();
    private KDPanel itemPane = new KDPanel();
    private KDScrollPane itemsContainer;
    private KDList listMain = null;

    public KDGroupContainer() {
        this("");
    }

    public KDGroupContainer(String name) {
        this(name, UIManager.getColor("Desktop.background"));
    }

    public KDGroupContainer(String name, Color background) {
        this.btnTitle.setText(name);
        this.btnTitle.setFocusable(false);
        this.itemPane.setLayout((LayoutManager)new GroupLayout(5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.btnTitle, "North");
        this.itemPane.setBackground(background);
        Color thumbColor = UIManager.getColor("ScrollBar.thumb");
        Color trackColor = UIManager.getColor("ScrollBar.track");
        Color trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        UIManager.put("ScrollBar.thumb", background);
        UIManager.put("ScrollBar.track", background);
        UIManager.put("ScrollBar.trackHighlight", background);
        this.listMain = new KDList();
        this.listMain.setFixedCellWidth(20);
        this.listMain.setSelectionMode(0);
        this.listMain.setFixedCellHeight(24);
        this.listMain.setBackground(Color.decode("#D9D9D0"));
        this.listMain.setSelectionBackground(Color.decode("#EFEFED"));
        this.listMain.setSelectionForeground(Color.decode("#000000"));
        this.listMain.setBorder((Border)new SpecialBorder.RemainderLineBorder());
        this.listMain.setCellBorderModal(4);
        this.itemsContainer = new KDScrollPane((Component)this.listMain);
        this.itemsContainer.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.itemsContainer, "Center");
        this.collapse();
        UIManager.put("ScrollBar.thumb", thumbColor);
        UIManager.put("ScrollBar.track", trackColor);
        UIManager.put("ScrollBar.trackHighlight", trackHighlightColor);
    }

    public KDList getMemberContainer() {
        return this.listMain;
    }

    public void setMemberGap(int hgap, int vgap) {
        this.itemPane.setLayout((LayoutManager)new GroupLayout(hgap, vgap));
    }

    public KDWorkButton getTitleButton() {
        return this.btnTitle;
    }

    public KDPanel getMembersContainer() {
        return this.itemPane;
    }

    public void collapse() {
        this.itemsContainer.setVisible(false);
        this.revalidate();
    }

    public void expand() {
        this.itemsContainer.setVisible(true);
        this.revalidate();
    }

    public void setName(String name) {
        this.btnTitle.setText(name);
    }

    public String getName() {
        return this.btnTitle.getText();
    }

    public void addMember(int index, Component c) {
        this.itemPane.add(c, index);
        this.itemPane.doLayout();
    }

    public void addMember(int index, Object c) {
        this.listMain.addElement(c);
    }

    public void removeMember(int index) {
        this.itemPane.remove(index);
        this.itemPane.doLayout();
    }

    public Component getMember(int index) {
        return this.itemPane.getComponent(index);
    }

    public Component[] getMembers() {
        Component[] coms = new Component[this.getMemberCount()];
        for (int i = 0; i < coms.length; ++i) {
            coms[i] = this.itemPane.getComponent(i);
        }
        return coms;
    }

    public int getMemberCount() {
        return this.itemPane.getComponentCount();
    }

    public String toString() {
        return this.getName();
    }
}

