/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.hr.base.client.DesignerPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class OrgChartPreviewPanel
extends KDPanel {
    private DesignerPanel designer;
    private PageFormat pf;
    private double scale;
    private int pageIndex;
    private double pageScale;
    private Dimension defaultSize = null;

    public OrgChartPreviewPanel(DesignerPanel designer, PageFormat pageFormat, double scale, int pageIndex, Dimension preferedSize) {
        this.setDesigner(designer);
        this.pf = pageFormat;
        this.scale = scale;
        this.pageIndex = pageIndex;
        this.setBackground(new Color(128, 128, 128));
        this.defaultSize = preferedSize;
        this.pf = pageFormat;
        if (this.pf == null) {
            this.pf = PrinterJob.getPrinterJob().defaultPage();
        }
        this.updatePreferredSize();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        double pageWidth = this.pf.getWidth() / this.pageScale * this.scale;
        double pageHeight = this.pf.getHeight() / this.pageScale * this.scale;
        int x = 5;
        if (pageWidth < (double)this.defaultSize.width) {
            x = (int)(((double)this.defaultSize.width - pageWidth) / 2.0);
        }
        int y = 10;
        Color oldColor = g2d.getColor();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(x, y, (int)pageWidth - 1, (int)pageHeight - 1);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, y, (int)pageWidth, (int)pageHeight);
        g2d.setColor(oldColor);
        Dimension pSize = this.designer.getPreferredSize();
        int cols = (int)Math.max(Math.ceil((double)pSize.width / (this.pf.getImageableWidth() / this.pageScale)), 1.0);
        int rows = (int)Math.max(Math.ceil((double)pSize.height / (this.pf.getImageableHeight() / this.pageScale)), 1.0);
        int w = (int)this.pf.getImageableWidth();
        int h = (int)this.pf.getImageableHeight();
        int dx = this.pageIndex % cols * w;
        int dy = this.pageIndex % rows * h;
        g2d.translate(x, y);
        g2d.translate(this.pf.getImageableX() / this.pageScale * this.scale, this.pf.getImageableY() / this.pageScale * this.scale);
        BufferedImage bufferedImage = (BufferedImage)this.createImage((int)(this.pf.getImageableWidth() / this.pageScale * this.scale), (int)(this.pf.getImageableHeight() / this.pageScale * this.scale));
        Graphics2D gg = (Graphics2D)bufferedImage.getGraphics();
        oldColor = gg.getColor();
        gg.setColor(Color.WHITE);
        gg.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        gg.setColor(oldColor);
        gg.translate(-((int)((double)dx / this.pageScale * this.scale)), -((int)((double)dy / this.pageScale * this.scale)));
        gg.scale(this.scale, this.scale);
        gg.setClip((int)((double)dx / this.pageScale), (int)((double)dy / this.pageScale), (int)(this.pf.getImageableWidth() / this.pageScale), (int)(this.pf.getImageableHeight() / this.pageScale));
        this.getDesigner().paintComponent(gg);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
    }

    public void setDesigner(DesignerPanel designer) {
        this.designer = designer;
    }

    public DesignerPanel getDesigner() {
        return this.designer;
    }

    public void setPf(PageFormat pf) {
        this.pf = pf;
        this.repaint();
    }

    public PageFormat getPf() {
        return this.pf;
    }

    private void updatePreferredSize() {
        int sr = Toolkit.getDefaultToolkit().getScreenResolution();
        this.pageScale = 72.0 / (double)sr;
        double width = this.defaultSize.width;
        if ((this.pf.getWidth() + 20.0) / this.pageScale * this.scale > width) {
            width = (this.pf.getWidth() + 5.0) / this.pageScale * this.scale;
        }
        double height = this.defaultSize.height;
        if ((this.pf.getHeight() + 20.0) / this.pageScale * this.scale > height) {
            height = (this.pf.getHeight() + 10.0) / this.pageScale * this.scale;
        }
        this.setPreferredSize(new Dimension((int)width, (int)height));
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updatePreferredSize();
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
        this.repaint();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }
}

