/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.OrgChartTreeBaseBuilder;
import com.kingdee.eas.hr.base.client.TreeNodeInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class OrgChartTreeBuilder
extends OrgChartTreeBaseBuilder {
    private int rootLevel = 0;
    private String rootLongNumber = null;
    private Map rootNodeMap = new HashMap();
    private Set toShowRrootNodeSet = new HashSet();
    private static int IMAX = 5000;
    private int max = IMAX;

    @Override
    public void builder() throws Exception {
        super.builder();
    }

    @Override
    protected DefaultMutableTreeNode getDefaultRootNode() throws Exception {
        this.rootNodeMap.clear();
        this.toShowRrootNodeSet.clear();
        this.rootNodeMap = this.getAllAdminByRootLongNumber(this.isShowSealUp());
        List rows = this.getOrgChartDataByUserAdmin(this.isShowSealUp());
        DefaultMutableTreeNode rootNode = this.newBuildTreeNode(rows);
        return rootNode;
    }

    private DefaultMutableTreeNode newBuildTreeNode(List rows) throws Exception {
        DefaultMutableTreeNode rootNode = null;
        DefaultMutableTreeNode childNode = null;
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();
        TreeNodeInfo treeNodeInfo = null;
        List temp = null;
        String fParentID = null;
        String fLongNumber = null;
        int fLevel = 0;
        int length = rows.size();
        for (int i = 0; i < length; ++i) {
            temp = (List)rows.get(i);
            treeNodeInfo = (TreeNodeInfo)temp.get(0);
            fParentID = (String)temp.get(1);
            fLongNumber = (String)temp.get(2);
            fLevel = (Integer)temp.get(3);
            if (rootNode == null) {
                if (this.adminInfo == null && !treeNodeInfo.getName().equals(SysContext.getSysContext().getCurrentAdminUnit().getName()) && !fLongNumber.startsWith(SysContext.getSysContext().getCurrentAdminUnit().getLongNumber() + "!")) continue;
                this.rootLevel = fLevel;
                this.rootLongNumber = fLongNumber;
                this.toShowRrootNodeSet.add(fLongNumber);
                rootNode = new DefaultMutableTreeNode(treeNodeInfo);
                nodeMap.put(treeNodeInfo.getObjId(), rootNode);
                continue;
            }
            if (fLevel > this.rootLevel + this.level || !fLongNumber.startsWith(this.rootLongNumber)) continue;
            this.createRootByChildLongNumber(fLongNumber, childNode, nodeMap, rootNode);
            if (!treeNodeInfo.isLeaf()) {
                this.toShowRrootNodeSet.add(fLongNumber);
            }
            this.max = IMAX;
            childNode = new DefaultMutableTreeNode(treeNodeInfo);
            if (nodeMap.get(fParentID) != null) {
                ((DefaultMutableTreeNode)nodeMap.get(fParentID)).add(childNode);
            } else {
                rootNode.add(childNode);
            }
            nodeMap.put(treeNodeInfo.getObjId(), childNode);
        }
        return rootNode;
    }

    private void createRootByChildLongNumber(String longNumber, DefaultMutableTreeNode childNode, HashMap nodeMap, DefaultMutableTreeNode rootNode) throws Exception {
        if (longNumber.indexOf("!") == -1) {
            return;
        }
        String rootNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        if (!this.toShowRrootNodeSet.contains(rootNumber)) {
            List temp = (List)this.rootNodeMap.get(rootNumber);
            TreeNodeInfo treeNodeInfo = (TreeNodeInfo)temp.get(0);
            String fParentID = (String)temp.get(1);
            if (!treeNodeInfo.isLeaf()) {
                this.toShowRrootNodeSet.add(rootNumber);
            }
            if (this.max == 0) {
                throw new RuntimeException();
            }
            --this.max;
            this.createRootByChildLongNumber(rootNumber, childNode, nodeMap, rootNode);
            childNode = new DefaultMutableTreeNode(treeNodeInfo);
            if (nodeMap.get(fParentID) != null) {
                ((DefaultMutableTreeNode)nodeMap.get(fParentID)).add(childNode);
            } else {
                rootNode.add(childNode);
            }
            nodeMap.put(treeNodeInfo.getObjId(), childNode);
        }
    }

    private Map getAllAdminByRootLongNumber(boolean includeSealup) throws Exception {
        HashMap allAdminLongNumber = new HashMap();
        StringBuffer sql = new StringBuffer("SELECT FLongNumber, FID, FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" FName,FParentID,FIsLeaf,FLevel ");
        sql.append(" FROM T_ORG_Admin WHERE 1=1 ");
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        if (!this.isShowVirtualOrg()) {
            sql.append(" and FISVIRTUAL = 0");
        }
        sql.append(" ORDER BY FLevel ");
        ISQLExecutor sqlExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = sqlExec.executeSQL();
        ArrayList<Object> temp = null;
        TreeNodeInfo treeNodeInfo = null;
        while (rows.next()) {
            temp = new ArrayList<Object>();
            treeNodeInfo = new TreeNodeInfo();
            treeNodeInfo.setObjId(rows.getString("FID"));
            treeNodeInfo.setName(rows.getString("FName"));
            treeNodeInfo.setLeaf(rows.getBoolean("FIsLeaf"));
            temp.add(treeNodeInfo);
            temp.add(rows.getString("FParentID"));
            temp.add(rows.getString("FLongNumber"));
            temp.add(new Integer(rows.getInt("FLevel")));
            allAdminLongNumber.put(rows.getString("FLongNumber"), temp);
        }
        rows.close();
        return allAdminLongNumber;
    }

    private List getOrgChartDataByUserAdmin(boolean includeSealup) throws Exception {
        LinkedList<List> rowsList = new LinkedList<List>();
        StringBuffer sql = new StringBuffer("SELECT FLongNumber, T_ORG_Admin.FID, FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" FName,FParentID,FIsLeaf,FLevel ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        sql.append(" WHERE T_PM_OrgRange.FType = 20 ");
        if (this.adminInfo != null) {
            sql.append(" AND (FLongNumber LIKE '");
            sql.append(this.adminInfo.getLongNumber());
            sql.append("!%' OR T_ORG_Admin.FID = '");
            sql.append(this.adminInfo.getId());
            sql.append("') AND FLevel >= ");
            sql.append(this.adminInfo.getLevel());
        }
        if (!includeSealup) {
            sql.append(" AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        if (!this.isShowVirtualOrg()) {
            sql.append(" and FISVIRTUAL = 0");
        }
        sql.append(" AND T_PM_OrgRange.FUserID='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' ORDER BY FLevel ,FLongNumber");
        ISQLExecutor sqlExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = sqlExec.executeSQL();
        List temp = null;
        String parentLongNumber = null;
        String fLongNumber = null;
        String tempLongNumber = null;
        while (rows.next()) {
            fLongNumber = rows.getString("FLongNumber");
            tempLongNumber = parentLongNumber;
            if (fLongNumber != null && fLongNumber.indexOf("!") != -1) {
                parentLongNumber = fLongNumber.substring(0, fLongNumber.lastIndexOf("!"));
            }
            if (tempLongNumber != null && tempLongNumber.equals(parentLongNumber)) {
                temp = (List)this.rootNodeMap.get(parentLongNumber);
                if (rowsList.size() > 1 && !rowsList.contains(temp) && temp != null) {
                    rowsList.add(rowsList.size() - 1, temp);
                }
            }
            if (rowsList.contains(temp = (List)this.rootNodeMap.get(fLongNumber)) || temp == null) continue;
            rowsList.add(temp);
        }
        rows.close();
        return rowsList;
    }
}

