/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class EditorCreator {
    public static final int FLOAT_VALUE = 0;
    public static final int INT_VALUE = 1;

    public static KDBizPromptBox getJobLevelEditor(JobInfo jobInfo) {
        KDBizPromptBox prmtJobLevel = new KDBizPromptBox();
        prmtJobLevel.setQueryInfo("com.kingdee.eas.hr.org.app.JobLevelListQuery");
        prmtJobLevel.setDisplayFormat("$name$");
        prmtJobLevel.setEditFormat("$number$");
        prmtJobLevel.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (jobInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)"nodata"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobInfo.getId()));
        }
        viewInfo.setFilter(filterInfo);
        prmtJobLevel.setEntityViewInfo(viewInfo);
        return prmtJobLevel;
    }

    public static KDComboBox getCBEditor(String enumClassName) {
        return EditorCreator.getCBEditor(enumClassName, false);
    }

    public static KDComboBox getCBEditor(String enumClassName, boolean isAddNull) {
        KDComboBox combo = new KDComboBox();
        if (!StringUtils.isEmpty((String)enumClassName)) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            List enumList = EnumUtils.getEnumList((String)enumClassName);
            if (isAddNull) {
                model.addElement(null);
            }
            int size = enumList.size();
            for (int i = 0; i < size; ++i) {
                model.addElement(enumList.get(i));
            }
            combo.setModel(model);
        }
        return combo;
    }

    public static KDComboBox getPersonPositionsCboEditor(String personId, String oqlCodition) {
        String oql = "select position.id,position.name,position.number ";
        oql = oql + " where person.id='" + personId + "' ";
        if (!StringUtils.isEmpty((String)oqlCodition)) {
            oql = oql + "and (" + oqlCodition + ")";
        }
        oql = oql + " order by isPrimary desc";
        PositionMemberCollection pmCol = null;
        try {
            pmCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(oql);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        KDComboBox combo = new KDComboBox();
        DefaultComboBoxModel<PositionInfo> model = new DefaultComboBoxModel<PositionInfo>();
        if (pmCol != null) {
            for (int i = 0; i < pmCol.size(); ++i) {
                model.addElement(pmCol.get(i).getPosition());
            }
        }
        combo.setModel(model);
        return combo;
    }

    public static KDComboBox getEmployeeTypeEditor(int[] inService) throws Exception {
        return EditorCreator.getEmployeeTypeEditor(inService, true);
    }

    public static KDComboBox getEmployeeTypeEditor(int[] inService, boolean isUsedInFenlei) throws Exception {
        StringBuffer oql = new StringBuffer("where isEnabled = 1 and (");
        for (int i = 0; i < inService.length; ++i) {
            if (i != 0) {
                oql.append(" or ");
            }
            oql.append("inService = " + inService[i]);
        }
        oql.append(") ");
        if (isUsedInFenlei) {
            oql.append(" and employeeFenLei.id is not null");
        }
        EmployeeTypeCollection empTypeCol = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(oql.toString());
        return EditorCreator.getEmpTypeEditor(empTypeCol);
    }

    public static KDComboBox getComboxEditor(Object[] objs) {
        KDComboBox combo = new KDComboBox();
        if (objs != null && objs.length > 0) {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
            for (int i = 0; i < objs.length; ++i) {
                model.addElement(objs[i]);
            }
            combo.setModel(model);
        }
        return combo;
    }

    public static KDComboBox getEmployeeTypeEditor(int inService) throws Exception {
        return EditorCreator.getEmployeeTypeEditor(inService, true);
    }

    public static KDComboBox getEmployeeTypeEditor(int inService, boolean isUsedInFenlei) throws Exception {
        StringBuffer oql = new StringBuffer("where isEnabled = 1 ");
        if (inService != -1) {
            oql.append(" and inService = ").append(inService);
        } else if (inService == -2) {
            oql.append(" and inService <> 1 ");
        }
        if (isUsedInFenlei) {
            oql.append(" and employeeFenLei.id is not null ");
        }
        EmployeeTypeCollection empTypeCol = null;
        empTypeCol = oql == null ? EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection() : EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(oql.toString());
        return EditorCreator.getEmpTypeEditor(empTypeCol);
    }

    public static ICellEditor getCommonF7CellEditor(String queryName) {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setQueryInfo(queryName);
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    public static ICellEditor getCommonF7CellEditor(String queryName, boolean multiSelect) {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setQueryInfo(queryName);
        f7.setEnabledMultiSelection(multiSelect);
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    public static ICellEditor getBizF7CellEditor(KDPromptSelector selector, String queryName) {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setSelector(selector);
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        if (StringUtils.isEmpty((String)queryName)) {
            f7.setEditable(false);
        } else {
            f7.setQueryInfo(queryName);
            f7.setCommitFormat("$number$");
        }
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    public static KDComboBox getEmpTypeEditor(EmployeeTypeCollection empTypeCol) {
        KDComboBox combo = new KDComboBox();
        if (empTypeCol != null && empTypeCol.size() > 0) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            Iterator iter = empTypeCol.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            combo.setModel(model);
        }
        return combo;
    }

    public static ICellEditor getTextCellEditor(int maxLength) {
        KDTextField txt = new KDTextField();
        txt.setMaxLength(maxLength);
        return new KDTDefaultCellEditor((JTextField)txt);
    }

    public static ICellEditor getTextNoEditbleCellEditor() {
        KDTextField txt = new KDTextField();
        txt.setEditable(false);
        return new KDTDefaultCellEditor((JTextField)txt);
    }

    public static ICellEditor getChkBoxCellEditor() {
        return new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
    }

    public static ICellEditor getDateCellEditor() {
        return new KDTDefaultCellEditor(new KDDatePicker());
    }

    public static KDBizPromptBox getJobGradeEditor(CtrlUnitInfo cu) {
        if (cu == null) {
            return null;
        }
        KDBizPromptBox prmtJobGrade = new KDBizPromptBox();
        prmtJobGrade.setQueryInfo("com.kingdee.eas.hr.org.app.JobGradeListQuery");
        prmtJobGrade.setDisplayFormat("$name$");
        prmtJobGrade.setEditFormat("$number$");
        prmtJobGrade.setCommitFormat("$number$");
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(cu);
        JobGradePromptBox selector = new JobGradePromptBox();
        selector.changeContextByCUSet(cuSet);
        prmtJobGrade.setEntityViewInfo(EditorCreator.getJobGradeViewByCU(cuSet));
        prmtJobGrade.setSelector((KDPromptSelector)selector);
        return prmtJobGrade;
    }

    public static ICellEditor getNumberCellEditor(int length, int pre, int type) {
        KDFormattedTextField txt = null;
        if (type == 0) {
            txt = new KDFormattedTextField(1);
            double bInt = Math.pow(10.0, length - pre);
            double pInt = EditorCreator.number(pre, Math.pow(0.1, pre));
            txt.setMaximumValue((Comparable)new BigDecimal(new Double(EditorCreator.number(pre, bInt - pInt)).toString()));
            txt.setPrecision(pre);
            txt.setMinimumValue((Comparable)new BigDecimal(new Double(0.0).toString()));
        } else if (type == 1) {
            txt = new KDFormattedTextField(0);
            txt.setMaximumValue((Comparable)Integer.valueOf((int)Math.pow(10.0, length) - 1));
            txt.setPrecision(0);
            txt.setMinimumValue((Comparable)Integer.valueOf(0));
        }
        if (txt != null) {
            txt.setHorizontalAlignment(4);
            return new KDTDefaultCellEditor((JTextField)txt);
        }
        return null;
    }

    public static double number(int pre, double pDouble) {
        BigDecimal bd = new BigDecimal(pDouble);
        BigDecimal bd1 = bd.setScale(pre, 4);
        pDouble = bd1.doubleValue();
        return pDouble;
    }

    public static String getIntFormatStr() {
        return "%r{#}d";
    }

    public static String getDateFormatStr() {
        return "yyyy-mm-dd";
    }

    public static String getMoneyFormatStr() {
        return "%r{############.##}d";
    }

    public static EntityViewInfo getJobGradeViewByCU(HashSet cuSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (cuSet != null && cuSet.size() > 0) {
            Iterator it = cuSet.iterator();
            HashSet<String> cuidSet = new HashSet<String>();
            Object ob = null;
            while (it.hasNext()) {
                ob = it.next();
                if (ob instanceof CtrlUnitInfo) {
                    cuidSet.add(((CtrlUnitInfo)ob).getId().toString());
                    continue;
                }
                cuidSet.add(ob);
            }
            filter.getFilterItems().add(new FilterItemInfo("toAdminCU.id", cuidSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

