/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class EmpLog {
    public static final Map<String, Logger> logContainer = new HashMap<String, Logger>();
    public static final String FILE_DEFAULT = "emp";
    public static String conversionPattern = "%n[%d{MMdd HH:mm:ss} %p %t %F %M %L]%m";
    public static final String PATH_DEFAULT = System.getProperty("EAS_HOME") + "/server/shr_emp_log";

    public static Logger getLogger(String filePath, String fileName, Map<String, String> configMap) {
        filePath = PATH_DEFAULT + (StringUtils.isEmpty((String)filePath) ? "" : "/" + filePath);
        fileName = StringUtils.isEmpty((String)fileName) ? FILE_DEFAULT : fileName;
        String file = filePath + "/" + fileName;
        Level level = Level.toLevel((String)configMap.get("level"), (Level)Level.ERROR);
        Logger logger = logContainer.get(file);
        if (logger != null) {
            logger.setLevel(level);
            return logger;
        }
        RollingFileAppender appender = new RollingFileAppender();
        logger = Logger.getLogger((String)filePath);
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
        logger.setLevel(level);
        logger.setAdditivity(Boolean.valueOf(EmpLog.getFromMap(configMap, "additivity", "true")).booleanValue());
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern(EmpLog.getFromMap(configMap, "conversionPattern", conversionPattern));
        int maxBackupIndex = 100;
        try {
            maxBackupIndex = Integer.valueOf(EmpLog.getFromMap(configMap, "maxBackupIndex"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        appender.setMaxBackupIndex(maxBackupIndex);
        appender.setLayout((Layout)layout);
        appender.setFile(file + ".log");
        appender.setEncoding(EmpLog.getFromMap(configMap, "encoding", "UTF-8"));
        appender.setAppend(Boolean.valueOf(EmpLog.getFromMap(configMap, "append", "true")).booleanValue());
        appender.setMaxFileSize(EmpLog.getFromMap(configMap, "maxFileSize", "10MB"));
        appender.activateOptions();
        logContainer.put(file, logger);
        return logger;
    }

    public static Logger getbillLog() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("level", Level.INFO.toString());
        map.put("additivity", "false");
        return EmpLog.getLogger("hr_emp_bill_log", "getbilllogInfo", map);
    }

    public static Logger getLog() {
        return EmpLog.getLogger(null, null, Collections.singletonMap("level", Level.ERROR.toString()));
    }

    private static String getFromMap(Map<?, ?> map, Object fieldName) {
        return EmpLog.getFromMap(map, fieldName, null);
    }

    private static String getFromMap(Map<?, ?> map, Object fieldName, String defaultVal) {
        if (map == null || map.get(fieldName) == null || StringUtils.isBlank((String)String.valueOf(map.get(fieldName)))) {
            return defaultVal;
        }
        return String.valueOf(map.get(fieldName));
    }
}

