/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BillCheckFacadeFactory;
import com.kingdee.eas.hr.base.IBillCheckFacade;
import com.kingdee.eas.hr.base.PersonCheckException;
import com.kingdee.eas.hr.base.util.PersonNumberCheck;

public class PersonNumberCheckByBill
implements PersonNumberCheck {
    public static final int ENROLLTYPE = 0;
    public static final int FLUCTUATIONTYPE = 1;
    private String checkedBillID = null;
    private int billType = 0;

    public PersonNumberCheckByBill(String checkedBillID, int billType) {
        this.checkedBillID = checkedBillID;
        this.billType = billType;
    }

    @Override
    public void check(String number, Context ctx) throws BOSException, EASBizException {
        IBillCheckFacade checkFacade = null;
        checkFacade = ctx == null ? BillCheckFacadeFactory.getRemoteInstance() : BillCheckFacadeFactory.getLocalInstance(ctx);
        boolean isExist = checkFacade.personNumberExistInBill(this.checkedBillID, number, this.billType);
        if (isExist) {
            switch (this.billType) {
                case 0: {
                    throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXISTINENROLL, new Object[]{number});
                }
                case 1: {
                    throw new PersonCheckException(PersonCheckException.PERSONEXISTINFLUCTUATION, new Object[]{number});
                }
            }
        }
    }
}

