/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class XMLReader {
    protected InputSource source;
    protected Document doc;
    private Element root;

    public XMLReader(String fileName) throws BOSException {
        try {
            this.source = new InputSource(new FileInputStream(fileName));
        }
        catch (FileNotFoundException err) {
            throw new BOSException("XML file [" + fileName + "] loading failed", (Throwable)err);
        }
    }

    public XMLReader(InputStream byteStream) {
        this.source = new InputSource(byteStream);
    }

    public XMLReader(Class caller, String file) {
        this(XMLReader.getInputStream(caller, file));
    }

    public XMLReader(Reader charStream) {
        this.source = new InputSource(charStream);
    }

    public static InputStream getInputStream(Class caller, String file) {
        return caller.getResourceAsStream(file);
    }

    public final Document getDoc() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            SAXBuilder builder = new SAXBuilder(false);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.doc = builder.build(this.source);
            }
            catch (JDOMException je) {
                throw je;
            }
            finally {
                try {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (JDOMException err) {
            throw new AssertionError((Object)("Error on analysis XML file, info: " + err.getMessage()));
        }
        catch (IOException err) {
            throw new AssertionError((Object)"Failed loading file");
        }
        return this.doc;
    }

    public final Element getRoot() {
        Document doc;
        if (this.root == null && (doc = this.getDoc()) != null) {
            this.root = doc.getRootElement();
        }
        return this.root;
    }
}

