/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisCollection;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.EmpTypeEnum;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeFactory;
import com.kingdee.eas.hr.base.HRBizDefineEntryCollection;
import com.kingdee.eas.hr.base.HRBizDefineEntryFactory;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.IEmpLaborRelationHis;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.base.IEmpPostExperienceHis;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.IHRBizDefEmpType;
import com.kingdee.eas.hr.base.IHRBizDefine;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.web.CheckEmpTypeSrvHelper;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class CheckEmployeeTypeOperatorService
implements IHRMsfService {
    private static final String ACTION_ID = "actionId";
    private static final String PERSON_ID = "personId";
    private static final String EFFDT = "effdt";
    private static final String TARGET_EMPLOYEE_TYPE = "targetEmployeeTypeId";
    private static final String TARGET_POSITION = "targetPositionId";
    private static final String TARGET_ORGADMIN = "targetOrgAdminId";
    private static final String IS_PARTTIME_JOB = "isParttimeJob";
    private static final String EMP_RELATION = "empPosOrgRelationId";
    private static final HRBizDefineTypeEnum EnrollActionType = HRBizDefineTypeEnum.ENROLL;
    private static final HRBizDefineTypeEnum ResignAction = HRBizDefineTypeEnum.RESIGN;
    private static final String parttimeActionId = "DawAAAApaaPmaL7Z";
    private static final String endOtherPositionActionId = "DawAAAAqVGbmaL7Z";
    private static final String fluctuationOutAction = "V2vNOLaKRuGuv9/HNB5laOZovtk=";
    private static final String FLUC_ACTION_ID = "DawAAAApVj/maL7Z";
    private static final String HIRE_ACTION_ID = "DawAAAApVhzmaL7Z";
    private IHRBizDefine iHRBizDefine;
    private IEmpPostExperienceHis iEmpPostExperienceHis;
    private IEmpPosOrgRelation iEmpPosOrgRelation;
    private IPerson iPerson;
    private IHRBizDefEmpType iHRBizDefEmpType;
    private IEmployeeType iEmployeeType;
    private IEmpLaborRelationHis iEmpLaborRelationHis;
    private IPosition iPosition;
    private Context ctx;
    private String actionId;
    private String personId;
    private String effdt;
    private Date effdtDate;
    private String targetEmployeeType;
    private String targetPosition;
    private String targetOrgAdmin;
    private Boolean isParttimeJob = null;
    private String empPosOrgRelationId;
    private String personName;
    private String actionName;
    private String dateString;
    private String positionName;
    private EmpTypeEnum empTypeConfigField;
    private HRBizDefineTypeEnum bizDefineType;
    boolean isSameDatePersonChange = false;

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        if (!this.initService(ctx, param)) {
            return null;
        }
        this.doProcess();
        return null;
    }

    private boolean initService(Context context, Map param) throws BOSException, EASBizException {
        this.ctx = context;
        String string = this.actionId = param.get(ACTION_ID) == null ? null : param.get(ACTION_ID).toString();
        if (StringUtils.isEmpty((String)this.actionId)) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.PARMCURRENTISNULL);
        }
        if (fluctuationOutAction.equals(this.actionId)) {
            return false;
        }
        this.personId = param.get(PERSON_ID) == null ? null : param.get(PERSON_ID).toString();
        String string2 = this.effdt = param.get(EFFDT) == null ? null : param.get(EFFDT).toString();
        if (!StringUtils.isEmpty((String)this.effdt)) {
            try {
                this.effdtDate = DateTimeUtils.parseDate((String)this.effdt);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new EmpAffairBizBillException(EmpAffairBizBillException.CHANGEERROR);
            }
        }
        this.targetEmployeeType = param.get(TARGET_EMPLOYEE_TYPE) == null ? null : param.get(TARGET_EMPLOYEE_TYPE).toString();
        this.targetPosition = param.get(TARGET_POSITION) == null ? null : param.get(TARGET_POSITION).toString();
        this.targetOrgAdmin = param.get(TARGET_ORGADMIN) == null ? null : param.get(TARGET_ORGADMIN).toString();
        SHRSameDatePersonChangeUtil SHRSameDatePersonChangeUtil2 = new SHRSameDatePersonChangeUtil();
        if (param.containsKey(IS_PARTTIME_JOB) && StringUtils.isEmpty((String)String.valueOf(param.get(IS_PARTTIME_JOB)))) {
            this.isParttimeJob = Boolean.parseBoolean(param.get(IS_PARTTIME_JOB) == null ? null : param.get(IS_PARTTIME_JOB).toString());
            this.isSameDatePersonChange = SHRSameDatePersonChangeUtil2.isSameDatePersonChange(context, this.personId, this.effdtDate, 0);
        } else {
            this.isSameDatePersonChange = SHRSameDatePersonChangeUtil2.isSameDatePersonChange(context, this.personId, this.effdtDate, 1);
        }
        this.empPosOrgRelationId = param.get(EMP_RELATION) == null ? null : param.get(EMP_RELATION).toString();
        this.iHRBizDefine = HRBizDefineFactory.getLocalInstance(this.ctx);
        this.iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(this.ctx);
        this.iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance(this.ctx);
        this.iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
        this.iHRBizDefEmpType = HRBizDefEmpTypeFactory.getLocalInstance(this.ctx);
        this.iEmployeeType = EmployeeTypeFactory.getLocalInstance((Context)this.ctx);
        this.iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance(this.ctx);
        this.iPosition = PositionFactory.getLocalInstance((Context)this.ctx);
        return true;
    }

    private void doProcess() throws EASBizException, BOSException {
        this.printServiceLog();
        this.initExceptionParamName();
        this.initActionType();
        this.checkInsertHisFixStandardAction();
        if (!this.isParttimeJob.booleanValue()) {
            this.checkForMainAction();
            this.checkIfHaveInLaborRelation();
        } else {
            this.checkForParttimeAction();
        }
    }

    private void checkInsertHisFixStandardAction() throws EASBizException, BOSException {
        if (this.isParttimeJob == null) {
            this.isParttimeJob = parttimeActionId.equals(this.actionId) || endOtherPositionActionId.equals(this.actionId) || this.bizDefineType.equals((Object)HRBizDefineTypeEnum.PLURALITY) || "cM5s6yPmTba5BXMKa6+h8uZovtk=".equals(this.actionId);
        }
        if (this.isParttimeJob.booleanValue()) {
            return;
        }
        if (!StringUtils.isEmpty((String)this.personId)) {
            EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)this.ctx, (String)this.personId);
            HRBizDefineInfo actionInfo = info.getAction();
            String notLegalActionName = actionInfo.getName();
            Date effectDate = info.getEFFDT();
            if (info != null && this.getEffdtDate().before(info.getEFFDT()) && !FLUC_ACTION_ID.equals(this.actionId) && !HIRE_ACTION_ID.equals(this.actionId)) {
                Object[] params = new Object[]{this.personName, HRUtilExtend.getDateStringWithoutMininute(effectDate), notLegalActionName};
                throw new EmpAffairBizBillException(EmpAffairBizBillException.NOT_SUPPORT_BIZTYPE, params);
            }
        }
    }

    private void initActionType() throws EASBizException, BOSException {
        HRBizDefineInfo hrBizDdfineInfo = this.iHRBizDefine.getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(this.actionId));
        this.actionName = hrBizDdfineInfo.getName();
        this.bizDefineType = hrBizDdfineInfo.getBizDefineType();
        this.empTypeConfigField = hrBizDdfineInfo.getEmpTypeField();
    }

    private void checkForMainAction() throws BOSException, EASBizException, EmpAffairBizBillException {
        if (!StringUtils.isEmpty((String)this.targetPosition)) {
            this.checkPositionForMainAction();
        }
        if (!StringUtils.isEmpty((String)this.targetEmployeeType)) {
            this.checkEmpTypeForMainAction();
        }
    }

    private void checkEmpTypeForMainAction() throws BOSException, EASBizException, EmpAffairBizBillException {
        String lacateInRecordOql = CheckEmpTypeSrvHelper.getLacateInEmpLaborRelationOql(this.effdtDate, this.personId);
        if (this.isEnrollActionTypeButNotEnrollAgain()) {
            return;
        }
        if (!this.iEmpLaborRelationHis.exists(lacateInRecordOql)) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.DONOTHAVEEMPTYPE, new Object[]{this.personName, this.dateString});
        }
        EmpLaborRelationHisCollection empLaborRelationHisCollection = this.iEmpLaborRelationHis.getEmpLaborRelationHisCollection(lacateInRecordOql);
        EmpLaborRelationHisInfo pointDateEmpLaborRelationInfo = null;
        if (empLaborRelationHisCollection.size() > 1) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.EMPTYPEHISERROR, new Object[]{this.personName, this.dateString});
        }
        pointDateEmpLaborRelationInfo = empLaborRelationHisCollection.get(0);
        String empTypeIdInEffect = pointDateEmpLaborRelationInfo.getLaborRelationState().getId().toString();
        if (!StringUtils.equals((String)empTypeIdInEffect, (String)this.targetEmployeeType) && !DateTimeUtils.dayEquals((Date)pointDateEmpLaborRelationInfo.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.EXISTLABELRELATION, new Object[]{this.personName, this.dateString});
        }
        this.judgeCurrentEmpTypeFitTargetAction(pointDateEmpLaborRelationInfo);
        if (!this.targetEmployeeType.equals(empTypeIdInEffect) && this.empTypeConfigField == EmpTypeEnum.NEW) {
            this.judgeTargetEmpTypeFitNextAction();
        }
    }

    private boolean isEnrollActionTypeButNotEnrollAgain() {
        return EnrollActionType == this.bizDefineType && !this.actionId.equals("DawAAAApC9TmaL7Z");
    }

    private void judgeTargetEmpTypeFitNextAction() throws BOSException, EASBizException, EmpAffairBizBillException {
        String nextEmpOrgRelationByEffdtOql = CheckEmpTypeSrvHelper.getNextEmpRelationByEffdtOql(this.effdtDate, this.personId);
        EmpPosOrgRelationCollection empPosOrgRelationForNextAction = this.iEmpPosOrgRelation.getEmpPosOrgRelationCollection(nextEmpOrgRelationByEffdtOql);
        EmployeeTypeInfo targetEmpType = this.iEmployeeType.getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(this.targetEmployeeType));
        if (targetEmpType != null) {
            HRBizDefEmpTypeCollection nextInEmployeeTypeColl = null;
            String nextActionId = null;
            if (empPosOrgRelationForNextAction.size() > 0) {
                EmpPosOrgRelationInfo nextEmpPosOrgRelationInfo = empPosOrgRelationForNextAction.get(0);
                nextActionId = nextEmpPosOrgRelationInfo.getAction().getId().toString();
                String getEmpTypeByActionIdOql = CheckEmpTypeSrvHelper.getEmpTypeByAction(nextActionId);
                nextInEmployeeTypeColl = this.iHRBizDefEmpType.getHRBizDefEmpTypeCollection(getEmpTypeByActionIdOql);
            }
            if (nextActionId != null && !this.isExistInCollection((CoreBaseInfo)targetEmpType, nextInEmployeeTypeColl)) {
                String currentEmpType = targetEmpType.getName();
                String nextActionName = null;
                nextActionName = this.iHRBizDefine.getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(nextActionId)).getName();
                throw new EmpAffairBizBillException(EmpAffairBizBillException.OUTEMPTYPEILLEGAL, new Object[]{this.personName, this.dateString, currentEmpType, nextActionName});
            }
        }
    }

    private void judgeCurrentEmpTypeFitTargetAction(EmpLaborRelationHisInfo pointDateEmpLaborRelationInfo) throws BOSException, EASBizException, EmpAffairBizBillException {
        String employeeTypeOql;
        HRBizDefEmpTypeCollection inEmployeeTypeColl;
        EmployeeTypeInfo inEmployeeType = pointDateEmpLaborRelationInfo.getLaborRelationState();
        if ((inEmployeeType = this.iEmployeeType.getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(inEmployeeType.getId()))) != null && !this.isExistInCollection((CoreBaseInfo)inEmployeeType, inEmployeeTypeColl = this.iHRBizDefEmpType.getHRBizDefEmpTypeCollection(employeeTypeOql = CheckEmpTypeSrvHelper.getEmpTypeByAction(this.actionId)))) {
            String empTypeName = inEmployeeType.getName();
            throw new EmpAffairBizBillException(EmpAffairBizBillException.INEMPTYPEILLEGAL, new Object[]{this.personName, this.dateString, empTypeName, this.actionName});
        }
    }

    private HRBizDefineTypeEnum getPreActionType() throws BOSException, EmpAffairBizBillException {
        EmpPosOrgRelationInfo preEmpPosOrgRelationInfo = null;
        EntityViewInfo entityViewInfo = CheckEmpTypeSrvHelper.getPointDateEmpPosOrgRelationOql(this.effdtDate, this.personId);
        EmpPosOrgRelationCollection empPosOrgRelationColl = this.iEmpPosOrgRelation.getEmpPosOrgRelationCollection(entityViewInfo);
        if (empPosOrgRelationColl.size() == 1) {
            preEmpPosOrgRelationInfo = empPosOrgRelationColl.get(0);
        } else {
            if (empPosOrgRelationColl.size() > 1) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.EMPRELATIONERROR, new Object[]{this.personName, this.dateString});
            }
            if (empPosOrgRelationColl.size() < 1) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.DONOTHAVEOFFICE, new Object[]{this.personName, this.dateString});
            }
        }
        HRBizDefineTypeEnum preActionType = preEmpPosOrgRelationInfo == null ? null : preEmpPosOrgRelationInfo.getAction().getBizDefineType();
        return preActionType;
    }

    private void checkPositionForMainAction() throws BOSException, EASBizException, EmpAffairBizBillException {
        String existAdminOrgId;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true, CompareType.EQUALS));
        FilterInfo pointDateLatest = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)this.effdtDate);
        filter.mergeFilter(pointDateLatest, "and");
        entityView.setFilter(filter);
        EmpPostExperienceHisCollection empPostExperienceHisCollection = this.iEmpPostExperienceHis.getEmpPostExperienceHisCollection(entityView);
        EmpPostExperienceHisInfo empPostExperienceHisInfo = null;
        if (empPostExperienceHisCollection.size() > 1) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.EXPRECORDERROR, new Object[]{this.personName, this.dateString});
        }
        if (empPostExperienceHisCollection.size() == 0) {
            StringBuilder oql = new StringBuilder(" where person.id ='").append(this.personId).append("' and laborRelation.laborRelationState.inService in (").append(2).append(",").append(3).append(")").append(" and action.id = '").append("P/OSDCPfQXqU0TB/LQoA6uZovtk=").append("' and endDateTime >=  ").append(HistoryVersionUtil.getMaxEndDateTs());
            if (EmpPosOrgRelationFactory.getLocalInstance(this.ctx).exists(oql.toString())) {
                return;
            }
            throw new EmpAffairBizBillException(EmpAffairBizBillException.EMPNOTEXISTHIS, new Object[]{this.personName, this.dateString});
        }
        empPostExperienceHisInfo = empPostExperienceHisCollection.get(0);
        String existPositionId = empPostExperienceHisInfo.getPosition() == null ? "" : empPostExperienceHisInfo.getPosition().getId().toString();
        String string = existAdminOrgId = empPostExperienceHisInfo.getAdminOrg() == null ? "" : empPostExperienceHisInfo.getAdminOrg().getId().toString();
        if (!StringUtils.equals((String)existPositionId, (String)this.targetPosition) || !StringUtils.equals((String)existAdminOrgId, (String)this.targetOrgAdmin)) {
            Date leffdt = empPostExperienceHisInfo.getLeffdt();
            if (!DateTimeUtils.dayEquals((Date)leffdt, (Date)HRUtil.getMaxEndDate())) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.EXISTEXPHIS, new Object[]{this.personName, this.dateString});
            }
            this.checkIfHaveInPosition();
        }
    }

    private void checkForParttimeAction() throws BOSException, EASBizException, EmpAffairBizBillException {
        this.checkIfHaveInPosition();
    }

    private void initExceptionParamName() throws EASBizException, BOSException {
        PersonInfo personInfo = this.iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(this.personId), new SelectorItemCollection(){
            {
                this.add(new SelectorItemInfo("name"));
            }
        });
        this.personName = personInfo.getName();
        this.dateString = this.effdt;
        if (!StringUtils.isEmpty((String)this.targetPosition)) {
            this.positionName = this.iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(this.targetPosition)).getName();
        }
    }

    private void printServiceLog() {
        System.out.println(MessageFormat.format("CheckEmployeeTypeOperatorService.doProcess params are personId:{0},actionId:{1},effdt:{2},targetEmployeeTypeId:{3},targetPositionId:{4},targetOrgAdminId:{5},isParttimeJob:{6}", this.personId, this.actionId, this.effdt, this.targetEmployeeType, this.targetPosition, this.targetOrgAdmin, this.isParttimeJob));
    }

    private void checkIfHaveInLaborRelation() throws BOSException, EASBizException, EmpAffairBizBillException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true, CompareType.EQUALS));
        FilterInfo pointDateLatest = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)this.effdtDate);
        filter.mergeFilter(pointDateLatest, "and");
        entityView.setFilter(filter);
        EmpLaborRelationHisCollection empPostExperienceHisCollection = this.iEmpLaborRelationHis.getEmpLaborRelationHisCollection(entityView);
        if (empPostExperienceHisCollection.size() == 0) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.DONOTHAVEEMPTYPE, new Object[]{this.personName, this.dateString});
        }
    }

    private void checkIfHaveInPosition() throws BOSException, EASBizException, EmpAffairBizBillException {
        EmpPostExperienceHisInfo hisInfo;
        if (StringUtils.isEmpty((String)this.targetPosition) || StringUtils.isEmpty((String)this.personId)) {
            return;
        }
        Date empPosOrgRelationInfoEffdt = null;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterAll = new FilterInfo();
        filterAll.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personId, CompareType.EQUALS));
        filterAll.getFilterItems().add(new FilterItemInfo("position.id", (Object)this.targetPosition, CompareType.EQUALS));
        filterAll.getFilterItems().add(new FilterItemInfo("isInner", (Object)true, CompareType.EQUALS));
        FilterInfo pointDateLatest = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)this.effdtDate);
        FilterInfo afterPointDate = HistoryVersionUtil.getEFFDTAfterPointDateFilterInfo((Date)this.effdtDate);
        pointDateLatest.mergeFilter(afterPointDate, "or");
        filterAll.mergeFilter(pointDateLatest, "and");
        if (!StringUtils.isEmpty((String)this.empPosOrgRelationId)) {
            EmpPosOrgRelationInfo empPosOrgRelationInfo = this.iEmpPosOrgRelation.getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(this.empPosOrgRelationId));
            empPosOrgRelationInfoEffdt = empPosOrgRelationInfo.getEFFDT();
            FilterInfo empPosOrgRelationEFFDTFilter = new FilterInfo();
            empPosOrgRelationEFFDTFilter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)empPosOrgRelationInfoEffdt, CompareType.NOTEQUALS));
            filterAll.mergeFilter(empPosOrgRelationEFFDTFilter, "and");
        }
        entityView.setFilter(filterAll);
        EmpPostExperienceHisCollection empPostExperienceHisCollection = this.iEmpPostExperienceHis.getEmpPostExperienceHisCollection(entityView);
        if (empPostExperienceHisCollection.size() > 0 && AssignTypeEnum.PARTTIME.equals((Object)(hisInfo = empPostExperienceHisCollection.get(0)).getAssignType())) {
            if ("DawAAAAqVFPmaL7Z".equals(this.actionId) || "cM5s6yPmTba5BXMKa6+h8uZovtk=".equals(this.actionId)) {
                return;
            }
            StringBuffer oql = new StringBuffer("select id, changeReason, affairActionOperate, positionField where parent.id = '").append(this.actionId).append("' ");
            HRBizDefineEntryCollection defineEntry = HRBizDefineEntryFactory.getLocalInstance(this.ctx).getHRBizDefineEntryCollection(oql.toString());
            if (null == defineEntry || defineEntry.size() == 0) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.PARMCURRENTISNULL);
            }
            boolean isOldMainPosEnd = false;
            boolean isPartTimeEnd = false;
            boolean isPartTimeAddNew = false;
            boolean isMainAddNew = false;
            for (int i = 0; i < defineEntry.size(); ++i) {
                int action = defineEntry.get(i).getAffairActionOperate().getValue();
                if (60 == action) {
                    isPartTimeAddNew = true;
                    continue;
                }
                if (70 == action) {
                    isPartTimeEnd = true;
                    continue;
                }
                if (10 == action) {
                    isMainAddNew = true;
                    continue;
                }
                if (20 != action) continue;
                isOldMainPosEnd = true;
            }
            if (isPartTimeEnd && defineEntry.size() == 1) {
                return;
            }
            if (isPartTimeEnd && !isPartTimeAddNew && isMainAddNew && isOldMainPosEnd) {
                return;
            }
            if (!isPartTimeEnd || isPartTimeAddNew) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.HASEXISTPOSTRECORD, new Object[]{this.personName, this.dateString, this.positionName});
            }
            if (!isOldMainPosEnd) {
                throw new EmpAffairBizBillException(EmpAffairBizBillException.NOT_SIPPORT_OLD_MAIN_POSITION_END);
            }
            throw new EmpAffairBizBillException(EmpAffairBizBillException.NOT_SUPPORT_MAIN_POSITION_ADDNEW);
        }
    }

    private boolean isExistInCollection(CoreBaseInfo coreBaseInfo, HRBizDefEmpTypeCollection coreBaseColl) {
        if (coreBaseInfo == null && (coreBaseColl == null || coreBaseColl.size() == 0)) {
            return true;
        }
        if (coreBaseInfo != null && (coreBaseColl == null || coreBaseColl.size() == 0)) {
            return false;
        }
        int size = coreBaseColl.size();
        for (int i = 0; i < size; ++i) {
            EmployeeTypeInfo empType = coreBaseColl.get(i).getEmpType();
            if (coreBaseInfo == null || !coreBaseInfo.getId().toString().equals(empType.getId().toString())) continue;
            return true;
        }
        return false;
    }

    public Date getEffdtDate() {
        return this.effdtDate;
    }

    public void setEffdtDate(Date effdtDate) {
        this.effdtDate = effdtDate;
    }
}

