/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.basedata.org.client.chart.HistoryNode;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.party.MemOrgBillInsideJobCollection;
import com.kingdee.eas.hr.party.MemOrgBillInsideJobFactory;
import com.kingdee.eas.hr.party.MemOrgBillInsideJobInfo;
import com.kingdee.eas.hr.party.MemOrgChartNodeInfo;
import com.kingdee.eas.hr.party.client.MemOrgDrawingPanel;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawMemOrg
extends KDPanel {
    public static final String RES = "com.kingdee.eas.hr.party.PartyResource";
    private KDPanel bar = new KDPanel();
    private KDCheckBox cbxShowInsideJob = null;
    private MemOrgDrawingPanel memOrgDrawingPanel = null;
    private KDScrollPane scrollPane = null;
    private FontMetrics fontM = null;
    private float maxy = 0.0f;
    private float maxx = 0.0f;
    static final float FixHeight = 20.0f;
    private float FixWidth = 20.0f;
    private float temp = 0.0f;
    private int interval = 0;
    protected Timer timer = new Timer();
    private DefaultMutableTreeNode rootNode = null;
    private DefaultMutableTreeNode lastNode = null;
    protected HistoryNode historyNode = null;
    private Map chiefJobMap = null;
    public int baseLevel = 0;
    public int chooseLevel = 0;
    public int chartType = 0;
    public boolean showInsideJob = false;
    private static String oldSessionId = null;

    public DrawMemOrg(int width, int height, DefaultMutableTreeNode rootNode, int level) throws Exception {
        this.initOrgUnitPanel(width, height, rootNode, level);
    }

    private void initOrgUnitPanel(int width, int height, DefaultMutableTreeNode rootNode, int level) throws Exception {
        if (rootNode == null) {
            return;
        }
        if (oldSessionId != null && !SysContext.getSysContext().getSessionID().equals(oldSessionId)) {
            this.chiefJobMap = null;
        }
        oldSessionId = SysContext.getSysContext().getSessionID();
        this.chooseLevel = rootNode.getDepth() + 1;
        this.setInsideJobVisible(this.showInsideJob);
        this.rootNode = rootNode;
        this.setBorder(new EtchedBorder(0));
        this.drawOrg();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    DrawMemOrg.this.changeSize();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    public void clearCacheData() throws Exception {
        this.chiefJobMap = null;
        this.cbxShowInsideJob.setSelected(false);
        this.setInsideJobVisible(false);
    }

    public void setRootNode(DefaultMutableTreeNode rootNode) throws Exception {
        this.rootNode = rootNode;
        this.init();
        this.memOrgDrawingPanel.clearSelectNode();
    }

    private void getInsideJobData() throws Exception {
        this.chiefJobMap = new HashMap();
        String oql = "select parent1.id, parent1.name, jobName.id, jobName.name, empName.id, empName.name where chiefPosition = 1";
        MemOrgBillInsideJobCollection insideJobs = MemOrgBillInsideJobFactory.getRemoteInstance().getMemOrgBillInsideJobCollection(oql);
        int size = insideJobs.size();
        for (int i = 0; i < size; ++i) {
            this.chiefJobMap.put(insideJobs.get(i).getParent1().getId().toString(), insideJobs.get(i));
        }
    }

    private void setInsideJobVisible(boolean showInsideJob) throws Exception {
        this.showInsideJob = showInsideJob;
        if (showInsideJob) {
            this.getInsideJobData();
        }
        this.FixWidth = showInsideJob ? 40.0f : 20.0f;
        this.startDraw();
    }

    private void changeSize() throws Exception {
        this.startDraw();
    }

    private void drawOrg() throws Exception {
        this.setLayout(new BorderLayout());
        this.bar.setLayout((LayoutManager)new FlowLayout(2));
        this.bar.setPreferredSize(new Dimension(0, 30));
        this.cbxShowInsideJob = new KDCheckBox(EASResource.getString((String)RES, (String)"SHOW_INSIDEJOB"));
        this.cbxShowInsideJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (DrawMemOrg.this.cbxShowInsideJob.isSelected()) {
                        DrawMemOrg.this.setInsideJobVisible(true);
                    } else {
                        DrawMemOrg.this.setInsideJobVisible(false);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.cbxShowInsideJob.setSelected(this.showInsideJob);
        this.bar.add((Component)this.cbxShowInsideJob);
        this.add((Component)this.bar, "North");
        this.memOrgDrawingPanel = new MemOrgDrawingPanel(this);
        this.scrollPane = new KDScrollPane((Component)((Object)this.memOrgDrawingPanel));
        this.add((Component)this.scrollPane, "Center");
        this.init();
    }

    private void init() throws Exception {
        this.historyNode = new HistoryNode();
        this.historyNode.value = ((MemOrgChartNodeInfo)this.rootNode.getUserObject()).ID;
        this.historyNode.curNode = this.rootNode;
        this.chooseLevel = this.rootNode.getDepth() + 1;
        this.startDraw();
    }

    public void startDraw() throws Exception {
        this.maxx = 0.0f;
        this.maxy = 0.0f;
        if (this.historyNode == null) {
            return;
        }
        this.baseLevel = this.historyNode.curNode.getLevel();
        this.buildFromTreeNode(this.historyNode.curNode);
        this.moveCoordinate(this.historyNode.curNode);
        this.rollCoordinate(this.historyNode.curNode);
        this.memOrgDrawingPanel.setRoot(this.historyNode.curNode);
        this.memOrgDrawingPanel.setDrawingPaneSize((int)this.maxy, (int)this.maxx);
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)this.historyNode.curNode.getUserObject();
        Rectangle rect = new Rectangle((int)memOrgChartNode.X - this.getWidth() / 2 + (int)memOrgChartNode.width / 2, 0, this.getWidth(), this.getHeight());
        if (this.scrollPane.getParent() != null) {
            this.scrollPane.getParent().validate();
        }
        this.scrollPane.getViewport().setViewSize(new Dimension((int)this.maxy, (int)this.maxx));
        if (this.maxy > (float)this.getWidth()) {
            this.scrollPane.getViewport().setViewPosition(new Point(rect.x, rect.y));
        }
    }

    private void buildFromTreeNode(DefaultMutableTreeNode root) {
        int i;
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)root.getUserObject();
        MemOrgChartNodeInfo lastMemOrgChartNode = null;
        if (this.lastNode != null) {
            lastMemOrgChartNode = (MemOrgChartNodeInfo)this.lastNode.getUserObject();
        }
        if (this.fontM == null) {
            this.fontM = this.memOrgDrawingPanel.getFontMetrics(this.memOrgDrawingPanel.getFont());
        }
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel) {
            return;
        }
        if (root.getLevel() == this.baseLevel) {
            memOrgChartNode.X = 20.0f;
            memOrgChartNode.Y = 20.0f;
        } else if (root.getLevel() == this.lastNode.getLevel() + 1) {
            memOrgChartNode.Y = lastMemOrgChartNode.Y;
            memOrgChartNode.X = lastMemOrgChartNode.X + this.FixWidth + 40.0f;
        } else if (root.getLevel() == this.lastNode.getLevel()) {
            memOrgChartNode.X = lastMemOrgChartNode.X;
            memOrgChartNode.Y = lastMemOrgChartNode.Y + lastMemOrgChartNode.height + 20.0f;
        } else {
            this.interval = this.lastNode.getLevel() - root.getLevel();
            for (i = 0; i < this.interval; ++i) {
                this.lastNode = (DefaultMutableTreeNode)this.lastNode.getParent();
            }
            lastMemOrgChartNode = (MemOrgChartNodeInfo)this.lastNode.getUserObject();
            memOrgChartNode.Y = this.maxy + 20.0f;
            memOrgChartNode.X = lastMemOrgChartNode.X;
        }
        if (this.cbxShowInsideJob.isSelected() && memOrgChartNode.ID != null) {
            memOrgChartNode.chiefPosition = this.getPompjByPoId(memOrgChartNode.ID);
        }
        memOrgChartNode.width = this.FixWidth;
        memOrgChartNode.height = (float)this.getNameMaxLength(memOrgChartNode) + 20.0f;
        this.lastNode = root;
        lastMemOrgChartNode = (MemOrgChartNodeInfo)this.lastNode.getUserObject();
        if (this.maxy < lastMemOrgChartNode.height + lastMemOrgChartNode.Y) {
            this.maxy = lastMemOrgChartNode.height + lastMemOrgChartNode.Y;
        }
        if (this.maxx < lastMemOrgChartNode.width + lastMemOrgChartNode.X) {
            this.maxx = lastMemOrgChartNode.width + lastMemOrgChartNode.X;
        }
        for (i = 0; i < root.getChildCount(); ++i) {
            this.buildFromTreeNode((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private int getNameMaxLength(MemOrgChartNodeInfo memOrgChartNode) {
        int length1 = 0;
        length1 = StringUtils.isEmpty((String)memOrgChartNode.name) ? 0 : this.fontM.stringWidth(memOrgChartNode.name);
        if (this.showInsideJob && memOrgChartNode.chiefPosition != null) {
            int length2 = 0;
            if (!StringUtils.isEmpty((String)memOrgChartNode.chiefPosition.getJobName().getName())) {
                length2 = memOrgChartNode.chiefPosition.getEmpName() != null ? this.fontM.stringWidth(memOrgChartNode.chiefPosition.getJobName().getName() + ":" + memOrgChartNode.chiefPosition.getEmpName().getName()) : this.fontM.stringWidth(memOrgChartNode.chiefPosition.getJobName().getName());
            }
            return StrictMath.max(length1, length2);
        }
        return length1;
    }

    private MemOrgBillInsideJobInfo getPompjByPoId(String memOrgId) {
        if (this.chiefJobMap != null) {
            return (MemOrgBillInsideJobInfo)this.chiefJobMap.get(memOrgId);
        }
        return null;
    }

    private void rollCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)root.getUserObject();
        this.temp = memOrgChartNode.Y + memOrgChartNode.height;
        memOrgChartNode.Y = memOrgChartNode.X;
        memOrgChartNode.X = this.maxy + 1.0f - this.temp;
        this.temp = memOrgChartNode.width;
        memOrgChartNode.width = memOrgChartNode.height;
        memOrgChartNode.height = this.temp;
        memOrgChartNode.rect = new Rectangle((int)memOrgChartNode.X, (int)memOrgChartNode.Y, (int)memOrgChartNode.width, (int)memOrgChartNode.height);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.rollCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private void moveCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        if (root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.moveCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
        if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() > 1) {
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)root.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)root.getFirstChild();
            MemOrgChartNodeInfo firstUnit = (MemOrgChartNodeInfo)firstChildNode.getUserObject();
            MemOrgChartNodeInfo endUnit = (MemOrgChartNodeInfo)lastChildNode.getUserObject();
            MemOrgChartNodeInfo rootUnit = (MemOrgChartNodeInfo)root.getUserObject();
            rootUnit.Y = firstUnit.Y / 2.0f + firstUnit.height / 4.0f + endUnit.Y / 2.0f + endUnit.height / 4.0f - rootUnit.height / 2.0f;
        } else if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() == 1) {
            MemOrgChartNodeInfo PartyOrgUnit2 = (MemOrgChartNodeInfo)((DefaultMutableTreeNode)root.getLastChild()).getUserObject();
            MemOrgChartNodeInfo rootUnit = (MemOrgChartNodeInfo)root.getUserObject();
            if (rootUnit.height < PartyOrgUnit2.height) {
                rootUnit.Y = PartyOrgUnit2.Y + (PartyOrgUnit2.height - rootUnit.height) / 2.0f;
            } else if (rootUnit.height == PartyOrgUnit2.height) {
                rootUnit.Y = PartyOrgUnit2.Y;
            } else if (rootUnit.Y < PartyOrgUnit2.Y) {
                rootUnit.Y = PartyOrgUnit2.Y + (PartyOrgUnit2.height - rootUnit.height) / 2.0f;
            } else {
                this.updateNodeY((DefaultMutableTreeNode)root.getLastChild(), (rootUnit.height - PartyOrgUnit2.height) / 2.0f);
            }
        }
    }

    private void updateNodeY(DefaultMutableTreeNode child, float height) {
        MemOrgChartNodeInfo childUnit = (MemOrgChartNodeInfo)child.getUserObject();
        childUnit.Y += height;
        for (int i = 0; i < child.getChildCount(); ++i) {
            this.updateNodeY((DefaultMutableTreeNode)child.getChildAt(i), height);
        }
    }

    public void setUserComponents(Component[] comps) {
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                this.bar.add(comps[i]);
            }
        }
    }

    public MemOrgChartNodeInfo getSelectNode() {
        return this.memOrgDrawingPanel.selMemOrg;
    }
}

