/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.party.HRPartyGroupReportFacadeFactory;
import com.kingdee.eas.hr.party.IHRPartyGroupReportFacade;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

public class HRPartyGroupReportUtil {
    public static int getAdminChildMaxLevel(AdminOrgUnitInfo adminOrg) throws Exception {
        int maxLevel = -1;
        if (!(adminOrg instanceof AdminOrgUnitInfo)) {
            return -1;
        }
        int[] datas = HRPartyGroupReportUtil.getLevelByLongNumber(adminOrg.getLongNumber(), true);
        maxLevel = datas[0] - datas[1] + 1;
        return maxLevel;
    }

    public static int[] getLevelByLongNumber(String longNumbers, boolean isByUserRange) throws Exception {
        int[] datas = new int[2];
        StringBuffer sql = new StringBuffer();
        if (isByUserRange) {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            sql.append("SELECT MAX(admin.FLevel) AS MAX0, MIN(admin.FLevel) AS MIN0 FROM T_ORG_ADMIN admin");
            sql.append(" inner join T_ORG_UnitRelation rel on rel.FFromUnitID = admin.FID");
            sql.append(" inner join T_PM_OrgRange rang on rang.FOrgID = rel.FFromUnitID");
            sql.append(" where ");
            sql.append(" rel.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append(" and rang.FUserID = ");
            sql.append("'");
            sql.append(userID);
            sql.append("'");
            sql.append(" and rang.FType = ");
            sql.append(20);
            sql.append(" and ");
            sql.append("admin.FLongNumber || '!' like");
            sql.append("'");
            sql.append(longNumbers);
            sql.append("!%'");
        } else {
            sql.append("SELECT MAX(admin.FLevel) AS MAX0, MIN(admin.FLevel) AS MIN0 From ");
            sql.append("T_ORG_Admin admin");
            sql.append(" Where ");
            sql.append("admin.FLongNumber || '!' like");
            sql.append("'");
            sql.append(longNumbers);
            sql.append("!%'");
        }
        ISQLExecutor isql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = isql.executeSQL();
        if (rows.next()) {
            datas[0] = rows.getInt("MAX0");
            datas[1] = rows.getInt("MIN0");
        }
        return datas;
    }

    public static DefaultKingdeeTreeNode getOrgUnitTreeNode(boolean isIncludePosition, String adminId) throws Exception {
        DefaultKingdeeTreeNode root = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)isIncludePosition, (boolean)false, (boolean)true, (boolean)false, null);
        if (root == null) {
            return null;
        }
        if (adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(HRPartyGroupReportUtil.getAdminIdByAdminNode(root), root);
            HRPartyGroupReportUtil.overTreeNodeSimple(root, map);
            root = (DefaultKingdeeTreeNode)map.get(adminId);
        }
        return root;
    }

    public static void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(HRPartyGroupReportUtil.getAdminIdByAdminNode(node), node);
            HRPartyGroupReportUtil.overTreeNodeSimple(node, nodeMap);
        }
    }

    public static void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec, boolean isIncludePosition) {
        AdminOrgUnitInfo adminInfo = null;
        DefaultKingdeeTreeNode childNode = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            int size = treeNode.getChildCount();
            for (int i = 0; i < size; ++i) {
                childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (childNode.getUserObject() instanceof AdminOrgUnitInfo) {
                    adminInfo = (AdminOrgUnitInfo)childNode.getUserObject();
                    adminInfo.setLevel(childNode.getLevel());
                    if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)childNode)) {
                        adminInfo.put("isEnable", (Object)new Boolean(false));
                    } else {
                        adminInfo.put("isEnable", (Object)new Boolean(true));
                    }
                    vec.add(adminInfo);
                } else if (isIncludePosition && childNode.getUserObject() instanceof PositionInfo) {
                    vec.add(childNode.getUserObject());
                }
                if (childNode.getChildCount() <= 0) continue;
                HRPartyGroupReportUtil.getCellUserObjects(childNode, vec, isIncludePosition);
            }
        }
    }

    public static String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    public static IRowSet query(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        IRowSet dataRows = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        return dataRows;
    }

    public static String metaQueryToSQL(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        String sql = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        sql = iqec.getSQL();
        return sql;
    }

    public static IRowSet query(String queryStr) throws BOSException {
        IRowSet dataRows = null;
        IHRPartyGroupReportFacade tool = HRPartyGroupReportFacadeFactory.getRemoteInstance();
        dataRows = tool.execuQuery(queryStr);
        return dataRows;
    }

    public static void sumUpOnTree(KDTable table, String treeColName, String[] countColNames) {
        HRPartyGroupReportUtil.sumNodeByChildNode(table, treeColName, countColNames, 0);
    }

    public static void sumNodeByChildNode(KDTable table, String treeColName, String[] countColNames, int startRowIndex) {
        if (startRowIndex < table.getRowCount()) {
            HRCellUserObject cellParent = (HRCellUserObject)table.getRow(startRowIndex).getCell(treeColName).getValue();
            int levelParent = cellParent.getLevel();
            String longNumberParent = cellParent.getLongNumber();
            String longNumberChild = null;
            HRCellUserObject cellChild = null;
            int rowCount = table.getRowCount();
            for (int step = startRowIndex + 1; step < rowCount; ++step) {
                cellChild = (HRCellUserObject)table.getRow(step).getCell(treeColName).getValue();
                int levelChild = cellChild.getLevel();
                longNumberChild = cellChild.getLongNumber();
                if (!longNumberChild.startsWith(longNumberParent) || levelChild - levelParent != 1) continue;
                HRPartyGroupReportUtil.sumNodeByChildNode(table, treeColName, countColNames, step);
                Object valueParent = null;
                Object valueChild = null;
                if (countColNames != null) {
                    String colName = null;
                    for (int i = 0; i < countColNames.length; ++i) {
                        colName = countColNames[i];
                        valueParent = table.getRow(startRowIndex).getCell(colName);
                        valueChild = table.getRow(step).getCell(colName);
                        table.getRow(startRowIndex).getCell(colName).setValue(HRPartyGroupReportUtil.add(valueParent, valueChild));
                    }
                    continue;
                }
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (table.getColumn(i).getKey() != null && table.getColumn(i).getKey().equals(treeColName)) continue;
                    valueParent = table.getCell(startRowIndex, i).getValue();
                    valueChild = table.getCell(step, i).getValue();
                    table.getCell(startRowIndex, i).setValue(HRPartyGroupReportUtil.add(valueParent, valueChild));
                }
            }
        }
    }

    public static Object add(Object value1, Object value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        if (value1 instanceof Byte && value2 instanceof Byte) {
            return Byte.valueOf(String.valueOf((Byte)value1 + (Byte)value2));
        }
        if (value1 instanceof Short && value2 instanceof Short) {
            return Short.valueOf(String.valueOf((Short)value1 + (Short)value2));
        }
        if (value1 instanceof Integer && value2 instanceof Integer) {
            return Integer.valueOf(String.valueOf((Integer)value1 + (Integer)value2));
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            return Long.valueOf(String.valueOf((Long)value1 + (Long)value2));
        }
        if (value1 instanceof Double && value2 instanceof Double) {
            return Double.valueOf(String.valueOf((Double)value1 + (Double)value2));
        }
        if (value1 instanceof Float && value2 instanceof Float) {
            return Float.valueOf(String.valueOf(((Float)value1).floatValue() + ((Float)value2).floatValue()));
        }
        if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
            return ((BigDecimal)value1).add((BigDecimal)value2);
        }
        if (value1 instanceof BigInteger && value2 instanceof BigInteger) {
            return ((BigInteger)value1).add((BigInteger)value2);
        }
        return null;
    }
}

