/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionActivityFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.LaborUnitPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class LaborUnionActivityFilterUI
extends AbstractLaborUnionActivityFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionActivityFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.client.PartyResource";

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtAdminOrg.getValue() != null) {
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)this.prmtAdminOrg.getValue();
            cp.addCustomerParam("adminId", info.getId().toString());
        }
        cp.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
        cp.putBoolean("isSealed", this.chkIsSealed.isSelected());
        if (this.dpkBeginDate.getValue() != null) {
            cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        }
        if (this.dpkEndDate.getValue() != null) {
            cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("adminId") != null) {
            String adminId = cp.getCustomerParam("adminId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            AdminOrgUnitInfo adminOrg = null;
            try {
                adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminOrg.setValue((Object)adminOrg);
        }
        this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        this.chkIsSealed.setSelected(cp.getBoolean("isSealed"));
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        Date endDate;
        Date startDate;
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtBelongUnit);
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null && (startDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue()))).after(endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue())))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"StartDateBeforeEndDate"));
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setValue(null);
        this.dpkBeginDate.setValue(null);
        this.dpkEndDate.setValue(null);
        this.chkIncludeChild.setSelected(false);
        this.chkIsSealed.setSelected(false);
        this.chkIsSealed.setEnabled(true);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        LaborUintInfo uintInfo = (LaborUintInfo)this.prmtBelongUnit.getData();
        filter.getFilterItems().add(new FilterItemInfo("belongUnit.number", (Object)uintInfo.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("belongUnit.longNumber", (Object)(uintInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 or #1");
        if (!this.chkIsSealed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("belongUnit.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            filter.setMaskString("#0 or (#1 and #2)");
        }
        this.setDateFilter(filter);
        return filter;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.dpkBeginDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue())), CompareType.GREATER_EQUALS));
        }
        if (this.dpkEndDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue())), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        this.prmtAdminOrg.setEditable(false);
        this.prmtAdminOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        LaborUnitPromptBox laborUnitF7 = new LaborUnitPromptBox();
        laborUnitF7.setIsSingleSelected(true);
        laborUnitF7.setIsUsePermission(true);
        this.prmtBelongUnit.setSelector((KDPromptSelector)laborUnitF7);
        this.prmtBelongUnit.setEditable(false);
    }

    protected void chkIncludeChild_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIncludeChild.isSelected()) {
            this.chkIsSealed.setEnabled(true);
            this.chkIsSealed.setSelected(false);
        } else {
            this.chkIsSealed.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkIsSealed.setEnabled(false);
    }
}

