/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.LaborUintFactory;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionFeeStatFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.LaborUnitPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LaborUnionFeeStatFilterUI
extends AbstractLaborUnionFeeStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionFeeStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.prmtBelongUnit.setValue(null);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkBeginDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtBelongUnit.getValue() != null) {
            cp.addCustomerParam("belongUnitId", ((LaborUintInfo)this.prmtBelongUnit.getValue()).getId().toString());
        }
        cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        cp.putBoolean("showCancel", this.cbxShowCancel.isSelected());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("belongUnit.number", (Object)((LaborUintInfo)this.prmtBelongUnit.getValue()).getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("belongUnit.longNumber", (Object)(((LaborUintInfo)this.prmtBelongUnit.getValue()).getLongNumber() + "!%"), CompareType.LIKE));
        if (!this.cbxShowCancel.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("belongUnit.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and #2");
        }
        filter.setMaskString("#0 or #1");
        return filter;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("belongUnitId") != null) {
            String belongUnitId = cp.getCustomerParam("belongUnitId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)belongUnitId));
            LaborUintInfo belongUnit = null;
            try {
                belongUnit = LaborUintFactory.getRemoteInstance().getLaborUintInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtBelongUnit.setValue((Object)belongUnit);
        }
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtBelongUnit);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkBeginDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null) {
            Date beginDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue()));
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        this.prmtAdminOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtAdminOrg.setEditable(false);
        LaborUnitPromptBox laborUnitF7 = new LaborUnitPromptBox();
        laborUnitF7.setIsSingleSelected(true);
        laborUnitF7.setIsUsePermission(true);
        this.prmtBelongUnit.setSelector((KDPromptSelector)laborUnitF7);
        this.prmtBelongUnit.setEditable(false);
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("belongUnitId", ((LaborUintInfo)this.prmtBelongUnit.getValue()).getId().toString());
        map.put("number", ((LaborUintInfo)this.prmtBelongUnit.getValue()).getNumber());
        map.put("longNumber", ((LaborUintInfo)this.prmtBelongUnit.getValue()).getLongNumber());
        map.put("beginDate", this.dpkBeginDate.getValue());
        map.put("endDate", this.dpkEndDate.getValue());
        map.put("showCancel", new Boolean(this.cbxShowCancel.isSelected()));
        return map;
    }
}

