/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionMemberDetailFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.LaborUnitPromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LaborUnionMemberDetailFilterUI
extends AbstractLaborUnionMemberDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionMemberDetailFilterUI.class);
    private int levelLimited = -1;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setValue(null);
        this.chkIsSealed.setEnabled(true);
        this.rbShowAllLevel.setSelected(true);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtAdminOrg.getValue() != null) {
            cp.addCustomerParam("adminId", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
        }
        cp.putBoolean("isSealed", this.chkIsSealed.isSelected());
        cp.putInt("levelLimited", this.levelLimited);
        if (this.rbNotIncludeChild.isSelected()) {
            cp.putInt("rb", 0);
        } else if (this.rbLevel.isSelected()) {
            cp.putInt("rb", 1);
            if (this.levelLimited != -1) {
                cp.putInt("selectedItem", ((Integer)this.cbLevel.getSelectedItem()).intValue());
            }
        } else if (this.rbShowAllLevel.isSelected()) {
            cp.putInt("rb", 2);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("adminId") != null) {
            String adminId = cp.getCustomerParam("adminId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            AdminOrgUnitInfo adminOrg = null;
            try {
                adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminOrg.setValue((Object)adminOrg);
        }
        this.chkIsSealed.setSelected(cp.getBoolean("isSealed"));
        switch (cp.getInt("rb")) {
            case 0: {
                this.rbNotIncludeChild.setSelected(true);
                break;
            }
            case 1: {
                this.rbLevel.setSelected(true);
                break;
            }
            case 2: {
                this.rbShowAllLevel.setSelected(true);
            }
        }
        this.levelLimited = cp.getInt("levelLimited");
        if (this.levelLimited != -1 && this.prmtAdminOrg.getValue() != null) {
            this.setCBox();
            this.cbLevel.setSelectedItem((Object)new Integer(cp.getInt("selectedItem")));
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        String maskStr = null;
        if (this.prmtBelongUnit.getData() != null) {
            LaborUintInfo uintInfo = (LaborUintInfo)this.prmtBelongUnit.getData();
            if (this.rbNotIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.id", (Object)uintInfo.getId(), CompareType.EQUALS));
            } else if (this.rbLevel.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.longNumber", (Object)(uintInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.number", (Object)uintInfo.getNumber(), CompareType.EQUALS));
                maskStr = new String("(#0 or #1)");
                if (this.levelLimited != -1) {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.level", (Object)new Integer(uintInfo.getLevel()), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.level", (Object)new Integer((Integer)this.cbLevel.getSelectedItem() - 1 + uintInfo.getLevel()), CompareType.LESS_EQUALS));
                    maskStr = new String("(#0 or #1) and #2 and #3");
                }
            } else if (this.rbShowAllLevel.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.longNumber", (Object)(uintInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.number", (Object)uintInfo.getNumber(), CompareType.EQUALS));
                maskStr = new String("(#0 or #1)");
            }
        }
        if (!this.chkIsSealed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("belongUnit.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            if (maskStr != null) {
                maskStr = maskStr.concat(" and #" + (filter.getFilterItems().size() - 1));
            }
        }
        if (maskStr != null) {
            filter.setMaskString(maskStr);
        }
        this.mergeUserOrgRangeFilter(filter);
        return filter;
    }

    public boolean verify() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtBelongUnit);
        return true;
    }

    protected void rbNotIncludeChild_actionPerformed(ActionEvent e) throws Exception {
        super.rbNotIncludeChild_actionPerformed(e);
        this.resetLevel();
        this.chkIsSealed.setSelected(false);
        this.chkIsSealed.setEnabled(false);
    }

    protected void rbShowAllLevel_actionPerformed(ActionEvent e) throws Exception {
        super.rbShowAllLevel_actionPerformed(e);
        this.resetLevel();
        this.chkIsSealed.setEnabled(true);
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        this.prmtAdminOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtAdminOrg.setEditable(false);
        LaborUnitPromptBox laborUnitF7 = new LaborUnitPromptBox();
        laborUnitF7.setIsSingleSelected(true);
        laborUnitF7.setIsUsePermission(true);
        this.prmtBelongUnit.setSelector((KDPromptSelector)laborUnitF7);
        this.prmtBelongUnit.setEditable(false);
    }

    private void resetLevel() {
        if (this.cbLevel.getItemCount() != 0) {
            this.cbLevel.removeAllItems();
        }
        this.levelLimited = -1;
    }

    private void setCBox() {
        if (this.levelLimited != -1) {
            for (int i = 0; i < this.levelLimited; ++i) {
                this.cbLevel.addItem((Object)new Integer(i + 1));
            }
            this.cbLevel.setSelectedIndex(0);
        }
    }

    private void mergeUserOrgRangeFilter(FilterInfo filter) {
        if (filter != null) {
            FilterInfo orgRangeFilter = new FilterInfo();
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.type", (Object)new Integer(20), CompareType.EQUALS));
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
            try {
                filter.mergeFilter(orgRangeFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

