/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.party.LaborUnionMemberCollection;
import com.kingdee.eas.hr.party.LaborUnionMemberFactory;
import com.kingdee.eas.hr.party.LaborUnionMemberInfo;
import com.kingdee.eas.hr.party.PartyPayPerInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnionMemberEditUI;
import com.kingdee.eas.hr.party.client.LaborUnitPromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class LaborUnionMemberEditUI
extends AbstractLaborUnionMemberEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnionMemberEditUI.class);
    private EmployeeTreeEditUI treeEditUI;
    private LaborUnitPromptBox promptBox = null;

    public LaborUnionMemberEditUI() throws Exception {
        this.prmtlaborUnionJob.setEnabled(false);
        this.showData.setFocusable(false);
        this.removeBelongUnitSelectorListener();
        this.initLaborUnitF7();
    }

    protected void initLaborUnitF7() {
        if (this.promptBox == null) {
            this.promptBox = new LaborUnitPromptBox();
            this.promptBox.setIsSingleSelected(true);
            this.promptBox.setIsUsePermission(false);
        }
    }

    private void removeBelongUnitSelectorListener() {
        SelectorListener[] listeners = this.prmtbelongUnit.getSelectorListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.prmtbelongUnit.removeSelectorListener(listeners[i]);
        }
    }

    public void loadFields() {
        this.prmtbelongUnit.setSelector((KDPromptSelector)this.promptBox);
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
    }

    protected void afterOnLoad() throws Exception {
        if (this.prmtlaborUnionJob.getValue() != null) {
            this.txtLaborUnionJob.setText(this.prmtlaborUnionJob.getValue().toString());
        }
        super.afterOnLoad();
    }

    protected IObjectValue createNewData() {
        LaborUnionMemberInfo info = new LaborUnionMemberInfo();
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
        person.setName(this.treeEditUI.personName);
        person.setNumber(this.treeEditUI.personNumber);
        info.setPerson(person);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LaborUnionMemberFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String id = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            id = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (id != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)id));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            LaborUnionMemberCollection coll = null;
            try {
                coll = LaborUnionMemberFactory.getRemoteInstance().getLaborUnionMemberCollection(view);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.editData = coll.size() > 0 ? coll.get(0) : (LaborUnionMemberInfo)this.createNewData();
            this.setDataObject((IObjectValue)this.editData);
            this.editData.copyNewToOld();
        }
        return this.editData;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    protected void prmtfeeRatio_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtfeeRatio.getValue() == null) {
            this.showData.setText("");
            return;
        }
        if (((PartyPayPerInfo)this.prmtfeeRatio.getValue()).getPartyfeemode() == null) {
            return;
        }
        String partyFeeMode = ((PartyPayPerInfo)this.prmtfeeRatio.getValue()).getPartyfeemode().getValue();
        String payper = ((PartyPayPerInfo)this.prmtfeeRatio.getValue()).getPayper().toString();
        String type = ((PartyPayPerInfo)this.prmtfeeRatio.getValue()).getName();
        payper = "1".equals(partyFeeMode) ? UIRuleUtil.getBigDecimal((String)payper).multiply(new BigDecimal(100)).setScale(2) + "%" : UIRuleUtil.getBigDecimal((String)payper).setScale(2) + "";
        partyFeeMode = ((PartyPayPerInfo)this.prmtfeeRatio.getValue()).getPartyfeemode().toString();
        this.showData.setText(type + "," + partyFeeMode + "," + payper);
        super.prmtfeeRatio_dataChanged(e);
    }
}

