/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.hr.party.LaborUintFactory;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.LaborUintInsideJobCollection;
import com.kingdee.eas.hr.party.client.AbstractLaborUnitChartUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.eas.hr.party.client.chart.DrawLaborUnit;
import com.kingdee.eas.hr.party.client.chart.LaborUnitChartNodeInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LaborUnitChartUI
extends AbstractLaborUnitChartUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborUnitChartUI.class);
    private DrawLaborUnit drawLaborUint = null;
    private int level = 0;
    private boolean isRefresh = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.buildTree();
        this.getSelectNodeLevel();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setEnabled(true);
        this.treeMain.setSelectionRow(0);
        if (this.treeMain.getRowCount() != 0) {
            this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
    }

    private void buildTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(treeSelectionListener);
        ITreeBuilder treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)100, (int)100, (FilterInfo)this.getDefaultFilter(), null);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.treeMain.setSelectionRow(0);
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return LaborUintFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilter() throws ParserException {
        FilterInfo cancelFilter = new FilterInfo("isCancel = 0");
        return cancelFilter;
    }

    public static DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    private void getChildrenNodes(DefaultKingdeeTreeNode parent, DefaultMutableTreeNode root) {
        if (parent.getUserObject() instanceof LaborUintInfo) {
            LaborUintInsideJobCollection insideJobs;
            LaborUintInfo uintInfo = (LaborUintInfo)parent.getUserObject();
            LaborUnitChartNodeInfo nodeInfo = new LaborUnitChartNodeInfo();
            nodeInfo.ID = uintInfo.getId().toString();
            nodeInfo.name = uintInfo.getName();
            nodeInfo.number = uintInfo.getNumber();
            nodeInfo.level = uintInfo.getLevel();
            nodeInfo.insideJobs = insideJobs = uintInfo.getInsideJob();
            if (!PartyUtils.isTreeNodeDisable(parent) && uintInfo.get("CAN_VIEW") != null) {
                nodeInfo.canView = true;
            }
            root.setUserObject(nodeInfo);
            DefaultMutableTreeNode child = null;
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                child = new DefaultMutableTreeNode();
                this.getChildrenNodes((DefaultKingdeeTreeNode)parent.getChildAt(i), child);
                root.add(child);
            }
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        DefaultKingdeeTreeNode selectNode = LaborUnitChartUI.getSelectTreeNode(this.treeMain);
        if (selectNode == null) {
            return;
        }
        this.getChildrenNodes(selectNode, (DefaultMutableTreeNode)root);
        if (this.drawLaborUint == null) {
            this.drawLaborUint = new DrawLaborUnit(this.getWidth(), this.getHeight(), (DefaultMutableTreeNode)root, this.level);
            this.drawLaborUint.setUserComponents(null);
        } else {
            this.drawLaborUint.setRootNode((DefaultMutableTreeNode)root);
        }
        if (this.isRefresh) {
            this.drawLaborUint.clearCacheData();
        }
        this.pnlMain.setDividerLocation(240);
        this.pnlMain.add((Component)((Object)this.drawLaborUint), (Object)"right");
        this.pnlMain.revalidate();
    }

    private void getSelectNodeLevel() {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            this.level = treeBaseInfo.getLevel();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isRefresh = true;
        this.buildTree();
        this.isRefresh = false;
    }
}

