/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.ILaborUnitPaymentBase;
import com.kingdee.eas.hr.party.LaborUnitPaymentBaseCollection;
import com.kingdee.eas.hr.party.LaborUnitPaymentBaseFactory;
import com.kingdee.eas.hr.party.LaborUnitPaymentBaseInfo;
import com.kingdee.eas.hr.party.client.AbstractLaborUnitPaymentBaseUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPaymentBaseUI;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LaborUnitPaymentBaseUI
extends AbstractLaborUnitPaymentBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(MemOrgPaymentBaseUI.class);
    protected AdminByOrgRangePromptBox adminF7 = null;
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private boolean isEditStatus = false;
    private HashSet deleteIds = new HashSet();
    private LaborUnitPaymentBaseCollection unitPaymentBaseCollection = null;
    private LaborUnitPaymentBaseCollection newPaymentBaseColl = null;

    public LaborUnitPaymentBaseUI() throws Exception {
        this.initEmpF7();
        this.adminF7 = new AdminByOrgRangePromptBox();
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setCellEditor();
        this.prmtAdminOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                LaborUnitPaymentBaseUI.this.prmtAdminOrgUnit_dataChanged();
            }
        });
        this.unitPaymentBaseCollection = this.getLaborUnitPaymentBaseCollection();
    }

    private void setCellEditor() {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setNumberFormat("0.00");
        KDFormattedTextField kdtEntrys_formatted_TextField = new KDFormattedTextField();
        kdtEntrys_formatted_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_formatted_TextField.setVisible(true);
        kdtEntrys_formatted_TextField.setEditable(true);
        kdtEntrys_formatted_TextField.setDataType(1);
        kdtEntrys_formatted_TextField.setPrecision(2);
        kdtEntrys_formatted_TextField.setDataVerifierType(12);
        kdtEntrys_formatted_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_formatted_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_formatted_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_formatted_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_formatted_TextField);
        this.kdtEntrys.getColumn("payBase").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payBase").getStyleAttributes().setNumberFormat("0.00");
        KDTextField kdtEntrys_description_TextField = new KDTextField();
        kdtEntrys_description_TextField.setName("kdtEntrys_description_TextField");
        kdtEntrys_description_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_description_TextField);
        this.kdtEntrys.getColumn("remark").setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
    }

    protected void loadMemOrgPaymentBaseInfos() throws Exception {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.removeRows();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getFilterInfo());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.*"));
        sic.add(new SelectorItemInfo("adminOrg.*"));
        view.setSelector(sic);
        this.unitPaymentBaseCollection = ((ILaborUnitPaymentBase)this.getBizInterface()).getLaborUnitPaymentBaseCollection(view);
        LaborUnitPaymentBaseInfo unitPaymentBaseInfo = null;
        IRow row = null;
        Iterator it = this.unitPaymentBaseCollection.iterator();
        while (it.hasNext()) {
            unitPaymentBaseInfo = (LaborUnitPaymentBaseInfo)it.next();
            row = this.kdtEntrys.addRow();
            this.kdtEntrys.getCell(row.getRowIndex(), "ID").setValue((Object)unitPaymentBaseInfo.getId().toString());
            this.kdtEntrys.getCell(row.getRowIndex(), "personNumber").setValue((Object)unitPaymentBaseInfo.getPerson().getNumber());
            this.kdtEntrys.getCell(row.getRowIndex(), "personName").setValue((Object)unitPaymentBaseInfo.getPerson());
            this.kdtEntrys.getCell(row.getRowIndex(), "adminOrg").setValue((Object)unitPaymentBaseInfo.getAdminOrg());
            if (unitPaymentBaseInfo.getImportData() != null) {
                this.kdtEntrys.getCell(row.getRowIndex(), "importData").setValue((Object)unitPaymentBaseInfo.getImportData());
            } else {
                this.kdtEntrys.getCell(row.getRowIndex(), "importData").setValue((Object)ZERO);
            }
            if (unitPaymentBaseInfo.getPayBase() != null) {
                this.kdtEntrys.getCell(row.getRowIndex(), "payBase").setValue((Object)unitPaymentBaseInfo.getPayBase());
            } else {
                this.kdtEntrys.getCell(row.getRowIndex(), "payBase").setValue((Object)ZERO);
            }
            this.kdtEntrys.getCell(row.getRowIndex(), "remark").setValue((Object)unitPaymentBaseInfo.getRemark());
        }
        this.unitPaymentBaseCollection = this.getLaborUnitPaymentBaseCollection();
    }

    protected LaborUnitPaymentBaseCollection getLaborUnitPaymentBaseCollection() {
        LaborUnitPaymentBaseCollection unitPaymentBaseCollection = new LaborUnitPaymentBaseCollection();
        LaborUnitPaymentBaseInfo unitPaymentBaseInfo = null;
        IRow row = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            row = this.kdtEntrys.getRow(i);
            unitPaymentBaseInfo = new LaborUnitPaymentBaseInfo();
            if (row.getCell("ID").getValue() != null) {
                unitPaymentBaseInfo.setId(BOSUuid.read((String)row.getCell("ID").getValue().toString()));
            }
            if (row.getCell("personName").getValue() != null) {
                unitPaymentBaseInfo.setPerson((PersonInfo)row.getCell("personName").getValue());
            }
            if (row.getCell("adminOrg").getValue() != null) {
                unitPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)row.getCell("adminOrg").getValue());
            }
            if (row.getCell("importData").getValue() != null) {
                unitPaymentBaseInfo.setImportData((BigDecimal)row.getCell("importData").getValue());
            }
            if (row.getCell("payBase").getValue() != null) {
                unitPaymentBaseInfo.setPayBase((BigDecimal)row.getCell("payBase").getValue());
            }
            if (row.getCell("remark").getValue() != null) {
                unitPaymentBaseInfo.setRemark(row.getCell("remark").getValue().toString());
            }
            unitPaymentBaseCollection.add(unitPaymentBaseInfo);
        }
        return unitPaymentBaseCollection;
    }

    private FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtAdminOrgUnit.getValue() != null) {
            AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)adminOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
        }
        return filterInfo;
    }

    private void loadTableRow(LaborUnitPaymentBaseInfo unitPaymentBaseInfo, IRow detailRow) {
        if (detailRow == null) {
            detailRow = this.kdtEntrys.addRow();
        }
        if (unitPaymentBaseInfo.getId() != null) {
            this.kdtEntrys.getCell(detailRow.getRowIndex(), "ID").setValue((Object)unitPaymentBaseInfo.getId().toString());
        }
        PersonInfo pInfo = unitPaymentBaseInfo.getPerson();
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "personName").setValue((Object)pInfo);
        if (pInfo != null) {
            this.kdtEntrys.getCell(detailRow.getRowIndex(), "personNumber").setValue((Object)pInfo.getNumber());
        }
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "adminOrg").setValue((Object)unitPaymentBaseInfo.getAdminOrg());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "importData").setValue((Object)unitPaymentBaseInfo.getImportData());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "payBase").setValue((Object)unitPaymentBaseInfo.getPayBase());
        this.kdtEntrys.getCell(detailRow.getRowIndex(), "remark").setValue((Object)unitPaymentBaseInfo.getRemark());
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contEntrys.setTitle(EASResource.getString((String)resClassName, (String)"PartyPaymentBase"));
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)this.adminF7);
        this.prmtAdminOrgUnit.setEditable(false);
        this.btDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btDeleteLine.setText(null);
        this.btInsertLine.setText(null);
        this.btAddLine.setText(null);
        this.btnPrint.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.contEntrys.addButton((JButton)this.btAddLine);
        this.contEntrys.addButton((JButton)this.btInsertLine);
        this.contEntrys.addButton((JButton)this.btDeleteLine);
        this.changeEditStatus(false);
    }

    protected void changeEditStatus(boolean lbEditStatus) {
        this.isEditStatus = lbEditStatus;
        if (this.isEditStatus) {
            this.kdtEntrys.setEditable(true);
            this.btAddLine.setEnabled(true);
            this.btDeleteLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
            this.btnImport.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnEdit.setEnabled(false);
        } else {
            this.kdtEntrys.setEditable(false);
            this.btnEdit.setEnabled(true);
            this.btAddLine.setEnabled(false);
            this.btDeleteLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnPrint.setEnabled(true);
        }
    }

    protected void prmtAdminOrgUnit_dataChanged() {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE"));
            if (comfirm == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (comfirm == 2) {
                SysUtil.abort();
            }
        }
        try {
            this.loadMemOrgPaymentBaseInfos();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtEntrys)) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        int top = this.kdtEntrys.getSelectManager().get().getTop();
        if (this.kdtEntrys.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        IRow currentRow = this.kdtEntrys.getRow(top);
        ICell cell = currentRow.getCell("ID");
        if (cell.getValue() != null) {
            this.deleteIds.add(cell.getValue().toString());
        }
        this.kdtEntrys.removeRow(top);
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("LaborUnionMember.checkInDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            } else if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        if ((persons = this.getProcessedPersons(persons)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected List getProcessedPersons(List persons) throws Exception {
        if (persons == null) {
            return null;
        }
        for (int i = 0; i < persons.size(); ++i) {
            PersonInfo person = (PersonInfo)persons.get(i);
            int n = this.kdtEntrys.getRowCount();
            for (int j = 0; j < n; ++j) {
                if (this.kdtEntrys.getCell(j, "personName").getValue() == null || !person.getId().equals((Object)((PersonInfo)this.kdtEntrys.getCell(j, "personName").getValue()).getId())) continue;
                persons.remove(i);
            }
        }
        return persons;
    }

    protected LaborUnitPaymentBaseInfo findPersonsInDB(String personID) throws Exception {
        LaborUnitPaymentBaseCollection unitPaymentBaseCollection = ((ILaborUnitPaymentBase)this.getBizInterface()).getLaborUnitPaymentBaseCollection("SELECT person.*, adminOrg.*, importData, payBase, remark WHERE person.id='" + personID + "'");
        if (unitPaymentBaseCollection != null && unitPaymentBaseCollection.size() > 0) {
            return unitPaymentBaseCollection.get(0);
        }
        return null;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected String getKeyFieldName() {
        return "adminOrg";
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        try {
            LaborUnitPaymentBaseInfo unitPaymentBaseInfo = this.findPersonsInDB(pInfo.getId().toString());
            if (unitPaymentBaseInfo == null) {
                unitPaymentBaseInfo = new LaborUnitPaymentBaseInfo();
                unitPaymentBaseInfo.setPerson(pInfo);
                if (pInfo.get("primaryAdminOrg") != null) {
                    unitPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg"));
                } else {
                    try {
                        unitPaymentBaseInfo.setAdminOrg(HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                unitPaymentBaseInfo.setImportData(ZERO);
                unitPaymentBaseInfo.setPayBase(ZERO);
            }
            this.loadTableRow(unitPaymentBaseInfo, row);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.changeEditStatus(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LaborUnitPaymentBaseFactory.getRemoteInstance();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.submit();
        this.loadFields();
        this.changeEditStatus(false);
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int intMsgReturn = MsgBox.showConfirm2((String)EASResource.getString((String)resClassName, (String)"delAllPaymentbase"));
        if (intMsgReturn == 0 && this.unitPaymentBaseCollection != null && this.unitPaymentBaseCollection.size() > 0) {
            IObjectPK[] arrayPK = new IObjectPK[this.unitPaymentBaseCollection.size()];
            for (int i = 0; i < this.unitPaymentBaseCollection.size(); ++i) {
                arrayPK[i] = new ObjectUuidPK(this.unitPaymentBaseCollection.get(i).getId());
            }
            this.getBizInterface().delete(arrayPK);
        }
        this.loadMemOrgPaymentBaseInfos();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE"));
            if (comfirm == 0) {
                this.submit();
            }
            if (comfirm == 2) {
                SysUtil.abort();
            }
        }
        this.loadMemOrgPaymentBaseInfos();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.party.LaborUnitPaymentBaseInfo";
        param.alias = EASResource.getString((String)resClassName, (String)"import_laborUnitPaymentBase");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"MODIFY_AND_SAVE"));
            return;
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        this.actionRefresh_actionPerformed(null);
    }

    private void submit() throws Exception {
        this.kdtEntrys.getEditManager().stopEditing();
        CoreBaseCollection coreCollAdd = new CoreBaseCollection();
        CoreBaseCollection coreCollUpdate = new CoreBaseCollection();
        int countCycle = this.kdtEntrys.getRowCount();
        for (int i = 0; i < countCycle; ++i) {
            BigDecimal bigDecValue;
            IRow currentRow = this.kdtEntrys.getRow(i);
            LaborUnitPaymentBaseInfo unitPaymentBaseInfo = new LaborUnitPaymentBaseInfo();
            Object cellValue = currentRow.getCell("ID").getValue();
            if (cellValue != null) {
                unitPaymentBaseInfo.setId(BOSUuid.read((String)cellValue.toString()));
            }
            unitPaymentBaseInfo.setPerson((PersonInfo)currentRow.getCell("personName").getValue());
            unitPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)currentRow.getCell("adminOrg").getValue());
            cellValue = currentRow.getCell("importData").getValue();
            if (cellValue != null) {
                bigDecValue = (BigDecimal)cellValue;
                unitPaymentBaseInfo.setImportData(bigDecValue);
            } else {
                unitPaymentBaseInfo.setImportData(ZERO);
            }
            cellValue = currentRow.getCell("payBase").getValue();
            if (cellValue != null) {
                bigDecValue = (BigDecimal)cellValue;
                unitPaymentBaseInfo.setPayBase(bigDecValue);
            } else {
                unitPaymentBaseInfo.setPayBase(ZERO);
            }
            cellValue = currentRow.getCell("remark").getValue();
            if (cellValue != null) {
                unitPaymentBaseInfo.setRemark(cellValue.toString());
            } else {
                unitPaymentBaseInfo.setRemark("");
            }
            if (unitPaymentBaseInfo.getId() == null) {
                coreCollAdd.add((CoreBaseInfo)unitPaymentBaseInfo);
                continue;
            }
            coreCollUpdate.add((CoreBaseInfo)unitPaymentBaseInfo);
        }
        if (!this.deleteIds.isEmpty() && this.unitPaymentBaseCollection != null && this.unitPaymentBaseCollection.size() > 0) {
            String deleteID2 = null;
            for (String deleteID2 : this.deleteIds) {
                if (this.unitPaymentBaseCollection.get(BOSUuid.read((String)deleteID2)) == null) continue;
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)deleteID2)));
            }
        }
        if (!coreCollAdd.isEmpty()) {
            this.getBizInterface().save(coreCollAdd);
        }
        if (!coreCollUpdate.isEmpty()) {
            this.getBizInterface().update(coreCollUpdate);
        }
        this.deleteIds.clear();
        this.loadMemOrgPaymentBaseInfos();
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int comfirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMFIRM_SAVE_EXIT"));
            if (comfirm == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else if (comfirm == 2) {
                return false;
            }
        }
        return super.checkBeforeWindowClosing();
    }

    protected boolean isModify() {
        this.newPaymentBaseColl = this.getLaborUnitPaymentBaseCollection();
        return this.unitPaymentBaseCollection == null && this.newPaymentBaseColl != null || this.unitPaymentBaseCollection != null && this.newPaymentBaseColl == null || this.unitPaymentBaseCollection != null && this.newPaymentBaseColl != null && !this.unitPaymentBaseCollection.equals((Object)this.newPaymentBaseColl);
    }
}

