/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.IMemberInfor;
import com.kingdee.eas.hr.party.MemActivityCollection;
import com.kingdee.eas.hr.party.MemActivityFactory;
import com.kingdee.eas.hr.party.MemActivityInfo;
import com.kingdee.eas.hr.party.MemberInforCollection;
import com.kingdee.eas.hr.party.MemberInforFactory;
import com.kingdee.eas.hr.party.client.AbstractMemActivityEditUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.party.client.PartyPrint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public class MemActivityEditUI
extends AbstractMemActivityEditUI {
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected AdminByOrgRangePromptBox adminF7 = null;
    protected MemOrgPromptBox memOrgF7 = null;
    private static String partyPrintID = null;
    private static String printParth = "/HR/state/party/MemActivityBill";
    private static String queryName = "MemActivityPrintQuery";
    private static String entryQueryName = "MemActivityEntryPrintQuery";
    private static String queryParth = "com.kingdee.eas.hr.party.app";
    private static String entryID = "bill.id";

    public MemActivityEditUI() throws Exception {
        this.initEmpF7();
        this.adminF7 = new AdminByOrgRangePromptBox();
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
        this.memOrgF7 = new MemOrgPromptBox();
        this.memOrgF7.setIsSingleSelected(true);
        this.memOrgF7.setIsUsePermission(true);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.prmtAdminOrg.setSelector((KDPromptSelector)this.adminF7);
        this.prmtAdminOrg.setEditable(false);
        this.prmtmemOrg.setSelector((KDPromptSelector)this.memOrgF7);
        this.prmtmemOrg.setEditable(false);
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btASC.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btDESC.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.contMain.addButton((JButton)this.btAddLine);
        this.contMain.addButton((JButton)this.btInsertLine);
        this.contMain.addButton((JButton)this.btRemoveLine);
        this.contMain.addButton((JButton)this.btASC);
        this.contMain.addButton((JButton)this.btDESC);
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.menuItemCopy.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnAttachment.setVisible(true);
        this.MenuItemAttachment.setVisible(true);
        this.kdtEntrys.getSelectManager().setSelectMode(10);
        this.txtActivityCost.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.txtActivityCost.setMinimumValue((Comparable)new BigDecimal(0));
    }

    public void storeFields() {
        super.storeFields();
        this.editData.setActivityCost(this.txtActivityCost.getBigDecimalValue());
    }

    protected IObjectValue createNewData() {
        MemActivityInfo info = new MemActivityInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MemActivityFactory.getRemoteInstance();
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        HRPartyClientUtils.removeLine(this.kdtEntrys);
    }

    protected void btASC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntrys, true);
        }
    }

    protected void btDESC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntrys, false);
        }
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("memberInfor.applyDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        String activeID = null;
        if (this.editData.getId() != null) {
            activeID = this.editData.getId().toString();
        }
        if ((persons = this.getProcessedPersons(persons, activeID)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected List getProcessedPersons(List persons, String billID) throws Exception {
        PersonInfo pinfo2 = null;
        int i = 0;
        int n = this.kdtEntrys.getRowCount();
        for (PersonInfo pinfo2 : persons) {
            for (i = 0; i < n; ++i) {
                if (this.kdtEntrys.getRow(i).getCell("person") == null || !this.kdtEntrys.getRow(i).getCell("person").equals(pinfo2)) continue;
                persons.remove(pinfo2);
            }
        }
        return persons;
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        EntityViewInfo MemberInforViewInfo = new EntityViewInfo();
        FilterInfo personCommunistFilter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        personCommunistFilter.getFilterItems().add(new FilterItemInfo("person", (Object)pInfo.getId(), CompareType.EQUALS));
        personCommunistFilter.getFilterItems().add(new FilterItemInfo("number", null, CompareType.NOTEQUALS));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        MemberInforViewInfo.setSelector(sic);
        MemberInforViewInfo.setFilter(personCommunistFilter);
        IMemberInfor iMemberInfor = MemberInforFactory.getRemoteInstance();
        MemberInforCollection collection = iMemberInfor.getMemberInforCollection(MemberInforViewInfo);
        table.getRow(row.getRowIndex()).getCell("person").setValue((Object)pInfo);
        table.getRow(row.getRowIndex()).getCell("personNumber").setValue((Object)pInfo.getNumber());
        if (pInfo.get("primaryAdminOrg") != null) {
            table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg")));
        } else {
            try {
                table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        if (collection.size() > 0) {
            table.getRow(row.getRowIndex()).getCell("number").setValue((Object)collection.get(0).getNumber());
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.verifyInput();
        super.beforeStoreFields(e);
    }

    private void verifyInput() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtActivityTheme);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtActivityType);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkStartDate);
        if (this.txtActivityCost.getText() == null || this.txtActivityCost.getText().trim().equals("")) {
            this.txtActivityCost.requestFocus(true);
            MsgBox.showInfo((Component)((Object)this), (String)(((KDLabelContainer)this.txtActivityCost.getParent()).getBoundLabelText() + EASResource.getString((String)resClassName, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        if (this.kdtEntrys == null || this.kdtEntrys.getRowCount() <= 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)resClassName, (String)"entrys") + EASResource.getString((String)resClassName, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        try {
            if (this.editData.getId() == null) {
                String sql = "select id where number = '" + this.txtNumber.getText() + "'";
                MemActivityCollection memCollect = MemActivityFactory.getRemoteInstance().getMemActivityCollection(sql);
                if (memCollect.size() > 0) {
                    MsgBox.showInfo((String)(EASResource.getString((String)resClassName, (String)"Number") + this.txtNumber.getText() + EASResource.getString((String)resClassName, (String)"Presence")));
                    SysUtil.abort();
                }
            } else {
                String sql = "select id where number = '" + this.txtNumber.getText() + "' and id = '" + this.editData.getId() + "'";
                MemActivityCollection memCollect = MemActivityFactory.getRemoteInstance().getMemActivityCollection(sql);
                if (memCollect.size() <= 0) {
                    sql = "select id where number = '" + this.txtNumber.getText() + "'";
                    memCollect = MemActivityFactory.getRemoteInstance().getMemActivityCollection(sql);
                    if (memCollect.size() > 0) {
                        MsgBox.showInfo((String)(EASResource.getString((String)resClassName, (String)"Number") + this.txtNumber.getText() + EASResource.getString((String)resClassName, (String)"Presence")));
                        SysUtil.abort();
                    }
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        HRPartyClientUtils.checkPersonDup((CoreUIObject)this, this.kdtEntrys, "person");
    }

    public void loadFields() {
        super.loadFields();
        this.setButton();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setButton();
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.setButton();
    }

    private void setButton() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.btAddLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btASC.setEnabled(true);
            this.btDESC.setEnabled(true);
        } else {
            this.btAddLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btASC.setEnabled(false);
            this.btDESC.setEnabled(false);
        }
    }

    protected void btnBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void MenuItemBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }
}

