/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemDevBillFilterUI;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;

public class MemDevBillFilterUI
extends AbstractMemDevBillFilterUI {
    private IMetaDataPK metaDataPKForPemmission;
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";

    public MemDevBillFilterUI() throws Exception {
        this.cbViewClosed.setVisible(false);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsSingleSelected(true);
        memOrgF7.setIsUsePermission(true);
        this.prmtMemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtMemOrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtMemOrg.setValue(null);
        this.cbViewClosed.setSelected(false);
        this.cbViewClosed.setEnabled(true);
    }

    public void setMetaDataPKForPemmissionByPath(String metaDataPath) {
        if (!StringUtils.isEmpty((String)metaDataPath)) {
            this.metaDataPKForPemmission = new MetaDataPK(metaDataPath);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.cbViewClosed.setEnabled(true);
        this.cbViewClosed.setSelected(false);
        this.prmtHROrg.setEditable(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.prmtMemOrg.getData() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtMemOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)memOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(memOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 and (#1 or #2)");
            if (!this.cbViewClosed.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                filterInfo.setMaskString("#0 and (#1 or #2) and #3");
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtHROrg.getValue() != null) {
            HROrgUnitInfo info = (HROrgUnitInfo)this.prmtHROrg.getValue();
            cp.addCustomerParam("HrId", info.getId().toString());
        }
        if (this.prmtMemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtMemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        cp.putBoolean("isSealed", this.cbViewClosed.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("HrId") != null) {
            String HrId = cp.getCustomerParam("HrId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)HrId));
            HROrgUnitInfo HROrg = null;
            try {
                HROrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtHROrg.setValue((Object)HROrg);
        }
        if (cp.getCustomerParam("memOrgId") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("memOrgId")));
            try {
                this.prmtMemOrg.setValue((Object)MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.cbViewClosed.setSelected(cp.getBoolean("isSealed"));
    }

    public boolean verify() {
        if (this.prmtMemOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"memOrgNotNull"));
            return false;
        }
        return true;
    }
}

