/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.party.MemOrgChartNodeInfo;
import com.kingdee.eas.hr.party.client.DrawMemOrg;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class MemOrgDrawingPanel
extends KDPanel {
    private static final Logger logger = CoreUIObject.getLogger(MemOrgDrawingPanel.class);
    private DefaultMutableTreeNode root = null;
    private DrawMemOrg drawMemOrg = null;
    public MemOrgChartNodeInfo selMemOrg = null;
    private MemOrgChartNodeInfo currMemOrg = null;
    private int translateX = 0;
    private int translateY = 0;
    public Color rectLineColor = new Color(0x9E9E9E);
    public Color currRectLineColor = new Color(14581776);
    public Color selRectLineColor = new Color(14588434);
    public Color orgRectColor = new Color(13296622);
    public Color currOrgRectColor = new Color(16247737);
    public Color selOrgRectColor = new Color(15653292);
    public Color otherRectColor = new Color(0xFFFFFF);
    public Color selOtherRectColor = new Color(16314050);
    public Color textColor = Color.BLACK;
    public Color separateLineColor = new Color(0xE6E6E6);
    public Color selSeparateLineColor = new Color(15653292);
    public Color lineColor = new Color(4145719);
    public Color currOtherRectColor = new Color(0xFFFFFF);
    public Color currSeparateLineColor = new Color(0xE6E6E6);
    public Color noPPBackgroudColor = new Color(0xD9D9D0);
    public Color bgColor = new Color(0xD9D9D0);
    private Point startPoint = null;
    private Point endPoint = null;
    private boolean finded = false;

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void clearSelectNode() {
        this.selMemOrg = null;
        this.currMemOrg = null;
    }

    public void setDrawingPaneSize(int maxX, int maxY) {
        this.setPreferredSize(new Dimension(maxX + 30, maxY + 30));
        this.translateX = 0;
        this.translateY = 0;
        if (maxX < this.drawMemOrg.getWidth()) {
            this.translateX = (this.drawMemOrg.getWidth() - maxX) / 2;
        }
    }

    public MemOrgDrawingPanel(DrawMemOrg drawMemOrg) {
        this.drawMemOrg = drawMemOrg;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.bgColor);
        g2.translate(this.translateX, this.translateY);
        if (this.root != null) {
            this.drawOrgNode(g2, this.root);
            g2.setColor(this.lineColor);
            this.drawOrgUnitLineH(g2, this.root);
        }
    }

    private void drawOrgUnit(Graphics2D g2, MemOrgChartNodeInfo memOrgChartNode) {
        Color tempRectLineColor = null;
        Color tempOrgRectColor = null;
        Color tempTextColor = this.textColor;
        if (memOrgChartNode.isMain || memOrgChartNode.isCurrent) {
            tempRectLineColor = this.currRectLineColor;
            tempOrgRectColor = this.currOrgRectColor;
        } else if (memOrgChartNode.isSelected) {
            tempRectLineColor = this.selRectLineColor;
            tempOrgRectColor = this.selOrgRectColor;
        } else {
            tempRectLineColor = this.rectLineColor;
            tempOrgRectColor = this.orgRectColor;
        }
        memOrgChartNode.rect = new Rectangle((int)memOrgChartNode.X, (int)memOrgChartNode.Y, (int)memOrgChartNode.width, (int)memOrgChartNode.height);
        g2.setColor(tempOrgRectColor);
        g2.fillRoundRect((int)memOrgChartNode.X, (int)memOrgChartNode.Y, (int)memOrgChartNode.width, (int)memOrgChartNode.height, 10, 10);
        g2.setColor(tempTextColor);
        int length = 0;
        if (StringUtils.isEmpty((String)memOrgChartNode.name)) {
            length = 0;
            g2.drawString("", (int)memOrgChartNode.X + ((int)memOrgChartNode.width - length) / 2, (int)memOrgChartNode.Y + 15);
        } else {
            length = g2.getFontMetrics().stringWidth(memOrgChartNode.name);
            g2.drawString(memOrgChartNode.name, (int)memOrgChartNode.X + ((int)memOrgChartNode.width - length) / 2, (int)memOrgChartNode.Y + 15);
        }
        if (this.drawMemOrg.showInsideJob) {
            g2.setColor(Color.WHITE);
            g2.fillRoundRect((int)memOrgChartNode.X, (int)memOrgChartNode.Y + 20, (int)memOrgChartNode.width, 20, 10, 10);
            g2.fillRect((int)memOrgChartNode.X, (int)memOrgChartNode.Y + 20, (int)memOrgChartNode.width, 20);
            g2.setColor(tempTextColor);
            if (memOrgChartNode.chiefPosition != null) {
                if (StringUtils.isEmpty((String)memOrgChartNode.chiefPosition.getJobName().getName())) {
                    length = 0;
                    g2.drawString("", (int)memOrgChartNode.X + ((int)memOrgChartNode.width - length) / 2, (int)memOrgChartNode.Y + 35);
                } else {
                    String displayTxt = null;
                    displayTxt = memOrgChartNode.chiefPosition.getEmpName() == null ? memOrgChartNode.chiefPosition.getJobName().getName() : memOrgChartNode.chiefPosition.getJobName().getName() + ":" + memOrgChartNode.chiefPosition.getEmpName().getName();
                    length = g2.getFontMetrics().stringWidth(displayTxt);
                    g2.drawString(displayTxt, (int)memOrgChartNode.X + ((int)memOrgChartNode.width - length) / 2, (int)memOrgChartNode.Y + 35);
                }
            }
        }
        g2.setColor(tempRectLineColor);
        g2.drawRoundRect((int)memOrgChartNode.X, (int)memOrgChartNode.Y, (int)memOrgChartNode.width, (int)memOrgChartNode.height, 10, 10);
    }

    private void drawOrgNode(Graphics2D g2, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawMemOrg.baseLevel + 1 > this.drawMemOrg.chooseLevel && this.drawMemOrg.chartType == 0) {
            return;
        }
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)node.getUserObject();
        this.drawOrgUnit(g2, memOrgChartNode);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawOrgNode(g2, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void drawOrgUnitLineH(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawMemOrg.baseLevel + 1 > this.drawMemOrg.chooseLevel && this.drawMemOrg.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawMemOrg.baseLevel + 1 < this.drawMemOrg.chooseLevel || this.drawMemOrg.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineH(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawMemOrg.baseLevel + 1 < this.drawMemOrg.chooseLevel || this.drawMemOrg.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            MemOrgChartNodeInfo startOrg = (MemOrgChartNodeInfo)firstChildNode.getUserObject();
            MemOrgChartNodeInfo endOrg = (MemOrgChartNodeInfo)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X + startOrg.width / 2.0f), (int)(startOrg.Y - 20.0f), (int)(endOrg.X + endOrg.width / 2.0f), (int)(endOrg.Y - 20.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointH(lastChildNode);
                this.startPoint.x = this.endPoint.x;
                this.startPoint.y = this.endPoint.y - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineH(g, lastChildNode);
            }
        }
    }

    private Point getStartPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)node.getUserObject();
        point.x = (int)(memOrgChartNode.X + memOrgChartNode.width / 2.0f);
        point.y = (int)(memOrgChartNode.Y + memOrgChartNode.height);
        return point;
    }

    private Point getEndPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        MemOrgChartNodeInfo memOrgChartNode = (MemOrgChartNodeInfo)node.getUserObject();
        point.x = (int)(memOrgChartNode.X + memOrgChartNode.width / 2.0f);
        point.y = (int)memOrgChartNode.Y;
        return point;
    }
}

