/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.MemberInforFactory;
import com.kingdee.eas.hr.party.client.AbstractMemberCollectListUI;
import com.kingdee.eas.hr.party.client.HRMemberGroupReportUtil;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.MemberCollectFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class MemberCollectListUI
extends AbstractMemberCollectListUI {
    private IRow row = null;
    private IColumn col = null;
    private static final String resClass = "com.kingdee.eas.hr.party.PartyResource";
    private final String adminOrgStr;
    private final String memOrgStr = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"MEMORG");
    private final String increase;
    private final String reduce;
    private final String devMember;
    private final String inAdminOrg;
    private final String outMember;
    private final String outAdminOrg;
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.MemberCollectFilterUI";
    private static final String COLUMN_NAME_TREECOLUMN = "memOrg";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.party.app";
    private static final String DATA_QUERY_CHECK_IN_OUT = "MemberCollectCheckInAndOutCountPersonsQuery";
    private static final String DATA_QUERY_SHIFT_IN_OUT = "MemberCollectShiftInAndOutCountPersonsQuery";

    public MemberCollectListUI() throws Exception {
        this.adminOrgStr = EASResource.getString((String)resClass, (String)"ADMIN_ORG");
        this.increase = EASResource.getString((String)resClass, (String)"increase");
        this.reduce = EASResource.getString((String)resClass, (String)"reduce");
        this.devMember = EASResource.getString((String)resClass, (String)"devMember");
        this.inAdminOrg = EASResource.getString((String)resClass, (String)"inAdminOrg");
        this.outMember = EASResource.getString((String)resClass, (String)"outMember");
        this.outAdminOrg = EASResource.getString((String)resClass, (String)"outAdminOrg");
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.tblMain.checkParsed();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.setEditable(false);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initTableHead() {
        this.tblMain.removeColumns();
        this.col = this.tblMain.addColumn();
        this.col.setKey(COLUMN_NAME_TREECOLUMN);
        this.col.setWidth(250);
        this.col = this.tblMain.addColumn();
        this.col.setKey("devMember");
        this.col = this.tblMain.addColumn();
        this.col.setKey("inAdminOrg");
        this.col = this.tblMain.addColumn();
        this.col.setKey("outMember");
        this.col = this.tblMain.addColumn();
        this.col.setKey("outAdminOrg");
        this.tblMain.removeRows();
        this.row = this.tblMain.addHeadRow();
        this.row.getCell(0).setValue((Object)this.memOrgStr);
        this.row.getCell(1).setValue((Object)this.increase);
        this.row.getCell(3).setValue((Object)this.reduce);
        this.row = this.tblMain.addHeadRow();
        this.row.getCell(1).setValue((Object)this.devMember);
        this.row.getCell(2).setValue((Object)this.inAdminOrg);
        this.row.getCell(3).setValue((Object)this.outMember);
        this.row.getCell(4).setValue((Object)this.outAdminOrg);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 0, 2);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 3, 0, 4);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((MemberCollectFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            MemberCollectFilterUI filterUI = new MemberCollectFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private void loadData() {
        this.resetTable();
        this.initTableHead();
        try {
            this.initLatitude();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClass, (String)"LatitudeInitError"));
            SysUtil.abort();
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        try {
            this.initData();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClass, (String)"DataInitError"));
            SysUtil.abort();
        }
        HRPartyGroupReportUtil.sumUpOnTree(this.tblMain, COLUMN_NAME_TREECOLUMN, null);
    }

    private void initLatitude() throws Exception {
        this.latitudeIDMap = new HashMap();
        Vector<MemOrgBillInfo> vec = new Vector<MemOrgBillInfo>();
        IRow row = null;
        MemOrgBillInfo info = null;
        DefaultKingdeeTreeNode rootNode = HRMemberGroupReportUtil.getMemOrgTreeNode((Boolean)this.statusMap.get("showCancel"), (String)this.statusMap.get("memOrgId"));
        if (rootNode == null) {
            return;
        }
        MemOrgBillInfo rootInfo = (MemOrgBillInfo)rootNode.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootInfo.put("isEnable", new Boolean(false));
        } else {
            rootInfo.put("isEnable", new Boolean(true));
        }
        rootInfo.setLevel(rootNode.getLevel());
        vec.add(rootInfo);
        HRMemberGroupReportUtil.getCellUserObjects(rootNode, vec);
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        int initLevel = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            info = (MemOrgBillInfo)vec.get(i);
            if (i == 0) {
                initLevel = info.getLevel();
            }
            row = this.tblMain.addRow(i);
            if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(info.getId().toString());
            orgCellObj.setName(info.getName());
            orgCellObj.setLongNumber(info.getLongNumber());
            orgCellObj.setIsLeaf(info.isIsLeaf());
            orgCellObj.setLevel(info.getLevel() - initLevel);
            orgCellObj.setExpanded(true);
            this.latitudeIDMap.put(info.getId().toString(), new Integer(row.getRowIndex()));
            row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
            row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
        }
    }

    private void initData() throws Exception {
        this.setDataOnTable(this.getDevMember(), "devMember");
        this.setDataOnTable(this.getLevMember(), "outMember");
        this.setDataOnTable(this.getShiftInData(), "inAdminOrg");
        this.setDataOnTable(this.getShiftOutData(), "outAdminOrg");
    }

    private IRowSet getPersonsData(EntityViewInfo view, String queryName) throws BOSException {
        IRowSet dataRows = null;
        String subSQL = HRPartyGroupReportUtil.metaQueryToSQL(view, QUERY_PATH, queryName);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll("MEMORG.ID", "MEMORGID");
        queryStr.append("SELECT MEMORGID,COUNT(MEMORGID) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n) AS T GROUP BY MEMORGID");
        dataRows = HRPartyGroupReportUtil.query(queryStr.toString());
        return dataRows;
    }

    private IRowSet getDevMember() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("joinDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("joinDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        dataRows = this.getPersonsData(view, DATA_QUERY_CHECK_IN_OUT);
        return dataRows;
    }

    private IRowSet getLevMember() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("outMemberDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("outMemberDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        dataRows = this.getPersonsData(view, DATA_QUERY_CHECK_IN_OUT);
        return dataRows;
    }

    private IRowSet getShiftInData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)((String)this.statusMap.get("number")), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)((String)this.statusMap.get("longNumber") + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("relaShiftDate", (Object)((Date)this.statusMap.get("beginDate")), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relaShiftDate", (Object)((Date)this.statusMap.get("endDate")), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shiftType", (Object)"1", CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4");
        view.setFilter(filter);
        dataRows = this.getPersonsData(view, DATA_QUERY_SHIFT_IN_OUT);
        return dataRows;
    }

    private IRowSet getShiftOutData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)((String)this.statusMap.get("number")), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)((String)this.statusMap.get("longNumber") + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("relaShiftDate", (Object)((Date)this.statusMap.get("beginDate")), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relaShiftDate", (Object)((Date)this.statusMap.get("endDate")), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shiftType", (Object)"2", CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4");
        view.setFilter(filter);
        dataRows = this.getPersonsData(view, DATA_QUERY_SHIFT_IN_OUT);
        return dataRows;
    }

    private void setDataOnTable(IRowSet dataRows, String colName) throws SQLException {
        if (dataRows != null) {
            while (dataRows.next()) {
                if (dataRows.getString("MEMORGID") == null || this.latitudeIDMap.get(dataRows.getString("MEMORGID")) == null) continue;
                this.tblMain.getRow(((Integer)this.latitudeIDMap.get(dataRows.getString("MEMORGID"))).intValue()).getCell(colName).setValue((Object)new Integer(dataRows.getInt("COUNTPERSONS")));
            }
        }
    }

    private void refreshData() {
        this.loadData();
    }

    private void resetTable() {
        this.tblMain.removeRows();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MemberInforFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new MemberCollectFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_TREECOLUMN;
    }
}

