/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.party.ActivityTypeCollection;
import com.kingdee.eas.hr.party.ActivityTypeFactory;
import com.kingdee.eas.hr.party.ActivityTypeInfo;
import com.kingdee.eas.hr.party.IActivityType;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberFeeStatListUI;
import com.kingdee.eas.hr.party.client.HRMemberGroupReportUtil;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.MemberFeeStatFilterUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MemberFeeStatListUI
extends AbstractMemberFeeStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(MemberFeeStatListUI.class);
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.MemberFeeStatFilterUI";
    private static final String COLUMN_NAME_TREECOLUMN = "latitude";
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.party.app";
    private static final String QUERY_NAME1 = "MemberFeeSumPayQuery";
    private static final String QUERY_NAME2 = "MemberFeeActivitySumCostQuery";
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private HashMap headIDMap;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    private void refreshData() {
        this.loadData();
    }

    private void resetTable() {
        this.tblMain.removeRows();
        int index = this.tblMain.getColumnCount();
        for (int i = index - 1; i > 0; --i) {
            if (this.tblMain.getColumn(i).getKey() != null) continue;
            this.tblMain.removeColumn(i);
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN).setWidth(200);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((MemberFeeStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            MemberFeeStatFilterUI filterUI = new MemberFeeStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    private void loadData() {
        this.resetTable();
        try {
            this.initTableHead();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            this.initLatitude();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        try {
            this.initData();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        HRPartyGroupReportUtil.sumUpOnTree(this.tblMain, COLUMN_NAME_TREECOLUMN, null);
    }

    private void initData() throws BOSException, SQLException {
        this.setMemberCountPayDataOnTable(this.getMemberCountPayData());
        this.setActivityCountCostDataOnTable(this.getActivityCountCostData());
    }

    private IRowSet getMemberCountPayData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = null;
        FilterInfo addFilter = new FilterInfo();
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        addFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(addFilter, "and");
        dataRows = HRStateTWOClientUtils.query((EntityViewInfo)view, (String)QUERY_PATH, (String)QUERY_NAME1);
        return dataRows;
    }

    private IRowSet getActivityCountCostData() throws BOSException {
        IRowSet dataRows = null;
        EntityViewInfo view = null;
        FilterInfo addFilter = new FilterInfo();
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)((String)this.statusMap.get("number")), CompareType.EQUALS));
        addFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("beginDate"))), CompareType.GREATER_EQUALS));
        addFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.statusMap.get("endDate"))), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(addFilter, "and");
        dataRows = HRStateTWOClientUtils.query((EntityViewInfo)view, (String)QUERY_PATH, (String)QUERY_NAME2);
        return dataRows;
    }

    private void setMemberCountPayDataOnTable(IRowSet dataRows) throws SQLException {
        if (dataRows != null) {
            while (dataRows.next()) {
                if (dataRows.getString("MEMORG.ID") == null || this.latitudeIDMap.get(dataRows.getString("MEMORG.ID")) == null) continue;
                if (dataRows.getString("SUMACTUALPAY") == null) {
                    this.tblMain.getRow(((Integer)this.latitudeIDMap.get(dataRows.getString("MEMORG.ID"))).intValue()).getCell("memberFee").setValue((Object)new BigDecimal(0));
                    continue;
                }
                this.tblMain.getRow(((Integer)this.latitudeIDMap.get(dataRows.getString("MEMORG.ID"))).intValue()).getCell("memberFee").setValue((Object)new BigDecimal(dataRows.getString("SUMACTUALPAY")));
            }
        }
    }

    private void setActivityCountCostDataOnTable(IRowSet dataRows) throws SQLException {
        if (dataRows != null) {
            while (dataRows.next()) {
                if (dataRows.getString("MEMORG.ID") == null || dataRows.getString("ACTIVITYTYPE.ID") == null || this.latitudeIDMap.get(dataRows.getString("MEMORG.ID")) == null || this.headIDMap.get(dataRows.getString("ACTIVITYTYPE.ID")) == null) continue;
                if (dataRows.getString("SUMCOST") == null) {
                    this.tblMain.getCell(((Integer)this.latitudeIDMap.get(dataRows.getString("MEMORG.ID"))).intValue(), ((Integer)this.headIDMap.get(dataRows.getString("ACTIVITYTYPE.ID"))).intValue()).setValue((Object)new BigDecimal(0));
                    continue;
                }
                this.tblMain.getCell(((Integer)this.latitudeIDMap.get(dataRows.getString("MEMORG.ID"))).intValue(), ((Integer)this.headIDMap.get(dataRows.getString("ACTIVITYTYPE.ID"))).intValue()).setValue((Object)new BigDecimal(dataRows.getString("SUMCOST")));
            }
        }
    }

    private void initLatitude() throws Exception {
        this.latitudeIDMap = new HashMap();
        Vector<MemOrgBillInfo> vec = new Vector<MemOrgBillInfo>();
        IRow row = null;
        MemOrgBillInfo info = null;
        DefaultKingdeeTreeNode rootNode = HRMemberGroupReportUtil.getMemOrgTreeNode((Boolean)this.statusMap.get("showCancel"), (String)this.statusMap.get("memOrgId"));
        if (rootNode == null) {
            return;
        }
        MemOrgBillInfo rootInfo = (MemOrgBillInfo)rootNode.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootInfo.put("isEnable", new Boolean(false));
        } else {
            rootInfo.put("isEnable", new Boolean(true));
        }
        rootInfo.setLevel(rootNode.getLevel());
        vec.add(rootInfo);
        HRMemberGroupReportUtil.getCellUserObjects(rootNode, vec);
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        int initLevel = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            info = (MemOrgBillInfo)vec.get(i);
            if (i == 0) {
                initLevel = info.getLevel();
            }
            row = this.tblMain.addRow(i);
            if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(info.getId().toString());
            orgCellObj.setName(info.getName());
            orgCellObj.setLongNumber(info.getLongNumber());
            orgCellObj.setIsLeaf(info.isIsLeaf());
            orgCellObj.setLevel(info.getLevel() - initLevel);
            orgCellObj.setExpanded(true);
            this.latitudeIDMap.put(info.getId().toString(), new Integer(row.getRowIndex()));
            row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
            row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
        }
    }

    private void initTableHead() throws BOSException {
        this.headIDMap = new HashMap();
        KDTMergeManager manager = this.tblMain.getHeadMergeManager();
        manager.mergeBlock(0, 0, 1, 0);
        manager.mergeBlock(0, 1, 1, 1);
        IActivityType iActivityType = ActivityTypeFactory.getRemoteInstance();
        ActivityTypeCollection coll = iActivityType.getActivityTypeCollection();
        if (coll != null && coll.size() > 0) {
            IColumn col = null;
            ActivityTypeInfo atInfo = null;
            int baseColIndex = this.tblMain.getColumnCount();
            for (int i = 0; i < coll.size(); ++i) {
                col = this.tblMain.addColumn();
                atInfo = coll.get(i);
                this.headIDMap.put(atInfo.getId().toString(), new Integer(col.getColumnIndex()));
                manager.mergeBlock(0, baseColIndex, 0, baseColIndex + i);
                manager.mergeBlock(1, baseColIndex + i, 1, baseColIndex + i);
                this.tblMain.getHead().getRow(1).getCell(baseColIndex + i).setValue((Object)atInfo.getName());
            }
            this.tblMain.getHead().getRow(0).getCell(baseColIndex).setValue((Object)EASResource.getString((String)RES, (String)"activityCost"));
            this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"MEMORG"));
        }
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new MemberFeeStatFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_TREECOLUMN;
    }
}

