/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberInfoActivityStatFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MemberInfoActivityStatFilterUI
extends AbstractMemberInfoActivityStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MemberInfoActivityStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        this.prmtAdminOrg.setEditable(false);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsSingleSelected(true);
        memOrgF7.setIsUsePermission(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setValue(null);
        this.prmtmemOrg.setValue(null);
        this.cbxShowCancel.setSelected(false);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkStartDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public boolean verify() {
        Date startDate = null;
        Date endDate = null;
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtmemOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkStartDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkStartDate.getValue() != null && this.dpkEndDate.getValue() != null && (startDate = (Date)this.dpkStartDate.getValue()).after(endDate = (Date)this.dpkEndDate.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
            this.dpkStartDate.requestFocus();
            SysUtil.abort();
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtmemOrg.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)((MemOrgBillInfo)this.prmtmemOrg.getValue()).getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(((MemOrgBillInfo)this.prmtmemOrg.getValue()).getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkStartDate.getValue())), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue())), CompareType.LESS_EQUALS));
            filter.setMaskString("(#0 or #1) and #2 and #3");
            try {
                this.filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
                this.filterInfo.setMaskString("(#0 or #1) and #2 and #3 and #4");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (!this.cbxShowCancel.isSelected()) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                this.filterInfo.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5");
            }
        }
        return filter;
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.prmtmemOrg.getValue() != null) {
            map.put("memOrgId", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getId().toString());
            map.put("longNumber", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getLongNumber());
            map.put("number", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getNumber());
        }
        map.put("showCancel", new Boolean(this.cbxShowCancel.isSelected()));
        if (this.dpkStartDate.getValue() != null) {
            map.put("startDate", (Date)this.dpkStartDate.getValue());
        }
        if (this.dpkEndDate.getValue() != null) {
            map.put("endDate", (Date)this.dpkEndDate.getValue());
        }
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtmemOrg.getValue() != null) {
            cp.addCustomerParam("memOrgId", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getId().toString());
        }
        if (this.dpkStartDate.getValue() != null) {
            cp.putDate("startDate", (Date)this.dpkStartDate.getValue());
        }
        if (this.dpkEndDate.getValue() != null) {
            cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        }
        cp.putBoolean("showCancel", this.cbxShowCancel.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            this._setCustomerParams(cp);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
        }
    }

    private void _setCustomerParams(CustomerParams cp) throws EASBizException, BOSException {
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("memOrgId") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("memOrgId")));
            this.prmtmemOrg.setValue((Object)MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk));
        }
        this.dpkStartDate.setValue((Object)cp.getDate("startDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }
}

