/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.IMemberInfor;
import com.kingdee.eas.hr.party.MemberInforCollection;
import com.kingdee.eas.hr.party.MemberInforFactory;
import com.kingdee.eas.hr.party.MemberInforInfo;
import com.kingdee.eas.hr.party.MemberPayFactory;
import com.kingdee.eas.hr.party.MemberPayInfo;
import com.kingdee.eas.hr.party.MemberPaymentBaseCollection;
import com.kingdee.eas.hr.party.MemberPaymentBaseFactory;
import com.kingdee.eas.hr.party.PartyFeeModeEnum;
import com.kingdee.eas.hr.party.PartyPayPerFactory;
import com.kingdee.eas.hr.party.PartyPayPerInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberPayEditUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.party.client.PartyPrint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;

public class MemberPayEditUI
extends AbstractMemberPayEditUI {
    public static final String pubResource = "com.kingdee.eas.hr.party.PartyResource";
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected AdminByOrgRangePromptBox adminF7 = new AdminByOrgRangePromptBox();
    protected MemOrgPromptBox memOrgF7 = null;
    private static String partyPrintID = null;
    private static String printParth = "/HR/state/party/MemPaymenBill";
    private static String queryName = "MemberPayPrintQuery";
    private static String entryQueryName = "MemberPayEntryPrintQuery";
    private static String queryParth = "com.kingdee.eas.hr.party.app";
    private static String entryID = "bill.id";
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);

    public MemberPayEditUI() throws Exception {
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
        this.initMemOrgF7();
    }

    protected void initMemOrgF7() {
        if (this.memOrgF7 == null) {
            this.memOrgF7 = new MemOrgPromptBox();
            this.memOrgF7.setIsSingleSelected(true);
            this.memOrgF7.setIsUsePermission(true);
        }
    }

    protected IObjectValue createNewData() {
        MemberPayInfo info = new MemberPayInfo();
        info.setPayDate(new Date());
        info.setAdminOrg(SysContext.getSysContext().getCurrentAdminUnit());
        return info;
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initEmpF7();
        this.prmtmemOrg.setSelector((KDPromptSelector)this.memOrgF7);
        this.prmtmemOrg.setEditable(false);
        this.prmtAdminOrg.setSelector((KDPromptSelector)this.adminF7);
        this.prmtAdminOrg.setEditable(false);
        this.menuItemCopy.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnAttachment.setVisible(true);
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    MemberPayEditUI.this.kdtEntrys_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    MemberPayEditUI.this.handUIException(exc);
                }
            }
        });
        KDTextField kdtEntrys_payPeriod_TextField = new KDTextField();
        kdtEntrys_payPeriod_TextField.setName("kdtEntrys_payPeriod_TextField");
        kdtEntrys_payPeriod_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_payPeriod_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_payPeriod_TextField);
        this.kdtEntrys.getColumn("payPeriod").setEditor((ICellEditor)kdtEntrys_payPeriod_CellEditor);
        KDFormattedTextField kdtEntrys_formatted_TextField = new KDFormattedTextField();
        kdtEntrys_formatted_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_formatted_TextField.setVisible(true);
        kdtEntrys_formatted_TextField.setEditable(true);
        kdtEntrys_formatted_TextField.setDataType(1);
        kdtEntrys_formatted_TextField.setPrecision(2);
        kdtEntrys_formatted_TextField.setDataVerifierType(12);
        kdtEntrys_formatted_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_formatted_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_formatted_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_formatted_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_formatted_TextField);
        this.kdtEntrys.getColumn("payBase").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payBase").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("payBase").getStyleAttributes().setBackground(Color.WHITE);
        this.kdtEntrys.getColumn("suggestPay").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("suggestPay").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("actualPay").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("actualPay").getStyleAttributes().setNumberFormat("0.00");
        KDFormattedTextField kdtEntrys_payedMonths_TextField = new KDFormattedTextField();
        kdtEntrys_payedMonths_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_payedMonths_TextField.setVisible(true);
        kdtEntrys_payedMonths_TextField.setEditable(true);
        kdtEntrys_payedMonths_TextField.setDataType(0);
        kdtEntrys_payedMonths_TextField.setPrecision(1);
        kdtEntrys_payedMonths_TextField.setDataVerifierType(12);
        kdtEntrys_payedMonths_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_payedMonths_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_payedMonths_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_payedMonths_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_payedMonths_TextField);
        this.kdtEntrys.getColumn("payedMonths").setEditor((ICellEditor)kdtEntrys_payedMonths_CellEditor);
        this.kdtEntrys.getColumn("payedMonths").getStyleAttributes().setNumberFormat("0.0");
        KDTextField kdtEntrys_description_TextField = new KDTextField();
        kdtEntrys_description_TextField.setName("kdtEntrys_description_TextField");
        kdtEntrys_description_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_description_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_description_TextField);
        this.kdtEntrys.getColumn("description").setEditor((ICellEditor)kdtEntrys_description_CellEditor);
        if (this.prmtHROrg.getValue() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
            this.prmtHROrg.setValue((Object)hrOrgUnitInfo);
        }
        if (this.prmtAdminOrg.getValue() == null) {
            AdminOrgUnitInfo adminOrgUnitInfo = SysContext.getSysContext().getCurrentAdminUnit();
            this.prmtAdminOrg.setValue((Object)adminOrgUnitInfo);
        }
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.kdtEntrys.getCell(i, "feeMode").getValue() == null) continue;
            if (this.kdtEntrys.getCell(i, "feeMode").getValue().equals((Object)PartyFeeModeEnum.RATE)) {
                this.kdtEntrys.getCell(i, "payPer").getStyleAttributes().setNumberFormat("0.00%");
                continue;
            }
            this.kdtEntrys.getCell(i, "payPer").getStyleAttributes().setNumberFormat("0.00");
        }
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        if ("payedMonths".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            Object feeMode = this.kdtEntrys.getCell(rowIndex, "feeMode").getValue();
            if (feeMode == null) {
                return;
            }
            BigDecimal payPer = ZERO;
            BigDecimal payBase = ZERO;
            BigDecimal payedMonths = ZERO;
            BigDecimal suggestPay = ZERO;
            if (this.kdtEntrys.getCell(rowIndex, "payPer").getValue() != null) {
                payPer = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "payPer").getValue());
            }
            if (this.kdtEntrys.getCell(rowIndex, "payBase").getValue() != null) {
                payBase = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "payBase").getValue());
            }
            if (this.kdtEntrys.getCell(rowIndex, "payedMonths").getValue() != null) {
                payedMonths = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "payedMonths").getValue());
            }
            suggestPay = feeMode.equals((Object)PartyFeeModeEnum.RATE) ? payPer.multiply(payBase).multiply(payedMonths) : payPer.multiply(payedMonths);
            this.kdtEntrys.getCell(rowIndex, "suggestPay").setValue((Object)suggestPay);
            this.kdtEntrys.getCell(rowIndex, "actualPay").setValue((Object)suggestPay);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("VIEW".equals(this.getOprtState())) {
            this.btAddLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.btAddLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
        }
    }

    public void loadFields() {
        this.kdtEntrys.checkParsed();
        if (this.prmtAdminOrg.getValue() == null) {
            this.prmtAdminOrg.setValue(null);
        }
        super.loadFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MemberPayFactory.getRemoteInstance();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.kDContainer1.addButton((JButton)this.btAddLine);
        this.kDContainer1.addButton((JButton)this.btInsertLine);
        this.kDContainer1.addButton((JButton)this.btRemoveLine);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        HRPartyClientUtils.removeLine(this.kdtEntrys);
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("memberInfor.joinDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        String activeID = null;
        if (this.editData.getId() != null) {
            activeID = this.editData.getId().toString();
        }
        if ((persons = this.getProcessedPersons(persons, activeID)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected List getProcessedPersons(List persons, String billID) throws Exception {
        return persons;
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        EntityViewInfo MemberInforViewInfo = new EntityViewInfo();
        FilterInfo personCommunistFilter = new FilterInfo();
        personCommunistFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId(), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.*"));
        sic.add(new SelectorItemInfo("payPer.*"));
        MemberInforViewInfo.setFilter(personCommunistFilter);
        IMemberInfor iMemberInfor = MemberInforFactory.getRemoteInstance();
        MemberInforCollection collection = iMemberInfor.getMemberInforCollection(MemberInforViewInfo);
        table.getRow(row.getRowIndex()).getCell("person").setValue((Object)pInfo);
        table.getRow(row.getRowIndex()).getCell("personNumber").setValue((Object)pInfo.getNumber());
        if (pInfo.get("primaryAdminOrg") != null) {
            table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg")));
        } else {
            try {
                table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        if (collection.size() > 0) {
            MemberInforInfo memberInfo = collection.get(0);
            PartyPayPerInfo payPer = null;
            try {
                if (memberInfo.getPayPer() != null) {
                    payPer = PartyPayPerFactory.getRemoteInstance().getPartyPayPerInfo((IObjectPK)new ObjectUuidPK(memberInfo.getPayPer().getId()));
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (payPer != null) {
                table.getRow(row.getRowIndex()).getCell("feeMode").setValue((Object)payPer.getPartyfeemode());
                if (payPer.getPartyfeemode().equals((Object)PartyFeeModeEnum.RATION)) {
                    table.getRow(row.getRowIndex()).getCell("payPer").getStyleAttributes().setNumberFormat("0.00");
                } else {
                    table.getRow(row.getRowIndex()).getCell("payPer").getStyleAttributes().setNumberFormat("0.00%");
                }
                table.getRow(row.getRowIndex()).getCell("payPer").setValue((Object)payPer.getPayper());
                table.getRow(row.getRowIndex()).getCell("payPerType").setValue((Object)payPer.getName());
            }
        }
        EntityViewInfo payBaseView = new EntityViewInfo();
        FilterInfo payBaseFilter = new FilterInfo();
        payBaseFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        payBaseView.setFilter(payBaseFilter);
        MemberPaymentBaseCollection memberPaymentBaseColl = MemberPaymentBaseFactory.getRemoteInstance().getMemberPaymentBaseCollection(payBaseView);
        if (memberPaymentBaseColl != null && memberPaymentBaseColl.size() > 0) {
            table.getRow(row.getRowIndex()).getCell("payBase").setValue((Object)memberPaymentBaseColl.get(0).getPayBase());
        } else {
            table.getRow(row.getRowIndex()).getCell("payBase").setValue((Object)ZERO);
        }
        table.getRow(row.getRowIndex()).getCell("payedMonths").setValue((Object)ZERO);
        table.getRow(row.getRowIndex()).getCell("suggestPay").setValue((Object)ZERO);
        table.getRow(row.getRowIndex()).getCell("actualPay").setValue((Object)ZERO);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.verifyInput();
        MemberPayEditUI.checkHasInputRows(this.kdtEntrys, this.getNoNullColumns());
        super.beforeStoreFields(e);
    }

    private void verifyInput() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtmemOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkPayDate);
        HRPartyClientUtils.checkPersonDup((CoreUIObject)this, this.kdtEntrys, "person");
    }

    protected ArrayList getNoNullColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("payedMonths");
        cols.add("suggestPay");
        cols.add("actualPay");
        return cols;
    }

    public static void checkHasInputRows(KDTable kdt) throws Exception {
        if (kdt.getRowCount() != 0) {
            return;
        }
        MsgBox.showInfo((String)(EASResource.getString((String)pubResource, (String)"entrys") + EASResource.getString((String)pubResource, (String)"CanNotBeNull")));
        SysUtil.abort();
    }

    public static void checkHasInputRows(KDTable kdt, ArrayList columns) throws Exception {
        MemberPayEditUI.checkHasInputRows(kdt);
        int colCount = columns.size();
        int rowCount = kdt.getRowCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            row = kdt.getRow(i);
            for (int j = 0; j < colCount; ++j) {
                if (columns.get(j) == null || row.getCell(columns.get(j).toString()) == null) continue;
                value = row.getCell(columns.get(j).toString()).getValue();
                if (value == null || value instanceof String && value.toString().trim().equals("")) {
                    kdt.getSelectManager().select(i, j);
                    MsgBox.showInfo((String)(EASResource.getString((String)pubResource, (String)"several") + ++i + EASResource.getString((String)pubResource, (String)"row") + MemberPayEditUI.getColumnStrs(kdt, columns, j) + EASResource.getString((String)pubResource, (String)"CanNotBeNull")));
                    --i;
                    SysUtil.abort();
                }
                if (row.getCell("payPeriod").getValue() != null && row.getCell("payPeriod").getValue().toString().length() > 80) {
                    MsgBox.showInfo((String)(EASResource.getString((String)pubResource, (String)"several") + ++i + EASResource.getString((String)pubResource, (String)"row") + kdt.getHeadRow(0).getCell("payPeriod").getValue().toString() + EASResource.getString((String)pubResource, (String)"characterLength")));
                    --i;
                    SysUtil.abort();
                }
                if (row.getCell("description").getValue() == null || row.getCell("description").getValue().toString().length() <= 80) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)pubResource, (String)"several") + ++i + EASResource.getString((String)pubResource, (String)"row") + kdt.getHeadRow(0).getCell("description").getValue().toString() + EASResource.getString((String)pubResource, (String)"characterLength")));
                --i;
                SysUtil.abort();
            }
        }
    }

    public static String getColumnStrs(KDTable kdt, ArrayList columns, int j) {
        String colStr = "";
        colStr = MemberPayEditUI.getColumnAlias(kdt, columns.get(j).toString());
        return colStr;
    }

    public static String getColumnAlias(KDTable kdt, String colName) {
        Object value = kdt.getHeadRow(0).getCell(colName).getValue();
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void btnBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void MenuItemBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btAddLine.setEnabled(true);
        this.btInsertLine.setEnabled(true);
        this.btRemoveLine.setEnabled(true);
    }
}

