/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.emp.IPersonCommunist;
import com.kingdee.eas.hr.emp.PersonCommunistCollection;
import com.kingdee.eas.hr.emp.PersonCommunistFactory;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.PartyActivityEntryInfo;
import com.kingdee.eas.hr.party.PartyActivityFactory;
import com.kingdee.eas.hr.party.PartyActivityInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyActivityEditUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.PartyPrint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class PartyActivityEditUI
extends AbstractPartyActivityEditUI {
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    private static final Logger logger = CoreUIObject.getLogger(PartyActivityEditUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected PlugInUIParam ctx = null;
    protected IUIWindow currOrgTreeDialog;
    protected AdminByOrgRangePromptBox adminF7 = null;
    private static String partyPrintID = null;
    private static String printParth = "/HR/state/party/PartyActivityBill";
    private static String queryName = "PartyActivityPrintQuery";
    private static String entryQueryName = "PartyActivityEntryPrintQuery";
    private static String queryParth = "com.kingdee.eas.hr.party.app";
    private static String entryID = "activity.id";

    public PartyActivityEditUI() throws Exception {
        this.initEmpF7();
        this.adminF7 = new AdminByOrgRangePromptBox();
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.btnAttachment.setVisible(true);
        this.kdtEntrys.getSelectManager().setSelectMode(10);
        this.prmtHROrg.setEditable(false);
        if (this.prmtHROrg.getValue() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
            this.prmtHROrg.setValue((Object)hrOrgUnitInfo);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.contEntrys.setTitle(EASResource.getString((String)resClassName, (String)"activityMember"));
        this.contEntrys.addButton((JButton)this.btAddLine);
        this.contEntrys.addButton((JButton)this.btInsertLine);
        this.contEntrys.addButton((JButton)this.btRemoveLine);
        this.contEntrys.addButton((JButton)this.btASC);
        this.contEntrys.addButton((JButton)this.btDESC);
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btASC.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btDESC.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btASC.setSize(22, 19);
        this.btDESC.setSize(22, 19);
        this.setButton();
        this.txtActivityCost.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.txtActivityCost.setMinimumValue((Comparable)new BigDecimal(0));
    }

    protected IObjectValue createNewData() {
        PartyActivityInfo info = new PartyActivityInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PartyActivityFactory.getRemoteInstance();
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
        this.refreshSeq();
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
        this.refreshSeq();
    }

    protected void btRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        HRPartyClientUtils.removeLine(this.kdtEntrys);
        this.refreshSeq();
    }

    protected void btASC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntrys, true);
        }
        this.refreshSeq();
    }

    protected void btDESC_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            HRPartyClientUtils.moveRows((CoreUIObject)this, this.kdtEntrys, false);
        }
        this.refreshSeq();
    }

    protected IObjectValue createNewDetailData(PersonInfo personInfo) {
        PartyActivityEntryInfo info = new PartyActivityEntryInfo();
        info.setPerson(personInfo);
        if (personInfo.get("primaryAdminOrg") != null) {
            info.setAdminOrg((AdminOrgUnitInfo)personInfo.get("primaryAdminOrg"));
        } else {
            try {
                info.setAdminOrg(HRPartyClientUtils.getNoPositionAdmin(personInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        return info;
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("personCommunist.applyDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
        this.refreshSeq();
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        String activeID = null;
        if (this.editData.getId() != null) {
            activeID = this.editData.getId().toString();
        }
        if ((persons = this.getProcessedPersons(persons, activeID)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
        this.refreshSeq();
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        EntityViewInfo personCommunistViewInfo = new EntityViewInfo();
        FilterInfo personCommunistFilter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        personCommunistFilter.getFilterItems().add(new FilterItemInfo("person", (Object)pInfo.getId(), CompareType.EQUALS));
        sic.add(new SelectorItemInfo("id"));
        personCommunistViewInfo.setSelector(sic);
        personCommunistViewInfo.setFilter(personCommunistFilter);
        IPersonCommunist ipersonCommunist = PersonCommunistFactory.getRemoteInstance();
        PersonCommunistCollection collection = ipersonCommunist.getPersonCommunistCollection(personCommunistViewInfo);
        IObjectValue detailData = this.createNewDetailData(pInfo);
        table.getRow(row.getRowIndex()).getCell("person").setValue((Object)pInfo);
        if (pInfo.get("primaryAdminOrg") != null) {
            table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg")));
        } else {
            try {
                table.getRow(row.getRowIndex()).getCell("adminOrg").setValue((Object)HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        if (pInfo.get("number") != null) {
            table.getRow(row.getRowIndex()).getCell("person.number").setValue(pInfo.get("number"));
        }
        this.refreshSeq();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected List getProcessedPersons(List persons, String billID) throws Exception {
        return persons;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtHROrg.getValue() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
            this.prmtHROrg.setValue((Object)hrOrgUnitInfo);
        }
        this.verifyInput();
        super.beforeStoreFields(e);
    }

    private void verifyInput() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.txtActivityTheme);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtActivityType);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkStartDate);
        if (this.txtActivityCost.getText() == null || this.txtActivityCost.getText().trim().equals("")) {
            this.txtActivityCost.requestFocus(true);
            MsgBox.showInfo((Component)((Object)this), (String)(((KDLabelContainer)this.txtActivityCost.getParent()).getBoundLabelText() + EASResource.getString((String)resClassName, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtPartyOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.kdtEntrys);
        HRPartyClientUtils.checkPersonDup((CoreUIObject)this, this.kdtEntrys, "person");
    }

    public void loadFields() {
        if (this.editData.getEntrys() != null) {
            block0: for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
                for (int j = i; j < this.editData.getEntrys().size(); ++j) {
                    if (this.editData.getEntrys().get(j).getSeq() - 1 != i) continue;
                    this.editData.getEntrys().move(j, i - 1);
                    continue block0;
                }
            }
        }
        this.setButton();
        super.loadFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setButton();
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.setButton();
    }

    private void setButton() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.btAddLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btASC.setEnabled(true);
            this.btDESC.setEnabled(true);
        } else {
            this.btAddLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btASC.setEnabled(false);
            this.btDESC.setEnabled(false);
        }
    }

    public void actionBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void MenuItemBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void refreshSeq() {
        if (this.kdtEntrys != null) {
            int row = this.kdtEntrys.getRowCount();
            for (int i = 0; i < row; ++i) {
                this.kdtEntrys.getCell(i, 0).setValue((Object)String.valueOf(i + 1));
            }
        }
    }
}

