/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyActivityFilterUI;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class PartyActivityFilterUI
extends AbstractPartyActivityFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyActivityFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
        this.pkDateEnd.setValue(null);
        this.pkDateStart.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtPartyOrg.getData() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)partyOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(partyOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            filterInfo.setMaskString("#0 or (#1 and #2)");
            try {
                filterInfo.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                filterInfo.setMaskString("(#0 or (#1 and #2)) and #3");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.setDateFilter(filterInfo);
        return filterInfo;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.pkDateStart.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.pkDateStart.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.pkDateEnd.getValue()), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            PartyOrgInfo info = (PartyOrgInfo)this.prmtPartyOrg.getValue();
            cp.addCustomerParam("partyOrgID", info.getId().toString());
        }
        cp.putBoolean("isIncludeChild", true);
        if (this.pkDateStart.getValue() != null) {
            cp.putDate("beginDate", (Date)this.pkDateStart.getValue());
        }
        if (this.pkDateEnd.getValue() != null) {
            cp.putDate("endDate", (Date)this.pkDateEnd.getValue());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("partyOrgId") != null) {
            String adminId = cp.getCustomerParam("partyOrgId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            PartyOrgInfo partyOrg = null;
            try {
                partyOrg = PartyOrgFactory.getRemoteInstance().getPartyOrgInfo("select id, name where id ='" + pk + "'");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPartyOrg.setValue(partyOrg);
        }
        this.cbInclude.setSelected(cp.getBoolean("isIncludeChild"));
        this.pkDateStart.setValue((Object)cp.getDate("beginDate"));
        this.pkDateEnd.setValue((Object)cp.getDate("endDate"));
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public boolean verify() {
        Date endDate;
        Date startDate;
        if (this.prmtPartyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.partyOrgNotNull"));
            return false;
        }
        if (this.pkDateStart.getValue() != null && this.pkDateEnd.getValue() != null && (startDate = (Date)this.pkDateStart.getValue()).after(endDate = (Date)this.pkDateEnd.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"StartDateBeforeEndDate"));
            return false;
        }
        return true;
    }
}

