/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.HROrgContextClientCache;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyChangeBillFilterUI;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class PartyChangeBillFilterUI
extends AbstractPartyChangeBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyChangeBillFilterUI.class);
    private IMetaDataPK metaDataPKForPemmission;
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";

    public void storeFields() {
        super.storeFields();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.prmtHROrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.cbInclude.setSelected(false);
        HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrgUnitInfo != null) {
            try {
                hrOrgUnitInfo.put("name", (Object)hrOrgUnitInfo.getName());
                this.prmtHROrg.setData((Object)HROrgContextClientCache.getLegalityHROrg((HROrgUnitInfo)hrOrgUnitInfo, (BOSObjectType)MetaDataTypeList.BASEQUERY, (IMetaDataPK)this.metaDataPKForPemmission));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.prmtHROrg.setData(null);
        }
    }

    public void setMetaDataPKForPemmissionByPath(String metaDataPath) {
        if (!StringUtils.isEmpty((String)metaDataPath)) {
            this.metaDataPKForPemmission = new MetaDataPK(metaDataPath);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtPartyOrg.getData() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)partyOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(partyOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            filterInfo.setMaskString("#0 or (#1 and #2)");
            try {
                filterInfo.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                filterInfo.setMaskString("(#0 or (#1 and #2)) and #3");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        Object info;
        CustomerParams cp = new CustomerParams();
        if (this.prmtHROrg.getValue() != null) {
            info = (HROrgUnitInfo)this.prmtHROrg.getValue();
            cp.addCustomerParam("HrId", info.getId().toString());
        }
        if (this.prmtPartyOrg.getValue() != null) {
            info = (PartyOrgInfo)this.prmtPartyOrg.getValue();
            cp.addCustomerParam("partyOrgID", info.getId().toString());
        }
        cp.putBoolean("isIncludeChild", this.cbInclude.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        ObjectUuidPK pk;
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("HrId") != null) {
            String HrId = cp.getCustomerParam("HrId");
            pk = new ObjectUuidPK(BOSUuid.read((String)HrId));
            HROrgUnitInfo HROrg = null;
            try {
                HROrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtHROrg.setValue((Object)HROrg);
        }
        if (cp.getCustomerParam("partyOrgID") != null) {
            String adminId = cp.getCustomerParam("partyOrgID");
            pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            PartyOrgInfo partyOrg = null;
            try {
                partyOrg = PartyOrgFactory.getRemoteInstance().getPartyOrgInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPartyOrg.setValue((Object)partyOrg);
        }
        this.cbInclude.setSelected(cp.getBoolean("isIncludeChild"));
    }

    public boolean verify() {
        if (this.prmtPartyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.partyOrgNotNull"));
            return false;
        }
        return true;
    }
}

