/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyCollectFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartyCollectFilterUI
extends AbstractPartyCollectFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyCollectFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.client.PartyResource";
    private static final String strResource = "com.kingdee.eas.hr.party.PartyResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPartyOrg.setEditable(false);
        this.prmtHROrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.pkDateStart.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.pkDateEnd.setValue((Object)endDate.getTime());
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo PartyRetfilter = new FilterInfo();
        if (this.prmtPartyOrg.getData() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getData();
            PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(partyOrg.getLongNumber() + "!%"), CompareType.LIKE));
            PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)partyOrg.getNumber(), CompareType.EQUALS));
            PartyRetfilter.setMaskString("#0 or #1");
            if (!this.cbIsCancel.isSelected()) {
                PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
                PartyRetfilter.setMaskString("#0 or (#1 and #2)");
                try {
                    PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    PartyRetfilter.setMaskString("(#0 or (#1 and #2)) and #3");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                try {
                    PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    PartyRetfilter.setMaskString("(#0 or #1) and #2");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return PartyRetfilter;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.pkDateStart.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("changeDate", (Object)((Date)this.pkDateStart.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("changeDate", (Object)((Date)this.pkDateEnd.getValue()), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        if (this.prmtPartyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.partyOrgNotNull"));
            return false;
        }
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkDateStart);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkDateEnd);
        if (this.pkDateStart.getValue() != null && this.pkDateEnd.getValue() != null) {
            Date beginDate = DateTimeUtils.truncateDate((Date)((Date)this.pkDateStart.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.pkDateEnd.getValue()));
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"StartDateBeforeEndDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    public Map getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.prmtPartyOrg.getValue() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getValue();
            params.put("partyOrg.id", partyOrg.getId().toString());
            params.put("partyOrg.longNumber", partyOrg.getLongNumber());
        }
        if (this.pkDateStart.getValue() != null) {
            Date startDate = (Date)this.pkDateStart.getValue();
            params.put("startDate", startDate);
        }
        if (this.pkDateEnd.getValue() != null) {
            Date endDate = (Date)this.pkDateEnd.getValue();
            params.put("endDate", endDate);
        }
        return params;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            PartyOrgInfo partyOrgInfo = (PartyOrgInfo)this.prmtPartyOrg.getValue();
            cp.addCustomerParam("partyOrgId", partyOrgInfo.getId().toString());
        }
        if (this.pkDateStart.getValue() != null) {
            cp.putDate("beginDate", (Date)this.pkDateStart.getValue());
        }
        if (this.pkDateEnd.getValue() != null) {
            cp.putDate("endDate", (Date)this.pkDateEnd.getValue());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("partyOrgId") != null) {
            String adminId = cp.getCustomerParam("partyOrgId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            PartyOrgInfo partyOrg = null;
            try {
                partyOrg = PartyOrgFactory.getRemoteInstance().getPartyOrgInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPartyOrg.setValue((Object)partyOrg);
        }
        this.pkDateStart.setValue((Object)cp.getDate("beginDate"));
        this.pkDateEnd.setValue((Object)cp.getDate("endDate"));
    }
}

