/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.party.IPartyOrgAdvancedRecord;
import com.kingdee.eas.hr.party.PartyCommonException;
import com.kingdee.eas.hr.party.PartyOrgAdvancedRecordCollection;
import com.kingdee.eas.hr.party.PartyOrgAdvancedRecordFactory;
import com.kingdee.eas.hr.party.PartyOrgAdvancedRecordInfo;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyOrgAdvancedRecordInfoUI;
import com.kingdee.eas.hr.party.client.IPartyOrgEditUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PartyOrgAdvancedRecordInfoUI
extends AbstractPartyOrgAdvancedRecordInfoUI
implements IPartyOrgEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyOrgAdvancedRecordInfoUI.class);
    private String curPartyOrgId = null;
    private ArrayList delPoarIds = new ArrayList();
    private PartyOrgAdvancedRecordCollection oldPoarCol = null;
    private PartyOrgAdvancedRecordCollection newPoarCol = null;
    private IPartyOrgAdvancedRecord iPoar = PartyOrgAdvancedRecordFactory.getRemoteInstance();
    private KDTSortManager sm = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setTableCellEditor();
        if (!this.getOprtState().equals("ADDNEW")) {
            this.loadPartyOrgAdvancedRecordInfo();
        }
        this.oldPoarCol = this.getPartyOrgAdvancedRecordCol();
        this.setTableHeadSortNotNeedSortManager();
    }

    private void loadPartyOrgAdvancedRecordInfo() throws BOSException, EASBizException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (this.curPartyOrgId == null) {
            this.curPartyOrgId = (String)this.getUIContext().get("ID");
        }
        String oql = "select id, advancedName, advancedStory, assessDate, remark where partyOrg = '" + this.curPartyOrgId + "'";
        PartyOrgAdvancedRecordCollection poarCol = this.iPoar.getPartyOrgAdvancedRecordCollection(oql);
        PartyOrgAdvancedRecordInfo poarInfo = null;
        IRow row = null;
        int size = poarCol.size();
        for (int i = 0; i < size; ++i) {
            poarInfo = poarCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)poarInfo.getId().toString());
            row.getCell("advancedName").setValue((Object)poarInfo.getAdvancedName());
            row.getCell("advancedStory").setValue((Object)poarInfo.getAdvancedStory());
            row.getCell("assessDate").setValue((Object)poarInfo.getAssessDate());
            row.getCell("remark").setValue((Object)poarInfo.getRemark());
        }
    }

    private PartyOrgAdvancedRecordCollection getPartyOrgAdvancedRecordCol() {
        PartyOrgAdvancedRecordCollection poarCol = new PartyOrgAdvancedRecordCollection();
        PartyOrgAdvancedRecordInfo poarInfo = null;
        PartyOrgInfo poInfo = new PartyOrgInfo();
        if (this.curPartyOrgId != null) {
            poInfo.setId(BOSUuid.read((String)this.curPartyOrgId));
        }
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            poarInfo = new PartyOrgAdvancedRecordInfo();
            if (row.getCell("id").getValue() != null) {
                poarInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            poarInfo.setPartyOrg(poInfo);
            if (row.getCell("advancedName").getValue() != null) {
                poarInfo.setAdvancedName(row.getCell("advancedName").getValue().toString());
            } else {
                poarInfo.setAdvancedName(null);
            }
            if (row.getCell("advancedStory").getValue() != null) {
                poarInfo.setAdvancedStory(row.getCell("advancedStory").getValue().toString());
            } else {
                poarInfo.setAdvancedStory(null);
            }
            if (row.getCell("assessDate").getValue() != null) {
                poarInfo.setAssessDate((Date)row.getCell("assessDate").getValue());
            } else {
                poarInfo.setAssessDate(null);
            }
            if (row.getCell("remark").getValue() != null) {
                poarInfo.setRemark(row.getCell("remark").getValue().toString());
            } else {
                poarInfo.setRemark(null);
            }
            poarCol.add(poarInfo);
        }
        return poarCol;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.btnAdd.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
        this.setTableHeadSortNotNeedSortManager();
    }

    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            this.tblMain.addRow(top + 1);
            this.setTableHeadSortNotNeedSortManager();
        } else {
            this.actionAdd_actionPerformed(e);
        }
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex < 0 || rowIndex >= this.tblMain.getRowCount()) {
            return;
        }
        ICell cell = this.tblMain.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            this.delPoarIds.add(cell.getValue().toString());
        }
        this.tblMain.removeRow(rowIndex);
        this.setTableHeadSortNotNeedSortManager();
    }

    public boolean isModify() {
        this.newPoarCol = this.getPartyOrgAdvancedRecordCol();
        return this.oldPoarCol == null && this.newPoarCol != null || this.oldPoarCol != null && this.newPoarCol == null || this.oldPoarCol != null && this.newPoarCol != null && !this.oldPoarCol.equals((Object)this.newPoarCol);
    }

    public void saveInfo() throws Exception {
        this.checkInput();
        this.iPoar.updateBatchPartyOrgAdvancedRecordInfo(this.getPartyOrgAdvancedRecordCol(), this.delPoarIds);
        this.loadPartyOrgAdvancedRecordInfo();
        this.delPoarIds = new ArrayList();
        this.oldPoarCol = this.getPartyOrgAdvancedRecordCol();
    }

    public void checkInput() throws Exception {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("advancedName").getValue() == null) {
                throw new PartyCommonException(PartyCommonException.ADVANCEDNAME_ISNULL, new Object[]{new Integer(i + 1)});
            }
            if (row.getCell("assessDate").getValue() != null) continue;
            throw new PartyCommonException(PartyCommonException.ASSESSDATE_ISNULL, new Object[]{new Integer(i + 1)});
        }
    }

    public void setPartyOrgId(String partyOrgId) throws Exception {
        this.curPartyOrgId = partyOrgId;
    }

    private void setTableCellEditor() {
        this.tblMain.checkParsed();
        KDTextField txtAdvancedName = new KDTextField();
        txtAdvancedName.setMaxLength(80);
        this.tblMain.getColumn("advancedName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAdvancedName));
        KDTextField txtAdvancedStory = new KDTextField();
        txtAdvancedStory.setMaxLength(200);
        this.tblMain.getColumn("advancedStory").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAdvancedStory));
        KDDatePicker assessDate = new KDDatePicker();
        assessDate.setValue((Object)new Date());
        this.tblMain.getColumn("assessDate").setEditor((ICellEditor)new KDTDefaultCellEditor(assessDate));
        this.tblMain.getColumn("assessDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(200);
        this.tblMain.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRemark));
    }

    public void clear() {
        this.tblMain.removeRows();
        this.oldPoarCol = this.getPartyOrgAdvancedRecordCol();
        this.newPoarCol = this.getPartyOrgAdvancedRecordCol();
    }

    public void changeOperate(String operateStr) {
        this.setOprtState(operateStr);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.btnAdd.setEnabled(true);
        this.btnInsert.setEnabled(true);
        this.btnDelete.setEnabled(true);
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
        }
        return this.sm;
    }

    protected void setTableHeadSortNotNeedSortManager() {
        if (this.tblMain.getRowCount() > 0) {
            PartyUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, this.getKDSortManger());
        } else {
            int count = this.tblMain.getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.tblMain.getColumn(i).setSortable(false);
            }
        }
    }
}

