/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyOrgMapUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.eas.hr.party.client.chart.DrawPartyOrg;
import com.kingdee.eas.hr.party.client.chart.PartyOrgUnit;
import java.awt.Component;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PartyOrgMapUI
extends AbstractPartyOrgMapUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyOrgMapUI.class);
    private DrawPartyOrg mapPanel = null;
    private int level = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.buildTree();
        this.getSelectNodeLevel();
    }

    protected void buildTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(treeSelectionListener);
        ITreeBuilder treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)100, (int)100, (FilterInfo)this.getDefaultFilter(), null);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.treeMain.setSelectionRow(0);
        this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return PartyOrgFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilter() throws ParserException {
        FilterInfo cancelFilter = new FilterInfo("isCancel = 0");
        return cancelFilter;
    }

    private static DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    private void getChildrenNodes(DefaultKingdeeTreeNode parent, DefaultMutableTreeNode root) {
        if (parent.getUserObject() instanceof PartyOrgInfo) {
            PartyOrgInfo partyOrgInfo = (PartyOrgInfo)parent.getUserObject();
            PartyOrgUnit unit = new PartyOrgUnit();
            unit.ID = partyOrgInfo.getId().toString();
            unit.level = partyOrgInfo.getLevel();
            unit.name = partyOrgInfo.getName();
            unit.number = partyOrgInfo.getNumber();
            if (!PartyUtils.isTreeNodeDisable(parent) && partyOrgInfo.get("CAN_VIEW") != null) {
                unit.canView = true;
            }
            root.setUserObject(unit);
            DefaultMutableTreeNode child = null;
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                child = new DefaultMutableTreeNode();
                this.getChildrenNodes((DefaultKingdeeTreeNode)parent.getChildAt(i), child);
                root.add(child);
            }
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        DefaultKingdeeTreeNode selectNode = PartyOrgMapUI.getSelectTreeNode(this.treeMain);
        if (selectNode == null) {
            return;
        }
        this.getChildrenNodes(selectNode, (DefaultMutableTreeNode)root);
        if (this.mapPanel == null) {
            this.mapPanel = new DrawPartyOrg(this.getWidth(), this.getHeight(), (DefaultMutableTreeNode)root, this.level);
            this.mapPanel.setUserComponents(null);
        } else {
            this.mapPanel.setRootNode((DefaultMutableTreeNode)root);
        }
        this.pnlMain.setDividerLocation(240);
        this.pnlMain.add((Component)((Object)this.mapPanel), (Object)"right");
        this.pnlMain.revalidate();
    }

    private void getSelectNodeLevel() {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            this.level = treeBaseInfo.getLevel();
        }
    }
}

