/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.party.LaborUintCollection;
import com.kingdee.eas.hr.party.LaborUintFactory;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.MemOrgBillCollection;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.PartyOrgCollection;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.PartyPermissionSetCollection;
import com.kingdee.eas.hr.party.PartyPermissionSetFactory;
import com.kingdee.eas.hr.party.PartyPermissionSetInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyPermissionListUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PartyPermissionListUI
extends AbstractPartyPermissionListUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyPermissionListUI.class);
    private String personId = null;
    private String orgType = null;
    DefaultKingdeeTreeNode orgRoot = null;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "person.id";
    }

    protected String getRootName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        if (this.getUIContext().get("ORGTYPE") != null) {
            this.orgType = this.getUIContext().get("ORGTYPE").toString();
            if ("PartyOrg".equals(this.orgType)) {
                return PartyOrgFactory.getRemoteInstance();
            }
            if ("MemOrg".equals(this.orgType)) {
                return MemOrgBillFactory.getRemoteInstance();
            }
            if ("UnionOrg".equals(this.orgType)) {
                return LaborUintFactory.getRemoteInstance();
            }
        }
        return null;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("personId") != null) {
            this.personId = this.getUIContext().get("personId").toString();
        }
        super.onLoad();
        KDCheckBox chkSetPermission = new KDCheckBox();
        this.tblMain.getColumn("isSetPermission").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkSetPermission));
        this.btnSave.setEnabled(false);
        PartyUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, new KDTSortManager(this.tblMain));
        if (this.getSelectedTreeNode() != null) {
            this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
    }

    private void loadPartyOrgValue(KDTreeNode node) throws BOSException {
        this.tblMain.removeRows();
        PartyOrgInfo poNodeInfo = (PartyOrgInfo)node.getUserObject();
        IRow row = null;
        Set permissionSet = this.getPartyOrgSelector();
        PartyOrgCollection poCol = PartyOrgFactory.getRemoteInstance().getPartyOrgCollection("where longNumber like '" + poNodeInfo.getLongNumber() + "%' order by number");
        PartyOrgInfo poInfo = null;
        int size = poCol.size();
        for (int i = 0; i < size; ++i) {
            poInfo = poCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("partyOrg.id").setValue((Object)poInfo.getId().toString());
            row.getCell("partyOrg.number").setValue((Object)poInfo.getNumber());
            row.getCell("partyOrg.name").setValue((Object)poInfo.getName());
            if (permissionSet != null && permissionSet.contains(poInfo.getId().toString())) {
                row.getCell("isSetPermission").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("isSetPermission").setValue((Object)Boolean.FALSE);
        }
    }

    private Set getPartyOrgSelector() throws BOSException {
        HashSet<String> permissionSet = new HashSet<String>();
        PartyPermissionSetCollection ppCol = PartyPermissionSetFactory.getRemoteInstance().getPartyPermissionSetCollection("select partyOrg where person = '" + this.personId + "' and permissionType = '" + this.orgType + "'");
        int size = ppCol.size();
        for (int i = 0; i < size; ++i) {
            permissionSet.add(ppCol.get(i).getPartyOrg().getId().toString());
        }
        return permissionSet;
    }

    private void loadMemOrgValue(KDTreeNode node) throws BOSException {
        this.tblMain.removeRows();
        MemOrgBillInfo moNodeInfo = (MemOrgBillInfo)node.getUserObject();
        IRow row = null;
        Set permissionSet = this.getMemOrgSelector();
        MemOrgBillCollection moCol = MemOrgBillFactory.getRemoteInstance().getMemOrgBillCollection("where longNumber like '" + moNodeInfo.getLongNumber() + "%' order by number");
        MemOrgBillInfo moInfo = null;
        int size = moCol.size();
        for (int i = 0; i < size; ++i) {
            moInfo = moCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("memOrg.id").setValue((Object)moInfo.getId().toString());
            row.getCell("memOrg.number").setValue((Object)moInfo.getNumber());
            row.getCell("memOrg.name").setValue((Object)moInfo.getName());
            if (permissionSet != null && permissionSet.contains(moInfo.getId().toString())) {
                row.getCell("isSetPermission").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("isSetPermission").setValue((Object)Boolean.FALSE);
        }
    }

    private Set getMemOrgSelector() throws BOSException {
        HashSet<String> permissionSet = new HashSet<String>();
        PartyPermissionSetCollection ppCol = PartyPermissionSetFactory.getRemoteInstance().getPartyPermissionSetCollection("select memOrg where person = '" + this.personId + "' and permissionType = '" + this.orgType + "'");
        int size = ppCol.size();
        for (int i = 0; i < size; ++i) {
            permissionSet.add(ppCol.get(i).getMemOrg().getId().toString());
        }
        return permissionSet;
    }

    private void loadUnionOrgValue(KDTreeNode node) throws BOSException {
        this.tblMain.removeRows();
        LaborUintInfo luNodeInfo = (LaborUintInfo)node.getUserObject();
        IRow row = null;
        Set permissionSet = this.getUnionOrgSelector();
        LaborUintCollection luCol = LaborUintFactory.getRemoteInstance().getLaborUintCollection("where longNumber like '" + luNodeInfo.getLongNumber() + "%' order by number");
        LaborUintInfo luInfo = null;
        int size = luCol.size();
        for (int i = 0; i < size; ++i) {
            luInfo = luCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("laborUnion.id").setValue((Object)luInfo.getId().toString());
            row.getCell("laborUnion.number").setValue((Object)luInfo.getNumber());
            row.getCell("laborUnion.name").setValue((Object)luInfo.getName());
            if (permissionSet != null && permissionSet.contains(luInfo.getId().toString())) {
                row.getCell("isSetPermission").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("isSetPermission").setValue((Object)Boolean.FALSE);
        }
    }

    private Set getUnionOrgSelector() throws BOSException {
        HashSet<String> permissionSet = new HashSet<String>();
        PartyPermissionSetCollection ppCol = PartyPermissionSetFactory.getRemoteInstance().getPartyPermissionSetCollection("select laborUnion where person = '" + this.personId + "' and permissionType = '" + this.orgType + "'");
        int size = ppCol.size();
        for (int i = 0; i < size; ++i) {
            permissionSet.add(ppCol.get(i).getLaborUnion().getId().toString());
        }
        return permissionSet;
    }

    private PartyPermissionSetCollection getTableValue() {
        PartyPermissionSetCollection ppCol = new PartyPermissionSetCollection();
        PartyPermissionSetInfo ppInfo = null;
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.personId));
        PartyOrgInfo poInfo = null;
        MemOrgBillInfo moInfo = null;
        LaborUintInfo luInfo = null;
        IRow row = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("isSetPermission").getValue()).booleanValue()) continue;
            ppInfo = new PartyPermissionSetInfo();
            ppInfo.setPerson(pInfo);
            if (row.getCell("partyOrg.id").getValue() != null) {
                poInfo = new PartyOrgInfo();
                poInfo.setId(BOSUuid.read((String)row.getCell("partyOrg.id").getValue().toString()));
                ppInfo.setPartyOrg(poInfo);
            }
            if (row.getCell("memOrg.id").getValue() != null) {
                moInfo = new MemOrgBillInfo();
                moInfo.setId(BOSUuid.read((String)row.getCell("memOrg.id").getValue().toString()));
                ppInfo.setMemOrg(moInfo);
            }
            if (row.getCell("laborUnion.id").getValue() != null) {
                luInfo = new LaborUintInfo();
                luInfo.setId(BOSUuid.read((String)row.getCell("laborUnion.id").getValue().toString()));
                ppInfo.setLaborUnion(luInfo);
            }
            ppInfo.setPermissionType(this.orgType);
            ppCol.add(ppInfo);
        }
        return ppCol;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return null;
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        PartyPermissionSetFactory.getRemoteInstance().savePermissionValue(this.getTableValue(), this.personId, this.orgType);
        this.tblMain.getColumn("isSetPermission").getStyleAttributes().setLocked(true);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.SAVE_SUCCESS"));
        this.btnEdit.setEnabled(true);
        this.btnSave.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getColumn("isSetPermission").getStyleAttributes().setLocked(false);
        this.btnEdit.setEnabled(false);
        this.btnSave.setEnabled(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        KDTreeNode node = this.getSelectedTreeNode();
        if (this.getUIContext().get("ORGTYPE") != null) {
            this.orgType = this.getUIContext().get("ORGTYPE").toString();
            if ("PartyOrg".equals(this.orgType)) {
                this.tblMain.getColumn("memOrg.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("memOrg.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("laborUnion.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("laborUnion.name").getStyleAttributes().setHided(true);
                this.loadPartyOrgValue(node);
            } else if ("MemOrg".equals(this.orgType)) {
                this.tblMain.getColumn("partyOrg.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("partyOrg.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("laborUnion.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("laborUnion.name").getStyleAttributes().setHided(true);
                this.loadMemOrgValue(node);
            } else if ("UnionOrg".equals(this.orgType)) {
                this.tblMain.getColumn("partyOrg.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("partyOrg.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("memOrg.number").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("memOrg.name").getStyleAttributes().setHided(true);
                this.loadUnionOrgValue(node);
            }
        }
    }
}

