/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client.chart;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.basedata.org.client.chart.HistoryNode;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.party.PartyOrgMappingPartyJobCollection;
import com.kingdee.eas.hr.party.PartyOrgMappingPartyJobFactory;
import com.kingdee.eas.hr.party.PartyOrgMappingPartyJobInfo;
import com.kingdee.eas.hr.party.client.chart.DrawPartyOrgPanel;
import com.kingdee.eas.hr.party.client.chart.PartyOrgUnit;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawPartyOrg
extends KDPanel {
    private KDPanel bar = new KDPanel();
    private DrawPartyOrgPanel partyOrgPanel = new DrawPartyOrgPanel(this);
    private KDScrollPane scrollPane = null;
    private KDCheckBox chkShowPompj = null;
    private FontMetrics fontM = null;
    private float maxy = 0.0f;
    private float maxx = 0.0f;
    static final float FixHeight = 20.0f;
    private float FixWidth = 20.0f;
    private float temp = 0.0f;
    protected HistoryNode historyNode = null;
    private int interval = 0;
    protected Timer timer = new Timer();
    private DefaultMutableTreeNode rootNode = null;
    private DefaultMutableTreeNode lastNode = null;
    public int baseLevel = 0;
    private HashMap pompjMap = null;
    private static String oldSessionId = null;
    public int chartType = 0;
    public int chooseLevel = 0;
    public boolean displayPompj = false;

    public DrawPartyOrg(int width, int height, DefaultMutableTreeNode rootNode, int level) throws Exception {
        this.initOrgUnitPanel(width, height, rootNode, level);
    }

    private void initOrgUnitPanel(int width, int height, DefaultMutableTreeNode rootNode, int level) throws Exception {
        if (rootNode == null) {
            return;
        }
        if (oldSessionId != null && !SysContext.getSysContext().getSessionID().equals(oldSessionId)) {
            this.pompjMap = null;
        }
        oldSessionId = SysContext.getSysContext().getSessionID();
        this.chooseLevel = rootNode.getDepth() + 1;
        this.setPompjVisible(false);
        this.rootNode = rootNode;
        this.setBorder(new EtchedBorder(0));
        this.drawOrg();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    DrawPartyOrg.this.startDraw();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    public void setRootNode(DefaultMutableTreeNode rootNode) throws Exception {
        this.rootNode = rootNode;
        this.init();
        this.partyOrgPanel.clearSelectNode();
    }

    private void getPompjData() throws Exception {
        this.pompjMap = new HashMap();
        String oql = "select partyOrg.id, partyOrg.name, partyJob.id, partyJob.name, person.id, person.name where principalJob = 1";
        PartyOrgMappingPartyJobCollection pompjCol = PartyOrgMappingPartyJobFactory.getRemoteInstance().getPartyOrgMappingPartyJobCollection(oql);
        int size = pompjCol.size();
        for (int i = 0; i < size; ++i) {
            this.pompjMap.put(pompjCol.get(i).getPartyOrg().getId().toString(), pompjCol.get(i));
        }
    }

    private void setPompjVisible(boolean vis) throws Exception {
        this.displayPompj = vis;
        if (vis) {
            this.getPompjData();
            this.FixWidth = 40.0f;
        } else {
            this.FixWidth = 20.0f;
        }
        this.startDraw();
    }

    private void drawOrg() throws Exception {
        this.setLayout(new BorderLayout());
        this.bar.setLayout((LayoutManager)new FlowLayout(2));
        this.bar.setPreferredSize(new Dimension(0, 30));
        this.chkShowPompj = new KDCheckBox(EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.SHOW_POMPJ"));
        this.chkShowPompj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (DrawPartyOrg.this.chkShowPompj.isSelected()) {
                        DrawPartyOrg.this.setPompjVisible(true);
                    } else {
                        DrawPartyOrg.this.setPompjVisible(false);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.chkShowPompj.setSelected(false);
        this.bar.add((Component)this.chkShowPompj);
        this.add((Component)this.bar, "North");
        this.partyOrgPanel = new DrawPartyOrgPanel(this);
        this.scrollPane = new KDScrollPane((Component)((Object)this.partyOrgPanel));
        this.add((Component)this.scrollPane, "Center");
        this.init();
    }

    private void init() throws Exception {
        this.historyNode = new HistoryNode();
        this.historyNode.value = ((PartyOrgUnit)this.rootNode.getUserObject()).ID;
        this.historyNode.curNode = this.rootNode;
        this.chooseLevel = this.rootNode.getDepth() + 1;
        this.startDraw();
    }

    public void startDraw() throws Exception {
        this.maxx = 0.0f;
        this.maxy = 0.0f;
        if (this.historyNode == null) {
            return;
        }
        this.baseLevel = this.historyNode.curNode.getLevel();
        this.buildFromTreeNode(this.historyNode.curNode);
        this.moveCoordinate(this.historyNode.curNode);
        this.rollCoordinate(this.historyNode.curNode);
        this.partyOrgPanel.setRoot(this.historyNode.curNode);
        this.partyOrgPanel.setDrawingPaneSize((int)this.maxy, (int)this.maxx);
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)this.historyNode.curNode.getUserObject();
        Rectangle rect = new Rectangle((int)PartyOrgUnit2.X - this.getWidth() / 2 + (int)PartyOrgUnit2.width / 2, 0, this.getWidth(), this.getHeight());
        if (this.scrollPane.getParent() != null) {
            this.scrollPane.getParent().validate();
        }
        this.scrollPane.getViewport().setViewSize(new Dimension((int)this.maxy, (int)this.maxx));
        if (this.maxy > (float)this.getWidth()) {
            this.scrollPane.getViewport().setViewPosition(new Point(rect.x, rect.y));
        }
    }

    private void buildFromTreeNode(DefaultMutableTreeNode root) {
        int i;
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)root.getUserObject();
        PartyOrgUnit lastOrgUnit = null;
        if (this.lastNode != null) {
            lastOrgUnit = (PartyOrgUnit)this.lastNode.getUserObject();
        }
        if (this.fontM == null) {
            this.fontM = this.partyOrgPanel.getFontMetrics(this.partyOrgPanel.getFont());
        }
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        if (root.getLevel() == this.baseLevel) {
            PartyOrgUnit2.X = 20.0f;
            PartyOrgUnit2.Y = 20.0f;
        } else if (root.getLevel() == this.lastNode.getLevel() + 1) {
            PartyOrgUnit2.Y = lastOrgUnit.Y;
            PartyOrgUnit2.X = lastOrgUnit.X + this.FixWidth + 40.0f;
        } else if (root.getLevel() == this.lastNode.getLevel()) {
            PartyOrgUnit2.X = lastOrgUnit.X;
            PartyOrgUnit2.Y = lastOrgUnit.Y + lastOrgUnit.height + 20.0f;
        } else {
            this.interval = this.lastNode.getLevel() - root.getLevel();
            for (i = 0; i < this.interval; ++i) {
                this.lastNode = (DefaultMutableTreeNode)this.lastNode.getParent();
            }
            lastOrgUnit = (PartyOrgUnit)this.lastNode.getUserObject();
            PartyOrgUnit2.Y = this.maxy + 20.0f;
            PartyOrgUnit2.X = lastOrgUnit.X;
        }
        if (this.chkShowPompj.isSelected() && PartyOrgUnit2.ID != null) {
            PartyOrgUnit2.pompjInfo = this.getPompjByPoId(PartyOrgUnit2.ID);
        }
        PartyOrgUnit2.width = this.FixWidth;
        PartyOrgUnit2.height = (float)this.getNameMaxLength(PartyOrgUnit2) + 20.0f;
        this.lastNode = root;
        lastOrgUnit = (PartyOrgUnit)this.lastNode.getUserObject();
        if (this.maxy < lastOrgUnit.height + lastOrgUnit.Y) {
            this.maxy = lastOrgUnit.height + lastOrgUnit.Y;
        }
        if (this.maxx < lastOrgUnit.width + lastOrgUnit.X) {
            this.maxx = lastOrgUnit.width + lastOrgUnit.X;
        }
        for (i = 0; i < root.getChildCount(); ++i) {
            this.buildFromTreeNode((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private int getNameMaxLength(PartyOrgUnit PartyOrgUnit2) {
        int length1 = 0;
        length1 = StringUtils.isEmpty((String)PartyOrgUnit2.name) ? 0 : this.fontM.stringWidth(PartyOrgUnit2.name);
        if (this.chkShowPompj.isSelected() && PartyOrgUnit2.ID != null) {
            int size;
            int length2 = 0;
            if (PartyOrgUnit2.pompjInfo != null && (size = PartyOrgUnit2.pompjInfo.size()) > 0 && !StringUtils.isEmpty((String)PartyOrgUnit2.pompjInfo.getPartyJob().getName())) {
                length2 = PartyOrgUnit2.pompjInfo.getPerson() != null ? this.fontM.stringWidth(PartyOrgUnit2.pompjInfo.getPartyJob().getName() + ":" + PartyOrgUnit2.pompjInfo.getPerson().getName()) : this.fontM.stringWidth(PartyOrgUnit2.pompjInfo.getPartyJob().getName());
            }
            return StrictMath.max(length1, length2);
        }
        return length1;
    }

    private PartyOrgMappingPartyJobInfo getPompjByPoId(String partyOrgId) {
        if (this.pompjMap != null) {
            return (PartyOrgMappingPartyJobInfo)this.pompjMap.get(partyOrgId);
        }
        return null;
    }

    private void rollCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)root.getUserObject();
        this.temp = PartyOrgUnit2.Y + PartyOrgUnit2.height;
        PartyOrgUnit2.Y = PartyOrgUnit2.X;
        PartyOrgUnit2.X = this.maxy + 1.0f - this.temp;
        this.temp = PartyOrgUnit2.width;
        PartyOrgUnit2.width = PartyOrgUnit2.height;
        PartyOrgUnit2.height = this.temp;
        PartyOrgUnit2.rect = new Rectangle((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y, (int)PartyOrgUnit2.width, (int)PartyOrgUnit2.height);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.rollCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private void moveCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        if (root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.moveCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
        if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() > 1) {
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)root.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)root.getFirstChild();
            PartyOrgUnit firstUnit = (PartyOrgUnit)firstChildNode.getUserObject();
            PartyOrgUnit endUnit = (PartyOrgUnit)lastChildNode.getUserObject();
            PartyOrgUnit rootUnit = (PartyOrgUnit)root.getUserObject();
            rootUnit.Y = firstUnit.Y / 2.0f + firstUnit.height / 4.0f + endUnit.Y / 2.0f + endUnit.height / 4.0f - rootUnit.height / 2.0f;
        } else if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() == 1) {
            PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)((DefaultMutableTreeNode)root.getLastChild()).getUserObject();
            PartyOrgUnit rootUnit = (PartyOrgUnit)root.getUserObject();
            if (rootUnit.height < PartyOrgUnit2.height) {
                rootUnit.Y = PartyOrgUnit2.Y + (PartyOrgUnit2.height - rootUnit.height) / 2.0f;
            } else if (rootUnit.height == PartyOrgUnit2.height) {
                rootUnit.Y = PartyOrgUnit2.Y;
            } else if (rootUnit.Y < PartyOrgUnit2.Y) {
                rootUnit.Y = PartyOrgUnit2.Y + (PartyOrgUnit2.height - rootUnit.height) / 2.0f;
            } else {
                this.updateNodeY((DefaultMutableTreeNode)root.getLastChild(), (rootUnit.height - PartyOrgUnit2.height) / 2.0f);
            }
        }
    }

    private void updateNodeY(DefaultMutableTreeNode child, float height) {
        PartyOrgUnit childUnit = (PartyOrgUnit)child.getUserObject();
        childUnit.Y += height;
        for (int i = 0; i < child.getChildCount(); ++i) {
            this.updateNodeY((DefaultMutableTreeNode)child.getChildAt(i), height);
        }
    }

    public void setUserComponents(Component[] comps) {
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                this.bar.add(comps[i]);
            }
        }
    }
}

