/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client.chart;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.hr.party.client.chart.DrawPartyOrg;
import com.kingdee.eas.hr.party.client.chart.PartyOrgUnit;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawPartyOrgPanel
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private DefaultMutableTreeNode root = null;
    private DrawPartyOrg drawPartyOrg = null;
    public PartyOrgUnit selOrgUnit = null;
    private PartyOrgUnit currOrgUnit = null;
    private int translateX = 0;
    private int translateY = 0;
    public Color rectLineColor = new Color(0x9E9E9E);
    public Color currRectLineColor = new Color(14581776);
    public Color selRectLineColor = new Color(14588434);
    public Color orgRectColor = new Color(13296622);
    public Color currOrgRectColor = new Color(16247737);
    public Color selOrgRectColor = new Color(15653292);
    public Color otherRectColor = new Color(0xFFFFFF);
    public Color selOtherRectColor = new Color(16314050);
    public Color textColor = Color.BLACK;
    public Color separateLineColor = new Color(0xE6E6E6);
    public Color selSeparateLineColor = new Color(15653292);
    public Color lineColor = new Color(4145719);
    public Color currOtherRectColor = new Color(0xFFFFFF);
    public Color currSeparateLineColor = new Color(0xE6E6E6);
    public Color noPPBackgroudColor = new Color(0xD9D9D0);
    public Color bgColor = new Color(0xD9D9D0);
    private Point startPoint = null;
    private Point endPoint = null;

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void clearSelectNode() {
        this.selOrgUnit = null;
        this.currOrgUnit = null;
    }

    public void setDrawingPaneSize(int maxX, int maxY) {
        this.setPreferredSize(new Dimension(maxX + 30, maxY + 30));
        this.translateX = 0;
        this.translateY = 0;
        if (maxX < this.drawPartyOrg.getWidth()) {
            this.translateX = (this.drawPartyOrg.getWidth() - maxX) / 2;
        }
    }

    public DrawPartyOrgPanel(DrawPartyOrg drawPartyOrg) {
        this.drawPartyOrg = drawPartyOrg;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.bgColor);
        g2.translate(this.translateX, this.translateY);
        if (this.root != null) {
            this.drawOrgNode(g2, this.root);
            g2.setColor(this.lineColor);
            this.drawOrgUnitLineH(g2, this.root);
        }
    }

    private void drawOrgUnit(Graphics2D g2, PartyOrgUnit PartyOrgUnit2) {
        Color tempRectLineColor = null;
        Color tempOrgRectColor = null;
        Color tempTextColor = this.textColor;
        Color tempOtherRectColor = null;
        if (PartyOrgUnit2.isMain || PartyOrgUnit2.isCurrent) {
            tempRectLineColor = this.currRectLineColor;
            tempOrgRectColor = this.currOrgRectColor;
            tempOtherRectColor = this.currOtherRectColor;
        } else if (PartyOrgUnit2.isSelected) {
            tempRectLineColor = this.selRectLineColor;
            tempOrgRectColor = this.selOrgRectColor;
            tempOtherRectColor = this.selOtherRectColor;
        } else {
            tempRectLineColor = this.rectLineColor;
            tempOrgRectColor = this.orgRectColor;
            tempOtherRectColor = PartyOrgUnit2.canView ? this.otherRectColor : this.noPPBackgroudColor;
        }
        PartyOrgUnit2.rect = new Rectangle((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y, (int)PartyOrgUnit2.width, (int)PartyOrgUnit2.height);
        g2.setColor(tempOrgRectColor);
        g2.fillRoundRect((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y, (int)PartyOrgUnit2.width, (int)PartyOrgUnit2.height, 10, 10);
        g2.setColor(tempTextColor);
        int length = 0;
        if (StringUtils.isEmpty((String)PartyOrgUnit2.name)) {
            length = 0;
            g2.drawString("", (int)PartyOrgUnit2.X + ((int)PartyOrgUnit2.width - length) / 2, (int)PartyOrgUnit2.Y + 15);
        } else {
            length = g2.getFontMetrics().stringWidth(PartyOrgUnit2.name);
            g2.drawString(PartyOrgUnit2.name, (int)PartyOrgUnit2.X + ((int)PartyOrgUnit2.width - length) / 2, (int)PartyOrgUnit2.Y + 15);
        }
        if (this.drawPartyOrg.displayPompj) {
            g2.setColor(Color.WHITE);
            g2.fillRoundRect((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y + 20, (int)PartyOrgUnit2.width, 20, 10, 10);
            g2.fillRect((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y + 20, (int)PartyOrgUnit2.width, 20);
            g2.setColor(tempTextColor);
            if (PartyOrgUnit2.pompjInfo != null) {
                String displayText = null;
                displayText = PartyOrgUnit2.pompjInfo.getPerson() == null ? PartyOrgUnit2.pompjInfo.getPartyJob().getName() : PartyOrgUnit2.pompjInfo.getPartyJob().getName() + ":" + PartyOrgUnit2.pompjInfo.getPerson().getName();
                length = g2.getFontMetrics().stringWidth(displayText);
                g2.drawString(displayText, (int)PartyOrgUnit2.X + ((int)PartyOrgUnit2.width - length) / 2, (int)PartyOrgUnit2.Y + 35);
            }
        }
        g2.setColor(tempRectLineColor);
        g2.drawRoundRect((int)PartyOrgUnit2.X, (int)PartyOrgUnit2.Y, (int)PartyOrgUnit2.width, (int)PartyOrgUnit2.height, 10, 10);
    }

    private void drawOrgNode(Graphics2D g2, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawPartyOrg.baseLevel + 1 > this.drawPartyOrg.chooseLevel && this.drawPartyOrg.chartType == 0) {
            return;
        }
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)node.getUserObject();
        this.drawOrgUnit(g2, PartyOrgUnit2);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawOrgNode(g2, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void drawOrgUnitLineH(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawPartyOrg.baseLevel + 1 > this.drawPartyOrg.chooseLevel && this.drawPartyOrg.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawPartyOrg.baseLevel + 1 < this.drawPartyOrg.chooseLevel || this.drawPartyOrg.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20 * 2;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineH(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawPartyOrg.baseLevel + 1 < this.drawPartyOrg.chooseLevel || this.drawPartyOrg.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            PartyOrgUnit startOrg = (PartyOrgUnit)firstChildNode.getUserObject();
            PartyOrgUnit endOrg = (PartyOrgUnit)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X + startOrg.width / 2.0f), (int)(startOrg.Y - 20.0f), (int)(endOrg.X + endOrg.width / 2.0f), (int)(endOrg.Y - 20.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointH(lastChildNode);
                this.startPoint.x = this.endPoint.x;
                this.startPoint.y = this.endPoint.y - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineH(g, lastChildNode);
            }
        }
    }

    private Point getStartPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)node.getUserObject();
        point.x = (int)(PartyOrgUnit2.X + PartyOrgUnit2.width / 2.0f);
        point.y = (int)(PartyOrgUnit2.Y + PartyOrgUnit2.height);
        return point;
    }

    private Point getEndPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        PartyOrgUnit PartyOrgUnit2 = (PartyOrgUnit)node.getUserObject();
        point.x = (int)(PartyOrgUnit2.X + PartyOrgUnit2.width / 2.0f);
        point.y = (int)PartyOrgUnit2.Y;
        return point;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

