/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client.util;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.party.PartyPermissionSetCollection;
import com.kingdee.eas.hr.party.PartyPermissionSetFactory;
import com.kingdee.eas.hr.party.PartyPermissionSetInfo;
import java.util.HashSet;
import java.util.Iterator;

public class PartyPermissionUtil {
    public static final int PARTY_PERMISSION = 0;
    public static final int MEM_PERMISSION = 1;
    public static final int UNION_PERMISSION = 2;

    public static FilterInfo getPermissionFilter(int permissionType) throws Exception {
        return PartyPermissionUtil.getPermissionFilter(permissionType, null);
    }

    public static FilterInfo getPermissionFilter(int permissionType, String compareExpr) throws Exception {
        compareExpr = compareExpr == null ? "" : compareExpr + ".";
        FilterInfo permissionFilter = new FilterInfo();
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo currPerson = currUser.getPerson();
        if (currPerson == null) {
            return new FilterInfo(compareExpr + "number = ''");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)currPerson.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        if (permissionType == 0) {
            sic.add(new SelectorItemInfo("partyOrg.id"));
        } else if (permissionType == 1) {
            sic.add(new SelectorItemInfo("memOrg.id"));
        } else if (permissionType == 2) {
            sic.add(new SelectorItemInfo("laborUnion.id"));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        PartyPermissionSetCollection coll = PartyPermissionSetFactory.getRemoteInstance().getPartyPermissionSetCollection(view);
        PartyPermissionSetInfo info = null;
        HashSet<String> idSet = new HashSet<String>();
        if (coll == null || coll.size() == 0) {
            permissionFilter = new FilterInfo(compareExpr + "number = ''");
            return permissionFilter;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            info = (PartyPermissionSetInfo)it.next();
            if (permissionType == 0) {
                if (info.getPartyOrg() == null) continue;
                idSet.add(info.getPartyOrg().getId().toString());
                continue;
            }
            if (permissionType == 1) {
                if (info.getMemOrg() == null) continue;
                idSet.add(info.getMemOrg().getId().toString());
                continue;
            }
            if (permissionType != 2 || info.getLaborUnion() == null) continue;
            idSet.add(info.getLaborUnion().getId().toString());
        }
        if (idSet.size() == 0) {
            return new FilterInfo(compareExpr + "number = ''");
        }
        permissionFilter.getFilterItems().add(new FilterItemInfo(compareExpr + "id", idSet, CompareType.INCLUDE));
        return permissionFilter;
    }
}

