/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.qualifications.QualLevelFactory;
import com.kingdee.eas.hr.qualifications.QualLevelInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractCerAppGeneralViewReportFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CerAppGeneralViewReportFilterUI
extends AbstractCerAppGeneralViewReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CerAppGeneralViewReportFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setValue(null);
        this.prmtLevel.setValue(null);
        this.prmtPerson.setValue(null);
        this.prmtPosition.setValue(null);
        this.dpkBeginDate.setValue(null);
        this.dpkEndDate.setValue(null);
        this.chkIncludeChild.setSelected(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtAdminOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtPerson.setSelector((KDPromptSelector)new EmployeeMultiF7PromptBox());
        this.prmtPosition.setSelector((KDPromptSelector)new PositionPromptBox2());
        this.chkIncludeChild.setEnabled(false);
    }

    protected void prmtAdminOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAdminOrg_dataChanged(e);
        if (this.prmtAdminOrg.getValue() == null) {
            this.chkIncludeChild.setEnabled(false);
            this.chkIncludeChild.setSelected(false);
        } else {
            this.chkIncludeChild.setEnabled(true);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtAdminOrg.getValue() != null) {
            cp.addCustomerParam("adminId", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
        }
        if (this.prmtLevel.getValue() != null) {
            cp.addCustomerParam("levelId", ((QualLevelInfo)this.prmtLevel.getValue()).getId().toString());
        }
        if (this.prmtPerson.getValue() != null) {
            cp.addCustomerParam("personId", ((PersonInfo)this.prmtPerson.getValue()).getId().toString());
        }
        if (this.prmtPosition.getValue() != null) {
            cp.addCustomerParam("positionId", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        cp.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtLevel.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("qualLevel.id", (Object)((QualLevelInfo)this.prmtLevel.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtPerson.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)this.prmtPerson.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtPosition.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)((PositionInfo)this.prmtPosition.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.dpkBeginDate.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue())), CompareType.GREATER_EQUALS));
        }
        if (this.dpkEndDate.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue())), CompareType.LESS_EQUALS));
        }
        this.appendAdmimOrgFilter(filter);
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.ISNOT));
        }
        return filter;
    }

    private void appendAdmimOrgFilter(FilterInfo filter) {
        if (this.prmtAdminOrg.getValue() != null) {
            AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.prmtAdminOrg.getValue();
            FilterInfo adminFilter = new FilterInfo();
            if (this.chkIncludeChild.isSelected()) {
                adminFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)adminOrg.getNumber(), CompareType.EQUALS));
                adminFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminOrg.getLongNumber() + "!%"), CompareType.LIKE));
                adminFilter.getFilterItems().add(new FilterItemInfo("adminOrg.isVirtual", (Object)false, CompareType.EQUALS));
                adminFilter.setMaskString("(#0 or #1) and #2");
            } else {
                adminFilter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
            }
            try {
                filter.mergeFilter(adminFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String id = null;
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("adminId") != null) {
            id = cp.getCustomerParam("adminId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            AdminOrgUnitInfo adminOrg = null;
            try {
                adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminOrg.setValue((Object)adminOrg);
        }
        if (cp.getCustomerParam("levelId") != null) {
            id = cp.getCustomerParam("levelId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            QualLevelInfo level = null;
            try {
                level = QualLevelFactory.getRemoteInstance().getQualLevelInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtLevel.setValue((Object)level);
        }
        if (cp.getCustomerParam("personId") != null) {
            id = cp.getCustomerParam("personId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            PersonInfo person = null;
            try {
                person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPerson.setValue((Object)person);
        }
        if (cp.getCustomerParam("positionId") != null) {
            id = cp.getCustomerParam("positionId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            PositionInfo position = null;
            try {
                position = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPosition.setValue((Object)position);
        }
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
        this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
    }

    public boolean verify() {
        Date endDate;
        Date startDate;
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null && (startDate = (Date)this.dpkBeginDate.getValue()).after(endDate = (Date)this.dpkEndDate.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
            SysUtil.abort();
        }
        return true;
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.prmtAdminOrg.getValue() == null) {
            map.put("isIncludeChild", true);
        } else {
            map.put("isIncludeChild", this.chkIncludeChild.isSelected());
        }
        if (this.prmtAdminOrg.getValue() != null) {
            map.put("adminId", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
        }
        return map;
    }
}

