/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.qualifications.CerSchemeBillCollection;
import com.kingdee.eas.hr.qualifications.CerSchemeBillFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractCerAppManageFilterUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class CerAppManageFilterUI
extends AbstractCerAppManageFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CerAppManageFilterUI.class);
    private CerSchemeBillCollection allSchemes = null;
    private CerSchemeBillInfo[] schemeArray = null;
    private List SchemeList = null;
    private String[] SchemeArray = null;
    private static final String STRRES = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initSchemeData();
    }

    private void initSchemeData() throws BOSException {
        EntityViewInfo view = null;
        HROrgUnitInfo hrOrg = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrg != null) {
            view = new EntityViewInfo();
            FilterInfo filter = HRQualClientUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "adminOrg.id");
            view.setFilter(filter);
        }
        this.prmtScheme.setEntityViewInfo(view);
        if (this.allSchemes == null && view != null) {
            this.allSchemes = CerSchemeBillFactory.getRemoteInstance().getCerSchemeBillCollection(view);
        }
        if (this.allSchemes != null && this.allSchemes.size() > 0) {
            this.schemeArray = new CerSchemeBillInfo[this.allSchemes.size()];
            for (int i = 0; i < this.allSchemes.size(); ++i) {
                this.schemeArray[i] = this.allSchemes.get(i);
            }
        }
    }

    public void clear() {
        super.clear();
        this.prmtScheme.setValue(null);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtScheme.getValue() != null) {
            Object[] dataArray = (Object[])this.prmtScheme.getValue();
            cp.putInt("schemeCount", dataArray.length);
            for (int i = 0; i < dataArray.length; ++i) {
                cp.addCustomerParam("scheme" + i, ((CerSchemeBillInfo)dataArray[i]).getId().toString());
            }
        }
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtScheme.getValue() != null) {
            Object value = this.prmtScheme.getValue();
            filter.getFilterItems().add(new FilterItemInfo("cerSchemeBill.id", (Object)this.getSchemeIds((Object[])value), CompareType.INCLUDE));
        }
        return filter;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        ObjectUuidPK pk = null;
        if (cp.getInt("schemeCount") > 0) {
            int schemeCount = cp.getInt("schemeCount");
            CerSchemeBillInfo[] schemes = new CerSchemeBillInfo[schemeCount];
            for (int i = 0; i < schemeCount; ++i) {
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("scheme" + i)));
                try {
                    schemes[i] = CerSchemeBillFactory.getRemoteInstance().getCerSchemeBillInfo((IObjectPK)pk);
                    continue;
                }
                catch (EASBizException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"162_GetCerSchemeBillError"));
                    SysUtil.abort();
                    continue;
                }
                catch (BOSException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"162_GetCerSchemeBillError"));
                    SysUtil.abort();
                }
            }
            this.prmtScheme.setValue((Object)schemes);
        }
    }

    public boolean verify() {
        return true;
    }

    public FilterItemInfo getHRAndAdminRangeFilterInfo(String adminOrgColName, String hrOrgUnitID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        FilterItemInfo item = new FilterItemInfo(adminOrgColName, (Object)sql.toString(), CompareType.INNER);
        return item;
    }

    private HashSet getSchemeIds(Object[] schemes) {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < schemes.length; ++i) {
            idSet.add(((CerSchemeBillInfo)schemes[i]).getId().toString());
        }
        return idSet;
    }
}

