/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.TechnicalPostPromptBox;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.JobLevelPromptBox;
import com.kingdee.eas.hr.qualifications.client.AbstractCerAppManageQualFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CerAppManageQualFilterUI
extends AbstractCerAppManageQualFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CerAppManageQualFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initCustomUI();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.chkDiploma.setSelected(false);
        this.chkPosition.setSelected(false);
        this.chkPositionLevel.setSelected(false);
        this.chkProfPost.setSelected(false);
        this.chkYear.setSelected(false);
        this.setPositionEnabled(false);
        this.setPositionLevelEnabled(false);
        this.setProfPostEnabled(false);
        this.setServiceYearEnabled(false);
        this.setDiplomaEnabled(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("isSelectDiploma", this.chkDiploma.isSelected());
        if (this.cboDiploma.getSelectedIndex() != -1) {
            cp.addCustomerParam("diplomaId", ((DiplomaInfo)this.cboDiploma.getSelectedItem()).getId().toString());
        }
        cp.putBoolean("isSelectPosition", this.chkPosition.isSelected());
        if (this.prmtPosition.getValue() != null) {
            cp.addCustomerParam("positionId", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        cp.putBoolean("isSelectPositionLevel", this.chkPositionLevel.isSelected());
        if (this.prmtPositionLevel.getValue() != null) {
            cp.addCustomerParam("positionLevelId", ((JobLevelInfo)this.prmtPositionLevel.getValue()).getId().toString());
        }
        cp.putBoolean("isSelectProfPost", this.chkProfPost.isSelected());
        if (this.prmtProfPost.getValue() != null) {
            cp.addCustomerParam("profPostId", ((TechnicalPostInfo)this.prmtProfPost.getValue()).getId().toString());
        }
        cp.putBoolean("isSelectYear", this.chkYear.isSelected());
        if (this.txtFromYear.getText() != null) {
            cp.addCustomerParam("fromYear", this.txtFromYear.getText());
        }
        if (this.txtToYear.getText() != null) {
            cp.addCustomerParam("toYear", this.txtToYear.getText());
        }
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.cboDiploma.getSelectedIndex() > -1) {
            filter.getFilterItems().add(new FilterItemInfo("Diploma.id", (Object)((DiplomaInfo)this.cboDiploma.getSelectedItem()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtPosition.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)((PositionInfo)this.prmtPosition.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtPositionLevel.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("JobLevel.id", (Object)((JobLevelInfo)this.prmtPositionLevel.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtProfPost.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("TechnicalPost.id", (Object)((TechnicalPostInfo)this.prmtProfPost.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.txtFromYear.getIntegerValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("JoinGroupYears", (Object)this.txtFromYear.getIntegerValue(), CompareType.GREATER_EQUALS));
        }
        if (this.txtToYear.getIntegerValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("JoinGroupYears", (Object)this.txtToYear.getIntegerValue(), CompareType.LESS_EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.ISNOT));
        }
        return filter;
    }

    public void setCustomerParams(CustomerParams cp) {
        DiplomaInfo info;
        super.setCustomerParams(cp);
        String id = null;
        ObjectUuidPK pk = null;
        this.chkDiploma.setSelected(cp.getBoolean("isSelectDiploma"));
        if (cp.getCustomerParam("diplomaId") != null) {
            id = cp.getCustomerParam("diplomaId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = null;
            try {
                info = DiplomaFactory.getRemoteInstance().getDiplomaInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.cboDiploma.setSelectedItem((Object)info);
        }
        this.chkPosition.setSelected(cp.getBoolean("isSelectPosition"));
        if (cp.getCustomerParam("positionId") != null) {
            id = cp.getCustomerParam("positionId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = null;
            try {
                info = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPosition.setValue((Object)info);
        }
        this.chkPositionLevel.setSelected(cp.getBoolean("isSelectPositionLevel"));
        if (cp.getCustomerParam("positionLevelId") != null) {
            id = cp.getCustomerParam("positionLevelId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = null;
            try {
                info = JobLevelFactory.getRemoteInstance().getJobLevelInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPositionLevel.setValue((Object)info);
        }
        this.chkProfPost.setSelected(cp.getBoolean("isSelectProfPost"));
        if (cp.getCustomerParam("profPostId") != null) {
            id = cp.getCustomerParam("profPostId");
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = null;
            try {
                info = TechnicalPostFactory.getRemoteInstance().getTechnicalPostInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtProfPost.setValue((Object)info);
        }
        this.chkYear.setSelected(cp.getBoolean("isSelectYear"));
        if (cp.getCustomerParam("fromYear") != null) {
            this.txtFromYear.setText(cp.getCustomerParam("fromYear"));
        }
        if (cp.getCustomerParam("toYear") != null) {
            this.txtToYear.setText(cp.getCustomerParam("toYear"));
        }
    }

    public boolean verify() {
        if (this.txtFromYear.getIntegerValue() != null && this.txtToYear.getIntegerValue() != null) {
            Integer beginYear = this.txtFromYear.getIntegerValue();
            Integer endYear = this.txtToYear.getIntegerValue();
            if (beginYear > endYear) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ServiceYearCompareError"));
                SysUtil.abort();
            }
        }
        if (!(this.chkPosition.isSelected() || this.chkPositionLevel.isSelected() || this.chkYear.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"QualFilterSelectError1"));
            SysUtil.abort();
        } else if (this.chkPosition.isSelected() && this.prmtPosition.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"QualFilterSelectError2"));
            SysUtil.abort();
        } else if (this.chkPositionLevel.isSelected() && this.prmtPositionLevel.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"QualFilterSelectError3"));
            SysUtil.abort();
        } else if (this.chkYear.isSelected() && this.txtFromYear.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"QualFilterSelectError4"));
            SysUtil.abort();
        } else if (this.chkYear.isSelected() && this.txtToYear.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"QualFilterSelectError5"));
            SysUtil.abort();
        }
        return true;
    }

    private void initCustomUI() {
        this.prmtPosition.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this));
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setEditable(false);
        this.prmtPositionLevel.setSelector((KDPromptSelector)new JobLevelPromptBox((IUIObject)this));
        this.prmtPositionLevel.setDisplayFormat("$name$");
        this.prmtPositionLevel.setEditFormat("$number$");
        this.prmtPositionLevel.setCommitFormat("$number$");
        this.prmtPositionLevel.setEditable(false);
        this.txtFromYear.setDataType(0);
        this.txtFromYear.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtFromYear.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtFromYear.setDataVerifierType(12);
        this.txtToYear.setDataType(0);
        this.txtToYear.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtToYear.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtToYear.setDataVerifierType(12);
        try {
            this.cboDiploma.setModel((ComboBoxModel)EmployeeClientUtils.getComboModel((IBasicItem)DiplomaFactory.getRemoteInstance()));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.cboDiploma.setSelectedIndex(-1);
        this.cboDiploma.setEnabled(false);
        this.prmtProfPost.setSelector((KDPromptSelector)new TechnicalPostPromptBox((IUIObject)this));
        this.prmtProfPost.setDisplayFormat("$name$");
        this.prmtProfPost.setEditFormat("$number$");
        this.prmtProfPost.setCommitFormat("$number$");
        this.prmtProfPost.setEditable(false);
    }

    protected void chkDiploma_stateChanged(ChangeEvent e) throws Exception {
        this.setDiplomaEnabled(this.chkDiploma.isSelected());
    }

    protected void chkPosition_stateChanged(ChangeEvent e) throws Exception {
        this.setPositionEnabled(this.chkPosition.isSelected());
    }

    protected void chkPositionLevel_stateChanged(ChangeEvent e) throws Exception {
        this.setPositionLevelEnabled(this.chkPositionLevel.isSelected());
    }

    protected void chkProfPost_stateChanged(ChangeEvent e) throws Exception {
        this.setProfPostEnabled(this.chkProfPost.isSelected());
    }

    protected void chkYear_stateChanged(ChangeEvent e) throws Exception {
        this.setServiceYearEnabled(this.chkYear.isSelected());
    }

    private void setPositionEnabled(boolean enabled) {
        if (enabled) {
            this.prmtPosition.setEnabled(enabled);
        } else {
            this.prmtPosition.setEnabled(enabled);
            this.prmtPosition.setValue(null);
        }
    }

    private void setPositionLevelEnabled(boolean enabled) {
        if (enabled) {
            this.prmtPositionLevel.setEnabled(enabled);
        } else {
            this.prmtPositionLevel.setEnabled(enabled);
            this.prmtPositionLevel.setValue(null);
        }
    }

    private void setServiceYearEnabled(boolean enabled) {
        if (enabled) {
            this.txtFromYear.setEnabled(enabled);
            this.txtToYear.setEnabled(enabled);
        } else {
            this.txtFromYear.setEnabled(enabled);
            this.txtToYear.setEnabled(enabled);
            this.txtFromYear.setNumberValue(null);
            this.txtToYear.setNumberValue(null);
        }
    }

    private void setDiplomaEnabled(boolean enabled) {
        if (enabled) {
            this.cboDiploma.setEnabled(enabled);
        } else {
            this.cboDiploma.setEnabled(enabled);
            this.cboDiploma.setSelectedIndex(-1);
        }
    }

    private void setProfPostEnabled(boolean enabled) {
        if (enabled) {
            this.prmtProfPost.setEnabled(enabled);
        } else {
            this.prmtProfPost.setEnabled(enabled);
            this.prmtProfPost.setValue(null);
        }
    }
}

