/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.qualifications.CerEvaluationCollection;
import com.kingdee.eas.hr.qualifications.CerEvaluationFactory;
import com.kingdee.eas.hr.qualifications.CerEvaluationInfo;
import com.kingdee.eas.hr.qualifications.CerStateEnum;
import com.kingdee.eas.hr.qualifications.ICerEvaluation;
import com.kingdee.eas.hr.qualifications.client.AbstractCerEvaluationListUI;
import com.kingdee.eas.hr.qualifications.client.CerEvaluationEditUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class CerEvaluationListUI
extends AbstractCerEvaluationListUI {
    private static final Logger logger = CoreUIObject.getLogger(CerEvaluationListUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name"};
        return locateNames;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CerEvaluationFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CerEvaluationEditUI.class.getName();
    }

    public void actionViewPerson_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        if (selectRows.length > 1 || this.tblMain.getSelectManager().get().getMode() == 8 && selectRows[0] == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"No_SelectedMultiRowWhenView"));
            SysUtil.abort();
        } else {
            row = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
            if (row != null) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)row.getCell("person").getValue().toString()));
                IPerson iPerson = PersonFactory.getRemoteInstance();
                PersonInfo pInfo = iPerson.getPersonInfo((IObjectPK)pk);
                String PersonID = null;
                if (pInfo != null) {
                    PersonID = pInfo.getId().toString();
                }
                HRQualClientUtils.viewPerson(PersonID, this.getEditUIModal(), (CoreUI)this);
                String cID = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("id").getValue().toString();
                ObjectUuidPK pk_id = new ObjectUuidPK(BOSUuid.read((String)cID));
                ((ICerEvaluation)this.getBizInterface()).viewPerson((IObjectPK)pk_id);
            }
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ICerEvaluation iCerEvaluation = CerEvaluationFactory.getRemoteInstance();
        CerEvaluationCollection CerCol = new CerEvaluationCollection();
        for (int i = 0; i < selectRows.length; ++i) {
            String cID = this.tblMain.getRow(selectRows[i]).getCell("id").getValue().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cID));
            CerEvaluationInfo cInfo = (CerEvaluationInfo)iCerEvaluation.getValue((IObjectPK)pk);
            if (CerStateEnum.Audited.equals((Object)cInfo.getCerState())) {
                return;
            }
            cInfo.setCerState(CerStateEnum.Audited);
            cInfo.setApproveDate(new Date());
            CerCol.add(cInfo);
        }
        iCerEvaluation.audit(CerCol);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmUnaudit()) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            ICerEvaluation iCerEvaluation = CerEvaluationFactory.getRemoteInstance();
            CerEvaluationCollection cerCol = new CerEvaluationCollection();
            for (int i = 0; i < selectRows.length; ++i) {
                String cID = this.tblMain.getRow(selectRows[i]).getCell("id").getValue().toString();
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cID));
                CerEvaluationInfo cInfo = (CerEvaluationInfo)iCerEvaluation.getValue((IObjectPK)pk);
                if (CerStateEnum.Unaudited.equals((Object)cInfo.getCerState())) {
                    return;
                }
                cInfo.setCerState(CerStateEnum.Unaudited);
                cInfo.setApproveDate(null);
                cerCol.add(cInfo);
            }
            iCerEvaluation.unAudit(cerCol);
            this.actionRefresh_actionPerformed(e);
        }
    }

    protected boolean confirmUnaudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"57_ConfirmUnaudit")));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        if (selectRows.length > 0 && (row = this.tblMain.getRow(selectRows[0])) != null) {
            super.tblMain_tableSelectChanged(e);
            this.setButton(e);
        }
    }

    private void setButton(KDTSelectEvent e) {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows != null) {
            if (rows.length > 1 || e.getSelectBlock().getMode() == 8 && rows[0] == 0 || rows[0] == -1) {
                boolean hasAudited = false;
                boolean hasUnAudited = false;
                this.btnEdit.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.btnRemove.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                for (int i = 0; i < rows.length; ++i) {
                    IRow row = this.tblMain.getRow(rows[i]);
                    String stateItem = row.getCell("cerState").getValue().toString();
                    if (stateItem.equals(CerStateEnum.Audited.toString()) || e.getSelectBlock().getMode() == 8 && rows[0] == 0) {
                        this.btnRemove.setEnabled(false);
                        this.menuItemRemove.setEnabled(false);
                    }
                    if (stateItem.equals(CerStateEnum.Audited.toString())) {
                        hasAudited = true;
                    }
                    if (!stateItem.equals(CerStateEnum.Unaudited.toString())) continue;
                    hasUnAudited = true;
                }
                if (hasAudited) {
                    this.menuItemUnaudit.setEnabled(true);
                    this.btnUnaudit.setEnabled(true);
                }
                if (hasUnAudited) {
                    this.btnAudit.setEnabled(true);
                    this.menuItemAudit.setEnabled(true);
                }
                if (hasAudited && hasUnAudited) {
                    this.menuItemUnaudit.setEnabled(false);
                    this.btnUnaudit.setEnabled(false);
                    this.btnAudit.setEnabled(false);
                    this.menuItemAudit.setEnabled(false);
                }
            } else {
                IRow row = this.tblMain.getRow(rows[0]);
                if (row != null) {
                    String stateItem = row.getCell("cerState").getValue().toString();
                    if (stateItem.equals(CerStateEnum.Audited.toString())) {
                        this.btnAudit.setEnabled(false);
                        this.menuItemAudit.setEnabled(false);
                        this.btnUnaudit.setEnabled(true);
                        this.menuItemUnaudit.setEnabled(true);
                        this.btnEdit.setEnabled(false);
                        this.menuItemEdit.setEnabled(false);
                        this.btnRemove.setEnabled(false);
                        this.menuItemRemove.setEnabled(false);
                    } else {
                        this.btnAudit.setEnabled(true);
                        this.menuItemAudit.setEnabled(true);
                        this.btnUnaudit.setEnabled(false);
                        this.menuItemUnaudit.setEnabled(false);
                        this.btnEdit.setEnabled(true);
                        this.menuItemEdit.setEnabled(true);
                        this.btnRemove.setEnabled(true);
                        this.menuItemRemove.setEnabled(true);
                    }
                }
            }
        }
    }

    protected FilterInfo getDefaultFilter() throws Exception {
        return HRQualClientUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

