/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.qualifications.HRQualReportFacadeFactory;
import com.kingdee.eas.hr.qualifications.IHRQualReportFacade;
import com.kingdee.eas.hr.qualifications.IIdentifyType;
import com.kingdee.eas.hr.qualifications.IdentifyTypeCollection;
import com.kingdee.eas.hr.qualifications.IdentifyTypeFactory;
import com.kingdee.eas.hr.qualifications.IdentifyTypeInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractCerResultAnalysisReportListUI;
import com.kingdee.eas.hr.qualifications.client.CerResultAnalysisReportFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CerResultAnalysisReportListUI
extends AbstractCerResultAnalysisReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(CerResultAnalysisReportListUI.class);
    private static final String RES = "com.kingdee.eas.hr.qualifications.QualificationsResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.qualifications.client.CerResultAnalysisReportFilterUI";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.qualifications.app";
    private static final String QUERY_NAME_LATITUDE_SCHEME = "CerResultAnalysisReportLatitude1Query";
    private static final String QUERY_NAME_LATITUDE_QUALTYPE = "CerResultAnalysisReportLatitude2Query";
    private static final String QUERY_NAME_DATA_SCHEME_DIPLOMA = "CerResultAnalysisReportDataSchemeDiplomaQuery";
    private static final String QUERY_NAME_DATA_SCHEME_GENDER = "CerResultAnalysisReportDataSchemeGenderQuery";
    private static final String QUERY_NAME_DATA_SCHEME_IDENTIFYTYPE = "CerResultAnalysisReportDataSchemeIdentifyTypeQuery";
    private static final String QUERY_NAME_DATA_QUALTYPE_DIPLOMA = "CerResultAnalysisReportDataQualTypeDiplomaQuery";
    private static final String QUERY_NAME_DATA_QUALTYPE_GENDER = "CerResultAnalysisReportDataQualTypeGenderQuery";
    private static final String QUERY_NAME_DATA_QUALTYPE_IDENTIFYTYPE = "CerResultAnalysisReportDataQualTypeIdentifyTypeQuery";
    private static final String QUERY_NAME_DATA_SCHEME_COUNTPERSON = "CerResultAnalysisReportDataSchemeCountPersonQuery";
    private static final String QUERY_NAME_DATA_QUALTYPE_COUNTPERSON = "CerResultAnalysisReportDataQualTypeCountPersonQuery";
    private static final String QUERY_NAME_DATA_SCHEME_COUNTPASS = "CerResultAnalysisReportDataSchemeCountPassQuery";
    private static final String QUERY_NAME_DATA_QUALTYPE_COUNTPASS = "CerResultAnalysisReportDataQualTypeCountPassQuery";
    private HashMap statusMap;
    private HashMap headIDMap;
    private HashMap latitudeIDMap;
    private List latitudeIDs;
    private static final String COLUMN_NAME_COUNTPERSON = "countperson";
    private static final String COLUMN_NAME_COUNTPASS = "countpass";
    private static final String COLUMN_NAME_PASSRATE = "countrate";
    private static final String COLUMN_NAME_CERSCHEMEBILL = "cerschemebill";
    private static final String COLUMN_NAME_QUALTYPE = "qualtype";
    private static final String COLUMN_NAME_QUALLEVEL = "quallevel";
    private static final String[] FIELD_NAME_LATITUDE_SCHEME = new String[]{"CERSCHEMEBILLID", "QUALTYPESORTID", "QUALLEVELID"};
    private static final String[] FIELD_NAME_LATITUDE_QUALTYPE = new String[]{"QUALTYPESORTID", "QUALLEVELID"};

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((CerResultAnalysisReportFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            CerResultAnalysisReportFilterUI filterUI = new CerResultAnalysisReportFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new CerResultAnalysisReportFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshData();
    }

    private void refreshData() throws Exception {
        this.loadData();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
    }

    private void loadData() throws Exception {
        int latitudeType = (Integer)this.statusMap.get("latitudeType");
        boolean hasGender = (Boolean)this.statusMap.get("hasGender");
        boolean hasDiploma = (Boolean)this.statusMap.get("hasDiploma");
        this.resetTable();
        this.tblMain.addHeadRow();
        this.tblMain.addHeadRow();
        this.initLatitude(latitudeType);
        this.initTableHead(hasGender, hasDiploma);
        this.initData();
        this.mergeLatitude();
    }

    private void mergeLatitude() throws Exception {
        if ((Integer)this.statusMap.get("latitudeType") == 0) {
            this.megreSchemeLatitude();
        } else if ((Integer)this.statusMap.get("latitudeType") == 1) {
            this.mergeQualTypeLatitude();
        }
    }

    private void megreSchemeLatitude() throws Exception {
        KDTMergeManager mm = this.tblMain.getMergeManager();
        String[] ids = null;
        String cerId = null;
        String qualId = null;
        int startCerRowIndex = -1;
        int startQualRowIndex = -1;
        if (this.latitudeIDs != null) {
            for (int i = 0; i < this.latitudeIDs.size(); ++i) {
                ids = (String[])this.latitudeIDs.get(i);
                if (!ids[0].equals(cerId)) {
                    cerId = ids[0];
                    startCerRowIndex = i;
                    qualId = ids[1];
                    startQualRowIndex = i;
                    continue;
                }
                mm.mergeBlock(startCerRowIndex, this.tblMain.getColumnIndex(COLUMN_NAME_CERSCHEMEBILL), i, this.tblMain.getColumnIndex(COLUMN_NAME_CERSCHEMEBILL));
                if (!ids[1].equals(qualId)) {
                    qualId = ids[1];
                    startQualRowIndex = i;
                    continue;
                }
                mm.mergeBlock(startQualRowIndex, this.tblMain.getColumnIndex(COLUMN_NAME_QUALTYPE), i, this.tblMain.getColumnIndex(COLUMN_NAME_QUALTYPE));
            }
        }
    }

    private void mergeQualTypeLatitude() {
        KDTMergeManager mm = this.tblMain.getMergeManager();
        String[] ids = null;
        String qualId = null;
        int startQualRowIndex = -1;
        if (this.latitudeIDs != null) {
            for (int i = 0; i < this.latitudeIDs.size(); ++i) {
                ids = (String[])this.latitudeIDs.get(i);
                if (!ids[0].equals(qualId)) {
                    qualId = ids[0];
                    startQualRowIndex = i;
                    continue;
                }
                mm.mergeBlock(startQualRowIndex, this.tblMain.getColumnIndex(COLUMN_NAME_QUALTYPE), i, this.tblMain.getColumnIndex(COLUMN_NAME_QUALTYPE));
            }
        }
    }

    private void initLatitude(int latiudeType) throws BOSException, SQLException {
        switch (latiudeType) {
            case 0: {
                this.initCerSchemeLatitude();
                break;
            }
            case 1: {
                this.initQualTypeLatitude();
            }
        }
        IRow sumRow = this.tblMain.addRow();
        sumRow.getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"totalCount"));
        sumRow.getStyleAttributes().setBackground(Color.YELLOW);
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    private void initCerSchemeLatitude() throws BOSException, SQLException {
        IColumn col = null;
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_CERSCHEMEBILL);
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_QUALTYPE);
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_QUALLEVEL);
        this.initLatitudeData();
    }

    private void initQualTypeLatitude() throws BOSException, SQLException {
        IColumn col = null;
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_QUALTYPE);
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_QUALLEVEL);
        this.initLatitudeData();
    }

    private void initData() throws Exception {
        int latitudeType = (Integer)this.statusMap.get("latitudeType");
        boolean hasGender = (Boolean)this.statusMap.get("hasGender");
        boolean hasDiploma = (Boolean)this.statusMap.get("hasDiploma");
        switch (latitudeType) {
            case 0: {
                this.initDataByScheme(hasGender, hasDiploma);
                break;
            }
            case 1: {
                this.initDataByQualType(hasGender, hasDiploma);
            }
        }
    }

    private void initDataByScheme(boolean hasGender, boolean hasDiploma) throws Exception {
        if (hasGender) {
            this.initDataOnGenderByScheme();
        }
        if (hasDiploma) {
            this.initDataOnDiplomaByScheme();
        }
        this.initDataOnIdentifyTypeByScheme();
        this.initDataOnCountPersonByScheme();
        this.initDataOnCountpassByScheme();
        this.initDataOnPassRateByScheme();
        this.initSumCount();
    }

    private void initDataOnGenderByScheme() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_SCHEME_GENDER, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_SCHEME, "PERSONGENDER", "COUNTPERSON");
    }

    private void initDataOnDiplomaByScheme() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_SCHEME_DIPLOMA, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_SCHEME, "HIGHESTDEGREEID", "COUNTPERSON");
    }

    private void initDataOnIdentifyTypeByScheme() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_SCHEME_IDENTIFYTYPE, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_SCHEME, "IDENTIFYTYPEID", "COUNTPERSON");
    }

    private void initDataOnCountPersonByScheme() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_SCHEME_COUNTPERSON, this.mainQuery), this.latitudeIDMap, FIELD_NAME_LATITUDE_SCHEME, COLUMN_NAME_COUNTPERSON, "COUNTPERSON");
    }

    private void initDataOnCountpassByScheme() throws SQLException, Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_SCHEME_COUNTPASS, this.mainQuery), this.latitudeIDMap, FIELD_NAME_LATITUDE_SCHEME, COLUMN_NAME_COUNTPASS, "COUNTPERSON");
    }

    private void initDataOnPassRateByScheme() {
        int rowCount = 0;
        rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue() == null) continue;
            int countPerson = this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue() instanceof BigDecimal ? ((BigDecimal)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue()).intValue() : ((Integer)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue()).intValue();
            int countPass = this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue() == null ? 0 : (this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue() instanceof BigDecimal ? ((BigDecimal)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue()).intValue() : ((Integer)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue()).intValue());
            float f = (float)countPass / (float)countPerson * 100.0f;
            DecimalFormat format = new DecimalFormat("#.00");
            String passRate = format.format(f);
            this.tblMain.getRow(i).getCell(COLUMN_NAME_PASSRATE).setValue((Object)passRate);
        }
    }

    private void initDataByQualType(boolean hasGender, boolean hasDiploma) throws Exception {
        if (hasGender) {
            this.initDataOnGenderByQualType();
        }
        if (hasDiploma) {
            this.initDataOnDiplomaByQualType();
        }
        this.initDataOnIdentifyTypeByQualType();
        this.initDataOnCountPersonsByQualType();
        this.initDataOnCountpassByQualType();
        this.initDataOnPassRateByQualType();
        this.initSumCount();
    }

    private void initDataOnGenderByQualType() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_QUALTYPE_GENDER, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_QUALTYPE, "PERSONGENDER", "COUNTPERSON");
    }

    private void initDataOnDiplomaByQualType() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_QUALTYPE_DIPLOMA, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_QUALTYPE, "HIGHESTDEGREEID", "COUNTPERSON");
    }

    private void initDataOnIdentifyTypeByQualType() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_QUALTYPE_IDENTIFYTYPE, this.mainQuery), this.latitudeIDMap, this.headIDMap, FIELD_NAME_LATITUDE_QUALTYPE, "IDENTIFYTYPEID", "COUNTPERSON");
    }

    private void initDataOnCountPersonsByQualType() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_QUALTYPE_COUNTPERSON, this.mainQuery), this.latitudeIDMap, FIELD_NAME_LATITUDE_QUALTYPE, COLUMN_NAME_COUNTPERSON, "COUNTPERSON");
    }

    private void initDataOnCountpassByQualType() throws Exception {
        this.initDataOnTable(this.getData(QUERY_PATH, QUERY_NAME_DATA_QUALTYPE_COUNTPASS, this.mainQuery), this.latitudeIDMap, FIELD_NAME_LATITUDE_QUALTYPE, COLUMN_NAME_COUNTPASS, "COUNTPERSON");
    }

    private void initDataOnPassRateByQualType() {
        int rowCount = 0;
        rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int countPerson = 0;
            int countPass = 0;
            if (this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue() == null) continue;
            countPerson = this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue() instanceof BigDecimal ? ((BigDecimal)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue()).intValue() : ((Integer)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPERSON).getValue()).intValue();
            countPass = this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue() == null ? 0 : (this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue() instanceof BigDecimal ? ((BigDecimal)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue()).intValue() : ((Integer)this.tblMain.getRow(i).getCell(COLUMN_NAME_COUNTPASS).getValue()).intValue());
        }
    }

    private IRowSet getData(String QueryPath, String QueryName, EntityViewInfo view) throws Exception {
        IRowSet dataRows = null;
        String subSQL = this.metaQueryToSQL(view, QUERY_PATH, QueryName);
        StringBuffer queryStr = new StringBuffer();
        if (QueryName.equals(QUERY_NAME_DATA_SCHEME_DIPLOMA)) {
            queryStr.append("SELECT CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,HIGHESTDEGREEID,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,HIGHESTDEGREEID");
        } else if (QueryName.equals(QUERY_NAME_DATA_QUALTYPE_DIPLOMA)) {
            queryStr.append("SELECT QUALTYPESORTID,QUALLEVELID,HIGHESTDEGREEID,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY QUALTYPESORTID,QUALLEVELID,HIGHESTDEGREEID");
        } else if (QueryName.equals(QUERY_NAME_DATA_SCHEME_GENDER)) {
            queryStr.append("SELECT CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,PERSONGENDER,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,PERSONGENDER");
        } else if (QueryName.equals(QUERY_NAME_DATA_QUALTYPE_GENDER)) {
            queryStr.append("SELECT QUALTYPESORTID,QUALLEVELID,PERSONGENDER,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY QUALTYPESORTID,QUALLEVELID,PERSONGENDER");
        } else if (QueryName.equals(QUERY_NAME_DATA_SCHEME_IDENTIFYTYPE)) {
            queryStr.append("SELECT CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,IDENTIFYTYPEID,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID,IDENTIFYTYPEID");
        } else if (QueryName.equals(QUERY_NAME_DATA_QUALTYPE_IDENTIFYTYPE)) {
            queryStr.append("SELECT QUALTYPESORTID,QUALLEVELID,IDENTIFYTYPEID,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY QUALTYPESORTID,QUALLEVELID,IDENTIFYTYPEID");
        } else if (QueryName.equals(QUERY_NAME_DATA_SCHEME_COUNTPERSON)) {
            queryStr.append("SELECT CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID, COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY CERSCHEMEBILLID,QUALTYPESORTID,QUALLEVELID");
        } else if (QueryName.equals(QUERY_NAME_DATA_QUALTYPE_COUNTPERSON)) {
            queryStr.append("SELECT QUALTYPESORTID,QUALLEVELID ,COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append(subSQL);
            queryStr.append("\n) AS T GROUP BY QUALTYPESORTID,QUALLEVELID");
        } else if (QueryName.equals(QUERY_NAME_DATA_SCHEME_COUNTPASS)) {
            queryStr.append("SELECT T3.CERSCHEMEBILLID,T3.QUALTYPESORTID,T3.QUALLEVELID , COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append("SELECT T1.CERSCHEMEBILLID AS CERSCHEMEBILLID,T1.QUALTYPESORTID AS QUALTYPESORTID, T1.QUALLEVELID AS QUALLEVELID, T1.IDENTIFYTYPEID AS IDENTIFYTYPEID, T1.PERSONID AS PERSONID, T1.RESULTS AS RESULTS, T1.APPROVEDATE AS APPROVEDATE FROM (\n");
            queryStr.append("select T11.CERSCHEMEBILLID,T11.QUALTYPESORTID,T11.QUALLEVELID,T11.IDENTIFYTYPEID,T11.PERSONID,T11.RESULTS,T11.APPROVEDATE from(");
            queryStr.append(subSQL);
            queryStr.append(")AS T11  GROUP BY T11.CERSCHEMEBILLID,T11.QUALTYPESORTID,T11.QUALLEVELID,T11.IDENTIFYTYPEID,T11.PERSONID,T11.RESULTS,T11.APPROVEDATE");
            queryStr.append("\n) AS T1 INNER JOIN (");
            queryStr.append("\n SELECT \nTEMP.CERSCHEMEBILLID,\nTEMP.QUALTYPESORTID, \nTEMP.QUALLEVELID, \nTEMP.IDENTIFYTYPEID,\nTEMP.PERSONID, \nMAX(TEMP.APPROVEDATE)AS APPROVEDATE FROM(\n");
            queryStr.append(subSQL);
            queryStr.append("\n)AS TEMP GROUP BY TEMP.CERSCHEMEBILLID,\nTEMP.QUALTYPESORTID, \nTEMP.QUALLEVELID, \nTEMP.IDENTIFYTYPEID, \nTEMP.PERSONID");
            queryStr.append("\n)AS T2 ");
            queryStr.append("\n ON T1.CERSCHEMEBILLID=T2.CERSCHEMEBILLID\nAND T1.QUALTYPESORTID = T2.QUALTYPESORTID \nAND T1.QUALLEVELID = T2.QUALLEVELID \nAND T1.IDENTIFYTYPEID= T2.IDENTIFYTYPEID \nAND T1.PERSONID = T2.PERSONID \nAND T1.APPROVEDATE = T2.APPROVEDATE \nWHERE T1.RESULTS = 2");
            queryStr.append(")AS T3 \nGROUP BY T3.CERSCHEMEBILLID,T3.QUALTYPESORTID,T3.QUALLEVELID");
        } else if (QueryName.equals(QUERY_NAME_DATA_QUALTYPE_COUNTPASS)) {
            queryStr.append("SELECT T3.QUALTYPESORTID,T3.QUALLEVELID , COUNT(*) AS COUNTPERSON FROM (\n");
            queryStr.append("SELECT T1.QUALTYPESORTID AS QUALTYPESORTID, T1.QUALLEVELID AS QUALLEVELID, T1.IDENTIFYTYPEID AS IDENTIFYTYPEID, T1.PERSONID AS PERSONID, T1.RESULTS AS RESULTS, T1.APPROVEDATE AS APPROVEDATE FROM (\n");
            queryStr.append("select T11.QUALTYPESORTID,T11.QUALLEVELID,T11.IDENTIFYTYPEID,T11.PERSONID,T11.RESULTS,T11.APPROVEDATE from(");
            queryStr.append(subSQL);
            queryStr.append(")AS T11  GROUP BY T11.QUALTYPESORTID,T11.QUALLEVELID,T11.IDENTIFYTYPEID,T11.PERSONID,T11.RESULTS,T11.APPROVEDATE");
            queryStr.append("\n) AS T1 INNER JOIN (");
            queryStr.append("\n SELECT \nTEMP.QUALTYPESORTID, \nTEMP.QUALLEVELID, \nTEMP.IDENTIFYTYPEID,\nTEMP.PERSONID, \nMAX(TEMP.APPROVEDATE)AS APPROVEDATE FROM(\n");
            queryStr.append(subSQL);
            queryStr.append("\n)AS TEMP \nGROUP BY TEMP.QUALTYPESORTID, \nTEMP.QUALLEVELID, \nTEMP.IDENTIFYTYPEID, \nTEMP.PERSONID");
            queryStr.append("\n)AS T2 ");
            queryStr.append("\n ON T1.QUALTYPESORTID = T2.QUALTYPESORTID \nAND T1.QUALLEVELID = T2.QUALLEVELID \nAND ISNULL(T1.IDENTIFYTYPEID,'')=ISNULL(T2.IDENTIFYTYPEID,'')\nAND T1.PERSONID = T2.PERSONID \nAND T1.APPROVEDATE = T2.APPROVEDATE \nWHERE T1.RESULTS = 2");
            queryStr.append(")AS T3 \nGROUP BY T3.QUALTYPESORTID,T3.QUALLEVELID");
        }
        dataRows = this.query(queryStr.toString());
        return dataRows;
    }

    private IRowSet query(String queryStr) throws Exception {
        IRowSet dataRows = null;
        IHRQualReportFacade tool = HRQualReportFacadeFactory.getRemoteInstance();
        dataRows = tool.execuQuery(queryStr);
        return dataRows;
    }

    private String metaQueryToSQL(EntityViewInfo view, String queryPath, String queryName) throws Exception {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        String sql = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        sql = iqec.getSQL();
        return sql;
    }

    private void initDataOnTable(IRowSet dataRows, HashMap latitudeIDMap, HashMap headIDMap, String[] latitudeFieldName, String headFieldName, String dataFieldName) throws Exception {
        if (dataRows != null) {
            StringBuffer latitudeId = new StringBuffer();
            String headId = null;
            while (dataRows.next()) {
                boolean isAvailable = true;
                if (dataRows.getString(headFieldName) == null) continue;
                headId = dataRows.getString(headFieldName);
                for (int i = 0; i < latitudeFieldName.length; ++i) {
                    if (dataRows.getString(latitudeFieldName[i]) == null) {
                        isAvailable = false;
                        break;
                    }
                    latitudeId.append(dataRows.getString(latitudeFieldName[i]));
                }
                if (latitudeIDMap.get(latitudeId.toString()) == null || headIDMap.get(headId) == null || !isAvailable) continue;
                int rowIndex = (Integer)latitudeIDMap.get(latitudeId.toString());
                int colIndex = (Integer)headIDMap.get(headId);
                this.tblMain.getCell(rowIndex, colIndex).setValue(dataRows.getObject(dataFieldName));
            }
        }
    }

    private void initDataOnTable(IRowSet dataRows, HashMap latitudeIDMap, String[] latitudeFieldName, String columnName, String dataFieldName) throws SQLException {
        if (dataRows != null) {
            StringBuffer latitudeId = new StringBuffer();
            while (dataRows.next()) {
                boolean isAvailable = true;
                for (int i = 0; i < latitudeFieldName.length; ++i) {
                    if (dataRows.getString(latitudeFieldName[i]) == null) {
                        isAvailable = false;
                        break;
                    }
                    latitudeId.append(dataRows.getString(latitudeFieldName[i]));
                }
                if (latitudeIDMap.get(latitudeId.toString()) == null || columnName == null || !isAvailable) continue;
                int rowIndex = (Integer)latitudeIDMap.get(latitudeId.toString());
                this.tblMain.getCell(rowIndex, columnName).setValue(dataRows.getObject(dataFieldName));
            }
        }
    }

    private void resetTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.getHead().removeRows();
    }

    private void initTableHead(boolean hasGender, boolean hasDiploma) throws Exception {
        this.headIDMap = new HashMap();
        KDTMergeManager manager = this.tblMain.getHeadMergeManager();
        int latitudeType = (Integer)this.statusMap.get("latitudeType");
        if (latitudeType == 0) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
            this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"CerSchemeBillQueryF7WindowTitle"));
            manager.mergeBlock(0, 1, 1, 1);
            this.tblMain.getHead().getRow(0).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"QualTypeSortQueryF7WindowTitle"));
            manager.mergeBlock(0, 2, 1, 2);
            this.tblMain.getHead().getRow(0).getCell(2).setValue((Object)EASResource.getString((String)RES, (String)"QualLevelQueryF7WindowTitle"));
        } else if (latitudeType == 1) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
            this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"QualTypeSortQueryF7WindowTitle"));
            manager.mergeBlock(0, 1, 1, 1);
            this.tblMain.getHead().getRow(0).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"QualLevelQueryF7WindowTitle"));
        }
        IColumn col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_COUNTPERSON);
        manager.mergeBlock(0, col.getColumnIndex(), 1, col.getColumnIndex());
        this.tblMain.getHead().getRow(0).getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)RES, (String)"countPersons"));
        if (hasGender) {
            this.initGenderTableHead();
        }
        if (hasDiploma) {
            this.initDiplomaTableHead();
        }
        this.initIdentifyTypeTableHead();
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_COUNTPASS);
        manager.mergeBlock(0, col.getColumnIndex(), 1, col.getColumnIndex());
        this.tblMain.getHead().getRow(0).getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)RES, (String)COLUMN_NAME_COUNTPASS));
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_PASSRATE);
        manager.mergeBlock(0, col.getColumnIndex(), 1, col.getColumnIndex());
        this.tblMain.getHead().getRow(0).getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)RES, (String)"passRate"));
        col.getStyleAttributes().setNumberFormat("0.00");
    }

    private void initGenderTableHead() {
        int startIndex = 0;
        IColumn col = null;
        startIndex = this.tblMain.getColumnCount();
        col = this.tblMain.addColumn();
        KDTMergeManager manager = this.tblMain.getHeadMergeManager();
        manager.mergeBlock(1, startIndex, 1, startIndex);
        this.tblMain.getHead().getRow(1).getCell(startIndex).setValue((Object)Genders.Male);
        this.headIDMap.put("1", col.getColumnIndex());
        col = this.tblMain.addColumn();
        manager.mergeBlock(1, startIndex + 1, 1, startIndex + 1);
        this.tblMain.getHead().getRow(1).getCell(startIndex + 1).setValue((Object)Genders.Female);
        this.headIDMap.put("2", col.getColumnIndex());
        manager.mergeBlock(0, startIndex, 0, startIndex + 1);
        this.tblMain.getHead().getRow(0).getCell(startIndex).setValue((Object)EASResource.getString((String)RES, (String)"genderName"));
    }

    private void initDiplomaTableHead() throws BOSException {
        IColumn col = null;
        IDiploma idt = DiplomaFactory.getRemoteInstance();
        DiplomaCollection coll = idt.getDiplomaCollection();
        if (coll != null && coll.size() > 0) {
            DiplomaInfo diplomainfo = null;
            int startIndex = 0;
            startIndex = this.tblMain.getColumnCount();
            for (int i = 0; i < coll.size(); ++i) {
                col = this.tblMain.addColumn();
                diplomainfo = coll.get(i);
                KDTMergeManager manager = this.tblMain.getHeadMergeManager();
                manager.mergeBlock(0, startIndex, 0, startIndex + i);
                manager.mergeBlock(1, col.getColumnIndex(), 1, col.getColumnIndex());
                this.tblMain.getHead().getRow(1).getCell(col.getColumnIndex()).setValue((Object)diplomainfo.getName());
                this.headIDMap.put(diplomainfo.getId().toString(), col.getColumnIndex());
            }
            this.tblMain.getHead().getRow(0).getCell(startIndex).setValue((Object)EASResource.getString((String)RES, (String)"diploma"));
        }
    }

    private void initIdentifyTypeTableHead() throws BOSException {
        IColumn col = null;
        IIdentifyType idt = IdentifyTypeFactory.getRemoteInstance();
        IdentifyTypeCollection coll = idt.getIdentifyTypeCollection();
        if (coll != null && coll.size() > 0) {
            IdentifyTypeInfo identtifytypeinfo = null;
            int startIndex = 0;
            startIndex = this.tblMain.getColumnCount();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                col = this.tblMain.addColumn();
                identtifytypeinfo = coll.get(i);
                KDTMergeManager manager = this.tblMain.getHeadMergeManager();
                manager.mergeBlock(0, startIndex, 0, startIndex + i);
                manager.mergeBlock(1, col.getColumnIndex(), 1, col.getColumnIndex());
                this.tblMain.getHead().getRow(1).getCell(col.getColumnIndex()).setValue((Object)identtifytypeinfo.getName());
                this.headIDMap.put(identtifytypeinfo.getId().toString(), col.getColumnIndex());
            }
            this.tblMain.getHead().getRow(0).getCell(startIndex).setValue((Object)EASResource.getString((String)RES, (String)"IdentifyTypeQueryF7WindowTitle"));
        }
    }

    private void initLatitudeData() throws BOSException, SQLException {
        block6: {
            String[] idArray;
            IRow row;
            StringBuffer ids;
            IRowSet dataRows;
            block7: {
                this.latitudeIDMap = new HashMap();
                IQueryExecutor iqec = null;
                dataRows = null;
                ids = new StringBuffer();
                if ((Integer)this.statusMap.get("latitudeType") == 0) {
                    iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(QUERY_PATH, QUERY_NAME_LATITUDE_SCHEME));
                }
                if ((Integer)this.statusMap.get("latitudeType") == 1) {
                    iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(QUERY_PATH, QUERY_NAME_LATITUDE_QUALTYPE));
                }
                dataRows = iqec.executeQuery();
                row = null;
                this.latitudeIDs = new Vector();
                idArray = null;
                if (dataRows == null) break block6;
                if ((Integer)this.statusMap.get("latitudeType") != 0) break block7;
                while (dataRows.next()) {
                    idArray = new String[FIELD_NAME_LATITUDE_SCHEME.length];
                    row = this.tblMain.addRow();
                    row.getCell(COLUMN_NAME_CERSCHEMEBILL).setValue((Object)dataRows.getString("CERSCHEMEBILL.NAME"));
                    row.getCell(COLUMN_NAME_QUALTYPE).setValue((Object)dataRows.getString("QUALTYPESORT.NAME"));
                    row.getCell(COLUMN_NAME_QUALLEVEL).setValue((Object)dataRows.getString("QUALLEVEL.NAME"));
                    for (int i = 0; i < FIELD_NAME_LATITUDE_SCHEME.length; ++i) {
                        ids.append(dataRows.getString(FIELD_NAME_LATITUDE_SCHEME[i]));
                        idArray[i] = dataRows.getString(FIELD_NAME_LATITUDE_SCHEME[i]);
                    }
                    this.latitudeIDs.add(idArray);
                    this.latitudeIDMap.put(ids.toString(), row.getRowIndex());
                }
                break block6;
            }
            if ((Integer)this.statusMap.get("latitudeType") != 1) break block6;
            while (dataRows.next()) {
                idArray = new String[FIELD_NAME_LATITUDE_QUALTYPE.length];
                ids = new StringBuffer();
                row = this.tblMain.addRow();
                row.getCell(COLUMN_NAME_QUALTYPE).setValue((Object)dataRows.getString("SORT.NAME"));
                row.getCell(COLUMN_NAME_QUALLEVEL).setValue((Object)dataRows.getString("LEVEL.NAME"));
                for (int i = 0; i < FIELD_NAME_LATITUDE_QUALTYPE.length; ++i) {
                    ids.append(dataRows.getString(FIELD_NAME_LATITUDE_QUALTYPE[i]));
                    idArray[i] = dataRows.getString(FIELD_NAME_LATITUDE_QUALTYPE[i]);
                }
                this.latitudeIDs.add(idArray);
                this.latitudeIDMap.put(ids.toString(), row.getRowIndex());
            }
        }
    }

    private void initSumCount() {
        int rowCount = 0;
        int columnCount = 0;
        int cellValue = 0;
        int sumColumn = 0;
        int startColumnIndex = 0;
        IRow sumRow = this.tblMain.getRow(this.tblMain.getRowCount() - 1);
        KDTMergeManager mm = this.tblMain.getMergeManager();
        if ((Integer)this.statusMap.get("latitudeType") == 0) {
            mm.mergeBlock(sumRow.getRowIndex(), 0, sumRow.getRowIndex(), 2);
            columnCount = this.tblMain.getColumnCount() - 3;
        } else if ((Integer)this.statusMap.get("latitudeType") == 1) {
            mm.mergeBlock(sumRow.getRowIndex(), 0, sumRow.getRowIndex(), 1);
            columnCount = this.tblMain.getColumnCount() - 2;
        }
        startColumnIndex = this.tblMain.getColumnIndex(COLUMN_NAME_COUNTPERSON);
        rowCount = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < columnCount; ++i) {
            sumColumn = 0;
            for (int j = 0; j < rowCount; ++j) {
                if (this.tblMain.getRow(j).getCell(startColumnIndex + i).getValue() == null) {
                    cellValue = 0;
                } else if (this.tblMain.getRow(j).getCell(startColumnIndex + i).getValue() instanceof Integer) {
                    cellValue = (Integer)this.tblMain.getRow(j).getCell(startColumnIndex + i).getValue();
                }
                sumColumn += cellValue;
            }
            this.tblMain.getRow(sumRow.getRowIndex()).getCell(startColumnIndex + i).setValue((Object)sumColumn);
        }
        if ((Integer)sumRow.getCell(COLUMN_NAME_COUNTPERSON).getValue() != null) {
            int countPerson = 0;
            int countPass = 0;
            countPerson = (Integer)sumRow.getCell(COLUMN_NAME_COUNTPERSON).getValue();
            countPass = sumRow.getCell(COLUMN_NAME_COUNTPASS).getValue() == null ? 0 : (Integer)sumRow.getCell(COLUMN_NAME_COUNTPASS).getValue();
            float f = (float)countPass / (float)countPerson * 100.0f;
            DecimalFormat format = new DecimalFormat("#.00");
            String passRate = format.format(f);
            sumRow.getCell(COLUMN_NAME_PASSRATE).setValue((Object)passRate);
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowSorter(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_QUALTYPE;
    }
}

